package cn.kinyun.wework.sdk.entity.external.statistic;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author sunwen
 */
@Data
public class GroupStatisticResult extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 命中过滤条件的记录总个数
     */
    private Integer total;

    /**
     * 当前分页的下一个offset。当next_offset和total相等时，说明已经取完所有
     */
    @JsonProperty("next_offset")
    private Integer nextOffset;

    /**
     * 记录列表。表示某个群主所拥有的客户群的统计数据
     */
    private List<GroupStatisticItem> items;
}
