package cn.kinyun.wework.sdk.callback.license;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;

import java.io.Serializable;

/**
 * @author: lwl
 * @date: 2023/5/18
 * @description: 接口许可失效通知
 *
 * @link: https://developer.work.weixin.qq.com/document/path/95716
 **/
@Data
@JacksonXmlRootElement(localName = "xml")
public class LicenseFailEvent implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 企业微信CorpID
     */
    @JacksonXmlProperty(localName = "ToUserName")
    private String toUserName;

    /**
     * 成员UserID
     */
    @JacksonXmlProperty(localName = "FromUserName")
    private String fromUserName;

    /**
     * 消息创建时间（整型）
     */
    @JacksonXmlProperty(localName = "CreateTime")
    private Long createTime;

    /**
     * 消息的类型，此时固定为event
     */
    @JacksonXmlProperty(localName = "MsgType")
    private String msgType;

    /**
     * 事件类型，此时固定为unlicensed_notify
     */
    @JacksonXmlProperty(localName = "Event")
    private String event;

    /**
     * 企业应用的id，整型。可在应用的设置页面查看
     */
    @JacksonXmlProperty(localName = "AgentID")
    private String agentID;

}
