package cn.kinyun.wework.sdk.callback.corp.external;

import cn.kinyun.wework.sdk.callback.corp.BaseCorpEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信客户发起会话事件
 *
 * 授权企业中配置了客户联系功能的成员通过获客链接添加微信客户后，当微信用户首次向成员发起会话时，回调此事件。
 * @author yanmaoyuan
 * @date 2023/5/6
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CustomerStartChat extends BaseCorpEvent {
    private static final long serialVersionUID = 1L;

    /**
     * 企业服务人员的UserID
     */
    @JacksonXmlProperty(localName = "UserID")
    private String userId;

    /**
     * 外部联系人的userid，注意不是企业成员的帐号
     */
    @JacksonXmlProperty(localName = "ExternalUserID")
    private String externalContactId;

}