package cn.kinyun.wework.sdk.callback.agent.msg;

import cn.kinyun.wework.sdk.callback.agent.BaseAgentMsg;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 图片消息
 * msgType image
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ImageMsg extends BaseAgentMsg {
    private static final long serialVersionUID = 1L;

    /**
     * 图片链接
     */
    @JacksonXmlProperty(localName = "PicUrl")
    private String picUrl;

    /**
     * 图片媒体文件id，可以调用获取媒体文件接口拉取，仅三天内有效
     */
    @JacksonXmlProperty(localName = "MediaId")
    private String mediaId;

}
