/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 企业微信回调的原始加密数据
 * 
 * @title EncryptData
 * @author yanmaoyuan
 * @date 2021年4月23日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class EncryptData implements Serializable {

    private static final long serialVersionUID = 1L;

    @JacksonXmlProperty(localName = "ToUserName")
    private String toUserName;

    @JacksonXmlProperty(localName = "Encrypt")
    private String encrypt;

    @JacksonXmlProperty(localName = "AgentID")
    private Integer agentId;
}
