/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.corpcontext.AccessTokenReq;
import cn.kinyun.wework.sdk.entity.corpcontext.CorpExternalUserId;
import cn.kinyun.wework.sdk.entity.corpcontext.CorpShareApp;
import cn.kinyun.wework.sdk.entity.corpcontext.DownstreamAccessToken;
import cn.kinyun.wework.sdk.entity.corpcontext.ExternalUserIdInfo;
import cn.kinyun.wework.sdk.entity.corpcontext.GetExternalUserIdReq;
import cn.kinyun.wework.sdk.entity.corpcontext.ShareAppInfo;
import cn.kinyun.wework.sdk.entity.corpcontext.ShareAppReq;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@GenIgnore
public class CorpContextApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.corp.group.share_app_info}")
    private String shareAppInfoUrl;
    @Value(value="${qyapi.corp.group.downstream.access_token}")
    private String downstreamAccessTokenUrl;
    @Value(value="${qyapi.corp.group.external_userid}")
    private String downstreamExternalUserIdUrl;

    public List<CorpShareApp> getShareAppInfo(@NonNull String accessToken, String corpId, @NonNull Integer agentId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (agentId == null) {
            throw new NullPointerException("agentId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.shareAppInfoUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ShareAppReq req = new ShareAppReq();
        req.setCorpId(corpId);
        req.setAgentId(agentId);
        req.setBusinessType(Integer.valueOf(1));
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ShareAppInfo.class, new Object[0]);
        ShareAppInfo result = (ShareAppInfo)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getCorpList();
    }

    public String getDownstreamAccessToken(@NonNull String accessToken, @NonNull String corpId, @NonNull Integer agentId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (corpId == null) {
            throw new NullPointerException("corpId is marked non-null but is null");
        }
        if (agentId == null) {
            throw new NullPointerException("agentId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.downstreamAccessTokenUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        AccessTokenReq req = new AccessTokenReq();
        req.setCorpId(corpId);
        req.setAgentId(agentId);
        req.setBusinessType(Integer.valueOf(1));
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, DownstreamAccessToken.class, new Object[0]);
        DownstreamAccessToken result = (DownstreamAccessToken)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getAccessToken();
    }

    public List<CorpExternalUserId> getDownstreamExternalUserId(@NonNull String accessToken, @NonNull String openId, @NonNull String unionId, @GenNullable String corpId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        if (unionId == null) {
            throw new NullPointerException("unionId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.downstreamExternalUserIdUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        GetExternalUserIdReq req = new GetExternalUserIdReq();
        req.setOpenId(openId);
        req.setUnionId(unionId);
        req.setCorpId(corpId);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ExternalUserIdInfo.class, new Object[0]);
        ExternalUserIdInfo result = (ExternalUserIdInfo)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getExternalUserIdInfos();
    }
}

