/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.contact.department.Department;
import cn.kinyun.wework.sdk.entity.contact.department.DepartmentList;
import cn.kinyun.wework.sdk.entity.contact.department.IdResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DepartmentApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.department.create}")
    private String createDepartmentUrl;
    @Value(value="${qyapi.department.update}")
    private String updateDepartmentUrl;
    @Value(value="${qyapi.department.delete}")
    private String delDepartmentUrl;
    @Value(value="${qyapi.department.list}")
    private String listDepartmentUrl;

    public Integer create(@NonNull String accessToken, @NonNull Department department) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (department == null) {
            throw new NullPointerException("department is marked non-null but is null");
        }
        String url = MessageFormat.format(this.createDepartmentUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)department, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, IdResp.class, new Object[0]);
        IdResp result = (IdResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getId();
    }

    public void update(@NonNull String accessToken, @NonNull Department department) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (department == null) {
            throw new NullPointerException("department is marked non-null but is null");
        }
        String url = MessageFormat.format(this.updateDepartmentUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)department, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    public void delete(@NonNull String accessToken, @NonNull Integer id) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        String url = MessageFormat.format(this.delDepartmentUrl, accessToken, String.valueOf(id));
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    public List<Department> list(@NonNull String accessToken, @GenNullable Integer id) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.listDepartmentUrl, accessToken);
        if (id != null && id >= 1) {
            url = url + "&id=" + id;
        }
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, DepartmentList.class, new Object[0]);
        DepartmentList result = (DepartmentList)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getDepartmentList();
    }
}

