/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.productAlbum.AddProductAlbumParams;
import cn.kinyun.wework.sdk.entity.external.productAlbum.AddProductAlbumResp;
import cn.kinyun.wework.sdk.entity.external.productAlbum.DeleteProductAlbumParams;
import cn.kinyun.wework.sdk.entity.external.productAlbum.DeleteProductAlbumResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ProductAlbumApi {
    private static final Logger log = LoggerFactory.getLogger(ProductAlbumApi.class);
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.externalcontact.add_product_album}")
    private String addProductAlbumUrl;
    @Value(value="${qyapi.externalcontact.delete_product_album}")
    private String deleteProductAlbumUrl;

    public AddProductAlbumResp add(@NonNull String accessToken, @NonNull AddProductAlbumParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("add product album params: {}", (Object)params);
        String url = MessageFormat.format(this.addProductAlbumUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, AddProductAlbumResp.class, new Object[0]);
        AddProductAlbumResp result = (AddProductAlbumResp)forEntity.getBody();
        log.info("add product album result: {}", (Object)result);
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public DeleteProductAlbumResp del(@NonNull String accessToken, @NonNull DeleteProductAlbumParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.deleteProductAlbumUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, DeleteProductAlbumResp.class, new Object[0]);
        DeleteProductAlbumResp result = (DeleteProductAlbumResp)forEntity.getBody();
        return result;
    }
}

