/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.externalpay.BillListResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WeworkPayApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.externalpay.get_bill_list}")
    private String billListUrl;

    public BillListResp getBillList(@NonNull String accessToken, @NonNull Long beginTime, @NonNull Long endTime, String cursor, Integer limit) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (beginTime == null) {
            throw new NullPointerException("beginTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        String url = MessageFormat.format(this.billListUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("begin_time", beginTime);
        params.put("end_time", endTime);
        if (StringUtils.isNotBlank((CharSequence)cursor)) {
            params.put("cursor", cursor);
        }
        if (limit != null) {
            params.put("limit", limit);
        }
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, BillListResp.class, new Object[0]);
        BillListResp result = (BillListResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

