/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.api.req.AddScheduleReq;
import cn.kinyun.wework.sdk.api.req.DelScheduleReq;
import cn.kinyun.wework.sdk.api.req.UpdateScheduleReq;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.calendar.ScheduleAddResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ScheduleApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.schedule.add}")
    private String addSchedule;
    @Value(value="${qyapi.schedule.update}")
    private String updateSchedule;
    @Value(value="${qyapi.schedule.del}")
    private String delSchedule;

    @GenAsync
    public ScheduleAddResp addSchedule(@NonNull String accessToken, @NonNull AddScheduleReq params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.addSchedule, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ScheduleAddResp.class, new Object[0]);
        ScheduleAddResp result = (ScheduleAddResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenAsync
    public void updateSchedule(@NonNull String accessToken, @NonNull UpdateScheduleReq params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.updateSchedule, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenAsync
    public void delSchedule(@NonNull String accessToken, @NonNull DelScheduleReq params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.delSchedule, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }
}

