package cn.kinyun.trade.dto;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class OrgPayChannelReqDto implements Serializable {

    private Long bizId;

    private Long orgId;

    private List<ChannelNameUrlReq> channelNameUrlReqList;

    private Long operatorId;

    public void validateParams() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(orgId != null, "orgId不能为空");
        Preconditions.checkArgument(channelNameUrlReqList != null, "channelNameUrlReqList不能为空");
        Preconditions.checkArgument(operatorId != null, "operatorId不能为空");
    }
}
