package cn.kinyun.trade.dto;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.io.Serializable;

@Data
@ExcelIgnoreUnannotated
public class DormBedResp implements Serializable {

    private Long id;

    @ExcelProperty("床号")
    @ColumnWidth(15)
    private String bedNo;

    private Long roomId;

    @ExcelProperty("房号")
    @ColumnWidth(15)
    private String roomNo;

    @ExcelProperty("楼栋")
    @ColumnWidth(15)
    private Integer block;

    @ExcelProperty("楼层")
    @ColumnWidth(15)
    private Integer floor;



    private Integer status;
    @ExcelProperty("状态")
    @ColumnWidth(15)
    private String statusDesc;

    private Long dormStudentId;

    private Integer roomStatus;

    private Integer gender;

    private Integer residentType;
    @ExcelProperty("居住人类型")
    @ColumnWidth(20)
    private String residentTypeDesc;

    @ExcelProperty("居住人姓名")
    @ColumnWidth(20)
    private String residentName;
}
