package cn.kinyun.trade.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ClassListResp implements Serializable {

    /**
     * 班级编码
     **/
    private String classCode;
    /**
     * 班级名称
     **/
    private String className;
    /**
     * 考试类型编码
     **/
    private String examTypeCode;
    /**
     * 考试类型名称
     **/
    private String examTypeName;
    /**
     * 产品类型编码
     **/
    private String productTypeCode;
    /**
     * 产品类型名字
     **/
    private String productTypeName;
    /**
     * 开课负责人id
     **/
    private Long chargeManId;
    /**
     * 开课负责人名字
     **/
    private String chargeManName;

    /**
     * 开课教室名字
     **/
    private String classroomName;
    /**
     * 开课时间
     **/
    private Date startDate;
    /**
     * 结课时间
     **/
    private Date endDate;
    /**
     * 满班人数
     **/
    private Integer fullCount;
    /**
     * 最低开班人数
     **/
    private Integer leastCount;
    /**
     * 备注
     **/
    private String remark;
    /**
     * 状态 1：已开班 2：未开班
     **/
    private Integer status;
    /**
     * 反馈状态 1:待反馈 2:已反馈
     */
    private Integer feedbackStatus;
    /**
     * 反馈状态描述
     */
    private String feedbackStatusDesc;
    /**
     * 状态描述
     **/
    private String statusDesc;
    /**
     * 在班人数
     **/
    private Integer inClassCount;
    /**
     * 开班时间
     **/
    private Date openTime;

    /**
     * 开课分校id
     */
    private Long openBranchSchoolId;

    /**
     * 开课分校名称
     */
    private String openBranchSchoolName;

    private Integer chargeManFeedbackStatus;

    private String chargeManFeedbackStatusDesc;

    private String originClassCode;

    /**
     * 督学师名称
     */
    private String supervisorName;


    /**
     * 班级id
     * */
    private Long id;
}
