/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.dto;

import cn.kinyun.trade.dto.OrderQuery;
import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

@ApiModel(value="\u8ba2\u5355\u5217\u8868\u8bf7\u6c42")
public class OrderListReqDto
implements Serializable {
    @ApiModelProperty(value="\u8ba2\u5355\u7f16\u53f7")
    private String orderNo;
    @ApiModelProperty(value="\u624b\u673a\u53f7")
    private String mobile;
    @ApiModelProperty(value="\u624b\u673a\u53f7/\u540d\u5b57")
    private String studentQuery;
    @ApiModelProperty(value="\u62a5\u540d\u5206\u6821ID")
    private Long entryNodeId;
    @ApiModelProperty(value="\u652f\u4ed8\u72b6\u6001 PayStatusEnum")
    private Integer payStatus;
    @ApiModelProperty(value="\u8ba2\u5355\u5bf9\u5e94\u8bfe\u7a0b\u9000\u8d39\u72b6\u6001 RefundStatusEnum")
    private Integer refundStatus;
    @ApiModelProperty(value="\u9879\u76ee\u7f16\u7801")
    private String bizUnitCode;
    @ApiModelProperty(value="\u8003\u8bd5\u7c7b\u578b\u7f16\u7801")
    private String examTypeCode;
    @ApiModelProperty(value="\u4ea7\u54c1\u7c7b\u578b\u7f16\u7801")
    private String productTypeCode;
    @ApiModelProperty(value="\u534f\u8bae\u7c7b\u578b\u7f16\u7801")
    private String protocolCode;
    @ApiModelProperty(value="\u521b\u5efa\u5f00\u59cb\u65e5\u671f")
    private Date createStartDate;
    @ApiModelProperty(value="\u521b\u5efa\u65e5\u671f\u7ed3\u675f\u65f6\u95f4")
    private Date createEndDate;
    @ApiModelProperty(value="\u6210\u5355\u4eba")
    private Long salesId;
    @ApiModelProperty(value="\u6210\u5355\u5206\u6821")
    private Long salesNodeId;
    private PageDto pageDto;
    private Boolean isFromPc = true;
    private Collection<Long> ids;
    private List<String> courseCodeList;
    private String queryCourse;
    private boolean isPage = true;
    private Integer isSelectAll;
    private Collection<String> bindingIds;
    private boolean isCall = false;
    private Date classStartDate1;
    private Date classStartDate2;
    private Date classEndDate1;
    private Date classEndDate2;
    private Integer signStatus;
    private Long branchSchoolId;
    private Integer verifyStatus;
    private Integer downPaidStatus;
    private String positionId;
    private Integer interviewStatus;
    private Integer scoreStatus;
    private Integer orderType;
    private String examPeriod;
    private Set<String> examPeriods;
    private Set<Integer> refundStatusSet;
    private Integer contractSmsFlag;
    private Integer isWidthPosition;
    private Boolean onlyPrimaryOrder = false;
    private Integer isSubOrder;
    private Long signNodeId;
    private boolean queryShareOrder = false;

    public OrderQuery toQuery(String corpId) {
        OrderQuery query = new OrderQuery();
        BeanUtils.copyProperties((Object)this, (Object)query);
        query.setCorpId(corpId);
        if (StringUtils.isNotBlank((CharSequence)this.studentQuery)) {
            if (this.isInteger(this.studentQuery)) {
                query.setMobile(this.studentQuery);
            } else {
                query.setStudentName(this.studentQuery);
            }
        }
        query.setJoinProduct(StringUtils.isNotBlank((CharSequence)this.bizUnitCode) || StringUtils.isNotBlank((CharSequence)this.examTypeCode) || StringUtils.isNotBlank((CharSequence)this.productTypeCode));
        query.setJoinCourse(org.apache.commons.collections.CollectionUtils.isNotEmpty(this.courseCodeList) || StringUtils.isNotBlank((CharSequence)this.queryCourse) || Objects.nonNull(this.classStartDate1) || Objects.nonNull(this.classEndDate1) || Objects.nonNull(this.branchSchoolId));
        if (StringUtils.isNotBlank((CharSequence)this.positionId) || Objects.nonNull(this.interviewStatus)) {
            query.setJoinPosition(true);
        }
        if (this.scoreStatus != null) {
            query.setJoinScore(true);
        }
        if (this.isPage) {
            this.pageDto = Optional.ofNullable(this.pageDto).orElse(new PageDto());
            query.setOffset(this.pageDto.getOffset());
            query.setLimit(this.pageDto.getPageSize());
        }
        query.setJoinOrderProtocolRule(Objects.nonNull(this.downPaidStatus));
        query.setJoinStudent(Objects.nonNull(this.verifyStatus) || Objects.nonNull(this.interviewStatus));
        query.setJoinOrderContract(Objects.nonNull(this.signStatus));
        query.setJoinPositionInterview(Objects.nonNull(this.interviewStatus));
        query.setQueryShareOrder(this.queryShareOrder);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.refundStatusSet)) {
            query.setJoinOrderRefund(true);
        }
        query.setContractSmsFlag(this.contractSmsFlag);
        return query;
    }

    public boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public void validate() {
        this.isSelectAll = Optional.ofNullable(this.isSelectAll).orElse(0);
        Preconditions.checkArgument((this.isSelectAll == 0 || this.isSelectAll == 1 ? 1 : 0) != 0, (Object)"\u662f\u5426\u5168\u9009\u53c2\u6570\u4e0d\u5408\u6cd5");
        if (this.isSelectAll == 0) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.bindingIds), (Object)"\u52fe\u9009\u6a21\u5f0f\u4e0b\uff0c\u9009\u4e2d\u7684\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getStudentQuery() {
        return this.studentQuery;
    }

    public Long getEntryNodeId() {
        return this.entryNodeId;
    }

    public Integer getPayStatus() {
        return this.payStatus;
    }

    public Integer getRefundStatus() {
        return this.refundStatus;
    }

    public String getBizUnitCode() {
        return this.bizUnitCode;
    }

    public String getExamTypeCode() {
        return this.examTypeCode;
    }

    public String getProductTypeCode() {
        return this.productTypeCode;
    }

    public String getProtocolCode() {
        return this.protocolCode;
    }

    public Date getCreateStartDate() {
        return this.createStartDate;
    }

    public Date getCreateEndDate() {
        return this.createEndDate;
    }

    public Long getSalesId() {
        return this.salesId;
    }

    public Long getSalesNodeId() {
        return this.salesNodeId;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public Boolean getIsFromPc() {
        return this.isFromPc;
    }

    public Collection<Long> getIds() {
        return this.ids;
    }

    public List<String> getCourseCodeList() {
        return this.courseCodeList;
    }

    public String getQueryCourse() {
        return this.queryCourse;
    }

    public boolean isPage() {
        return this.isPage;
    }

    public Integer getIsSelectAll() {
        return this.isSelectAll;
    }

    public Collection<String> getBindingIds() {
        return this.bindingIds;
    }

    public boolean isCall() {
        return this.isCall;
    }

    public Date getClassStartDate1() {
        return this.classStartDate1;
    }

    public Date getClassStartDate2() {
        return this.classStartDate2;
    }

    public Date getClassEndDate1() {
        return this.classEndDate1;
    }

    public Date getClassEndDate2() {
        return this.classEndDate2;
    }

    public Integer getSignStatus() {
        return this.signStatus;
    }

    public Long getBranchSchoolId() {
        return this.branchSchoolId;
    }

    public Integer getVerifyStatus() {
        return this.verifyStatus;
    }

    public Integer getDownPaidStatus() {
        return this.downPaidStatus;
    }

    public String getPositionId() {
        return this.positionId;
    }

    public Integer getInterviewStatus() {
        return this.interviewStatus;
    }

    public Integer getScoreStatus() {
        return this.scoreStatus;
    }

    public Integer getOrderType() {
        return this.orderType;
    }

    public String getExamPeriod() {
        return this.examPeriod;
    }

    public Set<String> getExamPeriods() {
        return this.examPeriods;
    }

    public Set<Integer> getRefundStatusSet() {
        return this.refundStatusSet;
    }

    public Integer getContractSmsFlag() {
        return this.contractSmsFlag;
    }

    public Integer getIsWidthPosition() {
        return this.isWidthPosition;
    }

    public Boolean getOnlyPrimaryOrder() {
        return this.onlyPrimaryOrder;
    }

    public Integer getIsSubOrder() {
        return this.isSubOrder;
    }

    public Long getSignNodeId() {
        return this.signNodeId;
    }

    public boolean isQueryShareOrder() {
        return this.queryShareOrder;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setStudentQuery(String studentQuery) {
        this.studentQuery = studentQuery;
    }

    public void setEntryNodeId(Long entryNodeId) {
        this.entryNodeId = entryNodeId;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public void setRefundStatus(Integer refundStatus) {
        this.refundStatus = refundStatus;
    }

    public void setBizUnitCode(String bizUnitCode) {
        this.bizUnitCode = bizUnitCode;
    }

    public void setExamTypeCode(String examTypeCode) {
        this.examTypeCode = examTypeCode;
    }

    public void setProductTypeCode(String productTypeCode) {
        this.productTypeCode = productTypeCode;
    }

    public void setProtocolCode(String protocolCode) {
        this.protocolCode = protocolCode;
    }

    public void setCreateStartDate(Date createStartDate) {
        this.createStartDate = createStartDate;
    }

    public void setCreateEndDate(Date createEndDate) {
        this.createEndDate = createEndDate;
    }

    public void setSalesId(Long salesId) {
        this.salesId = salesId;
    }

    public void setSalesNodeId(Long salesNodeId) {
        this.salesNodeId = salesNodeId;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setIsFromPc(Boolean isFromPc) {
        this.isFromPc = isFromPc;
    }

    public void setIds(Collection<Long> ids) {
        this.ids = ids;
    }

    public void setCourseCodeList(List<String> courseCodeList) {
        this.courseCodeList = courseCodeList;
    }

    public void setQueryCourse(String queryCourse) {
        this.queryCourse = queryCourse;
    }

    public void setPage(boolean isPage) {
        this.isPage = isPage;
    }

    public void setIsSelectAll(Integer isSelectAll) {
        this.isSelectAll = isSelectAll;
    }

    public void setBindingIds(Collection<String> bindingIds) {
        this.bindingIds = bindingIds;
    }

    public void setCall(boolean isCall) {
        this.isCall = isCall;
    }

    public void setClassStartDate1(Date classStartDate1) {
        this.classStartDate1 = classStartDate1;
    }

    public void setClassStartDate2(Date classStartDate2) {
        this.classStartDate2 = classStartDate2;
    }

    public void setClassEndDate1(Date classEndDate1) {
        this.classEndDate1 = classEndDate1;
    }

    public void setClassEndDate2(Date classEndDate2) {
        this.classEndDate2 = classEndDate2;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public void setBranchSchoolId(Long branchSchoolId) {
        this.branchSchoolId = branchSchoolId;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public void setDownPaidStatus(Integer downPaidStatus) {
        this.downPaidStatus = downPaidStatus;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public void setInterviewStatus(Integer interviewStatus) {
        this.interviewStatus = interviewStatus;
    }

    public void setScoreStatus(Integer scoreStatus) {
        this.scoreStatus = scoreStatus;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public void setExamPeriod(String examPeriod) {
        this.examPeriod = examPeriod;
    }

    public void setExamPeriods(Set<String> examPeriods) {
        this.examPeriods = examPeriods;
    }

    public void setRefundStatusSet(Set<Integer> refundStatusSet) {
        this.refundStatusSet = refundStatusSet;
    }

    public void setContractSmsFlag(Integer contractSmsFlag) {
        this.contractSmsFlag = contractSmsFlag;
    }

    public void setIsWidthPosition(Integer isWidthPosition) {
        this.isWidthPosition = isWidthPosition;
    }

    public void setOnlyPrimaryOrder(Boolean onlyPrimaryOrder) {
        this.onlyPrimaryOrder = onlyPrimaryOrder;
    }

    public void setIsSubOrder(Integer isSubOrder) {
        this.isSubOrder = isSubOrder;
    }

    public void setSignNodeId(Long signNodeId) {
        this.signNodeId = signNodeId;
    }

    public void setQueryShareOrder(boolean queryShareOrder) {
        this.queryShareOrder = queryShareOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderListReqDto)) {
            return false;
        }
        OrderListReqDto other = (OrderListReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPage() != other.isPage()) {
            return false;
        }
        if (this.isCall() != other.isCall()) {
            return false;
        }
        if (this.isQueryShareOrder() != other.isQueryShareOrder()) {
            return false;
        }
        Long this$entryNodeId = this.getEntryNodeId();
        Long other$entryNodeId = other.getEntryNodeId();
        if (this$entryNodeId == null ? other$entryNodeId != null : !((Object)this$entryNodeId).equals(other$entryNodeId)) {
            return false;
        }
        Integer this$payStatus = this.getPayStatus();
        Integer other$payStatus = other.getPayStatus();
        if (this$payStatus == null ? other$payStatus != null : !((Object)this$payStatus).equals(other$payStatus)) {
            return false;
        }
        Integer this$refundStatus = this.getRefundStatus();
        Integer other$refundStatus = other.getRefundStatus();
        if (this$refundStatus == null ? other$refundStatus != null : !((Object)this$refundStatus).equals(other$refundStatus)) {
            return false;
        }
        Long this$salesId = this.getSalesId();
        Long other$salesId = other.getSalesId();
        if (this$salesId == null ? other$salesId != null : !((Object)this$salesId).equals(other$salesId)) {
            return false;
        }
        Long this$salesNodeId = this.getSalesNodeId();
        Long other$salesNodeId = other.getSalesNodeId();
        if (this$salesNodeId == null ? other$salesNodeId != null : !((Object)this$salesNodeId).equals(other$salesNodeId)) {
            return false;
        }
        Boolean this$isFromPc = this.getIsFromPc();
        Boolean other$isFromPc = other.getIsFromPc();
        if (this$isFromPc == null ? other$isFromPc != null : !((Object)this$isFromPc).equals(other$isFromPc)) {
            return false;
        }
        Integer this$isSelectAll = this.getIsSelectAll();
        Integer other$isSelectAll = other.getIsSelectAll();
        if (this$isSelectAll == null ? other$isSelectAll != null : !((Object)this$isSelectAll).equals(other$isSelectAll)) {
            return false;
        }
        Integer this$signStatus = this.getSignStatus();
        Integer other$signStatus = other.getSignStatus();
        if (this$signStatus == null ? other$signStatus != null : !((Object)this$signStatus).equals(other$signStatus)) {
            return false;
        }
        Long this$branchSchoolId = this.getBranchSchoolId();
        Long other$branchSchoolId = other.getBranchSchoolId();
        if (this$branchSchoolId == null ? other$branchSchoolId != null : !((Object)this$branchSchoolId).equals(other$branchSchoolId)) {
            return false;
        }
        Integer this$verifyStatus = this.getVerifyStatus();
        Integer other$verifyStatus = other.getVerifyStatus();
        if (this$verifyStatus == null ? other$verifyStatus != null : !((Object)this$verifyStatus).equals(other$verifyStatus)) {
            return false;
        }
        Integer this$downPaidStatus = this.getDownPaidStatus();
        Integer other$downPaidStatus = other.getDownPaidStatus();
        if (this$downPaidStatus == null ? other$downPaidStatus != null : !((Object)this$downPaidStatus).equals(other$downPaidStatus)) {
            return false;
        }
        Integer this$interviewStatus = this.getInterviewStatus();
        Integer other$interviewStatus = other.getInterviewStatus();
        if (this$interviewStatus == null ? other$interviewStatus != null : !((Object)this$interviewStatus).equals(other$interviewStatus)) {
            return false;
        }
        Integer this$scoreStatus = this.getScoreStatus();
        Integer other$scoreStatus = other.getScoreStatus();
        if (this$scoreStatus == null ? other$scoreStatus != null : !((Object)this$scoreStatus).equals(other$scoreStatus)) {
            return false;
        }
        Integer this$orderType = this.getOrderType();
        Integer other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !((Object)this$orderType).equals(other$orderType)) {
            return false;
        }
        Integer this$contractSmsFlag = this.getContractSmsFlag();
        Integer other$contractSmsFlag = other.getContractSmsFlag();
        if (this$contractSmsFlag == null ? other$contractSmsFlag != null : !((Object)this$contractSmsFlag).equals(other$contractSmsFlag)) {
            return false;
        }
        Integer this$isWidthPosition = this.getIsWidthPosition();
        Integer other$isWidthPosition = other.getIsWidthPosition();
        if (this$isWidthPosition == null ? other$isWidthPosition != null : !((Object)this$isWidthPosition).equals(other$isWidthPosition)) {
            return false;
        }
        Boolean this$onlyPrimaryOrder = this.getOnlyPrimaryOrder();
        Boolean other$onlyPrimaryOrder = other.getOnlyPrimaryOrder();
        if (this$onlyPrimaryOrder == null ? other$onlyPrimaryOrder != null : !((Object)this$onlyPrimaryOrder).equals(other$onlyPrimaryOrder)) {
            return false;
        }
        Integer this$isSubOrder = this.getIsSubOrder();
        Integer other$isSubOrder = other.getIsSubOrder();
        if (this$isSubOrder == null ? other$isSubOrder != null : !((Object)this$isSubOrder).equals(other$isSubOrder)) {
            return false;
        }
        Long this$signNodeId = this.getSignNodeId();
        Long other$signNodeId = other.getSignNodeId();
        if (this$signNodeId == null ? other$signNodeId != null : !((Object)this$signNodeId).equals(other$signNodeId)) {
            return false;
        }
        String this$orderNo = this.getOrderNo();
        String other$orderNo = other.getOrderNo();
        if (this$orderNo == null ? other$orderNo != null : !this$orderNo.equals(other$orderNo)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$studentQuery = this.getStudentQuery();
        String other$studentQuery = other.getStudentQuery();
        if (this$studentQuery == null ? other$studentQuery != null : !this$studentQuery.equals(other$studentQuery)) {
            return false;
        }
        String this$bizUnitCode = this.getBizUnitCode();
        String other$bizUnitCode = other.getBizUnitCode();
        if (this$bizUnitCode == null ? other$bizUnitCode != null : !this$bizUnitCode.equals(other$bizUnitCode)) {
            return false;
        }
        String this$examTypeCode = this.getExamTypeCode();
        String other$examTypeCode = other.getExamTypeCode();
        if (this$examTypeCode == null ? other$examTypeCode != null : !this$examTypeCode.equals(other$examTypeCode)) {
            return false;
        }
        String this$productTypeCode = this.getProductTypeCode();
        String other$productTypeCode = other.getProductTypeCode();
        if (this$productTypeCode == null ? other$productTypeCode != null : !this$productTypeCode.equals(other$productTypeCode)) {
            return false;
        }
        String this$protocolCode = this.getProtocolCode();
        String other$protocolCode = other.getProtocolCode();
        if (this$protocolCode == null ? other$protocolCode != null : !this$protocolCode.equals(other$protocolCode)) {
            return false;
        }
        Date this$createStartDate = this.getCreateStartDate();
        Date other$createStartDate = other.getCreateStartDate();
        if (this$createStartDate == null ? other$createStartDate != null : !((Object)this$createStartDate).equals(other$createStartDate)) {
            return false;
        }
        Date this$createEndDate = this.getCreateEndDate();
        Date other$createEndDate = other.getCreateEndDate();
        if (this$createEndDate == null ? other$createEndDate != null : !((Object)this$createEndDate).equals(other$createEndDate)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        Collection<Long> this$ids = this.getIds();
        Collection<Long> other$ids = other.getIds();
        if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
            return false;
        }
        List<String> this$courseCodeList = this.getCourseCodeList();
        List<String> other$courseCodeList = other.getCourseCodeList();
        if (this$courseCodeList == null ? other$courseCodeList != null : !((Object)this$courseCodeList).equals(other$courseCodeList)) {
            return false;
        }
        String this$queryCourse = this.getQueryCourse();
        String other$queryCourse = other.getQueryCourse();
        if (this$queryCourse == null ? other$queryCourse != null : !this$queryCourse.equals(other$queryCourse)) {
            return false;
        }
        Collection<String> this$bindingIds = this.getBindingIds();
        Collection<String> other$bindingIds = other.getBindingIds();
        if (this$bindingIds == null ? other$bindingIds != null : !((Object)this$bindingIds).equals(other$bindingIds)) {
            return false;
        }
        Date this$classStartDate1 = this.getClassStartDate1();
        Date other$classStartDate1 = other.getClassStartDate1();
        if (this$classStartDate1 == null ? other$classStartDate1 != null : !((Object)this$classStartDate1).equals(other$classStartDate1)) {
            return false;
        }
        Date this$classStartDate2 = this.getClassStartDate2();
        Date other$classStartDate2 = other.getClassStartDate2();
        if (this$classStartDate2 == null ? other$classStartDate2 != null : !((Object)this$classStartDate2).equals(other$classStartDate2)) {
            return false;
        }
        Date this$classEndDate1 = this.getClassEndDate1();
        Date other$classEndDate1 = other.getClassEndDate1();
        if (this$classEndDate1 == null ? other$classEndDate1 != null : !((Object)this$classEndDate1).equals(other$classEndDate1)) {
            return false;
        }
        Date this$classEndDate2 = this.getClassEndDate2();
        Date other$classEndDate2 = other.getClassEndDate2();
        if (this$classEndDate2 == null ? other$classEndDate2 != null : !((Object)this$classEndDate2).equals(other$classEndDate2)) {
            return false;
        }
        String this$positionId = this.getPositionId();
        String other$positionId = other.getPositionId();
        if (this$positionId == null ? other$positionId != null : !this$positionId.equals(other$positionId)) {
            return false;
        }
        String this$examPeriod = this.getExamPeriod();
        String other$examPeriod = other.getExamPeriod();
        if (this$examPeriod == null ? other$examPeriod != null : !this$examPeriod.equals(other$examPeriod)) {
            return false;
        }
        Set<String> this$examPeriods = this.getExamPeriods();
        Set<String> other$examPeriods = other.getExamPeriods();
        if (this$examPeriods == null ? other$examPeriods != null : !((Object)this$examPeriods).equals(other$examPeriods)) {
            return false;
        }
        Set<Integer> this$refundStatusSet = this.getRefundStatusSet();
        Set<Integer> other$refundStatusSet = other.getRefundStatusSet();
        return !(this$refundStatusSet == null ? other$refundStatusSet != null : !((Object)this$refundStatusSet).equals(other$refundStatusSet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderListReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPage() ? 79 : 97);
        result = result * 59 + (this.isCall() ? 79 : 97);
        result = result * 59 + (this.isQueryShareOrder() ? 79 : 97);
        Long $entryNodeId = this.getEntryNodeId();
        result = result * 59 + ($entryNodeId == null ? 43 : ((Object)$entryNodeId).hashCode());
        Integer $payStatus = this.getPayStatus();
        result = result * 59 + ($payStatus == null ? 43 : ((Object)$payStatus).hashCode());
        Integer $refundStatus = this.getRefundStatus();
        result = result * 59 + ($refundStatus == null ? 43 : ((Object)$refundStatus).hashCode());
        Long $salesId = this.getSalesId();
        result = result * 59 + ($salesId == null ? 43 : ((Object)$salesId).hashCode());
        Long $salesNodeId = this.getSalesNodeId();
        result = result * 59 + ($salesNodeId == null ? 43 : ((Object)$salesNodeId).hashCode());
        Boolean $isFromPc = this.getIsFromPc();
        result = result * 59 + ($isFromPc == null ? 43 : ((Object)$isFromPc).hashCode());
        Integer $isSelectAll = this.getIsSelectAll();
        result = result * 59 + ($isSelectAll == null ? 43 : ((Object)$isSelectAll).hashCode());
        Integer $signStatus = this.getSignStatus();
        result = result * 59 + ($signStatus == null ? 43 : ((Object)$signStatus).hashCode());
        Long $branchSchoolId = this.getBranchSchoolId();
        result = result * 59 + ($branchSchoolId == null ? 43 : ((Object)$branchSchoolId).hashCode());
        Integer $verifyStatus = this.getVerifyStatus();
        result = result * 59 + ($verifyStatus == null ? 43 : ((Object)$verifyStatus).hashCode());
        Integer $downPaidStatus = this.getDownPaidStatus();
        result = result * 59 + ($downPaidStatus == null ? 43 : ((Object)$downPaidStatus).hashCode());
        Integer $interviewStatus = this.getInterviewStatus();
        result = result * 59 + ($interviewStatus == null ? 43 : ((Object)$interviewStatus).hashCode());
        Integer $scoreStatus = this.getScoreStatus();
        result = result * 59 + ($scoreStatus == null ? 43 : ((Object)$scoreStatus).hashCode());
        Integer $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : ((Object)$orderType).hashCode());
        Integer $contractSmsFlag = this.getContractSmsFlag();
        result = result * 59 + ($contractSmsFlag == null ? 43 : ((Object)$contractSmsFlag).hashCode());
        Integer $isWidthPosition = this.getIsWidthPosition();
        result = result * 59 + ($isWidthPosition == null ? 43 : ((Object)$isWidthPosition).hashCode());
        Boolean $onlyPrimaryOrder = this.getOnlyPrimaryOrder();
        result = result * 59 + ($onlyPrimaryOrder == null ? 43 : ((Object)$onlyPrimaryOrder).hashCode());
        Integer $isSubOrder = this.getIsSubOrder();
        result = result * 59 + ($isSubOrder == null ? 43 : ((Object)$isSubOrder).hashCode());
        Long $signNodeId = this.getSignNodeId();
        result = result * 59 + ($signNodeId == null ? 43 : ((Object)$signNodeId).hashCode());
        String $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : $orderNo.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $studentQuery = this.getStudentQuery();
        result = result * 59 + ($studentQuery == null ? 43 : $studentQuery.hashCode());
        String $bizUnitCode = this.getBizUnitCode();
        result = result * 59 + ($bizUnitCode == null ? 43 : $bizUnitCode.hashCode());
        String $examTypeCode = this.getExamTypeCode();
        result = result * 59 + ($examTypeCode == null ? 43 : $examTypeCode.hashCode());
        String $productTypeCode = this.getProductTypeCode();
        result = result * 59 + ($productTypeCode == null ? 43 : $productTypeCode.hashCode());
        String $protocolCode = this.getProtocolCode();
        result = result * 59 + ($protocolCode == null ? 43 : $protocolCode.hashCode());
        Date $createStartDate = this.getCreateStartDate();
        result = result * 59 + ($createStartDate == null ? 43 : ((Object)$createStartDate).hashCode());
        Date $createEndDate = this.getCreateEndDate();
        result = result * 59 + ($createEndDate == null ? 43 : ((Object)$createEndDate).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        Collection<Long> $ids = this.getIds();
        result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
        List<String> $courseCodeList = this.getCourseCodeList();
        result = result * 59 + ($courseCodeList == null ? 43 : ((Object)$courseCodeList).hashCode());
        String $queryCourse = this.getQueryCourse();
        result = result * 59 + ($queryCourse == null ? 43 : $queryCourse.hashCode());
        Collection<String> $bindingIds = this.getBindingIds();
        result = result * 59 + ($bindingIds == null ? 43 : ((Object)$bindingIds).hashCode());
        Date $classStartDate1 = this.getClassStartDate1();
        result = result * 59 + ($classStartDate1 == null ? 43 : ((Object)$classStartDate1).hashCode());
        Date $classStartDate2 = this.getClassStartDate2();
        result = result * 59 + ($classStartDate2 == null ? 43 : ((Object)$classStartDate2).hashCode());
        Date $classEndDate1 = this.getClassEndDate1();
        result = result * 59 + ($classEndDate1 == null ? 43 : ((Object)$classEndDate1).hashCode());
        Date $classEndDate2 = this.getClassEndDate2();
        result = result * 59 + ($classEndDate2 == null ? 43 : ((Object)$classEndDate2).hashCode());
        String $positionId = this.getPositionId();
        result = result * 59 + ($positionId == null ? 43 : $positionId.hashCode());
        String $examPeriod = this.getExamPeriod();
        result = result * 59 + ($examPeriod == null ? 43 : $examPeriod.hashCode());
        Set<String> $examPeriods = this.getExamPeriods();
        result = result * 59 + ($examPeriods == null ? 43 : ((Object)$examPeriods).hashCode());
        Set<Integer> $refundStatusSet = this.getRefundStatusSet();
        result = result * 59 + ($refundStatusSet == null ? 43 : ((Object)$refundStatusSet).hashCode());
        return result;
    }

    public String toString() {
        return "OrderListReqDto(orderNo=" + this.getOrderNo() + ", mobile=" + this.getMobile() + ", studentQuery=" + this.getStudentQuery() + ", entryNodeId=" + this.getEntryNodeId() + ", payStatus=" + this.getPayStatus() + ", refundStatus=" + this.getRefundStatus() + ", bizUnitCode=" + this.getBizUnitCode() + ", examTypeCode=" + this.getExamTypeCode() + ", productTypeCode=" + this.getProductTypeCode() + ", protocolCode=" + this.getProtocolCode() + ", createStartDate=" + this.getCreateStartDate() + ", createEndDate=" + this.getCreateEndDate() + ", salesId=" + this.getSalesId() + ", salesNodeId=" + this.getSalesNodeId() + ", pageDto=" + this.getPageDto() + ", isFromPc=" + this.getIsFromPc() + ", ids=" + this.getIds() + ", courseCodeList=" + this.getCourseCodeList() + ", queryCourse=" + this.getQueryCourse() + ", isPage=" + this.isPage() + ", isSelectAll=" + this.getIsSelectAll() + ", bindingIds=" + this.getBindingIds() + ", isCall=" + this.isCall() + ", classStartDate1=" + this.getClassStartDate1() + ", classStartDate2=" + this.getClassStartDate2() + ", classEndDate1=" + this.getClassEndDate1() + ", classEndDate2=" + this.getClassEndDate2() + ", signStatus=" + this.getSignStatus() + ", branchSchoolId=" + this.getBranchSchoolId() + ", verifyStatus=" + this.getVerifyStatus() + ", downPaidStatus=" + this.getDownPaidStatus() + ", positionId=" + this.getPositionId() + ", interviewStatus=" + this.getInterviewStatus() + ", scoreStatus=" + this.getScoreStatus() + ", orderType=" + this.getOrderType() + ", examPeriod=" + this.getExamPeriod() + ", examPeriods=" + this.getExamPeriods() + ", refundStatusSet=" + this.getRefundStatusSet() + ", contractSmsFlag=" + this.getContractSmsFlag() + ", isWidthPosition=" + this.getIsWidthPosition() + ", onlyPrimaryOrder=" + this.getOnlyPrimaryOrder() + ", isSubOrder=" + this.getIsSubOrder() + ", signNodeId=" + this.getSignNodeId() + ", queryShareOrder=" + this.isQueryShareOrder() + ")";
    }
}

