package cn.kinyun.trade.service;

import cn.kinyun.trade.dto.StuInfoDto;
import cn.kinyun.trade.dto.StudentInfoReqDto;
import cn.kinyun.trade.dto.StudentInfoRespDto;
import cn.kinyun.trade.dto.StudentQueryReq;

import java.util.List;
import java.util.Map;
import java.util.Set;

public interface TradeStudentService {

    StudentInfoRespDto getStudentInfoByOpenId(Long bizId, String openId);

    StudentInfoRespDto getStudentInfoByOfficialOpenId(Long bizId, String openId);

    StudentInfoRespDto getStudentInfoByUnionId(Long bizId, String unionId);

    void unbindByMobile(String corpId, String mobile);

    StudentInfoRespDto insertOrUpdateStudentInfo(StudentInfoReqDto req);

    /**
     * 通过学生id批量查询学生信息
     **/
    List<StuInfoDto> getStuInfoByIds(List<Long> ids);

    /**
     * id转num
     **/
    Map<Long,String> getNumById(List<Long> ids);

    /**
     * num转id
     **/
    Map<String,Long> getIdByNum(List<String> nums);

    /**
     * 根据条件查询学社ID
     * @param req
     * @return
     */
    List<Long> queryStudentInfo(StudentQueryReq req);

    /**
     * 根据条件查询学员id集合
     * @param bzId 商户id
     * @param query 学员姓名/电话
     * @return 学员id集合
     */
    Set<Long> getStudentIds(Long bzId, String query);
}
