package cn.kinyun.trade.service;

import cn.kinyun.trade.dto.*;
import com.kuaike.common.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface TradeClassService {

    /**
     * 通过classId查询班级下所有学生信息
     **/
    List<StuInfoDto> getStuInfoByClassId(Long bizId, Long classId, String query);

    /**
     * 分页查询classId下学生信息
     **/
    StuInfoResp getStuInfoByClassId(StudentQueryReq req);

    /**
     * 根据classId列表批量查询所有学生id
     **/
    StuIdsByClassIdsRespDto getStuIdsByClassIdsPageDto(Long bizId, List<Long> classIds, List<Long> stuIdList, PageDto pageDto);

    Set<Long> getStuIdsByClassIds(Long bizId, List<Long> classIds);

    /**
     * 根据classCode列表批量查询所有学生id
     **/
    Set<Long> getStuIdsByClassCodes(Long bizId, List<String> classCodes);

    /**
     * 根据bizId获取所有在班学生id
     **/
    Set<Long> getStuIdsByBizId(Long bizId);

    /**
     * 根据stuId查询学生所在班id
     */
    List<Long> queryClassIdByStudentId(Long bizId, Long stuId);

    /**
     * id转num
     **/
    Map<Long,String> getNumById(List<Long> ids);

    /**
     * num转id
     **/
    Map<String,Long> getIdByNum(List<String> nums);


    TradeListResp list(ClassListReq reqDto);


    Set<Long> getClassIdSet(ClassListReq reqDto);

    /**
     * 根据条件查询对应的班级id
     */
    Set<Long> getClassIds(ClassQueryReqDto reqDto);

    /**
     * 根据班级ids获取对应的简明信息
     */
    List<ClassSimpleInfoDto> getClassSimpleInfoByIds(Long bizId, Collection<Long> classIds);

    Map<Long, List<Long>> getClassByStuIds(Long bzId, List<Long> stuIds);

}
