package cn.kinyun.trade.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author sunwen
 */
@Data
public class RefundListRespDto implements Serializable {

    /**
     * 业务退款单号
     */
    private String bizRefundNo;

    /**
     * 退款单号
     */
    private String refundNo;

    /**
     * 学员姓名
     */
    private String studentName;

    /**
     * 学员电话
     */
    private String studentMobile;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 订单类型 1：优惠券订单 2:课程订单
     */
    private Integer orderType;
    private String orderTypeDesc;

    /**
     * 退款类型
     * @see cn.kinyun.trade.enums.RefundTypeEnum
     */
    private Integer refundType;
    private String refundTypeDesc;

    /**
     * 退款方式 1:退转一体 2:转账
     */
    private Integer refundWay;
    private String refundWayDesc;

    /**
     * 账号类型 1:银行卡 2:支付宝
     */
    private Integer accountType;
    private String accountTypeDesc;

    /**
     * 收款账户号
     */
    private String accountNo;
    /**
     * 开户姓名
     */
    private String accountName;

    /**
     * 退款金额 单位为分
     */
    private Long refundAmount;

    /**
     * 退款发起人名称
     */
    private String refundOperator;

    /**
     * 退款发起时间
     */
    private Date refundOperateTime;
}
