package cn.kinyun.trade.dto;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.*;
import java.util.regex.Pattern;

/**
 * @author zyl
 */
@Data
@ApiModel("订单列表请求")
public class OrderListReqDto implements Serializable {

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("手机号/名字")
    private String studentQuery;

    @ApiModelProperty("报名分校ID")
    private Long entryNodeId;

    @ApiModelProperty("支付状态 PayStatusEnum")
    private Integer payStatus;

    @ApiModelProperty("订单对应课程退费状态 RefundStatusEnum")
    private Integer refundStatus;

    @ApiModelProperty("项目编码")
    private String bizUnitCode;

    @ApiModelProperty("考试类型编码")
    private String examTypeCode;

    @ApiModelProperty("产品类型编码")
    private String productTypeCode;

    @ApiModelProperty("协议类型编码")
    private String protocolCode;

    @ApiModelProperty("创建开始日期")
    private Date createStartDate;

    @ApiModelProperty("创建日期结束时间")
    private Date createEndDate;

    @ApiModelProperty("成单人")
    private Long salesId;

    @ApiModelProperty("成单分校")
    private Long salesNodeId;

    private PageDto pageDto;

    // 是否来源与 pc 端，pc端返回的信息多，移动端返回的信息少
    private Boolean isFromPc = true;

    /**
     * 订单主键id列表
     **/
    private Collection<Long> ids;
    /**
     * 课程编码列表
     **/
    private List<String> courseCodeList;

    /**
     * 课程编码精确查询或课程名称模糊查询
     **/
    private String queryCourse;
    /**
     * 是否分页，默认分页
     **/
    private boolean isPage = true;
    /**
     * 是否全选 0：否 1：是
     **/
    private Integer isSelectAll;
    /**
     * 选中的订单编号
     **/
    private Collection<String> bindingIds;
    /**
     * 是否是外呼
     **/
    private boolean isCall = false;

    /**
     * 开课时间第一个时间
     **/
    private Date classStartDate1;

    /**
     * 开课时间第2个时间
     **/
    private Date classStartDate2;

    /**
     * 结课时间第一个时间
     **/
    private Date classEndDate1;

    /**
     * 结课时间第2个时间
     **/
    private Date classEndDate2;

    /**
     * 电子合同签署状态
     */
    private Integer signStatus;

    /**
     * 开课分校
     **/
    private Long branchSchoolId;

    /**
     * 实名认证状态
     */
    private Integer verifyStatus;

    /**
     * 先交后补首付支付状态
     */
    private Integer downPaidStatus;

    private String positionId;

    /**
     * 进面状态 1为进面，0为未进面 2为名单未出
     **/
    private Integer interviewStatus;

    /**
     * 成绩状态 1为已录  2为未录， 3 已录审批中
     **/
    private Integer scoreStatus;

    private Integer orderType;

    private String examPeriod;

    private Set<String> examPeriods;

    private Set<Integer> refundStatusSet;
    /**
     * 0：未发送签署合同短信 1：已发送签署合同短信
     */
    private Integer contractSmsFlag;

    /**
     * 订单是否携带职位
     **/
    private Integer isWidthPosition;

    /**
     * 仅查找主订单
     **/
    private Boolean onlyPrimaryOrder = false;

    /**
     * 是否为子订单
     **/
    private Integer isSubOrder;

    /**
     * 签约分校
     **/
    private Long signNodeId;

    /**
     * 是否查询分享订单
     **/
    private boolean queryShareOrder = false;


    public OrderQuery toQuery(String corpId) {
        OrderQuery query = new OrderQuery();
        BeanUtils.copyProperties(this, query);
        query.setCorpId(corpId);

        if (StringUtils.isNotBlank(studentQuery)) {
            if (isInteger(studentQuery)) {
                query.setMobile(studentQuery);
            } else {
                query.setStudentName(studentQuery);
            }
        }
        query.setJoinProduct(StringUtils.isNotBlank(bizUnitCode) ||
                StringUtils.isNotBlank(examTypeCode) ||
                StringUtils.isNotBlank(productTypeCode));
        query.setJoinCourse(CollectionUtils.isNotEmpty(courseCodeList) || StringUtils.isNotBlank(queryCourse) || Objects.nonNull(classStartDate1)
                || Objects.nonNull(classEndDate1) || Objects.nonNull(branchSchoolId));

        if (StringUtils.isNotBlank(positionId) || Objects.nonNull(interviewStatus)) {
            query.setJoinPosition(true);
        }
        if (scoreStatus != null) {
            query.setJoinScore(true);
        }
        if (isPage){
            pageDto = Optional.ofNullable(pageDto).orElse(new PageDto());
            query.setOffset(pageDto.getOffset());
            query.setLimit(pageDto.getPageSize());
        }
        query.setJoinOrderProtocolRule(Objects.nonNull(downPaidStatus));
        query.setJoinStudent(Objects.nonNull(verifyStatus) || Objects.nonNull(interviewStatus));
        query.setJoinOrderContract(Objects.nonNull(signStatus));
        query.setJoinPositionInterview(Objects.nonNull(interviewStatus));
        query.setQueryShareOrder(queryShareOrder);
        if (CollectionUtils.isNotEmpty(refundStatusSet)) {
            query.setJoinOrderRefund(true);
        }
        query.setContractSmsFlag(contractSmsFlag);
        return query;
    }

    public boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public void validate(){
        isSelectAll = Optional.ofNullable(isSelectAll).orElse(0);
        Preconditions.checkArgument(isSelectAll == 0 || isSelectAll == 1, "是否全选参数不合法");
        if (isSelectAll == 0) {
            Preconditions.checkArgument(org.apache.commons.collections4.CollectionUtils.isNotEmpty(bindingIds), "勾选模式下，选中的列表不能为空");
        }
    }
}
