package cn.kinyun.trade.dto;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.io.Serializable;

@Data
@ColumnWidth(15)
@ExcelIgnoreUnannotated
public class OrderExportRespDto implements Serializable {

    @ExcelProperty("订单编号")
    private String orderNo;

    @ExcelProperty("项目")
    private String bizUnitName;

    @ExcelProperty("课程名称")
    private String courseName;

    @ExcelProperty("考试类型")
    private String examTypeName;

    @ExcelProperty("学员")
    private String studentName;

    @ExcelProperty("手机号")
    private String mobile;

    @ExcelProperty("身份证")
    private String idNo;

    @ExcelProperty("老学员")
    private String isOldStudentDesc;

    @ExcelProperty("协议类型")
    private String protocolCode;

    @ExcelProperty("协议名称")
    private String protocolName;

    @ExcelProperty("开课分校")
    private String courseBranchName;

    @ColumnWidth(22)
    @ExcelProperty("开课时间")
    private String startDate;

    @ColumnWidth(22)
    @ExcelProperty("结课时间")
    private String endDate;

    @ExcelProperty("课时")
    private Float classHour;

    @ExcelProperty("天数")
    private Float days;

    @ExcelProperty("支付状态")
    private String payStatusDesc;

    @ExcelProperty("已付首付")
    private String downPaidStatusDesc;

    @ExcelProperty("报名状态")
    private String refundStatusDesc;

    @ExcelProperty("学员类型")
    private String orderTypeDesc;

    @ExcelProperty("学费合计")
    private Float totalAmount;

    @ExcelProperty("优惠金额")
    private Float discountAmount;

    @ExcelProperty("优惠名称")
    private String discountName;

    @ExcelProperty("收款金额")
    private Float paidAmount;

    @ExcelProperty("尾款")
    private Float remainAmount;

    @ExcelProperty("协议订单")
    private String protocolOrderNo;

    @ExcelProperty("成单人")
    private String salesName;

    @ExcelProperty("成单分校")
    private String salesNodeName;

    @ExcelProperty("业绩分校")
    private String performanceNodeName;

    @ExcelProperty("退费类型")
    private String refundTypeDesc;

    @ExcelProperty("代理商")
    private String agentMerchant;

    @ExcelProperty("地区")
    private String fullAreaName;

    @ColumnWidth(22)
    @ExcelProperty("创建时间")
    private String createTime;

    @ExcelProperty("更新人")
    private String updaterName;

    @ExcelProperty("创建人")
    private String creatorName;

    @ExcelProperty("类型")
    private String productTypeName;

    @ColumnWidth(22)
    @ExcelProperty("更新时间")
    private String updateTime;

    @ExcelProperty("源订单")
    private String originOrderNo;

    @ExcelProperty("学科学段")
    private String studyPhaseSubject;

    @ExcelProperty("发票状态")
    private String  invoiceStatusDesc;

    @ExcelProperty("承诺书签署状态")
    private String  insuranceStatusDesc;

    @ExcelProperty("录用结果")
    private String scoreResult;

    @ExcelProperty("职位名称")
    private String positionName;

    @ExcelProperty("职位代码")
    private String recruitCode;

    @ExcelProperty("招录地区")
    private String recruitArea;

    @ExcelProperty("招录机关")
    private String recruitAgency;

    @ExcelProperty("已报班人数")
    private Integer positionSignUpCount;

    @ExcelProperty("机构")
    private String agency;

    @ExcelProperty("招录人数")
    private Integer recruitCount;

    @ExcelProperty("排名")
    private Integer examRank;

    @ExcelProperty("守擂/翻盘")
    private String defendTypeName;

    @ExcelProperty("分差")
    private String diffScore;

    @ExcelProperty("备注")
    private String remark;

}
