package cn.kinyun.trade.dto;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel("住宿学员列表")
@ExcelIgnoreUnannotated
public class DormResideStudentResp implements Serializable {

    private Long id;

    @ExcelProperty("姓名")
    @ColumnWidth(20)
    private String studentName;

    @ExcelProperty("手机号")
    @ColumnWidth(20)
    private String mobile;

    @ExcelProperty("入住日期")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(20)
    private Date checkinTime;

    @ExcelProperty("退房日期")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(20)
    private Date checkoutTime;

    @ExcelProperty("办理退房日期")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(23)
    private Date realCheckoutTime;

    @ExcelProperty("班级")
    @ColumnWidth(20)
    private String className;

    @ExcelProperty("班级编号")
    @ColumnWidth(20)
    private String classCode;

    @ExcelProperty("教务")
    @ColumnWidth(18)
    private String teacherName;

    @ExcelProperty("床铺编号")
    @ColumnWidth(18)
    private String bedNo;

    @ExcelProperty("密码")
    @ColumnWidth(18)
    private String lockPwd;

    private Integer block;

    private Long roomId;
    private String roomNo;

    private Integer bedStatus;
    private String bedStatusDesc;

    private Integer resideStatus;
    @ExcelProperty("状态")
    @ColumnWidth(15)
    private String resideStatusDesc;

    private Integer depositStatus;
    @ExcelProperty("押金状态")
    @ColumnWidth(20)
    private String depositStatusDesc;

    private Integer residentType;
    @ExcelProperty("居住人类型")
    @ColumnWidth(20)
    private String residentTypeDesc;

    private Integer gender;
    @ExcelProperty("居住人性别")
    private String genderDesc;


}
