package cn.kinyun.trade.dto;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel(value = "住宿学员列表查询条件")
public class DormResideStudentReq implements Serializable {

    @ApiModelProperty(value = "班级名称")
    private String className;

    @ApiModelProperty(value = "班级编号")
    private String classCode;

    @ApiModelProperty(value = "押金状态")
    private Integer depositStatus;

    @ApiModelProperty(value = "学员查询条件 姓名/手机号")
    private String studentQuery;

    private Integer residentType;

    private Date checkinTimeBegin;
    private Date checkinTimeEnd;

    private Date checkoutTimeBegin;
    private Date checkoutTimeEnd;

    private String roomNo;
    private Integer resideStatus;

    @ApiModelProperty(value = "分页信息")
    private PageDto pageDto;
}
