package cn.kinyun.trade.dto;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class ClassListReq implements Serializable {

    private Long bizId;

    private String corpId;

    private Long userId;

    private String className;

    private String classCode;

    private List<Long> superVisorIds;

    private PageDto pageDto;

    private Long teacherId;

    /**
     * 开课结束日期
     **/
    private Date classStartDate2;

    private Date classStartDate1;

    private String bizUnitCode;

    /**
     * 开课分校
     */
    private Long branchSchoolId;

    /**
     * 考试类型编码
     **/
    private String examTypeCode;

    private String examPeriod;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "商户ID不能为空");
        Preconditions.checkArgument(userId != null, "用户ID不能为空");
        Preconditions.checkArgument(StringUtils.isNotEmpty(corpId), "corpId不能为空");
    }
}
