/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.pay.business.utils;

import cn.kinyun.pay.business.utils.JsonSortUtil;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalSignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(DigitalSignatureUtil.class);
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final Integer RSA_SIZE = 1024;

    private DigitalSignatureUtil() {
    }

    public static KeyPair getKeyPair() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyGen.initialize(RSA_SIZE);
        KeyPair keyPair = keyGen.generateKeyPair();
        return keyPair;
    }

    public static Pair<String, String> getTupleKey() throws Exception {
        KeyPair keyPair = DigitalSignatureUtil.getKeyPair();
        String privateKey = Base64.encodeBase64String((byte[])keyPair.getPrivate().getEncoded());
        String publicKey = Base64.encodeBase64String((byte[])keyPair.getPublic().getEncoded());
        return new ImmutablePair((Object)privateKey, (Object)publicKey);
    }

    public static String signFromSha1WithRSA(Object obj, String privateKey) {
        String sign;
        try {
            sign = DigitalSignatureUtil.getSha1WithRSASign(JsonSortUtil.sortBy(obj), privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u5f02\u5e38", e);
        }
        return sign;
    }

    public static String getSha1WithRSASign(String content, String privateKey) throws Exception {
        byte[] privateKeyBytes = Base64.decodeBase64((String)privateKey);
        byte[] contentBytes = content.getBytes("utf-8");
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(keyFactory.generatePrivate(pkcs8EncodedKeySpec));
        signature.update(contentBytes);
        byte[] signs = signature.sign();
        return Base64.encodeBase64String((byte[])signs);
    }

    public static String calPublicKeyFromPrivateKey(String privateKey) throws Exception {
        byte[] privateKeyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey1 = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        KeyFactory kf = KeyFactory.getInstance(KEY_ALGORITHM);
        RSAPrivateKeySpec priv = kf.getKeySpec(privateKey1, RSAPrivateKeySpec.class);
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(priv.getModulus(), BigInteger.valueOf(65537L));
        PublicKey publicKey = kf.generatePublic(keySpec);
        return Base64.encodeBase64String((byte[])publicKey.getEncoded());
    }
}

