/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.pay.business.status;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum RefundStatus {
    INIT(10, "\u5f85\u5904\u7406"),
    REFUNDING(1, "\u5904\u7406\u4e2d"),
    REFUND_SUCCESS(2, "\u6210\u529f"),
    REFUND_FAILED(3, "\u5931\u8d25"),
    REFUND_CANCELED(4, "\u64a4\u9500");

    private static final Map<Integer, RefundStatus> MAP;
    private static final Set<Integer> finalStatusSet;
    private int value;
    private String desc;

    private RefundStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static RefundStatus get(int value) {
        return MAP.get(value);
    }

    public static Set<Integer> getFinalStatusSet() {
        return finalStatusSet;
    }

    static {
        finalStatusSet = Sets.newHashSet((Object[])new Integer[]{REFUND_SUCCESS.getValue(), REFUND_FAILED.getValue(), REFUND_CANCELED.getValue()});
        MAP = ImmutableMap.copyOf(Arrays.stream(RefundStatus.values()).collect(Collectors.toMap(RefundStatus::getValue, e -> e)));
    }
}

