/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.pay.business.dto.request;

import cn.kinyun.pay.business.dto.request.BaseRequest;
import cn.kinyun.pay.business.dto.request.trans.BaseAccountInfo;
import cn.kinyun.pay.business.enums.PayTransChannelType;
import cn.kinyun.pay.business.enums.SourceType;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TransRequest
extends BaseRequest {
    private String amount;
    private String bizOrderNum;
    private String bizTransNum;
    private String refundReason;
    private Integer payTransType;
    private BaseAccountInfo accountInfo;
    private Integer sourceType;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.bizTransNum), (Object)"bizTransNum\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.amount) && this.amount.matches("\\d+") ? 1 : 0) != 0, (Object)"\u65e0\u6548\u7684amount,\u91d1\u989d\u5fc5\u987b\u4ee5\u5206\u4e3a\u5355\u4f4d,\u4e14\u662f\u4e00\u4e2a\u6b63\u6574\u6570");
        Long totalAmountNum = NumberUtils.toLong((String)this.amount);
        Preconditions.checkArgument((totalAmountNum >= 10L && totalAmountNum < 100000000000L ? 1 : 0) != 0, (Object)"amount\u53d6\u503c\u8303\u56f4\u4e3a:[10,100000000000)");
        Preconditions.checkArgument((Objects.nonNull(this.payTransType) && PayTransChannelType.get(this.payTransType) != null ? 1 : 0) != 0, (Object)"\u8f6c\u8d26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.accountInfo), (Object)"\u8f6c\u8d26\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        this.accountInfo.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.bizOrderNum), (Object)"bizOrderNum \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.refundReason), (Object)"refundReason \u4e0d\u80fd\u4e3a\u7a7a");
        if (Objects.isNull(this.sourceType)) {
            this.sourceType = SourceType.DEFAULT.getType();
        }
    }

    @Override
    public String toString() {
        return "TransRequest(amount=" + this.getAmount() + ", bizOrderNum=" + this.getBizOrderNum() + ", bizTransNum=" + this.getBizTransNum() + ", refundReason=" + this.getRefundReason() + ", payTransType=" + this.getPayTransType() + ", accountInfo=" + this.getAccountInfo() + ", sourceType=" + this.getSourceType() + ")";
    }

    public String getAmount() {
        return this.amount;
    }

    public String getBizOrderNum() {
        return this.bizOrderNum;
    }

    public String getBizTransNum() {
        return this.bizTransNum;
    }

    public String getRefundReason() {
        return this.refundReason;
    }

    public Integer getPayTransType() {
        return this.payTransType;
    }

    public BaseAccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setBizOrderNum(String bizOrderNum) {
        this.bizOrderNum = bizOrderNum;
    }

    public void setBizTransNum(String bizTransNum) {
        this.bizTransNum = bizTransNum;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public void setPayTransType(Integer payTransType) {
        this.payTransType = payTransType;
    }

    public void setAccountInfo(BaseAccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransRequest)) {
            return false;
        }
        TransRequest other = (TransRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$payTransType = this.getPayTransType();
        Integer other$payTransType = other.getPayTransType();
        if (this$payTransType == null ? other$payTransType != null : !((Object)this$payTransType).equals(other$payTransType)) {
            return false;
        }
        Integer this$sourceType = this.getSourceType();
        Integer other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !((Object)this$sourceType).equals(other$sourceType)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$bizOrderNum = this.getBizOrderNum();
        String other$bizOrderNum = other.getBizOrderNum();
        if (this$bizOrderNum == null ? other$bizOrderNum != null : !this$bizOrderNum.equals(other$bizOrderNum)) {
            return false;
        }
        String this$bizTransNum = this.getBizTransNum();
        String other$bizTransNum = other.getBizTransNum();
        if (this$bizTransNum == null ? other$bizTransNum != null : !this$bizTransNum.equals(other$bizTransNum)) {
            return false;
        }
        String this$refundReason = this.getRefundReason();
        String other$refundReason = other.getRefundReason();
        if (this$refundReason == null ? other$refundReason != null : !this$refundReason.equals(other$refundReason)) {
            return false;
        }
        BaseAccountInfo this$accountInfo = this.getAccountInfo();
        BaseAccountInfo other$accountInfo = other.getAccountInfo();
        return !(this$accountInfo == null ? other$accountInfo != null : !((Object)this$accountInfo).equals(other$accountInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TransRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $payTransType = this.getPayTransType();
        result = result * 59 + ($payTransType == null ? 43 : ((Object)$payTransType).hashCode());
        Integer $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : ((Object)$sourceType).hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $bizOrderNum = this.getBizOrderNum();
        result = result * 59 + ($bizOrderNum == null ? 43 : $bizOrderNum.hashCode());
        String $bizTransNum = this.getBizTransNum();
        result = result * 59 + ($bizTransNum == null ? 43 : $bizTransNum.hashCode());
        String $refundReason = this.getRefundReason();
        result = result * 59 + ($refundReason == null ? 43 : $refundReason.hashCode());
        BaseAccountInfo $accountInfo = this.getAccountInfo();
        result = result * 59 + ($accountInfo == null ? 43 : ((Object)$accountInfo).hashCode());
        return result;
    }
}

