/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.pay.business.dto.request;

import cn.kinyun.pay.business.dto.request.BaseRequest;
import cn.kinyun.pay.business.dto.vo.OrderHeaderDto;
import cn.kinyun.pay.business.enums.PayChannelType;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class OrderRequest
extends BaseRequest {
    private Integer channelType;
    private String totalAmount;
    private String subject;
    private Integer timeoutMinute;
    private String params;
    private OrderHeaderDto orderHeaderDto;
    private String corpAppChannelNum;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.channelType != null && PayChannelType.get(this.channelType) != null ? 1 : 0) != 0, (Object)"\u65e0\u6548\u7684channelType");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.totalAmount) && this.totalAmount.matches("\\d+") ? 1 : 0) != 0, (Object)"\u65e0\u6548\u7684totalAmount,\u91d1\u989d\u5fc5\u987b\u4ee5\u5206\u4e3a\u5355\u4f4d,\u4e14\u662f\u4e00\u4e2a\u6b63\u6574\u6570");
        Long totalAmountNum = NumberUtils.toLong((String)this.totalAmount);
        Preconditions.checkArgument((totalAmountNum > 0L && totalAmountNum < 100000000000L ? 1 : 0) != 0, (Object)"totalAmount\u53d6\u503c\u8303\u56f4\u4e3a:(0,100000000000)");
        Preconditions.checkArgument((this.orderHeaderDto != null ? 1 : 0) != 0, (Object)"orderHeaderDto \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.subject), (Object)"subject \u5546\u54c1\u7b80\u5355\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Long amountNum = this.orderHeaderDto.validate();
        Preconditions.checkArgument((amountNum >= totalAmountNum ? 1 : 0) != 0, (Object)"\u672c\u6b21\u652f\u4ed8\u91d1\u989dtotalAmount\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u603b\u91d1\u989damount");
        if (this.timeoutMinute == null) {
            this.timeoutMinute = 30;
        } else {
            Preconditions.checkArgument((this.timeoutMinute >= 5 && this.timeoutMinute <= 120 ? 1 : 0) != 0, (Object)"timeoutMinute\u53d6\u503c\u8303\u56f4\u4e3a[5,120]");
        }
    }

    public Integer getChannelType() {
        return this.channelType;
    }

    public String getTotalAmount() {
        return this.totalAmount;
    }

    public String getSubject() {
        return this.subject;
    }

    public Integer getTimeoutMinute() {
        return this.timeoutMinute;
    }

    public String getParams() {
        return this.params;
    }

    public OrderHeaderDto getOrderHeaderDto() {
        return this.orderHeaderDto;
    }

    public String getCorpAppChannelNum() {
        return this.corpAppChannelNum;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTimeoutMinute(Integer timeoutMinute) {
        this.timeoutMinute = timeoutMinute;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setOrderHeaderDto(OrderHeaderDto orderHeaderDto) {
        this.orderHeaderDto = orderHeaderDto;
    }

    public void setCorpAppChannelNum(String corpAppChannelNum) {
        this.corpAppChannelNum = corpAppChannelNum;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderRequest)) {
            return false;
        }
        OrderRequest other = (OrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$channelType = this.getChannelType();
        Integer other$channelType = other.getChannelType();
        if (this$channelType == null ? other$channelType != null : !((Object)this$channelType).equals(other$channelType)) {
            return false;
        }
        Integer this$timeoutMinute = this.getTimeoutMinute();
        Integer other$timeoutMinute = other.getTimeoutMinute();
        if (this$timeoutMinute == null ? other$timeoutMinute != null : !((Object)this$timeoutMinute).equals(other$timeoutMinute)) {
            return false;
        }
        String this$totalAmount = this.getTotalAmount();
        String other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !this$totalAmount.equals(other$totalAmount)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$params = this.getParams();
        String other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        OrderHeaderDto this$orderHeaderDto = this.getOrderHeaderDto();
        OrderHeaderDto other$orderHeaderDto = other.getOrderHeaderDto();
        if (this$orderHeaderDto == null ? other$orderHeaderDto != null : !((Object)this$orderHeaderDto).equals(other$orderHeaderDto)) {
            return false;
        }
        String this$corpAppChannelNum = this.getCorpAppChannelNum();
        String other$corpAppChannelNum = other.getCorpAppChannelNum();
        return !(this$corpAppChannelNum == null ? other$corpAppChannelNum != null : !this$corpAppChannelNum.equals(other$corpAppChannelNum));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OrderRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $channelType = this.getChannelType();
        result = result * 59 + ($channelType == null ? 43 : ((Object)$channelType).hashCode());
        Integer $timeoutMinute = this.getTimeoutMinute();
        result = result * 59 + ($timeoutMinute == null ? 43 : ((Object)$timeoutMinute).hashCode());
        String $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : $totalAmount.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        OrderHeaderDto $orderHeaderDto = this.getOrderHeaderDto();
        result = result * 59 + ($orderHeaderDto == null ? 43 : ((Object)$orderHeaderDto).hashCode());
        String $corpAppChannelNum = this.getCorpAppChannelNum();
        result = result * 59 + ($corpAppChannelNum == null ? 43 : $corpAppChannelNum.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OrderRequest(channelType=" + this.getChannelType() + ", totalAmount=" + this.getTotalAmount() + ", subject=" + this.getSubject() + ", timeoutMinute=" + this.getTimeoutMinute() + ", params=" + this.getParams() + ", orderHeaderDto=" + this.getOrderHeaderDto() + ", corpAppChannelNum=" + this.getCorpAppChannelNum() + ")";
    }
}

