package cn.kinyun.pay.business.utils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

@JsonIgnoreProperties
public class JsonSortUtil {

    private JsonSortUtil() {
        throw new UnsupportedOperationException();
    }

    /**
     * 请求对象排序
     *
     * @param obj
     * @return
     */
    public static String sortBy(Object obj) {
        String orderByStr = null;
        try {
            ObjectMapper mapper = new ObjectMapper(); //转换器
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String json = mapper.writeValueAsString(obj); //将对象转换成json
            mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            JsonNode jsonNode = mapper.readTree(json);
            Object request = mapper.treeToValue(jsonNode, Object.class);
            orderByStr = mapper.writeValueAsString(request);
        } catch (Exception ex) {
        }
        return orderByStr;
    }
}
