package cn.kinyun.pay.business.status;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created by jiangtiteng on 2018-12-14
 */
public enum RefundStatus {

    INIT(10, "待处理"),

    REFUNDING(1, "处理中"),

    REFUND_SUCCESS(2, "成功"),

    REFUND_FAILED(3, "失败"),

    REFUND_CANCELED(4, "撤销");

    //UNKOWN(5, "状态未知");

    private static final Map<Integer, RefundStatus> MAP;

    private static final Set<Integer> finalStatusSet = Sets.newHashSet(REFUND_SUCCESS.getValue(), REFUND_FAILED.getValue(), REFUND_CANCELED.getValue());

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(RefundStatus.values()).collect(Collectors.toMap(RefundStatus::getValue, e -> e)));
    }

    RefundStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private int value;

    private String desc;

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static RefundStatus get(int value) {
        return MAP.get(value);
    }

    public static Set<Integer> getFinalStatusSet() {
        return finalStatusSet;
    }
}
