package cn.kinyun.pay.business.service;

import cn.kinyun.pay.business.dto.request.OrderCloseRequest;
import cn.kinyun.pay.business.dto.request.OrderQuerySimpleRequest;
import cn.kinyun.pay.business.dto.request.OrderRequest;
import cn.kinyun.pay.business.dto.request.OrderQueryRequest;
import cn.kinyun.pay.business.dto.response.BaseResponse;
import cn.kinyun.pay.business.dto.response.OrderCloseData;
import cn.kinyun.pay.business.dto.response.OrderData;
import cn.kinyun.pay.business.dto.response.OrderQueryData;

/**
 * Created by titengjiang on 2021/8/31
 */
public interface PayOrderService {
    /**
     * 统一下单接口
     *
     * @param orderRequest
     * @return
     */
    BaseResponse<OrderData> order(OrderRequest orderRequest) throws InterruptedException;

    /**
     * 查询支付订单接口
     *
     * @param queryOrderRequest
     * @return
     */
    BaseResponse<OrderQueryData> queryOrder(OrderQueryRequest queryOrderRequest);

    /**
     * 简化订单查询接口
     *
     * @param orderQuerySimpleRequest
     * @return
     */
    BaseResponse<OrderQueryData> queryOrderSimple(OrderQuerySimpleRequest orderQuerySimpleRequest);


    /**
     * 关闭订单接口
     *
     * @param orderCloseRequest
     * @return
     */
    BaseResponse<OrderCloseData> closeOrder(OrderCloseRequest orderCloseRequest);

}
