package cn.kinyun.pay.business.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum RefundDetailType {

    REFUND(0, "退款"),

    TRANS(1, "转账"),
    ;

    private Integer type;

    private String desc;

    RefundDetailType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, RefundDetailType> MAP;

    static {
        MAP = Arrays.stream(RefundDetailType.values()).collect(Collectors.toMap(a -> a.getType(), a -> a));
    }

    public static RefundDetailType getByType(Integer type){
        return MAP.get(type);
    }
}
