package cn.kinyun.pay.business.dto.request.audit.trans;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Objects;

@SuppressWarnings({"common-java:DuplicatedBlocks"})
@Data
public class TransListCalReq implements Serializable {
    /**
     * 列表查询参数
     */
    private TransListQueryReq query;

    /**
     * 选择模式:
     * 0: 勾选
     * 1: 根据条件全选所有
     * 2: 根据条件全选当前页
     */
    private Integer selectMode;

    public void validate(){
        Preconditions.checkArgument(selectMode == null || (selectMode >= 0 && selectMode <= 2), "选择模式必须在0,2之间");
        if (Objects.isNull(selectMode) || selectMode == 0) {
            selectMode = 0;
            Preconditions.checkArgument(Objects.nonNull(query), "query不能为空");
            Preconditions.checkArgument(CollectionUtils.isNotEmpty(query.getSelectedRequestId()), "勾选模式下,selectedRequestId不能为空");
        } else {
            Preconditions.checkArgument(Objects.nonNull(query), "query不能为空");
            query.validate();
        }
    }
}
