package cn.kinyun.pay.business.dto.request.audit.trans;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

@ToString(callSuper = true)
@Data
public class ManualTransReq extends TransListCalReq {

    private String smsVerify;

    private String remark;


    private Long operatorId;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument(StringUtils.isNotBlank(smsVerify), "短信验证码为空");
        Preconditions.checkArgument(Objects.nonNull(operatorId), "operatorId不能为空");
        if (StringUtils.isNotBlank(remark)) {
            Preconditions.checkArgument(remark.length() < 500, "备注需在500字以内");
        }
    }

    public void rejectValidate() {
        super.validate();
        Preconditions.checkArgument(Objects.nonNull(operatorId), "operatorId不能为空");
        if (StringUtils.isNotBlank(remark)) {
            Preconditions.checkArgument(remark.length() < 500, "备注需在500字以内");
        }
    }
}
