package cn.kinyun.pay.business.dto.request.audit.refund;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@SuppressWarnings({"java:S1068", "common-java:DuplicatedBlocks"})
@Data
public class RefundBatchItem implements Serializable {
    /**
     * 批次号
     */
    private String batchNum;
    /**
     * 退款金额,(元)
     */
    private BigDecimal refundAmount;
    /**
     * 批次笔数, 业务退款单个数
     */
    private Integer bizRefundCount;
    /**
     * 实际退款支付笔数
     */
    private Integer realPayRefundCount;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 退款方式
     */
    private Integer refundType;
    /**
     * 成功总金额
     */
    private BigDecimal successAmount;
    /**
     * 成功总笔数
     */
    private Integer successCount;
    /**
     * 失败总金额
     */
    private BigDecimal failAmount;
    /**
     * 失败总笔数
     */
    private Integer failCount;
    /**
     * 备注
     */
    private String remark;
    /**
     * 出纳审批人
     */
    private String operatorName;
    /**
     * 批次进度,状态
     */
    private Integer status;
    /**
     * 批次状态描述
     */
    private String statusDesc;

}
