package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class TransQueryRequest implements Serializable {

    /**
     * 业务转账单号,(唯一)
     */
    private String bizTransNum;

    /**
     * 支付系统转账单号
     */
    private String transNum;

    /**
     * 转账系统返回的requestId
     */
    private String requestId;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(bizTransNum) || StringUtils.isNotBlank(transNum) || StringUtils.isNotBlank(requestId), "bizTransNum,transNum,requestId不能同时为空");
    }
}
