package cn.kinyun.pay.business.dto.request;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.jboss.netty.util.internal.StringUtil;

import java.io.Serializable;

@Data
public class CertValidReq implements Serializable {

    private String publicKey;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(publicKey), "publicKey不能为空");
    }
}
