/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.crm.common.enums.OrderTradeType;
import cn.kinyun.crm.common.service.dto.req.SaleStateEvent;
import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.dto.QueryOrderDto;
import cn.kinyun.customer.center.dal.entity.Customer;
import cn.kinyun.customer.center.dal.entity.CustomerOrder;
import cn.kinyun.customer.center.dal.entity.CustomerOrderPayRecord;
import cn.kinyun.customer.center.dal.entity.OrderDictionary;
import cn.kinyun.customer.center.dal.entity.OrderSkuList;
import cn.kinyun.customer.center.dal.mapper.CustomerDetailMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerOrderMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerOrderPayRecordMapper;
import cn.kinyun.customer.center.dal.mapper.OrderDictionaryMapper;
import cn.kinyun.customer.center.dal.mapper.OrderSkuListMapper;
import cn.kinyun.customer.center.dal.util.BizTableContext;
import cn.kinyun.customer.center.dto.req.CustomerInfoPageReq;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.req.order.OrderRecordReq;
import cn.kinyun.customer.center.dto.req.order.OrderReq;
import cn.kinyun.customer.center.dto.req.order.OrderSkuListReq;
import cn.kinyun.customer.center.dto.req.order.RefundReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderPayStatusReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderRefundInfoReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderReq;
import cn.kinyun.customer.center.dto.resp.CustomerAndOrderResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderAmountResq;
import cn.kinyun.customer.center.dto.resp.CustomerOrderInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderWeworkInfoResp;
import cn.kinyun.customer.center.dto.resp.DynamicFieldDto;
import cn.kinyun.customer.center.dto.resp.ExtendFieldResp;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.dto.resp.OrderTotalResp;
import cn.kinyun.customer.center.dto.resp.PageCustomerOrderResp;
import cn.kinyun.customer.center.dto.resp.PageOrderListResp;
import cn.kinyun.customer.center.enums.OrderEntryMethodEnum;
import cn.kinyun.customer.center.enums.OrderSource;
import cn.kinyun.customer.center.enums.PayChannelType;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.sal.biz.service.impl.CcCustomerNumServiceImpl;
import cn.kinyun.customer.center.sal.biz.service.impl.CcCustomerService;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.common.OrderMsgDto;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmChannelService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.service.dto.resp.ChannelDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CcCustomerOrderServiceImpl
implements CcCustomerOrderService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerOrderServiceImpl.class);
    @Value(value="${kafka.topic.trade_order}")
    private String topic;
    @Value(value="${sale.state.calculate.topic}")
    private String recalculateStateTopic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private IdGen idGen;
    @Autowired
    private CustomerOrderMapper customerOrderMapper;
    @Autowired
    private CustomerOrderPayRecordMapper customerOrderPayRecordMapper;
    @Autowired
    private CcCustomerDetailService customerDetailService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerNumServiceImpl customerNumService;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private OrderSkuListMapper orderSkuListMapper;
    @Autowired
    private CustomerDetailMapper customerDetailMapper;
    @Autowired
    private OrderDictionaryMapper orderDictionaryMapper;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private ScrmChannelService scrmChannelService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private CcCustomerService customerService;

    public void addOrder(OrderReq params) {
        this.checkAddParam(params);
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"is_deleted", (Object)0));
        boolean exist = true;
        if (record == null) {
            record = new CustomerOrder();
            record.setNum(this.idGen.getNum());
            record.setBizId(params.getBizId());
            BizSimpleDto biz = this.scrmBizService.getById(params.getBizId());
            Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)"invalid bizId");
            record.setCorpId(biz.getCorpId());
            params.setCorpId(biz.getCorpId());
            record.setUserId(params.getUserId());
            params.setAfterOrderUser(params.getUserId());
            record.setWeworkUserNum(params.getWeworkUserNum());
            if (StringUtils.isNotBlank((CharSequence)params.getCustomerNum())) {
                record.setCustomerNum(params.getCustomerNum());
            }
            record.setProductLineId(params.getProductLineId());
            record.setSource(params.getSource());
            record.setOrderNo(params.getOrderNo());
            record.setCreateTime(new Date());
            if (params.getCreateTime() != null) {
                record.setOrderTime(params.getCreateTime());
            } else {
                record.setOrderTime(new Date());
            }
            record.setCreateBy(params.getCreateBy());
            exist = false;
        }
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerNum())) {
            record.setCustomerNum(params.getCustomerNum());
        }
        if (params.getCreateTime() != null) {
            record.setOrderTime(params.getCreateTime());
        }
        record.setOrderAmount(params.getOrderAmount());
        if (exist) {
            this.orderSkuListMapper.delete((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        }
        if (CollectionUtils.isNotEmpty((Collection)params.getOrderSkuListReqs())) {
            for (OrderSkuListReq orderSkuListReq : params.getOrderSkuListReqs()) {
                OrderSkuList orderSkuList = new OrderSkuList();
                orderSkuList.setNum(this.idGen.getNum());
                orderSkuList.setCorpId(record.getCorpId());
                orderSkuList.setBizId(record.getBizId());
                orderSkuList.setOrderNo(params.getOrderNo());
                orderSkuList.setSkuNo(orderSkuListReq.getSkuNo());
                orderSkuList.setSkuName(orderSkuListReq.getSkuName());
                orderSkuList.setSkuAmount(orderSkuListReq.getSkuAmount());
                orderSkuList.setSkuImgUrl(orderSkuListReq.getSkuImgUrl());
                orderSkuList.setRemark(orderSkuListReq.getRemark());
                orderSkuList.setCreateTime(new Date());
                orderSkuList.setUpdateTime(new Date());
                orderSkuList.setIsDeleted(Integer.valueOf(0));
                this.orderSkuListMapper.insert((Object)orderSkuList);
            }
        } else {
            record.setSkuNo(params.getSkuNo());
            record.setSkuName(params.getSkuName());
            record.setSkuImgUrl(params.getSkuImgUrl());
            if (StringUtils.isNotBlank((CharSequence)params.getSkuNo())) {
                OrderSkuList orderSkuList = new OrderSkuList();
                orderSkuList.setNum(this.idGen.getNum());
                orderSkuList.setBizId(record.getBizId());
                orderSkuList.setCorpId(record.getCorpId());
                orderSkuList.setOrderNo(params.getOrderNo());
                orderSkuList.setSkuNo(params.getSkuNo());
                orderSkuList.setSkuName(params.getSkuName());
                orderSkuList.setSkuAmount(params.getSkuAmount());
                orderSkuList.setSkuImgUrl(params.getSkuImgUrl());
                orderSkuList.setCreateTime(new Date());
                orderSkuList.setUpdateTime(new Date());
                orderSkuList.setIsDeleted(Integer.valueOf(0));
                this.orderSkuListMapper.insert((Object)orderSkuList);
            }
        }
        record.setPayStatus(params.getPayStatus());
        if (Objects.nonNull(params.getEntryMethod()) && OrderEntryMethodEnum.MANUAL.getValue().equals(params.getEntryMethod())) {
            record.setEntryMethod(params.getEntryMethod());
            record.setPayStatus(Integer.valueOf(PayStatusEnum.PAID.getValue()));
            if (CollectionUtils.isNotEmpty((Collection)params.getDynamicColValue())) {
                record.setDynamicCol(JacksonUtil.obj2Str((Object)params.getDynamicColValue()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)params.getSource())) {
            record.setSource(params.getSource());
        }
        if (Objects.nonNull(params.getAchieveDepartId())) {
            record.setAchieveDepartId(params.getAchieveDepartId());
        }
        record.setPaidAmount(params.getPaidAmount());
        record.setDiscountAmount(params.getDiscountAmount());
        record.setRefundNo(params.getRefundNo());
        record.setRefundAmount(params.getRefundAmount());
        record.setRefundStatus(params.getRefundStatus());
        record.setFkType(params.getFkType());
        record.setFkId(params.getFkId());
        record.setRemark(params.getRemark());
        record.setUpdateTime(new Date());
        if (exist) {
            params.setBeforeOrderUser(record.getUserId());
            params.setAfterOrderUser(params.getUserId());
            record.setUserId(params.getUserId());
            this.customerOrderMapper.updateById((Object)record);
        } else {
            this.customerOrderMapper.insert((Object)record);
        }
        params.setCustomerOrderNum(record.getNum());
        if (!record.getSource().equals(OrderSource.TRADE_ORDER) && StringUtils.isNotBlank((CharSequence)params.getCustomerMobile())) {
            OrderMsgDto msgDto = this.buildOrderMsg(record, params.getCustomerMobile());
            msgDto.setName(params.getCustomerName());
            log.info("send order msg to kafka crm refresh leads msgDto: {}", (Object)msgDto);
            this.kafkaTemplate.send(this.topic, (Object)record.getOrderNo(), (Object)JacksonUtil.obj2Str((Object)msgDto));
        }
    }

    private OrderMsgDto buildOrderMsg(CustomerOrder customerOrder, String mobile) {
        ChannelDto channelDto = this.scrmChannelService.getByNum(Long.valueOf(0L), "orderCenter");
        OrderMsgDto orderMsgDto = new OrderMsgDto();
        orderMsgDto.setBizId(customerOrder.getBizId());
        orderMsgDto.setCorpId(customerOrder.getCorpId());
        orderMsgDto.setUserId(customerOrder.getUserId());
        orderMsgDto.setSource(customerOrder.getSource());
        orderMsgDto.setProductLineNo(customerOrder.getProductLineId());
        orderMsgDto.setMobile(mobile);
        orderMsgDto.setOrderNo(customerOrder.getOrderNo());
        orderMsgDto.setOrderPrice(customerOrder.getOrderAmount());
        orderMsgDto.setOrderTime(customerOrder.getOrderTime() == null ? null : Long.valueOf(customerOrder.getOrderTime().getTime()));
        orderMsgDto.setTradeAmount(customerOrder.getPaidAmount());
        orderMsgDto.setTradeType(Integer.valueOf(OrderTradeType.PAID.getValue()));
        orderMsgDto.setUserId(customerOrder.getUserId());
        orderMsgDto.setChannelId(channelDto.getId());
        return orderMsgDto;
    }

    private OrderRecordReq buildOrdPayRecordReq(OrderReq orderReq) {
        OrderRecordReq orderRecordReq = new OrderRecordReq();
        BeanUtils.copyProperties((Object)orderReq, (Object)orderRecordReq);
        orderRecordReq.setChannelType(orderReq.getPaidChannelType());
        orderRecordReq.setPayTime(orderReq.getCreateTime());
        orderRecordReq.setPayAmount(orderReq.getPaidAmount());
        return orderRecordReq;
    }

    public void addOrderPayRecord(OrderRecordReq params) {
        log.info("add order pay record, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSource()), (Object)"source is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
        if (StringUtils.isBlank((CharSequence)params.getPayNo())) {
            params.setPayNo("");
        }
        CustomerOrderPayRecord record = (CustomerOrderPayRecord)this.customerOrderPayRecordMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        boolean exist = true;
        if (record == null) {
            record = new CustomerOrderPayRecord();
            record.setNum(this.idGen.getNum());
            record.setBizId(params.getBizId());
            BizSimpleDto biz = null;
            try {
                biz = this.scrmBizService.getById(params.getBizId());
            }
            catch (Exception e) {
                log.error("\u8c03\u7528scrmBizService.getById \u5f02\u5e38\uff1a:param{}", (Object)params.getBizId(), (Object)e);
            }
            Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)"invalid bizId");
            record.setCorpId(biz.getCorpId());
            exist = false;
        } else {
            log.warn("Exist bizId={}, payNo={}", (Object)params.getBizId(), (Object)params.getPayNo());
        }
        record.setPaymentVoucherUrl(params.getPaymentVoucherUrl());
        record.setChannelType(Integer.valueOf(Objects.isNull(params.getChannelType()) ? -1 : params.getChannelType()));
        record.setPayNo(params.getPayNo());
        record.setPayAmount(params.getPayAmount());
        record.setPayTime(params.getPayTime());
        record.setOrderNo(params.getOrderNo());
        record.setFkType(params.getFkType());
        record.setFkId(params.getFkId());
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        if (exist) {
            this.customerOrderPayRecordMapper.updateById((Object)record);
        } else {
            this.customerOrderPayRecordMapper.insert((Object)record);
        }
    }

    public void setOrderPayStatus(SetOrderPayStatusReq params) {
        log.info("set order pay status, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
        Preconditions.checkArgument((params.getPaidAmount() != null ? 1 : 0) != 0, (Object)"paidAmount is null");
        Preconditions.checkArgument((params.getPayStatus() != null ? 1 : 0) != 0, (Object)"payStatus is null");
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        log.warn("order not found, bizId={}, orderNo={}", (Object)params.getBizId(), (Object)params.getOrderNo());
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)("order not found:" + params.getOrderNo()));
        record.setPaidAmount(params.getPaidAmount());
        record.setPayStatus(params.getPayStatus());
        record.setUpdateTime(new Date());
        this.customerOrderMapper.updateById((Object)record);
    }

    public void setOrder(SetOrderReq params) {
        log.info("setOrder req:{}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)("order not found:" + params.getOrderNo()));
        log.info("setOrder old order info:{}", (Object)record);
        boolean flag = false;
        if (params.getBelongUserId() != null) {
            flag = true;
            record.setUserId(params.getBelongUserId());
        }
        if (flag) {
            this.customerOrderMapper.updateById((Object)record);
        }
    }

    public void setOrderRefundInfo(SetOrderRefundInfoReq params) {
        log.info("set order refund info, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getRefundNo()), (Object)"refundNo is null");
        Preconditions.checkArgument((params.getRefundAmount() != null ? 1 : 0) != 0, (Object)"refundAmount is null");
        Preconditions.checkArgument((params.getRefundStatus() != null ? 1 : 0) != 0, (Object)"refundStatus is null");
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        log.warn("order not found, bizId={}, orderNo={}", (Object)params.getBizId(), (Object)params.getOrderNo());
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)("order not found:" + params.getOrderNo()));
        record.setRefundNo(params.getRefundNo());
        record.setRefundStatus(params.getRefundStatus());
        record.setRefundAmount(params.getRefundAmount());
        record.setRefundTime(new Date());
        record.setUpdateTime(new Date());
        this.customerOrderMapper.updateById((Object)record);
    }

    public CustomerOrderResp queryCustomerOrderInfo(CustomerInfoPageReq pageReq) {
        Preconditions.checkArgument((pageReq.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pageReq.getCustomerNum()), (Object)"customerNum is null");
        List<String> customerNums = this.customerNumService.getCustomerNums(pageReq.getBizId(), pageReq.getCustomerNum());
        if (CollectionUtils.isEmpty(customerNums)) {
            log.info("queryCustomerOrderInfo customerNums is null");
            return null;
        }
        List orderList = this.customerOrderMapper.queryCustomerOrderList(pageReq.getBizId(), customerNums, Integer.valueOf(pageReq.getPageDto().getOffset()), pageReq.getPageDto().getPageSize());
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            log.info("queryCustomerOrderInfo, \u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f, bizId: {}, customerNum: {}", (Object)pageReq.getBizId(), (Object)pageReq.getCustomerNum());
            return null;
        }
        int count = this.customerOrderMapper.queryCustomerOrderSize(pageReq.getBizId(), customerNums);
        pageReq.getPageDto().setCount(Integer.valueOf(count));
        pageReq.getPageDto().setCurPageCount(Integer.valueOf(orderList.size()));
        List orderNoList = orderList.stream().map(CustomerOrder::getOrderNo).collect(Collectors.toList());
        List payRecordList = this.customerOrderPayRecordMapper.queryOrderPayRecord(pageReq.getBizId(), orderNoList);
        List orderSkus = this.orderSkuListMapper.querySkuListByOrderNos(pageReq.getBizId(), orderNoList);
        Map<String, List<OrderSkuList>> orderSkuMap = orderSkus.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo));
        ArrayList respList = Lists.newArrayList();
        for (CustomerOrder order : orderList) {
            CustomerOrderInfoResp infoResp = new CustomerOrderInfoResp();
            infoResp.setId(order.getNum());
            infoResp.setOrderNo(order.getOrderNo());
            infoResp.setOrderTime(order.getOrderTime());
            infoResp.setSkuNo(order.getSkuNo());
            infoResp.setSkuName(order.getSkuName());
            List<OrderSkuList> orderSkuList = orderSkuMap.getOrDefault(order.getOrderNo(), Lists.newArrayList());
            if (CollectionUtils.isNotEmpty(orderSkuList)) {
                List skuNames = orderSkuList.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getSkuName())).map(it -> it.getSkuName()).collect(Collectors.toList());
                infoResp.setSkuName(Joiner.on((String)",").join(skuNames));
                List skuNos = orderSkuList.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getSkuNo())).map(it -> it.getSkuNo()).collect(Collectors.toList());
                infoResp.setSkuNo(Joiner.on((String)",").join(skuNos));
            }
            infoResp.setOrderAmount(order.getOrderAmount());
            infoResp.setPaidAmount(order.getPaidAmount());
            infoResp.setRefundAmount(order.getRefundAmount());
            infoResp.setRefundTime(order.getRefundTime());
            infoResp.setRefundStatus(order.getRefundStatus());
            if (order.getRefundStatus() != null) {
                RefundStatusEnum refundStatusEnum = RefundStatusEnum.get((int)order.getRefundStatus());
                infoResp.setRefundStatusDesc(refundStatusEnum == null ? null : refundStatusEnum.getDesc());
            }
            infoResp.setCreateBy(order.getCreateBy());
            infoResp.setUserId(order.getUserId());
            List<CustomerOrderPayRecord> recordList = payRecordList.stream().filter(a -> a.getOrderNo().equals(order.getOrderNo())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(recordList)) {
                ArrayList payTypeList = Lists.newArrayList();
                recordList.forEach(a -> {
                    String payType = PayChannelType.get((Integer)a.getChannelType()).getDesc();
                    payTypeList.add(payType);
                });
                infoResp.setPayTypeList((List)payTypeList);
            }
            respList.add(infoResp);
        }
        CustomerOrderResp orderResp = new CustomerOrderResp();
        orderResp.setOrderInfoResps((List)respList);
        orderResp.setPageDto(pageReq.getPageDto());
        return orderResp;
    }

    public List<CustomerOrderWeworkInfoResp> queryCustomerOrderList(Long bizId, String customerNum) {
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"Invalid customer num");
        List<String> customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
        log.info("queryCustomerOrderList customerNum: {},  customerNums: {}", (Object)customerNum, customerNums);
        if (CollectionUtils.isEmpty(customerNums)) {
            return null;
        }
        List userIdList = this.customerOrderMapper.queryCustomerOrderListByNum(bizId, customerNums);
        log.info("queryCustomerOrderList userIdList: {}", (Object)userIdList);
        ArrayList respList = Lists.newArrayList();
        userIdList.forEach(a -> {
            CustomerOrderWeworkInfoResp resp = new CustomerOrderWeworkInfoResp();
            resp.setUserId(a);
            respList.add(resp);
        });
        return respList;
    }

    public OrderTotalResp orderTotal(QueryOrderListReq params) {
        OrderTotalResp resp = new OrderTotalResp();
        log.info("order list params: {}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = params.getBizId();
        BizTableContext.putBizId((Long)bizId);
        QueryOrderDto queryParams = (QueryOrderDto)BeanUtil.convert((Object)params, QueryOrderDto.class, (String[])new String[0]);
        int total = this.customerOrderMapper.queryOrderCount(queryParams);
        Long paidTotal = this.customerOrderMapper.queryOrderPaidAmount(queryParams);
        resp.setOrderTotal(Integer.valueOf(total));
        resp.setPaidTotal(paidTotal);
        BizTableContext.clear();
        return resp;
    }

    public OrderTotalResp orderCountGroupByUser(QueryOrderListReq params) {
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getUserIds()), (Object)"user id \u4e0d\u80fd\u4e3a\u7a7a");
        QueryOrderDto queryParams = (QueryOrderDto)BeanUtil.convert((Object)params, QueryOrderDto.class, (String[])new String[0]);
        Long bizId = params.getBizId();
        BizTableContext.putBizId((Long)bizId);
        Map userOrderCounts = this.customerOrderMapper.queryOrderCountGroupByUserId(queryParams);
        OrderTotalResp resp = new OrderTotalResp();
        resp.setUserOrderCount(userOrderCounts);
        BizTableContext.clear();
        return resp;
    }

    public PageOrderListResp orderList(QueryOrderListReq params) {
        List fieldDtos;
        log.info("order list params: {}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getPageDto() != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = params.getBizId();
        BizTableContext.putBizId((Long)bizId);
        QueryOrderDto queryParams = (QueryOrderDto)BeanUtil.convert((Object)params, QueryOrderDto.class, (String[])new String[0]);
        PageDto pageDto = params.getPageDto();
        int total = this.customerOrderMapper.queryOrderCount(queryParams);
        pageDto.setCount(Integer.valueOf(total));
        List customerOrders = this.customerOrderMapper.queryOrderList(queryParams);
        List orderNoList = customerOrders.stream().map(it -> it.getOrderNo()).collect(Collectors.toList());
        Map<Object, Object> orderNoSkuNameMap = Maps.newHashMap();
        HashMap orderNoPayTypeMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orderNoList)) {
            QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"order_no", orderNoList);
            List skuList = this.orderSkuListMapper.selectList((Wrapper)queryWrapper);
            orderNoSkuNameMap = skuList.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo, Collectors.mapping(OrderSkuList::getSkuName, Collectors.toList())));
            List payRecords = this.customerOrderPayRecordMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"order_no", orderNoList));
            for (CustomerOrderPayRecord payRecord : payRecords) {
                if (orderNoPayTypeMap.containsKey(payRecord.getOrderNo())) continue;
                orderNoPayTypeMap.put(payRecord.getOrderNo(), payRecord);
            }
        }
        Set customerNums = customerOrders.stream().map(it -> it.getCustomerNum()).collect(Collectors.toSet());
        Map customerNumMobileMap = this.customerMapper.selectMobileByNums(bizId, customerNums);
        Map customerNameMap = this.customerDetailMapper.queryCustomerNameMap(bizId, customerNums);
        Set orgIds = customerOrders.stream().filter(it -> it.getAchieveDepartId() != null).map(it -> it.getAchieveDepartId()).collect(Collectors.toSet());
        Map orgNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            orgNameMap = this.nodeService.getNameByIds(bizId, orgIds);
        }
        OrderDictionary orderDictionary = (OrderDictionary)this.orderDictionaryMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).orderByDesc((Object)"create_time"));
        Map<Object, Object> keyNames = Maps.newHashMap();
        Map<Object, Object> sourceMap = Maps.newHashMap();
        if (orderDictionary != null && StringUtils.isNotBlank((CharSequence)orderDictionary.getExtendField())) {
            try {
                fieldDtos = JacksonUtil.str2List((String)orderDictionary.getExtendField(), DynamicFieldDto.class);
                keyNames = fieldDtos.stream().filter(it -> it.getIsDeleted() == 0).collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
            }
            catch (IOException e) {
                log.error("error: ", (Throwable)e);
            }
        }
        if (orderDictionary != null && StringUtils.isNotBlank((CharSequence)orderDictionary.getSources())) {
            try {
                fieldDtos = JacksonUtil.str2List((String)orderDictionary.getSources(), DynamicFieldDto.class);
                sourceMap = fieldDtos.stream().collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
            }
            catch (IOException e) {
                log.error("error: ", (Throwable)e);
            }
        }
        for (OrderSource orderSource : OrderSource.values()) {
            sourceMap.put(orderSource.getValue(), orderSource.getDesc());
        }
        sourceMap.put("scrm", "\u5c0f\u5546\u5e97\u8ba2\u5355");
        HashSet userIdSet = Sets.newHashSet();
        for (CustomerOrder customerOrder : customerOrders) {
            if (customerOrder.getUserId() != null) {
                userIdSet.add(customerOrder.getUserId());
            }
            userIdSet.add(customerOrder.getCreateBy());
        }
        Map userNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)userIdSet)) {
            userNameMap = this.scrmUserService.getNameByIds((Collection)userIdSet);
        }
        ArrayList list = Lists.newArrayList();
        for (CustomerOrder customerOrder : customerOrders) {
            OrderListResp order = new OrderListResp();
            list.add(order);
            order.setId(customerOrder.getNum());
            order.setOrderNo(customerOrder.getOrderNo());
            order.setOrderTime(customerOrder.getOrderTime());
            order.setSource(customerOrder.getSource());
            order.setSourceDesc((String)sourceMap.get(customerOrder.getSource()));
            order.setSkuNames((List)orderNoSkuNameMap.get(customerOrder.getOrderNo()));
            if (CollectionUtils.isEmpty((Collection)order.getSkuNames())) {
                order.setSkuNames((List)Lists.newArrayList((Object[])new String[]{customerOrder.getSkuName()}));
            }
            order.setOrderAmount(Long.valueOf(customerOrder.getOrderAmount() == null ? 0L : customerOrder.getOrderAmount()));
            order.setDiscountAmount(Long.valueOf(customerOrder.getDiscountAmount() == null ? 0L : customerOrder.getDiscountAmount()));
            order.setPaidAmount(Long.valueOf(customerOrder.getPaidAmount() == null ? 0L : customerOrder.getPaidAmount()));
            CustomerOrderPayRecord payRecord = (CustomerOrderPayRecord)orderNoPayTypeMap.get(customerOrder.getOrderNo());
            if (payRecord != null) {
                Integer payType = payRecord.getChannelType();
                order.setPaidChannelType(payType);
                if (payType != null && PayChannelType.get((Integer)payType) != null) {
                    order.setPaidTypeDesc(PayChannelType.get((Integer)payType).getDesc());
                }
                order.setPayNo(payRecord.getPayNo());
            }
            order.setCustomerMobile((String)customerNumMobileMap.get(customerOrder.getCustomerNum()));
            order.setCustomerName((String)customerNameMap.get(customerOrder.getCustomerNum()));
            order.setUserId(customerOrder.getUserId());
            order.setUserName((String)userNameMap.get(customerOrder.getUserId()));
            order.setAchieveDepartId(customerOrder.getAchieveDepartId());
            order.setAchieveDepartDesc((String)orgNameMap.get(customerOrder.getAchieveDepartId()));
            order.setEntryUser((String)userNameMap.get(customerOrder.getCreateBy()));
            order.setEntryTime(customerOrder.getCreateTime());
            order.setRemark(customerOrder.getRemark());
            order.setIsEntry(customerOrder.getEntryMethod());
            try {
                if (!StringUtils.isNotBlank((CharSequence)customerOrder.getDynamicCol())) continue;
                List extendFieldRespList = JacksonUtil.str2List((String)customerOrder.getDynamicCol(), ExtendFieldResp.class);
                for (ExtendFieldResp extendField : extendFieldRespList) {
                    extendField.setName((String)keyNames.get(extendField.getKey()));
                }
                extendFieldRespList = extendFieldRespList.stream().filter(it -> it.getName() != null).collect(Collectors.toList());
                order.setExtendFiled(extendFieldRespList);
            }
            catch (IOException e) {
                log.error("json parse error: ", (Throwable)e);
            }
        }
        PageOrderListResp resp = new PageOrderListResp();
        resp.setList((List)list);
        resp.setPageDto(pageDto);
        BizTableContext.clear();
        return resp;
    }

    private CustomerOrderInfoResp build(CustomerOrder customerOrder) {
        CustomerOrderInfoResp resp = new CustomerOrderInfoResp();
        resp.setId(customerOrder.getNum());
        resp.setCustomerNum(customerOrder.getCustomerNum());
        resp.setOrderTime(customerOrder.getOrderTime());
        resp.setOrderNo(customerOrder.getOrderNo());
        resp.setSkuNo(customerOrder.getSkuNo());
        resp.setSkuName(customerOrder.getSkuName());
        resp.setOrderAmount(customerOrder.getOrderAmount());
        resp.setPaidAmount(customerOrder.getPaidAmount());
        resp.setRefundAmount(customerOrder.getRefundAmount());
        resp.setRefundTime(customerOrder.getRefundTime());
        resp.setRefundStatus(customerOrder.getRefundStatus());
        resp.setUserId(customerOrder.getUserId());
        resp.setCreateBy(customerOrder.getCreateBy());
        resp.setCustomerName(customerOrder.getCustomerName());
        resp.setProductLineId(customerOrder.getProductLineId());
        return resp;
    }

    public PageCustomerOrderResp queryByCustomerNum(Long bizId, List<String> customerNums, PageDto pageDto) {
        log.info("query by customerNum bizId: {}, customerNums: {}, pageDto: {}", new Object[]{bizId, customerNums, pageDto});
        if (CollectionUtils.isEmpty(customerNums)) {
            log.warn("queryByCustomerNum customerNums is empty");
            return null;
        }
        List customerOrders = this.customerOrderMapper.selectByCustomerNums(bizId, customerNums, pageDto);
        if (pageDto != null) {
            int total = this.customerOrderMapper.selectByCustomerNumsCount(bizId, customerNums);
            pageDto.setCount(Integer.valueOf(total));
            pageDto.setCurPageCount(Integer.valueOf(customerOrders.size()));
        }
        ArrayList list = Lists.newArrayList();
        for (CustomerOrder customerOrder : customerOrders) {
            CustomerOrderInfoResp orderInfoResp = this.build(customerOrder);
            list.add(orderInfoResp);
        }
        PageCustomerOrderResp resp = new PageCustomerOrderResp();
        resp.setList((List)list);
        resp.setPageDto(pageDto);
        return resp;
    }

    public PageCustomerOrderResp queryCustomerOrderList(Long bizId, Long userId, String skuName, List<String> customerNums, Long orderTimeBegin, Long orderTimeEnd, PageDto pageDto) {
        log.info("query customer order list bizId: {}, userId: {}, skuName: {}, customerNums: {}, orderTimeBegin:{}, orderTimeEnd: {}, pageDto: {}", new Object[]{bizId, userId, skuName, customerNums, orderTimeBegin, orderTimeEnd, pageDto});
        List customerOrders = this.customerOrderMapper.selectCustomerOrderList(bizId, userId, skuName, customerNums, orderTimeBegin, orderTimeEnd, pageDto);
        if (pageDto != null) {
            int total = this.customerOrderMapper.selectCustomerOrderCount(bizId, userId, skuName, customerNums, orderTimeBegin, orderTimeEnd);
            pageDto.setCount(Integer.valueOf(total));
            pageDto.setCurPageCount(Integer.valueOf(customerOrders.size()));
        }
        ArrayList list = Lists.newArrayList();
        for (CustomerOrder customerOrder : customerOrders) {
            CustomerOrderInfoResp infoResp = this.build(customerOrder);
            list.add(infoResp);
        }
        PageCustomerOrderResp resp = new PageCustomerOrderResp();
        resp.setPageDto(pageDto);
        resp.setList((List)list);
        return resp;
    }

    public CustomerAndOrderResp countCustomerAndOrder(Long bizId, Long userId, List<String> customerNums, Long orderTimeBegin, Long orderTimeEnd) {
        log.info("count customer order bizId: {}, userId: {}, customerNums: {}, orderTimeBegin: {}, orderTimeEnd: {}", new Object[]{bizId, userId, customerNums, orderTimeBegin, orderTimeEnd});
        int orderCount = this.customerOrderMapper.selectOrderCount(bizId, userId, customerNums, orderTimeBegin, orderTimeEnd);
        List list = this.customerOrderMapper.selectOrderCustomerNums(bizId, userId, customerNums, orderTimeBegin, orderTimeEnd);
        CustomerAndOrderResp req = new CustomerAndOrderResp();
        req.setCustomerNums(list);
        req.setOrderCount(orderCount);
        return req;
    }

    public Map<Long, List<String>> countCustomers(Long bizId, Date startTime, Date endTime, Set<Long> userIds, Long amount) {
        log.info("count customers bizId: {}, startTime: {}, endTime: {}, userIds: {}, amount: {}", new Object[]{bizId, startTime, endTime, userIds, amount});
        return this.customerOrderMapper.countCustomers(bizId, userIds, startTime, endTime, amount);
    }

    public List<CustomerOrderAmountResq> sumAmountByCustomerNum(Long bizId, Collection<String> customerNums) {
        log.info("sum amount by customerNum bizId: {}, customerNums: {}", (Object)bizId, customerNums);
        List list = this.customerOrderMapper.sumAmountByCustomerNum(bizId, customerNums);
        ArrayList result = Lists.newArrayList();
        for (Map map : list) {
            CustomerOrderAmountResq resq = new CustomerOrderAmountResq();
            resq.setCustomerNum(map.get("customerNum").toString());
            resq.setOrderCount(Integer.valueOf(NumberUtils.toInt((String)(map.get("orderCount") == null ? "0" : map.get("orderCount").toString()))));
            resq.setPaidAmount(Long.valueOf(NumberUtils.toLong((String)(map.get("paidAmount") == null ? "0" : map.get("paidAmount").toString()))));
            resq.setRefundAmount(Long.valueOf(NumberUtils.toLong((String)(map.get("refundAmount") == null ? "0" : map.get("refundAmount").toString()))));
            result.add(resq);
        }
        return result;
    }

    public List<CustomerOrderInfoResp> queryOrderListByUserAndCustomerNums(Long bizId, Long userId, Collection<String> customerNums) {
        log.info("count customers bizId: {}, userId: {}, customerNums: {}", new Object[]{bizId, userId, customerNums});
        List customerOrders = this.customerOrderMapper.queryListByUserIdCustomerNums(bizId, userId, customerNums);
        ArrayList list = Lists.newArrayList();
        for (CustomerOrder customerOrder : customerOrders) {
            CustomerOrderInfoResp infoResp = this.build(customerOrder);
            list.add(infoResp);
        }
        return list;
    }

    public Map<Long, Long> countPayAmount(Long bizId, Date startTime, Date endTime, Set<Long> userIds, Long amount) {
        log.info("countPayAmount bizId: {}, startTime: {}, endTime: {}, userIds: {}, amount: {}", new Object[]{bizId, startTime, endTime, userIds, amount});
        return this.customerOrderPayRecordMapper.countPayAmount(bizId, startTime, endTime, userIds, amount);
    }

    public Map<Long, Long> countRefundAmount(RefundReq req) {
        log.info("countRefundAmount request:{}", (Object)JSON.toJSONString((Object)req));
        if (Objects.isNull(req) || Objects.isNull(req.getBizId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "bizId \u4e3a\u7a7a");
        }
        if (Objects.isNull(req.getStartTime()) || Objects.isNull(req.getEndTime())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65f6\u95f4\u8303\u56f4\u4e3a\u7a7a");
        }
        return this.customerOrderPayRecordMapper.countDiscountAmount(req.getBizId(), req.getStartTime(), req.getEndTime(), req.getUserIds());
    }

    public String addOrderManuel(OrderReq params) {
        log.info("\u624b\u52a8\u65b0\u589e\u8ba2\u5355\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)params));
        String customerNum = this.customerNumService.getCustomerNumByMobile(params.getBizId(), params.getCustomerMobile());
        params.setCustomerNum(customerNum);
        this.addOrder(params);
        this.addOrderPayRecord(this.buildOrdPayRecordReq(params));
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerName())) {
            ModMobileReq modMobileReq = new ModMobileReq();
            modMobileReq.setCustomerNum(customerNum);
            modMobileReq.setBizId(params.getBizId());
            modMobileReq.setName(params.getCustomerName());
            this.customerDetailService.updateCustomerDetail(modMobileReq, params.getCorpId());
        }
        HashSet updateSaleStateUser = Sets.newHashSet();
        if (Objects.nonNull(params.getBeforeOrderUser())) {
            updateSaleStateUser.add(params.getBeforeOrderUser());
        }
        if (Objects.nonNull(params.getAfterOrderUser())) {
            updateSaleStateUser.add(params.getAfterOrderUser());
        }
        if (CollectionUtils.isNotEmpty((Collection)updateSaleStateUser)) {
            this.sendSaleStateMessage(params.getBizId(), params.getCorpId(), updateSaleStateUser);
        }
        return params.getCustomerOrderNum();
    }

    public List<String> butchAdd(List<OrderReq> orderReq) {
        ArrayList result = Lists.newArrayList();
        for (OrderReq param : orderReq) {
            result.add(this.addOrderManuel(param));
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delOrder(OrderReq params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((params.getOrderNo() != null ? 1 : 0) != 0, (Object)"orderNo is null");
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        if (Objects.isNull(record)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u901a\u8fc7\u8ba2\u5355\u53f7\uff1a" + params.getOrderNo() + "\u6ca1\u6709\u627e\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        CustomerOrder customerOrder = new CustomerOrder();
        customerOrder.setId(record.getId());
        customerOrder.setIsDeleted(Integer.valueOf(1));
        this.customerOrderMapper.updateById((Object)customerOrder);
        if (Objects.nonNull(record.getUserId())) {
            this.sendSaleStateMessage(record.getBizId(), record.getCorpId(), Sets.newHashSet((Object[])new Long[]{record.getUserId()}));
        }
    }

    public Boolean checkOrderExist(Long bizId, String orderNo) {
        log.info("add customer order, biId={};orderNo:{}", (Object)bizId, (Object)orderNo);
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (Object)"orderNo is null");
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"order_no", (Object)orderNo)).eq((Object)"is_deleted", (Object)0));
        return Objects.nonNull(record) ? Boolean.TRUE : Boolean.FALSE;
    }

    public OrderListResp customerOrdDetail(Long bizId, String num) {
        List fieldDtos;
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"biz id is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u5ba2\u6237\u4e2d\u5fc3\u8ba2\u5355num \u4e0d\u80fd\u4e3a\u7a7a");
        CustomerOrder customerOrder = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)num)).eq((Object)"is_deleted", (Object)0));
        if (Objects.isNull(customerOrder)) {
            log.warn("\u672a\u67e5\u5230\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606f\uff1a:bizId{};num:{}", (Object)bizId, (Object)num);
            return null;
        }
        List payRecords = this.customerOrderPayRecordMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"order_no", (Object)customerOrder.getOrderNo()));
        HashSet customerNums = Sets.newHashSet((Object[])new String[]{customerOrder.getCustomerNum()});
        List<String> userMobileByNum = this.customerService.getUserMobileByNum(bizId, customerOrder.getCustomerNum());
        String multiMobile = String.join((CharSequence)",", userMobileByNum);
        Map customerNumMobileMap = this.customerMapper.selectMobileByNums(bizId, (Collection)customerNums);
        List customerList = this.customerMapper.selectMobileByMainNums(bizId, (Collection)customerNums);
        for (Customer customer : customerList) {
            customerNumMobileMap.put(customer.getMainNum(), customer.getId1());
        }
        Map customerNameMap = this.customerDetailMapper.queryCustomerNameMap(bizId, (Collection)customerNums);
        Long achieveDepartId = customerOrder.getAchieveDepartId();
        HashMap orgNameMap = Maps.newHashMap();
        if (Objects.nonNull(achieveDepartId)) {
            orgNameMap.putAll(this.nodeService.getNameByIds(bizId, (Collection)Sets.newHashSet((Object[])new Long[]{achieveDepartId})));
        }
        OrderDictionary orderDictionary = (OrderDictionary)this.orderDictionaryMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).orderByDesc((Object)"create_time"));
        Map<Object, Object> keyNames = Maps.newHashMap();
        Map<Object, Object> sourceMap = Maps.newHashMap();
        if (orderDictionary != null && StringUtils.isNotBlank((CharSequence)orderDictionary.getExtendField())) {
            try {
                fieldDtos = JacksonUtil.str2List((String)orderDictionary.getExtendField(), DynamicFieldDto.class);
                keyNames = fieldDtos.stream().collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
            }
            catch (IOException e) {
                log.error("error: ", (Throwable)e);
            }
        }
        if (orderDictionary != null && StringUtils.isNotBlank((CharSequence)orderDictionary.getSources())) {
            try {
                fieldDtos = JacksonUtil.str2List((String)orderDictionary.getSources(), DynamicFieldDto.class);
                sourceMap = fieldDtos.stream().collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
            }
            catch (IOException e) {
                log.error("error: ", (Throwable)e);
            }
        }
        Map userNameMap = Maps.newHashMap();
        if (Objects.nonNull(customerOrder.getUserId())) {
            userNameMap = this.scrmUserService.getNameByIds((Collection)Sets.newHashSet((Object[])new Long[]{customerOrder.getUserId()}));
        }
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"order_no", (Collection)Sets.newHashSet((Object[])new String[]{customerOrder.getOrderNo()}));
        List skuList = this.orderSkuListMapper.selectList((Wrapper)queryWrapper);
        Map orderNoSkuNameMap = skuList.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo, Collectors.mapping(OrderSkuList::getSkuName, Collectors.toList())));
        OrderListResp order = new OrderListResp();
        order.setId(customerOrder.getNum());
        order.setOrderNo(customerOrder.getOrderNo());
        order.setOrderTime(customerOrder.getOrderTime());
        order.setSource(customerOrder.getSource());
        order.setSourceDesc((String)sourceMap.get(customerOrder.getSource()));
        order.setSkuNames(orderNoSkuNameMap.get(customerOrder.getOrderNo()));
        if (CollectionUtils.isEmpty((Collection)order.getSkuNames())) {
            order.setSkuNames((List)Lists.newArrayList((Object[])new String[]{customerOrder.getSkuName()}));
        }
        order.setOrderAmount(Long.valueOf(customerOrder.getOrderAmount() == null ? 0L : customerOrder.getOrderAmount()));
        order.setDiscountAmount(Long.valueOf(customerOrder.getDiscountAmount() == null ? 0L : customerOrder.getDiscountAmount()));
        order.setPaidAmount(Long.valueOf(customerOrder.getPaidAmount() == null ? 0L : customerOrder.getPaidAmount()));
        if (CollectionUtils.isNotEmpty((Collection)payRecords)) {
            CustomerOrderPayRecord payRecord = (CustomerOrderPayRecord)payRecords.get(0);
            Integer payType = payRecord.getChannelType();
            order.setPaidChannelType(payType);
            if (payType != null && PayChannelType.get((Integer)payType) != null) {
                order.setPaidTypeDesc(PayChannelType.get((Integer)payType).getDesc());
            }
            order.setPayNo(payRecord.getPayNo());
            order.setPaymentVoucherUrl(payRecord.getPaymentVoucherUrl());
            if (StringUtils.isNotBlank((CharSequence)payRecord.getPaymentVoucherUrl())) {
                order.setPaymentVoucherUrlList(Arrays.asList(payRecord.getPaymentVoucherUrl().split(",")));
            }
        }
        order.setCustomerMobile(multiMobile);
        order.setCustomerName((String)customerNameMap.get(customerOrder.getCustomerNum()));
        order.setUserId(customerOrder.getUserId());
        order.setUserName((String)userNameMap.get(customerOrder.getUserId()));
        order.setAchieveDepartId(customerOrder.getAchieveDepartId());
        order.setAchieveDepartDesc((String)orgNameMap.get(customerOrder.getAchieveDepartId()));
        order.setEntryUser((String)userNameMap.get(customerOrder.getCreateBy()));
        order.setEntryTime(customerOrder.getCreateTime());
        order.setRemark(customerOrder.getRemark());
        order.setIsEntry(customerOrder.getEntryMethod());
        try {
            if (StringUtils.isNotBlank((CharSequence)customerOrder.getDynamicCol())) {
                List extendFieldRespList = JacksonUtil.str2List((String)customerOrder.getDynamicCol(), ExtendFieldResp.class);
                for (ExtendFieldResp extendField : extendFieldRespList) {
                    extendField.setName((String)keyNames.get(extendField.getKey()));
                }
                order.setExtendFiled(extendFieldRespList);
            }
        }
        catch (IOException e) {
            log.error("json parse error: ", (Throwable)e);
        }
        return order;
    }

    public void sendSaleStateMessage(Long bizId, String corpId, Set<Long> userId) {
        SaleStateEvent saleStateEvent = new SaleStateEvent();
        saleStateEvent.setEventUpStream("scrm-backend");
        saleStateEvent.setBiId(bizId);
        saleStateEvent.setCorpId(corpId);
        saleStateEvent.setNeedReCountUserId(userId);
        String saleStateEventStr = JSON.toJSONString((Object)saleStateEvent);
        log.info("kafka topic:{} produce msg:{}", (Object)this.recalculateStateTopic, (Object)saleStateEventStr);
        CompletableFuture.runAsync(() -> this.kafkaTemplate.send(this.recalculateStateTopic, (Object)saleStateEventStr));
    }

    private void checkAddParam(OrderReq params) {
        log.info("add customer order, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSource()), (Object)"source is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCustomerNum()), (Object)"customerNum is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
    }
}

