/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.crm.common.service.CrmCustomerService;
import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.entity.Customer;
import cn.kinyun.customer.center.dal.entity.CustomerDetail;
import cn.kinyun.customer.center.dal.entity.CustomerStage;
import cn.kinyun.customer.center.dal.mapper.CustomerDetailMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerStageMapper;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.CustomerInfoPageReq;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.req.QueryBindStatusReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.follow.AllocateInfoDto;
import cn.kinyun.customer.center.dto.req.follow.CsTag;
import cn.kinyun.customer.center.dto.req.follow.FollowQueryParams;
import cn.kinyun.customer.center.dto.req.follow.FormInfoDto;
import cn.kinyun.customer.center.dto.req.follow.LeadTransferDto;
import cn.kinyun.customer.center.dto.req.follow.RadarInfoDto;
import cn.kinyun.customer.center.dto.req.follow.TagInfoDto;
import cn.kinyun.customer.center.dto.resp.CustomerBasicInfoLog;
import cn.kinyun.customer.center.dto.resp.CustomerBasicInfoLogResp;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.dto.resp.CustomerInheritLog;
import cn.kinyun.customer.center.dto.resp.CustomerInheritLogResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderResp;
import cn.kinyun.customer.center.dto.resp.CustomerRadarInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerReleaselog;
import cn.kinyun.customer.center.dto.resp.CustomerReleaselogResp;
import cn.kinyun.customer.center.dto.resp.CustomerRouteInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerRouteResp;
import cn.kinyun.customer.center.dto.resp.CustomerStageInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerTagLog;
import cn.kinyun.customer.center.dto.resp.CustomerTagLogResp;
import cn.kinyun.customer.center.dto.resp.FollowListResp;
import cn.kinyun.customer.center.dto.resp.FollowResp;
import cn.kinyun.customer.center.dto.resp.FormFollowInfoResp;
import cn.kinyun.customer.center.enums.CustomerFollowType;
import cn.kinyun.customer.center.enums.CustomerIdType;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerFollowRecordService;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import com.alibaba.dubbo.config.annotation.Service;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class CcCustomerInfoServiceImpl
implements CcCustomerInfoService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerInfoServiceImpl.class);
    private static final String BIZ_ID = "biz_id";
    private static final String CUSTOMER_NUM = "customer_num";
    private static final String MAIN_NUM = "main_num";
    private static final String ID_TYPE = "id_type";
    @Autowired
    private CcCustomerDetailService customerDetailService;
    @Autowired
    private CustomerStageMapper stageMapper;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private CustomerDetailMapper customerDetailMapper;
    @Autowired
    private CcCustomerOrderService customerOrderService;
    @Autowired
    private CcCustomerFollowRecordService customerFollowRecordService;
    @Autowired
    private CcCustomerNumService customerNumService;
    @Resource
    private ScrmUserService scrmUserService;
    @Autowired
    private IdGen idGen;
    @Resource
    private ScrmBizService scrmBizService;
    @Resource
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;

    public CustomerDetailResp queryCustomerDetail(Long bizId, String customerNum) {
        String mainNum;
        String customerDetailNum;
        CustomerDetail customerDetail;
        log.info("queryCustomerDetail bizId:{}, customerNum: {}", (Object)bizId, (Object)customerNum);
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"Invalid customer num");
        CustomerDetailResp resp = new CustomerDetailResp();
        String id1 = customer.getId1();
        String id2 = customer.getId2();
        Integer idType = customer.getIdType();
        resp.setIdType(idType);
        resp.setId1(id1);
        resp.setId2(id2);
        resp.setCustomerNum(customerNum);
        if (CustomerIdType.MOBILE.getValue() == customer.getIdType().intValue()) {
            resp.setMobile1(customer.getId1());
        }
        if ((customerDetail = this.customerDetailMapper.queryCustomerDetail(bizId, customerDetailNum = StringUtils.isBlank((CharSequence)(mainNum = customer.getMainNum())) ? customerNum : mainNum)) != null) {
            BeanUtils.copyProperties((Object)customerDetail, (Object)resp);
        } else {
            log.warn("customer detail is null, bizId={}, customer num={}", (Object)bizId, (Object)customerDetailNum);
        }
        if (StringUtils.isBlank((CharSequence)mainNum)) {
            return resp;
        }
        resp.setMainNum(mainNum);
        List customerList = this.customerMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)BIZ_ID, (Object)bizId)).eq((Object)MAIN_NUM, (Object)mainNum)).eq((Object)ID_TYPE, (Object)CustomerIdType.MOBILE.getValue()));
        if (CollectionUtils.isNotEmpty((Collection)customerList)) {
            for (int i = 0; i < customerList.size(); ++i) {
                String mobile = ((Customer)customerList.get(i)).getId1();
                if (i == 0) {
                    resp.setMobile1(mobile);
                }
                if (i != 1) continue;
                resp.setMobile2(mobile);
            }
        }
        return resp;
    }

    @Transactional(rollbackFor={Exception.class})
    public void modCustomerMobiles(ModMobileReq params) {
        Customer exist;
        log.info("modify customer mobiles, params: {}", (Object)params);
        Long bizId = params.getBizId();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isNotBlank((CharSequence)params.getName()) || Objects.nonNull(params.getGender())) {
            this.customerDetailService.updateCustomerDetail(params, bizSimpleDto.getCorpId());
        }
        Preconditions.checkArgument(((exist = this.customerMapper.getByNum(bizId, params.getCustomerNum())) != null ? 1 : 0) != 0, (Object)"Invalid customer");
        CustomerIdType idType = CustomerIdType.getType((Integer)exist.getIdType());
        Preconditions.checkArgument((idType != null ? 1 : 0) != 0, (Object)"Invalid customer idType");
        String mainNum = exist.getMainNum();
        List<Object> existRecords = StringUtils.isNotBlank((CharSequence)mainNum) ? this.customerMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)BIZ_ID, (Object)bizId)).eq((Object)ID_TYPE, (Object)CustomerIdType.MOBILE.getValue())).eq((Object)MAIN_NUM, (Object)mainNum)) : (CustomerIdType.MOBILE.getValue() == exist.getIdType().intValue() ? Collections.singletonList(exist) : Collections.emptyList());
        ArrayList existMobiles = Lists.newArrayList();
        HashMap existMobileMap = Maps.newHashMap();
        for (Customer customer : existRecords) {
            existMobiles.add(customer.getId1());
            existMobileMap.put(customer.getId1(), customer);
        }
        log.info("exist mobiles: {}", (Object)existMobiles);
        ArrayList addMobiles = Lists.newArrayList();
        HashMap hashMap = Maps.newHashMap();
        this.addMobile(bizId, params.getMobile1(), existMobiles, addMobiles, hashMap);
        this.addMobile(bizId, params.getMobile2(), existMobiles, addMobiles, hashMap);
        log.info("add mobiles:{}, delete mobiles:{}", (Object)addMobiles, (Object)existMobiles);
        if (CollectionUtils.isEmpty((Collection)addMobiles) && CollectionUtils.isEmpty((Collection)existMobiles)) {
            log.info("No need to modify customer mobile");
            return;
        }
        log.info("idtype: {}", (Object)idType);
        if (CollectionUtils.isNotEmpty((Collection)addMobiles)) {
            block5: for (String mobile : addMobiles) {
                switch (idType) {
                    case WEWORK_CONTACT_ID: {
                        this.tryBindWeworkContactIdAndMobile(bizId, exist, mobile, (Customer)hashMap.get(mobile), existMobiles, existMobileMap, params.getModuleType());
                        continue block5;
                    }
                    case MOBILE: {
                        this.tryBindMobiles(bizId, exist, mobile, (Customer)hashMap.get(mobile), existMobiles, existMobileMap, params.getModuleType());
                        continue block5;
                    }
                }
                log.warn("Unknown modify mobile case:{}", (Object)idType);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)existMobiles)) {
            for (String mobile : existMobiles) {
                log.info("modCustomerMobiles unbindCustomerNumByMobile  mobile : {}", (Object)mobile);
                this.unbindCustomerNumByMobile(bizId, mobile, exist, params.getModuleType());
            }
        }
    }

    private void tryBindWeworkContactIdAndMobile(Long bizId, Customer exist, String mobile, Customer customer, List<String> existMobiles, Map<String, Customer> existMobileMap, String moduleType) {
        List list;
        log.info("try bind customer, contactId:{}, mobile: {}", (Object)exist.getId1(), (Object)mobile);
        if (customer != null && StringUtils.isNotBlank((CharSequence)customer.getMainNum()) && CollectionUtils.isNotEmpty((Collection)(list = this.customerMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)BIZ_ID, (Object)bizId)).eq((Object)MAIN_NUM, (Object)customer.getMainNum())).eq((Object)ID_TYPE, (Object)CustomerIdType.WEWORK_CONTACT_ID.getValue()))))) {
            log.warn("modCustomerMobiles\uff0c \u5f53\u524d\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5176\u4ed6\u5fae\u4fe1\u5ba2\u6237\uff0c\u65e0\u6cd5\u5728\u7ed1\u5b9a\u65b0\u7528\u6237");
            for (Customer it : list) {
                log.info("\u5df2\u7ecf\u7ed1\u5b9a\u7684\u5ba2\u6237:{}, mobile:{}", (Object)it.getId1(), (Object)mobile);
            }
            throw new IllegalArgumentException("\u624b\u673a\u53f7[" + mobile + "]\u5df2\u7ed1\u5b9a\u5176\u4ed6\u5fae\u4fe1\u5ba2\u6237\uff0c\u65e0\u6cd5\u518d\u7ed1\u5b9a\u65b0\u5ba2\u6237");
        }
        if (customer == null && existMobiles.size() > 0) {
            String existMobile = existMobiles.remove(0);
            Customer del = existMobileMap.get(existMobile);
            this.updateMobileByCustomerNum(bizId, del.getNum(), mobile);
        } else {
            this.customerNumService.bindWeworkContactAndMobile(bizId, exist.getId1(), mobile, moduleType);
        }
    }

    private void tryBindMobiles(Long bizId, Customer exist, String mobile, Customer customer, List<String> existMobiles, Map<String, Customer> existMobileMap, String moduleType) {
        log.info("try bind customer, mobile1:{}, mobile2: {}", (Object)exist.getId1(), (Object)mobile);
        if (customer != null && StringUtils.isNotBlank((CharSequence)customer.getMainNum()) && StringUtils.isNotBlank((CharSequence)exist.getMainNum()) && !Objects.equals(customer.getMainNum(), exist.getMainNum())) {
            log.warn("modCustomerMobiles\uff0c \u5f53\u524d\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a\uff0c\u65e0\u6cd5\u5728\u7ed1\u5b9a\u65b0\u7528\u6237");
            throw new IllegalArgumentException("\u524d\u624b\u673a\u53f7[" + mobile + "]\u5df2\u7ed1\u5b9a\u5176\u4ed6\u5ba2\u6237\uff0c\u65e0\u6cd5\u518d\u7ed1\u5b9a\u65b0\u5ba2\u6237");
        }
        if (customer == null && existMobiles.size() > 0) {
            String existMobile = existMobiles.remove(0);
            Customer del = existMobileMap.get(existMobile);
            this.updateMobileByCustomerNum(bizId, del.getNum(), mobile);
        } else {
            this.customerNumService.bindMobile1AndMobile2(bizId, exist.getId1(), mobile, moduleType);
        }
    }

    private void addMobile(Long bizId, String mobile, List<String> existMobiles, List<String> addMobiles, Map<String, Customer> addMobileMap) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return;
        }
        if (existMobiles.contains(mobile)) {
            existMobiles.remove(mobile);
            return;
        }
        Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.MOBILE.getValue()), mobile, "");
        if (customer != null) {
            addMobileMap.put(mobile, customer);
        }
        addMobiles.add(mobile);
    }

    public void updateMobileByCustomerNum(Long bizId, String customerNum, String mobile) {
        log.info("update customer mobile, bizId={}, customerNum:{}, mobile:{}", new Object[]{bizId, customerNum, mobile});
        Customer exists = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((exists != null ? 1 : 0) != 0, (Object)"Invalid customer num");
        Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.MOBILE.getValue()), mobile, "");
        Preconditions.checkArgument((customer == null ? 1 : 0) != 0, (Object)"\u8be5\u624b\u673a\u53f7\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539\u3002");
        log.info("update mobile:{} -> {}", new Object[]{bizId, customerNum, exists.getId(), mobile});
        exists.setId1(mobile);
        exists.setUpdateTime(new Date());
        this.customerMapper.updateById((Object)exists);
    }

    private void unbindCustomerNumByMobile(Long bizId, String mobile, Customer exist, String moduleType) {
        Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.MOBILE.getValue()), mobile, "");
        if (customer != null && StringUtils.isNotBlank((CharSequence)customer.getMainNum())) {
            String mainNum = customer.getMainNum();
            List nums = this.customerMapper.selectNumByMainNum(bizId, mainNum);
            if (nums.size() <= 2) {
                this.customerMapper.updateMainNum(bizId, mainNum, "");
                ArrayList list = Lists.newArrayList();
                List customers = this.customerMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)BIZ_ID, (Object)bizId)).in((Object)"num", (Collection)nums));
                Map customerMap = customers.stream().collect(Collectors.toMap(Customer::getNum, Function.identity()));
                nums.stream().forEach(num -> {
                    Customer byNum = (Customer)customerMap.get(num);
                    CustomerEventReq req = new CustomerEventReq();
                    req.setBizId(bizId);
                    req.setCustomerNum(exist.getNum());
                    req.setEventType(EventType.UNBIND_RELATIONS.getCode());
                    EventData eventData = new EventData();
                    EventModule eventModule = new EventModule();
                    eventModule.setType(moduleType);
                    eventData.setModule(eventModule);
                    eventData.setId1(exist.getId1());
                    eventData.setId1Type(exist.getIdType());
                    eventData.setId2(byNum.getId1());
                    eventData.setId2Type(byNum.getIdType());
                    req.setEventData(eventData);
                    req.setEventTime(new Date());
                    list.add(req);
                });
                this.ccCustomerEventService.addBatch(bizId, null, (List)list);
            } else {
                customer.setMainNum("");
                this.customerMapper.updateById((Object)customer);
                if (mainNum.equals(customer.getNum())) {
                    nums.remove(mainNum);
                    String num2 = (String)nums.get(0);
                    this.customerMapper.updateMainNum(bizId, mainNum, num2);
                    this.mergeCustomerDetail(bizId, mainNum, num2);
                }
            }
            this.customerNumService.touchSyncIsAssociate(bizId, customer.getNum(), Integer.valueOf(CustomerIdType.WEWORK_CONTACT_ID.getValue()));
            this.customerNumService.touchSyncIsAssociate(bizId, customer.getNum(), Integer.valueOf(CustomerIdType.MINI_PROGRAM_OPENID.getValue()));
            this.customerNumService.touchSyncIsAssociate(bizId, customer.getNum(), Integer.valueOf(CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue()));
        }
    }

    private void mergeCustomerDetail(Long bizId, String oldNum, String newNum) {
        CustomerDetail oldDetail = (CustomerDetail)this.customerDetailMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)BIZ_ID, (Object)bizId)).eq((Object)CUSTOMER_NUM, (Object)oldNum));
        if (oldDetail == null) {
            log.warn("customer_detail not found, bizId={}, customer_num={}", (Object)bizId, (Object)oldNum);
            return;
        }
        CustomerDetail newDetail = (CustomerDetail)this.customerDetailMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)BIZ_ID, (Object)bizId)).eq((Object)CUSTOMER_NUM, (Object)newNum));
        if (newDetail == null) {
            newDetail = new CustomerDetail();
            BeanUtils.copyProperties((Object)oldDetail, (Object)newDetail, (String[])new String[]{"id", "num", "cutomerNum", "createBy", "createTime", "updateBy", "updateTime"});
            newDetail.setNum(this.idGen.getNum());
            newDetail.setCustomerNum(newNum);
            newDetail.setCreateBy(Long.valueOf(-1L));
            newDetail.setCreateTime(new Date());
            newDetail.setUpdateBy(Long.valueOf(-1L));
            newDetail.setUpdateTime(new Date());
            this.customerDetailMapper.insert((Object)newDetail);
        } else {
            BeanUtils.copyProperties((Object)oldDetail, (Object)newDetail, (String[])new String[]{"id", "num", "cutomerNum", "createBy", "createTime", "updateBy", "updateTime"});
            newDetail.setUpdateTime(new Date());
            this.customerDetailMapper.updateById((Object)newDetail);
        }
    }

    public boolean queryBindStatus(QueryBindStatusReq req) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getMobile()), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        boolean ret = false;
        Customer customer = this.customerMapper.getByType(req.getBizId(), Integer.valueOf(CustomerIdType.MOBILE.getValue()), req.getMobile(), "");
        Customer exists = this.customerMapper.getByNum(req.getBizId(), req.getCustomerNum());
        if (Objects.nonNull(customer) && StringUtils.isNotBlank((CharSequence)customer.getMainNum()) && !customer.getMainNum().equals(exists.getMainNum())) {
            ret = true;
        }
        return ret;
    }

    public CustomerStageInfoResp queryCustomerStage(Long bizId, String customerNum) {
        log.info("queryCustomerStage baseReq: {},bizId:{}", (Object)bizId, (Object)customerNum);
        List customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
        log.info("queryCustomerStage customerNums: {},bizId:{}", (Object)customerNums, (Object)bizId);
        List stageList = this.stageMapper.queryCustomerStage(bizId, customerNums);
        if (CollectionUtils.isNotEmpty((Collection)stageList)) {
            CustomerStage newStage = (CustomerStage)stageList.get(0);
            CustomerStageInfoResp infoResp = new CustomerStageInfoResp();
            infoResp.setStageId(newStage.getStageId());
            infoResp.setRemark(newStage.getRemark());
            infoResp.setStatus(newStage.getStatus());
            infoResp.setFinalStageId(newStage.getFinalStageId());
            infoResp.setStageReason(newStage.getStageReason());
            infoResp.setStageReasonId(newStage.getStageReasonId());
            log.info("queryCustomerStage stageList: {},bizId:{}", (Object)stageList, (Object)bizId);
            return infoResp;
        }
        return null;
    }

    public CustomerOrderResp queryOrderInfo(CustomerInfoPageReq pageReq) {
        return this.customerOrderService.queryCustomerOrderInfo(pageReq);
    }

    public CustomerRouteResp queryCustomerRouteInfo(CustomerInfoPageReq pageReq) {
        List<FollowResp> followResps;
        ArrayList types = Lists.newArrayList();
        types.add(CustomerFollowType.RADAR.getValue());
        types.add(CustomerFollowType.FORM_CUSTOMER_FOLLOW.getValue());
        if (pageReq.getRouteType() != null) {
            types.clear();
            types.add(pageReq.getRouteType());
        }
        if (CollectionUtils.isEmpty(followResps = this.buildFollowQueryParam(pageReq, types, 0))) {
            return null;
        }
        CustomerRouteResp resp = new CustomerRouteResp();
        ArrayList respList = Lists.newArrayList();
        for (FollowResp followResp : followResps) {
            FormInfoDto formInfo;
            CustomerDetailResp customerDetailResp;
            CustomerRouteInfoResp infoResp = new CustomerRouteInfoResp();
            infoResp.setType(followResp.getFollowType());
            infoResp.setTypeValue(CustomerFollowType.getType((Integer)followResp.getFollowType()).getDesc());
            infoResp.setCreateTime(followResp.getFollowTime());
            if (followResp.getFollowType().intValue() == CustomerFollowType.RADAR.getValue()) {
                RadarInfoDto infoDto = followResp.getJsonContent().getRadarInfo();
                if (Objects.nonNull(infoDto)) {
                    CustomerRadarInfoResp radarInfoResp = new CustomerRadarInfoResp();
                    infoResp.setRadarInfoResp(radarInfoResp);
                    radarInfoResp.setRadarTitle(infoDto.getTitle());
                    radarInfoResp.setRadarUrl(infoDto.getFileUrl());
                    radarInfoResp.setDuration(infoDto.getDuration());
                    radarInfoResp.setProgress(infoDto.getProgress());
                    radarInfoResp.setViewTime(infoDto.getViewTime());
                    radarInfoResp.setWeworkUserNum(followResp.getWeworkUserNum());
                    radarInfoResp.setShareUserName(followResp.getWeworkUserName());
                    customerDetailResp = this.customerDetailService.queryCustomerDetail(pageReq.getBizId(), pageReq.getCustomerNum());
                    if (Objects.nonNull(customerDetailResp)) {
                        radarInfoResp.setCustomerAvatar(customerDetailResp.getAvatar());
                        radarInfoResp.setCustomerName(customerDetailResp.getName());
                        radarInfoResp.setCustomerCorpName(customerDetailResp.getCorpName());
                        radarInfoResp.setCustomerType(customerDetailResp.getType());
                    }
                }
            } else if (followResp.getFollowType().intValue() == CustomerFollowType.FORM_CUSTOMER_FOLLOW.getValue() && (formInfo = followResp.getJsonContent().getFormInfoDto()) != null) {
                FormFollowInfoResp formInfoResp = new FormFollowInfoResp();
                infoResp.setFormInfoResp(formInfoResp);
                formInfoResp.setFormName(formInfo.getFormName());
                formInfoResp.setWeworkUserNum(formInfo.getWeworkUserNum());
                formInfoResp.setShareUserName(formInfo.getShareName());
                formInfoResp.setDynamicFormId(formInfo.getDynamicFormId());
                formInfoResp.setSubmitList(formInfo.getSubmitList());
                customerDetailResp = this.customerDetailService.queryCustomerDetail(pageReq.getBizId(), pageReq.getCustomerNum());
                if (Objects.nonNull(customerDetailResp)) {
                    formInfoResp.setCustomerAvatar(customerDetailResp.getAvatar());
                    formInfoResp.setCustomerName(customerDetailResp.getName());
                    formInfoResp.setCustomerCorpName(customerDetailResp.getCorpName());
                    formInfoResp.setCustomerType(customerDetailResp.getType());
                }
            }
            respList.add(infoResp);
        }
        resp.setRouteInfoResps((List)respList);
        resp.setPageDto(pageReq.getPageDto());
        return resp;
    }

    public CustomerBasicInfoLog queryBasicLog(CustomerInfoPageReq pageReq) {
        ArrayList types = Lists.newArrayList();
        types.add(CustomerFollowType.MOD_CUSTOMER.getValue());
        List<FollowResp> followResps = this.buildFollowQueryParam(pageReq, types, 0);
        log.info("queryBasicLog pageReq: {}", (Object)pageReq);
        if (CollectionUtils.isNotEmpty(followResps)) {
            CustomerBasicInfoLog infoLog = new CustomerBasicInfoLog();
            Set userIds = followResps.stream().map(FollowResp::getUserId).collect(Collectors.toSet());
            Map nameByIds = this.scrmUserService.getNameByIds(userIds);
            List basicInfoLogResps = followResps.stream().map(a -> {
                CustomerBasicInfoLogResp logResp = new CustomerBasicInfoLogResp();
                String source = a.getSource();
                logResp.setModTime(a.getFollowTime());
                logResp.setModContent("crm".equals(source) ? JacksonUtil.obj2Str((Object)a.getJsonContent().getLeadsInfo()) : a.getViewContent());
                logResp.setWeworkUserNum(a.getWeworkUserNum());
                logResp.setSource(source);
                logResp.setFollowUserName("crm".equals(source) ? (String)nameByIds.get(a.getUserId()) : a.getWeworkUserName());
                return logResp;
            }).collect(Collectors.toList());
            infoLog.setInfoLogResps(basicInfoLogResps);
            infoLog.setPageDto(pageReq.getPageDto());
            return infoLog;
        }
        return null;
    }

    public CustomerTagLog queryTagLog(CustomerInfoPageReq pageReq) {
        log.info("queryTagLog pageReq: {}", (Object)pageReq);
        ArrayList types = Lists.newArrayList();
        types.add(CustomerFollowType.MOD_TAG.getValue());
        types.add(CustomerFollowType.MOD_FOLLOW.getValue());
        List<FollowResp> followResps = this.buildFollowQueryParam(pageReq, types, 0);
        if (CollectionUtils.isNotEmpty(followResps)) {
            CustomerTagLog tagLog = new CustomerTagLog();
            Set userIds = followResps.stream().map(FollowResp::getUserId).collect(Collectors.toSet());
            log.info("queryTagLog userIds: {}", userIds);
            Map nameByIds = this.scrmUserService.getNameByIds(userIds);
            log.info("queryTagLog nameByIds: {}", (Object)nameByIds);
            List tagLogResps = followResps.stream().map(a -> {
                CustomerTagLogResp logResp = new CustomerTagLogResp();
                String source = a.getSource();
                logResp.setModTime(a.getFollowTime());
                TagInfoDto tagInfo = a.getJsonContent().getTagInfo();
                logResp.setModContent("crm".equals(source) ? JacksonUtil.obj2Str((Object)tagInfo) : this.buildTagContent(tagInfo));
                logResp.setWeworkUserNum(a.getWeworkUserNum());
                logResp.setSource(source);
                String followUserName = a.getWeworkUserName();
                if (StringUtils.isBlank((CharSequence)followUserName)) {
                    followUserName = "\u7cfb\u7edf";
                }
                logResp.setFollowUserName("crm".equals(source) ? (String)nameByIds.get(a.getUserId()) : followUserName);
                return logResp;
            }).collect(Collectors.toList());
            tagLog.setRespList(tagLogResps);
            tagLog.setPageDto(pageReq.getPageDto());
            return tagLog;
        }
        return null;
    }

    public CustomerReleaselog queryReleaseLog(CustomerInfoPageReq pageReq) {
        log.info("queryReleaseLog pageReq: {}", (Object)pageReq);
        ArrayList types = Lists.newArrayList();
        types.add(CustomerFollowType.LEADS_BIND_OR_RELEASE.getValue());
        List<FollowResp> followResps = this.buildFollowQueryParam(pageReq, types, 1);
        if (CollectionUtils.isNotEmpty(followResps)) {
            CustomerReleaselog releaselog = new CustomerReleaselog();
            List releaselogResps = followResps.stream().map(a -> {
                CustomerReleaselogResp logResp = new CustomerReleaselogResp();
                LeadTransferDto transferDto = a.getJsonContent().getLeadTransfer();
                Date followTime = a.getFollowTime();
                if (Objects.nonNull(transferDto)) {
                    logResp.setReleaseReason(transferDto.getReleaseReason());
                    logResp.setReleaseFrom(transferDto.getReleaseFrom());
                    logResp.setBindTo(transferDto.getBindTo());
                    logResp.setOpUser(transferDto.getOpUser());
                    logResp.setOp(transferDto.getOp());
                    logResp.setTaskName(transferDto.getTaskName());
                    logResp.setOpTime(followTime);
                }
                return logResp;
            }).collect(Collectors.toList());
            releaselog.setRespList(releaselogResps);
            releaselog.setPageDto(pageReq.getPageDto());
            return releaselog;
        }
        return null;
    }

    public CustomerInheritLog queryInheritLog(CustomerInfoPageReq pageReq) {
        log.info("queryInheritLog pageReq: {}", (Object)pageReq);
        ArrayList types = Lists.newArrayList();
        types.add(CustomerFollowType.INHERIT.getValue());
        List<FollowResp> followResps = this.buildFollowQueryParam(pageReq, types, 0);
        if (CollectionUtils.isNotEmpty(followResps)) {
            CustomerInheritLog inheritLog = new CustomerInheritLog();
            List inheritLogResps = followResps.stream().map(a -> {
                CustomerInheritLogResp logResp = new CustomerInheritLogResp();
                logResp.setModTime(a.getFollowTime());
                logResp.setContent(a.getViewContent());
                logResp.setWeworkUserNum(a.getWeworkUserNum());
                logResp.setFollowUserName(a.getWeworkUserName());
                AllocateInfoDto infoDto = a.getJsonContent().getAllocateInfo();
                if (Objects.nonNull(infoDto)) {
                    logResp.setAllocateType(infoDto.getAllocateType());
                    logResp.setHandoverUserId(infoDto.getHandoverUserId());
                    logResp.setTakeoverUserId(infoDto.getTakeoverUserId());
                }
                return logResp;
            }).collect(Collectors.toList());
            inheritLog.setLogResps(inheritLogResps);
            inheritLog.setPageDto(pageReq.getPageDto());
            return inheritLog;
        }
        return null;
    }

    private List<FollowResp> buildFollowQueryParam(CustomerInfoPageReq pageReq, List<Integer> types, Integer asc) {
        log.info("buildFollowQueryParam types: {}", types);
        FollowQueryParams params = new FollowQueryParams();
        params.setBizId(pageReq.getBizId());
        params.setCustomerNum(pageReq.getCustomerNum());
        params.setSource(pageReq.getSource());
        params.setUserId(pageReq.getUserId());
        params.setProductLineId(pageReq.getProductLineId());
        params.setWeworkUserNum(pageReq.getWeworkUserNum());
        params.setAsc(asc);
        if (Objects.nonNull(pageReq.getStartTime()) && Objects.nonNull(pageReq.getEndTime())) {
            params.setStartTime(pageReq.getStartTime());
            params.setEndTime(pageReq.getEndTime());
        }
        ArrayList followType = Lists.newArrayList();
        followType.addAll(types);
        params.setFollowTypes((List)followType);
        params.setPageDto(pageReq.getPageDto());
        log.info("buildFollowQueryParam params: {}", (Object)params);
        FollowListResp resp = this.customerFollowRecordService.list(params);
        log.info("buildFollowQueryParam dto: {}", (Object)params.getPageDto());
        if (resp.getPageDto() != null && pageReq.getPageDto() != null) {
            pageReq.getPageDto().setCount(resp.getPageDto().getCount());
            pageReq.getPageDto().setCurPageCount(resp.getPageDto().getPageSize());
        }
        return resp.getList();
    }

    private String buildTagContent(TagInfoDto tagInfo) {
        List oldTags = tagInfo.getOldTag();
        List newTags = tagInfo.getNewTag();
        String oldTagName = null;
        String newTagName = null;
        if (CollectionUtils.isNotEmpty((Collection)oldTags)) {
            oldTagName = StringUtils.join((Object[])oldTags.stream().map(CsTag::getTagName).collect(Collectors.toList()).toArray(), (String)"/");
        }
        if (CollectionUtils.isNotEmpty((Collection)newTags)) {
            newTagName = StringUtils.join((Object[])newTags.stream().map(CsTag::getTagName).collect(Collectors.toList()).toArray(), (String)"/");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isSame(oldTagName, newTagName)) {
            this.appendContent("", stringBuilder, oldTagName, newTagName);
        }
        return stringBuilder.toString();
    }

    private boolean isSame(String oldValue, String newValue) {
        if (StringUtils.isBlank((CharSequence)oldValue) && StringUtils.isBlank((CharSequence)newValue)) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)oldValue) && oldValue.equals(newValue);
    }

    private void appendContent(String head, StringBuilder sb, String oldVal, String newVal) {
        if (!(this.isSame(oldVal, newVal) || StringUtils.isBlank((CharSequence)oldVal) && StringUtils.isBlank((CharSequence)newVal))) {
            sb.append(head);
            if (StringUtils.isBlank((CharSequence)oldVal)) {
                sb.append("\u65b0\u589e\"").append(newVal).append("\"");
            } else if (StringUtils.isBlank((CharSequence)newVal)) {
                sb.append("\u5220\u9664\"").append(oldVal).append("\"");
            } else {
                sb.append(oldVal).append(" -> ").append(newVal);
            }
            sb.append("\n");
        }
    }
}

