/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.util.DateUtil;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.AccessInfo;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventListQueryParams;
import cn.kinyun.customer.center.dto.req.event.EventQueryParams;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.dto.resp.EventListResp;
import cn.kinyun.customer.center.dto.resp.EventResp;
import cn.kinyun.customer.center.enums.CustomerIdType;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.dubbo.config.annotation.Service;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

@Service
public class CcCustomerEventServiceImpl
implements CcCustomerEventService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerEventServiceImpl.class);
    @Value(value="${scrm.elasticsearch.customerEventIndex}")
    private String index;
    @Autowired
    private IdGen idGen;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    @Qualifier(value="esStoreThreadPool")
    private ExecutorService executorService;
    @Autowired
    private CcCustomerNumService customerNumService;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;

    public void add(CustomerEventReq params) {
        log.info("add customer event:{}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCustomerNum()), (Object)"customerNum is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getEventType()), (Object)"eventType is null");
        Preconditions.checkArgument((params.getEventTime() != null ? 1 : 0) != 0, (Object)"eventTime is null");
        Preconditions.checkArgument((params.getEventData() != null ? 1 : 0) != 0, (Object)"eventData is null");
        this.asyncWrite(params);
    }

    public void addBindRelation(CustomerEventReq params) {
        log.info("add bindRelation event:{}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCustomerNum()), (Object)"customerNum is null");
        Preconditions.checkArgument((params.getEventTime() != null ? 1 : 0) != 0, (Object)"eventTime is null");
        Preconditions.checkArgument((params.getEventData() != null ? 1 : 0) != 0, (Object)"eventData is null");
        EventData eventData = params.getEventData();
        String id1 = eventData.getId1();
        Integer id1Type = eventData.getId1Type();
        String id2 = eventData.getId2();
        Integer id2Type = eventData.getId2Type();
        int compareInt = this.compareIdType(id1Type, id2Type);
        if (compareInt < 0) {
            eventData.setId1(id2);
            eventData.setId1Type(id2Type);
            eventData.setId2(id1);
            eventData.setId2Type(id1Type);
        }
        eventData.setBindRelationsType(eventData.getId1Type() + "," + eventData.getId2Type());
        params.setEventType(EventType.BIND_RELATIONS.getCode());
        CustomerDetailResp customerDetailResp = this.ccCustomerDetailService.queryCustomerDetail(params.getBizId(), params.getCustomerNum());
        eventData.setAvatar(customerDetailResp.getAvatar());
        eventData.setName(customerDetailResp.getName());
        log.info("add bindRelation about bindRelationsType event:{}", (Object)params);
        this.asyncWrite(params);
    }

    public void addBindRelations(Long bizId, String source, List<CustomerEventReq> list) {
        log.info("add bindRelation list, bizId:{}, list:{}", (Object)bizId, list);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(list), (Object)"list is empty");
        for (CustomerEventReq it : list) {
            it.setBizId(bizId);
            it.setSource(source);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it.getCustomerNum()), (Object)"customerNum is null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it.getEventType()), (Object)"eventType is null");
            Preconditions.checkArgument((it.getEventTime() != null ? 1 : 0) != 0, (Object)"eventTime is null");
            Preconditions.checkArgument((it.getEventData() != null ? 1 : 0) != 0, (Object)"eventData is null");
            EventData eventData = it.getEventData();
            String id1 = eventData.getId1();
            Integer id1Type = eventData.getId1Type();
            String id2 = eventData.getId2();
            Integer id2Type = eventData.getId2Type();
            int compareInt = this.compareIdType(id1Type, id2Type);
            if (compareInt < 0) {
                eventData.setId1(id2);
                eventData.setId1Type(id2Type);
                eventData.setId2(id1);
                eventData.setId2Type(id1Type);
            }
            eventData.setBindRelationsType(eventData.getId1Type() + "," + eventData.getId2Type());
            it.setEventType(EventType.BIND_RELATIONS.getCode());
            CustomerDetailResp customerDetailResp = this.ccCustomerDetailService.queryCustomerDetail(bizId, it.getCustomerNum());
            eventData.setAvatar(customerDetailResp.getAvatar());
            eventData.setName(customerDetailResp.getName());
        }
        this.asyncBatchWrite(list);
    }

    public void addBatch(Long bizId, String source, List<CustomerEventReq> list) {
        log.info("add event list, bizId:{}, list:{}", (Object)bizId, list);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(list), (Object)"list is empty");
        for (CustomerEventReq it : list) {
            it.setBizId(bizId);
            it.setSource(source);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it.getCustomerNum()), (Object)"customerNum is null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it.getEventType()), (Object)"eventType is null");
            Preconditions.checkArgument((it.getEventTime() != null ? 1 : 0) != 0, (Object)"eventTime is null");
            Preconditions.checkArgument((it.getEventData() != null ? 1 : 0) != 0, (Object)"eventData is null");
        }
        this.asyncBatchWrite(list);
    }

    public EventListResp list(EventQueryParams params) {
        log.info("list, params:{}", (Object)params);
        Long bizId = params.getBizId();
        String customerNum = params.getCustomerNum();
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((customerNum != null ? 1 : 0) != 0, (Object)"customerNum is null");
        List typeParams = params.getTypeParams();
        List customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
        log.info("list, customerNums:{}", (Object)customerNums);
        ArrayList list = Lists.newArrayList();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)params.getBizId()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (CollectionUtils.isNotEmpty((Collection)typeParams)) {
            for (EventListQueryParams listQueryParams : typeParams) {
                BoolQueryBuilder typeQueryIndex = QueryBuilders.boolQuery();
                String eventType = listQueryParams.getEventType();
                List moduleTypes = listQueryParams.getModuleTypes();
                typeQueryIndex.must((QueryBuilder)QueryBuilders.termsQuery((String)"eventType.keyword", (String[])new String[]{eventType}));
                if (CollectionUtils.isNotEmpty((Collection)moduleTypes)) {
                    if (eventType.equals(EventType.BIND_RELATIONS.getCode())) {
                        typeQueryIndex.must((QueryBuilder)QueryBuilders.termsQuery((String)"eventData.bindRelationsType.keyword", (Collection)moduleTypes));
                    } else {
                        typeQueryIndex.must((QueryBuilder)QueryBuilders.termsQuery((String)"eventData.module.type.keyword", (Collection)moduleTypes));
                    }
                }
                queryBuilder.should((QueryBuilder)typeQueryIndex);
            }
            queryBuilder.minimumShouldMatch(1);
        }
        if (StringUtils.isNotBlank((CharSequence)params.getField())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)params.getField(), (String)params.getValue()));
        }
        if (CollectionUtils.isNotEmpty((Collection)customerNums)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"customerNum.keyword", (Collection)customerNums));
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{params.getStartTime(), params.getEndTime()})) {
            Date endTime = params.getEndTime();
            Long endTimestamp = DateUtil.getEndTime((Date)endTime);
            Date startTime = params.getStartTime();
            Long startTimestamp = DateUtil.getStartTime((Date)startTime);
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"eventTime").from((Object)startTimestamp).to((Object)endTimestamp));
        }
        log.info("list, queryBuilder:{}", (Object)queryBuilder);
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("eventTime", SortOrder.DESC);
        if (params.getPageDto() != null) {
            searchSourceBuilder.from((params.getPageDto().getPageNum() - 1) * params.getPageDto().getPageSize());
            searchSourceBuilder.size(params.getPageDto().getPageSize().intValue());
        } else {
            searchSourceBuilder.size(10000);
        }
        log.info("list, searchSourceBuilder:{}", (Object)searchSourceBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + params.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed query event from Elastic Search.", (Throwable)e);
            return new EventListResp(Collections.emptyList(), new PageDto());
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            return new EventListResp(Collections.emptyList(), new PageDto());
        }
        for (SearchHit searchHit : searchHits) {
            try {
                String doc = searchHit.getSourceAsString();
                EventResp msg = (EventResp)JacksonUtil.str2Obj((String)doc, EventResp.class);
                list.add(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf((int)hits.getTotalHits()));
            params.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        return new EventListResp((List)list, params.getPageDto());
    }

    public int count(EventQueryParams params) {
        log.info("list, params:{}", (Object)params);
        Long bizId = params.getBizId();
        String customerNum = params.getCustomerNum();
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((customerNum != null ? 1 : 0) != 0, (Object)"customerNum is null");
        List typeParams = params.getTypeParams();
        List customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
        log.info("list, customerNums:{}", (Object)customerNums);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)params.getBizId()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (CollectionUtils.isNotEmpty((Collection)typeParams)) {
            for (EventListQueryParams listQueryParams : typeParams) {
                BoolQueryBuilder typeQueryIndex = QueryBuilders.boolQuery();
                String eventType = listQueryParams.getEventType();
                List moduleTypes = listQueryParams.getModuleTypes();
                typeQueryIndex.must((QueryBuilder)QueryBuilders.termsQuery((String)"eventType.keyword", (String[])new String[]{eventType}));
                if (CollectionUtils.isNotEmpty((Collection)moduleTypes)) {
                    if (eventType.equals(EventType.BIND_RELATIONS.getCode())) {
                        typeQueryIndex.must((QueryBuilder)QueryBuilders.termsQuery((String)"eventData.bindRelationsType.keyword", (Collection)moduleTypes));
                    } else {
                        typeQueryIndex.must((QueryBuilder)QueryBuilders.termsQuery((String)"eventData.module.type.keyword", (Collection)moduleTypes));
                    }
                }
                queryBuilder.should((QueryBuilder)typeQueryIndex);
            }
            queryBuilder.minimumShouldMatch(1);
        }
        if (CollectionUtils.isNotEmpty((Collection)customerNums)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"customerNum.keyword", (Collection)customerNums));
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{params.getStartTime(), params.getEndTime()})) {
            Date startTime = params.getStartTime();
            Long startTimestamp = DateUtil.getStartTime((Date)startTime);
            Date endTime = params.getEndTime();
            Long endTimestamp = DateUtil.getEndTime((Date)endTime);
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"eventTime").from((Object)startTimestamp).to((Object)endTimestamp));
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + params.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed count event from Elastic Search.", (Throwable)e);
            return 0;
        }
        return (int)searchResponse.getHits().getTotalHits();
    }

    public void updateVisitPage(final CustomerEventReq params) {
        log.info("save visit page event:{}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSource()), (Object)"source is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getEventType()), (Object)"eventType is null");
        Preconditions.checkArgument((params.getEventData() != null ? 1 : 0) != 0, (Object)"eventData is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getEventData().getAccessNum()), (Object)"eventData.accessNum is null");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"eventData.accessNum.keyword", (String[])new String[]{params.getEventData().getAccessNum()}));
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + params.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
            SearchHits hits = searchResponse.getHits();
            if (hits.getTotalHits() == 0L) {
                log.info("not find visit page event customerNum: {}, accessNum: {}", (Object)params.getCustomerNum(), (Object)params.getEventData().getAccessNum());
                return;
            }
            SearchHit searchHit = hits.getAt(0);
            UpdateRequest updateRequest = new UpdateRequest(this.index + "_" + params.getBizId(), "doc", searchHit.getId());
            if (params.getEventData().getAccessInfo() != null) {
                AccessInfo accessInfo = params.getEventData().getAccessInfo();
                updateRequest.doc(XContentFactory.jsonBuilder().startObject().startObject("eventData").startObject("accessInfo").field("visitBeginTime", accessInfo.getVisitBeginTime().getTime()).field("stayTime", accessInfo.getStayTime()).field("finishPercent", accessInfo.getFinishPercent()).field("visitEndTime", accessInfo.getVisitEndTime().getTime()).endObject().endObject().endObject());
                this.restHighLevelClient.update(updateRequest, new Header[0]);
                return;
            }
            CustomerEventReq eventReq = (CustomerEventReq)JacksonUtil.str2Obj((String)searchHit.getSourceAsString(), CustomerEventReq.class);
            log.info("find origin visit page event: {}", (Object)eventReq);
            EventData eventData = eventReq.getEventData();
            String customerNum = eventReq.getCustomerNum();
            if (params.getEventData().getSubmitList() != null) {
                eventData.setSubmitList(params.getEventData().getSubmitList());
            }
            if (params.getEventData().getVisitor() != null) {
                eventData.setVisitor(params.getEventData().getVisitor());
            }
            if (params.getEventData().getModule() != null) {
                eventData.setModule(params.getEventData().getModule());
            }
            if (params.getEventTime() != null) {
                eventReq.setEventTime(params.getEventTime());
            }
            if (StringUtils.isNotBlank((CharSequence)params.getCustomerNum()) && !params.getCustomerNum().equals(customerNum)) {
                eventReq.setCustomerNum(params.getCustomerNum());
            }
            if (params.getEventData().getPayAmount() != null && !params.getEventData().getPayAmount().equals(eventData.getPayAmount())) {
                eventData.setPayAmount(params.getEventData().getPayAmount());
            }
            if (StringUtils.isNotBlank((CharSequence)params.getEventData().getOrderNo()) && !params.getEventData().getOrderNo().equals(eventData.getOrderNo())) {
                eventData.setOrderNo(params.getEventData().getOrderNo());
            }
            if (StringUtils.isNotBlank((CharSequence)params.getEventData().getMobile()) && !params.getEventData().getMobile().equals(eventData.getMobile())) {
                eventData.setMobile(params.getEventData().getMobile());
            }
            eventReq.setEventData(eventData);
            updateRequest.doc(JacksonUtil.obj2Str((Object)eventReq), XContentType.JSON);
            log.info("update request doc: {}", (Object)JacksonUtil.obj2Str((Object)eventReq));
            this.restHighLevelClient.updateAsync(updateRequest, (ActionListener)new ActionListener<UpdateResponse>(){

                public void onResponse(UpdateResponse updateResponse) {
                    log.info("update visit page success:{}", (Object)params);
                }

                public void onFailure(Exception e) {
                    log.error("update visit page failed:{}", (Object)params, (Object)e);
                }
            }, new Header[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed search visit page event from Elastic Search.", (Throwable)e);
        }
    }

    private IndexRequest newIndexRequest(CustomerEventReq params) {
        Map map = JacksonUtil.toMap((Object)params);
        map.put("timestamp", System.currentTimeMillis());
        IndexRequest indexRequest = new IndexRequest(this.index + "_" + params.getBizId(), "doc", this.idGen.getNum());
        indexRequest.source(map, XContentType.JSON);
        return indexRequest;
    }

    private void asyncWrite(final CustomerEventReq params) {
        IndexRequest indexRequest = this.newIndexRequest(params);
        this.restHighLevelClient.indexAsync(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                log.info("insert success:{}", (Object)params);
            }

            public void onFailure(Exception e) {
                log.error("insert failed:{}", (Object)params, (Object)e);
            }
        }, new Header[0]);
    }

    private void asyncBatchWrite(List<CustomerEventReq> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List partition = Lists.partition(list, (int)100);
        for (List part : partition) {
            this.executorService.submit(() -> {
                try {
                    this.batchWrite(part);
                }
                catch (Exception e) {
                    log.error("write data failed", (Throwable)e);
                }
            });
        }
    }

    private void batchWrite(List<CustomerEventReq> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (CustomerEventReq it : list) {
            bulkRequest.add(this.newIndexRequest(it));
        }
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        log.info("bulk response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            log.error("response.id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
        }
    }

    private int compareIdType(Integer id1Type, Integer id2Type) {
        if (id1Type == null) {
            return 1;
        }
        if (id2Type == null) {
            return -1;
        }
        if (id1Type.intValue() == CustomerIdType.WEWORK_CONTACT_ID.getValue()) {
            return 1;
        }
        if (id2Type.intValue() == CustomerIdType.WEWORK_CONTACT_ID.getValue()) {
            return -1;
        }
        if (id1Type.intValue() == CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue()) {
            return 1;
        }
        if (id2Type.intValue() == CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue()) {
            return -1;
        }
        if (id1Type.intValue() == CustomerIdType.MINI_PROGRAM_OPENID.getValue()) {
            return 1;
        }
        if (id2Type.intValue() == CustomerIdType.MINI_PROGRAM_OPENID.getValue()) {
            return -1;
        }
        if (id1Type.intValue() == CustomerIdType.WEWORK_CONTACT_OPEN_ID.getValue()) {
            return 1;
        }
        if (id2Type.intValue() == CustomerIdType.WEWORK_CONTACT_OPEN_ID.getValue()) {
            return -1;
        }
        if (id1Type.intValue() == CustomerIdType.MOBILE.getValue()) {
            return 1;
        }
        if (id2Type.intValue() == CustomerIdType.MOBILE.getValue()) {
            return -1;
        }
        if (id1Type.intValue() == CustomerIdType.H5_COOKIE.getValue()) {
            return 1;
        }
        if (id2Type.intValue() == CustomerIdType.H5_COOKIE.getValue()) {
            return -1;
        }
        return 0;
    }
}

