/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.entity.CustomerTag;
import cn.kinyun.customer.center.dal.mapper.CustomerTagMapper;
import cn.kinyun.customer.center.dto.req.AttachTagReq;
import cn.kinyun.customer.center.dto.req.BatchSetTagReq;
import cn.kinyun.customer.center.dto.req.CustomerTagReq;
import cn.kinyun.customer.center.dto.req.IdAndNameDto;
import cn.kinyun.customer.center.dto.req.SetTagReq;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerTagService;
import com.alibaba.dubbo.config.annotation.Service;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmTagService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

@Service
public class CcCustomerTagServiceImpl
extends ServiceImpl<CustomerTagMapper, CustomerTag>
implements CcCustomerTagService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerTagServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private ScrmTagService scrmTagService;
    @Autowired
    private CcCustomerNumService customerNumService;

    public void setTags(SetTagReq params) {
        log.info("setTags params:{}", (Object)params);
        params.validate();
        List tagIds = params.getTagIds();
        Long bizId = params.getBizId();
        String customerNum = params.getCustomerNum();
        Long userId = params.getUserId();
        String productLineId = params.getProductLineId();
        String source = params.getSource();
        String weworkUserNum = params.getWeworkUserNum();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        this.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"source", (Object)source)).eq((Object)"customer_num", (Object)customerNum)).eq(!ObjectUtils.isEmpty((Object)userId), (Object)"user_id", (Object)userId)).isNull(ObjectUtils.isEmpty((Object)userId), (Object)"user_id")).eq(StringUtils.isNotBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)weworkUserNum)).eq(StringUtils.isBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)"")).eq(StringUtils.isNotBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)productLineId)).eq(StringUtils.isBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)"")).set((Object)"is_deleted", (Object)1));
        ArrayList customerTags = Lists.newArrayList();
        Sets.newHashSet((Iterable)tagIds).stream().forEach(tagId -> customerTags.add(this.buildCustomerTag(params, bizSimpleDto.getCorpId(), (String)tagId)));
        this.saveBatch(customerTags);
    }

    public void batchSetTags(BatchSetTagReq params) {
        log.info("batchSetTags params:{}", (Object)params);
        params.validate();
        List customerTagReqs = params.getList();
        Long bizId = params.getBizId();
        String source = params.getSource();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        ArrayList customerTags = Lists.newArrayList();
        customerTagReqs.forEach(customerTagReq -> {
            Long userId = customerTagReq.getUserId();
            String productLineId = customerTagReq.getProductLineId();
            String customerNum = customerTagReq.getCustomerNum();
            List tagIds = customerTagReq.getTagIds();
            String weworkUserNum = customerTagReq.getWeworkUserNum();
            this.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"source", (Object)source)).eq((Object)"biz_id", (Object)bizId)).eq((Object)"customer_num", (Object)customerNum)).eq(!ObjectUtils.isEmpty((Object)userId), (Object)"user_id", (Object)userId)).isNull(ObjectUtils.isEmpty((Object)userId), (Object)"user_id")).eq(StringUtils.isNotBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)weworkUserNum)).eq(StringUtils.isBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)"")).eq(StringUtils.isNotBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)productLineId)).eq(StringUtils.isBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)"")).set((Object)"is_deleted", (Object)1));
            customerTags.addAll(this.buildCustomerTags(params, (CustomerTagReq)customerTagReq, bizSimpleDto.getCorpId(), tagIds));
        });
        this.saveBatch(customerTags);
    }

    public void attachTag(AttachTagReq params) {
        List addTagIds;
        log.info("attachTag params:{}", (Object)params);
        params.validate();
        Long bizId = params.getBizId();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        String customerNum = params.getCustomerNum();
        List customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
        List removeTagIds = params.getRemoveTagIds();
        if (CollectionUtils.isNotEmpty((Collection)removeTagIds)) {
            this.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"biz_id", (Object)bizId)).in((Object)"customer_num", (Collection)customerNums)).in((Object)"tag_id", (Collection)removeTagIds)).set((Object)"is_deleted", (Object)1));
        }
        if (CollectionUtils.isEmpty((Collection)(addTagIds = params.getAddTagIds()))) {
            return;
        }
        ArrayList customerTags = Lists.newArrayList();
        SetTagReq setTagReq = new SetTagReq();
        BeanUtils.copyProperties((Object)params, (Object)setTagReq);
        Sets.newHashSet((Iterable)addTagIds).forEach(tagId -> customerTags.add(this.buildCustomerTag(setTagReq, bizSimpleDto.getCorpId(), (String)tagId)));
        log.info("attachTag customerTags:{}", (Object)customerTags);
        this.saveBatch(customerTags);
    }

    public List<IdAndNameDto> getTags(SetTagReq params) {
        log.info("getTags params:{}", (Object)params);
        Long bizId = params.getBizId();
        String source = params.getSource();
        String customerNum = params.getCustomerNum();
        Long userId = params.getUserId();
        String productLineId = params.getProductLineId();
        String weworkUserNum = params.getWeworkUserNum();
        List customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).in((Object)"customer_num", (Collection)customerNums)).eq(StringUtils.isNotBlank((CharSequence)source), (Object)"source", (Object)source)).eq(!ObjectUtils.isEmpty((Object)userId), (Object)"user_id", (Object)userId)).eq(StringUtils.isNotBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)weworkUserNum)).eq(StringUtils.isNotBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)productLineId)).eq((Object)"is_deleted", (Object)0);
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        Map tagNameMap = this.scrmTagService.getNameByIds(bizSimpleDto.getCorpId(), (Collection)list.stream().map(CustomerTag::getTagId).collect(Collectors.toSet()));
        ArrayList result = Lists.newArrayList();
        list.forEach(customerTag -> {
            IdAndNameDto idAndNameDto = new IdAndNameDto(customerTag.getTagId(), (String)tagNameMap.get(customerTag.getTagId()));
            if (!result.contains(idAndNameDto)) {
                result.add(idAndNameDto);
            }
        });
        return result;
    }

    private List<CustomerTag> buildCustomerTags(BatchSetTagReq params, CustomerTagReq customerTagReq, String corpId, List<String> tagIds) {
        ArrayList customerTags = Lists.newArrayList();
        Sets.newHashSet(tagIds).forEach(tagId -> {
            SetTagReq tagReq = new SetTagReq();
            BeanUtils.copyProperties((Object)customerTagReq, (Object)tagReq);
            tagReq.setSource(params.getSource());
            tagReq.setBizId(params.getBizId());
            customerTags.add(this.buildCustomerTag(tagReq, corpId, (String)tagId));
        });
        return customerTags;
    }

    private CustomerTag buildCustomerTag(SetTagReq params, String corpId, String tagId) {
        return CustomerTag.builder().num(this.idGen.getNum()).bizId(params.getBizId()).corpId(corpId).userId(params.getUserId()).weworkUserNum(params.getWeworkUserNum()).customerNum(params.getCustomerNum()).tagId(tagId).userId(params.getUserId()).source(params.getSource()).productLineId(params.getProductLineId()).createBy(Long.valueOf(-1L)).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date()).isDeleted(Integer.valueOf(0)).build();
    }
}

