/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.entity.CustomerStage;
import cn.kinyun.customer.center.dal.mapper.CustomerStageMapper;
import cn.kinyun.customer.center.dto.req.BatchSetStageReq;
import cn.kinyun.customer.center.dto.req.SetStageReq;
import cn.kinyun.customer.center.service.CcCustomerStageService;
import com.alibaba.dubbo.config.annotation.Service;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

@Service
public class CcCustomerStageServiceImpl
extends ServiceImpl<CustomerStageMapper, CustomerStage>
implements CcCustomerStageService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerStageServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private ScrmBizService scrmBizService;

    public void setStage(SetStageReq params) {
        log.info("setStage params:{}", (Object)params);
        params.validate();
        Long bizId = params.getBizId();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        this.save(this.buildCustomerStage(params, bizSimpleDto.getCorpId()));
    }

    public void batchSetStage(BatchSetStageReq params) {
        log.info("batchSetStage params:{}", (Object)params);
        params.validate();
        List customerStageReqs = params.getList();
        Long bizId = params.getBizId();
        String source = params.getSource();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        ArrayList customerStages = Lists.newArrayList();
        customerStageReqs.forEach(customerStageReq -> {
            Long userId = customerStageReq.getUserId();
            String productLineId = customerStageReq.getProductLineId();
            String customerNum = customerStageReq.getCustomerNum();
            Long stageId = customerStageReq.getStageId();
            String remark = customerStageReq.getRemark();
            String weworkUserNum = customerStageReq.getWeworkUserNum();
            Integer status = customerStageReq.getStatus();
            Long finalStageId = customerStageReq.getFinalStageId();
            String stageReason = customerStageReq.getStageReason();
            Long stageReasonId = customerStageReq.getStageReasonId();
            CustomerStage customerStage = (CustomerStage)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"source", (Object)source)).eq((Object)"customer_num", (Object)customerNum)).eq(!ObjectUtils.isEmpty((Object)userId), (Object)"user_id", (Object)userId)).isNull(ObjectUtils.isEmpty((Object)userId), (Object)"user_id")).eq(StringUtils.isNotBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)weworkUserNum)).eq(StringUtils.isBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)"")).eq(StringUtils.isNotBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)productLineId)).eq(StringUtils.isBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)""));
            if (ObjectUtils.isEmpty((Object)customerStage)) {
                SetStageReq setStageReq = new SetStageReq();
                BeanUtils.copyProperties((Object)customerStageReq, (Object)setStageReq);
                setStageReq.setBizId(bizId);
                setStageReq.setSource(params.getSource());
                customerStages.add(this.buildCustomerStage(setStageReq, bizSimpleDto.getCorpId()));
            } else {
                customerStage.setStageId(stageId);
                customerStage.setRemark(remark);
                customerStage.setStatus(status);
                customerStage.setFinalStageId(finalStageId);
                customerStage.setStageReason(stageReason);
                customerStage.setStageReasonId(stageReasonId);
                customerStages.add(customerStage);
            }
        });
        this.saveOrUpdateBatch(customerStages);
    }

    private CustomerStage buildCustomerStage(SetStageReq params, String corpId) {
        return CustomerStage.builder().num(this.idGen.getNum()).bizId(params.getBizId()).corpId(corpId).userId(params.getUserId()).weworkUserNum(params.getWeworkUserNum()).customerNum(params.getCustomerNum()).stageId(params.getStageId()).remark(params.getRemark()).userId(params.getUserId()).source(params.getSource()).productLineId(params.getProductLineId()).createBy(Long.valueOf(-1L)).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date()).isDeleted(Integer.valueOf(0)).status(params.getStatus()).finalStageId(params.getFinalStageId()).stageReason(params.getStageReason()).stageReasonId(params.getStageReasonId()).build();
    }
}

