/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.dal.entity.Customer;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerRepairService;
import com.alibaba.dubbo.config.annotation.Service;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service
public class CcCustomerRepairServiceImpl
implements CcCustomerRepairService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerRepairServiceImpl.class);
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;

    public void bindRelation(Long bizId) {
        log.info("repair bindRelation by bizId={}", (Object)bizId);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        List customers = this.customerMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).isNotNull((Object)"main_num"));
        Map<String, List<Customer>> listMap = customers.stream().collect(Collectors.groupingBy(Customer::getMainNum));
        for (Map.Entry<String, List<Customer>> entry : listMap.entrySet()) {
            List<Customer> customerList = entry.getValue();
            if (CollectionUtils.isEmpty(customerList) || customerList.size() == 1) continue;
            int size = customerList.size();
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < size - 1; ++i) {
                CustomerEventReq req = new CustomerEventReq();
                req.setBizId(bizId);
                req.setCustomerNum(entry.getKey());
                req.setEventType(EventType.BIND_RELATIONS.getCode());
                EventData eventData = new EventData();
                eventData.setId1(customerList.get(i).getId1());
                eventData.setId1Type(customerList.get(i).getIdType());
                eventData.setId2(customerList.get(i + 1).getId1());
                eventData.setId2Type(customerList.get(i + 1).getIdType());
                req.setEventData(eventData);
                req.setEventTime(new Date());
                list.add(req);
            }
            this.ccCustomerEventService.addBindRelations(bizId, "", null);
        }
    }
}

