/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.util.DateUtil;
import cn.kinyun.customer.center.dto.req.follow.FollowQueryParams;
import cn.kinyun.customer.center.dto.req.follow.FollowReq;
import cn.kinyun.customer.center.dto.resp.FollowListResp;
import cn.kinyun.customer.center.dto.resp.FollowResp;
import cn.kinyun.customer.center.service.CcCustomerFollowRecordService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

@Service
public class CcCustomerFollowRecordServiceImpl
implements CcCustomerFollowRecordService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerFollowRecordServiceImpl.class);
    @Value(value="${scrm.elasticsearch.customerFollowRecordIndex}")
    private String index;
    @Autowired
    private IdGen idGen;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    @Qualifier(value="esStoreThreadPool")
    private ExecutorService executorService;
    @Autowired
    private CcCustomerNumService customerNumService;

    public void add(FollowReq params) {
        log.info("add follow record:{}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCustomerNum()), (Object)"customerNum is null");
        Preconditions.checkArgument((params.getFollowType() != null ? 1 : 0) != 0, (Object)"followType is null");
        Preconditions.checkArgument((params.getFollowTime() != null ? 1 : 0) != 0, (Object)"followTime is null");
        Preconditions.checkArgument((params.getJsonContent() != null ? 1 : 0) != 0, (Object)"jsonContent is null");
        this.write(params);
    }

    public void addBatch(Long bizId, String source, List<FollowReq> list) {
        log.info("add follow list, bizId:{}, list:{}", (Object)bizId, list);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(list), (Object)"list is empty");
        for (FollowReq it : list) {
            it.setBizId(bizId);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it.getCustomerNum()), (Object)"customerNum is null");
            Preconditions.checkArgument((it.getFollowType() != null ? 1 : 0) != 0, (Object)"followType is null");
            Preconditions.checkArgument((it.getFollowTime() != null ? 1 : 0) != 0, (Object)"followTime is null");
            Preconditions.checkArgument((it.getJsonContent() != null ? 1 : 0) != 0, (Object)"jsonContent is null");
        }
        this.asyncBatchWrite(list);
    }

    public FollowListResp list(FollowQueryParams params) {
        log.info("list, params:{}", (Object)params);
        Long bizId = params.getBizId();
        String customerNum = params.getCustomerNum();
        Integer asc = params.getAsc();
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((customerNum != null ? 1 : 0) != 0, (Object)"customerNum is null");
        if (CollectionUtils.isEmpty((Collection)params.getFollowTypes())) {
            return new FollowListResp(Collections.emptyList(), new PageDto());
        }
        List customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
        log.info("list, customerNums:{}", (Object)customerNums);
        ArrayList list = Lists.newArrayList();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)params.getBizId())).must((QueryBuilder)QueryBuilders.termsQuery((String)"followType", (Collection)params.getFollowTypes())).must((QueryBuilder)QueryBuilders.termsQuery((String)"customerNum.keyword", (Collection)customerNums));
        if (StringUtils.isNotBlank((CharSequence)params.getProductLineId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"productLineId", (Object)params.getProductLineId()));
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{params.getStartTime(), params.getEndTime()})) {
            Date startTime = params.getStartTime();
            Long startTimestamp = DateUtil.getStartTime((Date)startTime);
            Date endTime = params.getEndTime();
            Long endTimestamp = DateUtil.getEndTime((Date)endTime);
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"followTime").from((Object)startTimestamp).to((Object)endTimestamp));
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("followTime", asc != null && asc == 1 ? SortOrder.ASC : SortOrder.DESC);
        if (params.getPageDto() != null) {
            searchSourceBuilder.from((params.getPageDto().getPageNum() - 1) * params.getPageDto().getPageSize());
            searchSourceBuilder.size(params.getPageDto().getPageSize().intValue());
        } else {
            searchSourceBuilder.size(10000);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + params.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed query follow from Elastic Search.", (Throwable)e);
            return new FollowListResp(Collections.emptyList(), new PageDto());
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            return new FollowListResp(Collections.emptyList(), new PageDto());
        }
        for (SearchHit searchHit : searchHits) {
            try {
                String doc = searchHit.getSourceAsString();
                FollowResp msg = (FollowResp)JacksonUtil.str2Obj((String)doc, FollowResp.class);
                list.add(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(Math.toIntExact(hits.getTotalHits())));
            params.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        return new FollowListResp((List)list, params.getPageDto());
    }

    public Map<String, List<FollowResp>> listBatch(FollowQueryParams params) {
        log.info("listBatch, params:{}", (Object)params);
        Long bizId = params.getBizId();
        List customerNumsReq = params.getCustomerNums();
        Integer asc = params.getAsc();
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        if (CollectionUtils.isEmpty((Collection)customerNumsReq)) {
            log.info("listBatch: customerNumsReq is null");
            return Maps.newHashMap();
        }
        if (CollectionUtils.isEmpty((Collection)params.getFollowTypes())) {
            return Maps.newHashMap();
        }
        ArrayList allCustomerNums = Lists.newArrayList();
        HashMap customerNumRelationMap = Maps.newHashMap();
        customerNumsReq.forEach(a -> {
            List tempList = this.customerNumService.getCustomerNums(bizId, a);
            tempList.forEach(b -> customerNumRelationMap.put(b, a));
            allCustomerNums.addAll(tempList);
        });
        log.info("listBatch: allCustomerNums:{}", (Object)allCustomerNums);
        ArrayList list = Lists.newArrayList();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)params.getBizId())).must((QueryBuilder)QueryBuilders.termsQuery((String)"followType", (Collection)params.getFollowTypes())).must((QueryBuilder)QueryBuilders.termsQuery((String)"customerNum.keyword", (Collection)allCustomerNums));
        if (StringUtils.isNotBlank((CharSequence)params.getProductLineId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"productLineId", (Object)params.getProductLineId()));
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{params.getStartTime(), params.getEndTime()})) {
            Date startTime = params.getStartTime();
            Long startTimestamp = DateUtil.getStartTime((Date)startTime);
            Date endTime = params.getEndTime();
            Long endTimestamp = DateUtil.getEndTime((Date)endTime);
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"followTime").from((Object)startTimestamp).to((Object)endTimestamp));
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("followTime", asc != null && asc == 1 ? SortOrder.ASC : SortOrder.DESC);
        searchSourceBuilder.size(10000);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + params.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("listBatch: Failed query follow from Elastic Search.", (Throwable)e);
            return Maps.newHashMap();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            return Maps.newHashMap();
        }
        for (SearchHit searchHit : searchHits) {
            try {
                String doc = searchHit.getSourceAsString();
                FollowResp msg = (FollowResp)JacksonUtil.str2Obj((String)doc, FollowResp.class);
                msg.setCommonCustomerNum((String)customerNumRelationMap.get(msg.getCustomerNum()));
                list.add(msg);
            }
            catch (IOException e) {
                log.error("listBatch: add error : ", (Throwable)e);
            }
        }
        return list.stream().collect(Collectors.groupingBy(FollowResp::getCommonCustomerNum));
    }

    public FollowListResp countByUserIdOrWeworkNum(FollowQueryParams params) {
        SearchResponse searchResponse;
        List userIds = params.getUserIds();
        List weworkNums = params.getWeworkNums();
        FollowListResp followListResp = new FollowListResp();
        if (CollectionUtils.isEmpty((Collection)userIds) && CollectionUtils.isEmpty((Collection)weworkNums)) {
            log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)params));
            return followListResp;
        }
        if (Objects.isNull(params.getBizId()) || Objects.isNull(params.getStartTime()) || Objects.isNull(params.getEndTime())) {
            log.info("\u67e5\u8be2\u5546\u5bb6\u6216\u65f6\u95f4\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)params));
            return followListResp;
        }
        RangeQueryBuilder rangeByFollowTime = QueryBuilders.rangeQuery((String)"followTime");
        rangeByFollowTime.gte((Object)params.getStartTime().getTime());
        rangeByFollowTime.lte((Object)params.getEndTime().getTime());
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)rangeByFollowTime).must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)params.getBizId())).should((QueryBuilder)QueryBuilders.termsQuery((String)"weworkUserNum.keyword", (Collection)weworkNums)).should((QueryBuilder)QueryBuilders.termsQuery((String)"userId", (Collection)userIds)).minimumShouldMatch(1);
        TermsAggregationBuilder subAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"customerNum").field("customerNum.keyword");
        TermsAggregationBuilder userIdAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"userId").field("userId");
        userIdAgg.subAggregation((AggregationBuilder)subAgg);
        TermsAggregationBuilder weworkUserNumAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"weworkUserNum").field("weworkUserNum.keyword");
        weworkUserNumAgg.subAggregation((AggregationBuilder)subAgg);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)userIdAgg);
        searchSourceBuilder.aggregation((AggregationBuilder)weworkUserNumAgg);
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + params.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return null;
        }
        Aggregations aggregations = searchResponse.getAggregations();
        Terms weworkUserNumAggResp = (Terms)aggregations.get("weworkUserNum");
        Terms userIdAggResp = (Terms)aggregations.get("userId");
        List numBuckets = weworkUserNumAggResp.getBuckets();
        List userIdBuckets = userIdAggResp.getBuckets();
        HashMap numCount = Maps.newHashMap();
        for (Terms.Bucket numBucket : numBuckets) {
            String key = numBucket.getKeyAsString();
            Long counts = this.countByCustomerNum(numBucket.getAggregations(), "customerNum");
            numCount.put(key, counts);
        }
        HashMap userIdCount = Maps.newHashMap();
        for (Terms.Bucket numBucket : userIdBuckets) {
            long key = numBucket.getKeyAsNumber().longValue();
            Long counts = this.countByCustomerNum(numBucket.getAggregations(), "customerNum");
            userIdCount.put(key, counts);
        }
        followListResp.setWeworkNumCount((Map)numCount);
        followListResp.setUserIdsCount((Map)userIdCount);
        return followListResp;
    }

    private Long countByCustomerNum(Aggregations agg, String itemsName) {
        if (Objects.isNull(agg)) {
            return 0L;
        }
        Terms customerNum = (Terms)agg.get(itemsName);
        if (Objects.isNull(customerNum)) {
            return 0L;
        }
        List buckets = customerNum.getBuckets();
        if (CollectionUtils.isEmpty((Collection)buckets)) {
            return 0L;
        }
        return customerNum.getBuckets().size();
    }

    private IndexRequest newIndexRequest(FollowReq params) {
        Map map = JacksonUtil.toMap((Object)params);
        map.put("timestamp", System.currentTimeMillis());
        IndexRequest indexRequest = new IndexRequest(this.index + "_" + params.getBizId(), "doc", this.idGen.getNum());
        indexRequest.source(map, XContentType.JSON);
        return indexRequest;
    }

    private void write(FollowReq params) {
        IndexRequest indexRequest = this.newIndexRequest(params);
        try {
            IndexResponse indexResponse = this.restHighLevelClient.index(indexRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("es\u63d2\u5165\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("es\u63d2\u5165\u5f02\u5e38", e);
        }
    }

    private void asyncWrite(final FollowReq params) {
        IndexRequest indexRequest = this.newIndexRequest(params);
        this.restHighLevelClient.indexAsync(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                log.info("insert success:{}", (Object)params);
            }

            public void onFailure(Exception e) {
                log.error("insert failed:{}", (Object)params, (Object)e);
            }
        }, new Header[0]);
    }

    private void asyncBatchWrite(List<FollowReq> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List partition = Lists.partition(list, (int)100);
        for (List part : partition) {
            this.executorService.submit(() -> {
                try {
                    this.batchWrite(part);
                }
                catch (Exception e) {
                    log.error("write data failed", (Throwable)e);
                }
            });
        }
    }

    private void batchWrite(List<FollowReq> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (FollowReq it : list) {
            bulkRequest.add(this.newIndexRequest(it));
        }
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        log.info("bulk response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            log.error("response.id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
        }
    }
}

