/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.entity.CustomerDetail;
import cn.kinyun.customer.center.dal.mapper.CustomerDetailMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dal.util.BizTableContext;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.CustomerIdType;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.dubbo.config.annotation.Service;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmChannelService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.service.dto.resp.ChannelDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

@Service
public class CcCustomerDetailServiceImpl
extends ServiceImpl<CustomerDetailMapper, CustomerDetail>
implements CcCustomerDetailService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerDetailServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerNumService customerNumService;
    @Autowired
    private CustomerDetailMapper customerDetailMapper;
    @Autowired
    private ScrmChannelService scrmChannelService;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private CustomerMapper customerMapper;

    public void add(CustomerDetailReq req) {
        log.info("customerDetail req:{}, bizId: {}, customerNum: {}", new Object[]{req, req.getBizId(), req.getCustomerNum()});
        req.validate();
        Long bizId = req.getBizId();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        String customerNum = req.getCustomerNum();
        CustomerDetail detail = (CustomerDetail)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)req.getBizId())).eq((Object)"customer_num", (Object)customerNum));
        log.info("customerDetail detail: {}", (Object)detail);
        if (ObjectUtils.isEmpty((Object)detail)) {
            log.info("customerDetail save detail: {}", (Object)detail);
            this.save(this.buildCustomerDetail(req, bizSimpleDto.getCorpId()));
        } else {
            if (StringUtils.isNotBlank((CharSequence)req.getAvatar())) {
                detail.setAvatar(req.getAvatar());
            }
            if (StringUtils.isEmpty((CharSequence)detail.getName())) {
                detail.setName(req.getName());
            }
            if (StringUtils.isEmpty((CharSequence)detail.getArea())) {
                detail.setArea(req.getArea());
            }
            if (ObjectUtils.isEmpty((Object)detail.getChannelId())) {
                detail.setChannelId(req.getChannelId());
            }
            if (ObjectUtils.isEmpty((Object)detail.getGender()) || !ObjectUtils.isEmpty((Object)detail.getGender()) && detail.getGender() == 0) {
                detail.setGender(req.getGender());
            }
            detail.setUpdateTime(new Date());
            log.info("customerDetail update detail: {}", (Object)detail);
            this.updateById(detail);
        }
    }

    public void addBatch(Long bizId, List<CustomerDetailReq> list) {
        log.info("batchCustomerDetail bizId:{}, list: {}", (Object)bizId, list);
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        ArrayList addList = Lists.newArrayList();
        ArrayList modList = Lists.newArrayList();
        Map<Object, Object> existMap = Collections.emptyMap();
        List customerNums = list.stream().map(it -> it.getCustomerNum()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerNums)) {
            List existList = this.customerDetailMapper.queryByCustomerNums(bizId, customerNums);
            existMap = existList.stream().collect(Collectors.toMap(it -> it.getCustomerNum(), it -> it));
        }
        for (CustomerDetailReq it2 : list) {
            String customerNum = it2.getCustomerNum();
            CustomerDetail detail = (CustomerDetail)existMap.get(customerNum);
            if (Objects.nonNull(detail)) {
                detail.setName(it2.getName());
                detail.setArea(it2.getArea());
                detail.setAvatar(it2.getAvatar());
                detail.setCorpName(it2.getCorpName());
                detail.setCorpFullName(it2.getCorpFullName());
                detail.setType(it2.getType());
                detail.setGender(it2.getGender());
                detail.setRemark(it2.getRemark());
                modList.add(detail);
                continue;
            }
            CustomerDetail customerDetail = this.buildCustomerDetail(it2, bizSimpleDto.getCorpId());
            addList.add(customerDetail);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("\u6279\u91cf\u4fdd\u5b58\u5ba2\u6237\u8be6\u60c5:{}", (Object)addList.size());
            this.customerDetailMapper.batchInsert((Collection)addList);
        }
        if (CollectionUtils.isNotEmpty((Collection)modList)) {
            log.info("\u6279\u91cf\u66f4\u65b0\u5ba2\u6237\u8be6\u60c5:{}", (Object)modList.size());
            this.customerDetailMapper.batchInsert((Collection)modList);
        }
    }

    public CustomerDetailResp queryCustomerDetail(Long bizId, String customerNum) {
        log.info("queryCustomerDetail bizId:{}, num: {}", (Object)bizId, (Object)customerNum);
        String mainNum = this.customerNumService.getMainNum(bizId, customerNum);
        customerNum = StringUtils.isBlank((CharSequence)mainNum) ? customerNum : mainNum;
        CustomerDetail detail = (CustomerDetail)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"customer_num", (Object)customerNum));
        CustomerDetailResp resp = new CustomerDetailResp();
        if (detail != null) {
            BeanUtils.copyProperties((Object)detail, (Object)resp);
        }
        return resp;
    }

    public List<CustomerDetailResp> queryCustomerDetails(Long bizId, Collection<String> customerNums) {
        log.info("queryCustomerDetails bizId:{}, num: {}", (Object)bizId, customerNums);
        if (CollectionUtils.isEmpty(customerNums)) {
            return Collections.emptyList();
        }
        Map mainNumMap = this.customerMapper.selectMainNums(bizId, customerNums);
        if (MapUtils.isEmpty((Map)mainNumMap)) {
            return Collections.emptyList();
        }
        HashBiMap biMap = HashBiMap.create((Map)mainNumMap);
        List details = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).in((Object)"customer_num", mainNumMap.values()));
        if (CollectionUtils.isEmpty((Collection)details)) {
            return Collections.emptyList();
        }
        ArrayList respList = Lists.newArrayList();
        for (CustomerDetail detail : details) {
            if (!mainNumMap.containsKey(detail.getCustomerNum())) {
                detail.setCustomerNum((String)biMap.inverse().get((Object)detail.getCustomerNum()));
            }
            CustomerDetailResp resp = new CustomerDetailResp();
            BeanUtils.copyProperties((Object)detail, (Object)resp);
            respList.add(resp);
        }
        return respList;
    }

    public void updateCustomerDetail(ModMobileReq req, String corpId) {
        String customerNum = req.getCustomerNum();
        ArrayList customerNums = Lists.newArrayList();
        String mainNum = this.customerNumService.getMainNum(req.getBizId(), req.getCustomerNum());
        customerNums.add(customerNum);
        if (StringUtils.isNotBlank((CharSequence)mainNum)) {
            customerNums.add(mainNum);
        }
        log.info("updateCustomerDetail customerNum: {}, mainNum: {}", (Object)req.getCustomerNum(), (Object)mainNum);
        List details = this.customerDetailMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)req.getBizId())).in((Object)"customer_num", (Collection)customerNums));
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            for (CustomerDetail customerDetail : details) {
                customerDetail.setGender(req.getGender());
                customerDetail.setName(req.getName());
                customerDetail.setChannelId(req.getChannelId());
                customerDetail.setArea(req.getArea());
                this.updateById(customerDetail);
            }
        } else {
            CustomerDetailReq customerDetailReq = new CustomerDetailReq();
            customerDetailReq.setCustomerNum(req.getCustomerNum());
            customerDetailReq.setName(req.getName());
            customerDetailReq.setGender(req.getGender());
            customerDetailReq.setArea(req.getArea());
            customerDetailReq.setBizId(req.getBizId());
            customerDetailReq.setChannelId(req.getChannelId());
            this.save(this.buildCustomerDetail(customerDetailReq, corpId));
        }
    }

    public void channelAssignment(Long bizId) {
        log.info("channelAssignment bizId: {}", (Object)bizId);
        CompletableFuture.runAsync(() -> {
            BizTableContext.putBizId((Long)bizId);
            ArrayList channelNums = Lists.newArrayList((Object[])new String[]{SourceType.SCRM_SYNC.getCode(), SourceType.TRADE_SYNC.getCode(), SourceType.AD_SYNC.getCode(), SourceType.DYNAMIC_FORM_SYNC.getCode(), SourceType.LIVE_COMMERCE.getCode()});
            Map channelIdMap = this.scrmChannelService.getIdByNums(bizId, (Collection)channelNums);
            Map channelNumMap = this.scrmChannelService.getNumByIds(bizId, channelIdMap.values());
            for (CustomerIdType idType : CustomerIdType.values()) {
                int value = idType.getValue();
                try {
                    if (value != CustomerIdType.WEWORK_CONTACT_ID.getValue() && value != CustomerIdType.MOBILE.getValue()) continue;
                    List customerDetails = this.customerDetailMapper.queryEmptyChannelCustomerDetail(bizId, Integer.valueOf(value));
                    if (CollectionUtils.isEmpty((Collection)customerDetails)) {
                        log.info("no customerDetails to update channel, bizId: {}, idType: {}", (Object)bizId, (Object)value);
                        continue;
                    }
                    if (value == CustomerIdType.WEWORK_CONTACT_ID.getValue()) {
                        for (CustomerDetail customerDetail : customerDetails) {
                            customerDetail.setChannelId(SourceType.SCRM_SYNC.getCode());
                            customerDetail.setUpdateTime(new Date());
                        }
                        boolean update = this.updateBatchById(customerDetails);
                        log.info("channelAssignment update: {}, size: {}", (Object)update, (Object)customerDetails.size());
                    } else {
                        if (value != CustomerIdType.MOBILE.getValue()) continue;
                        ArrayList updateDetails = Lists.newArrayList();
                        for (CustomerDetail customerDetail : customerDetails) {
                            CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
                            crmLeadsInfoReq.setMobile(customerDetail.getId1());
                            crmLeadsInfoReq.setCorpId(customerDetail.getCorpId());
                            CrmLeadsInfoResp leads = this.crmLeadsService.getLeads(crmLeadsInfoReq);
                            if (leads == null || leads.getChannelId() == -1L) continue;
                            String channelNum = (String)channelNumMap.get(leads.getChannelId());
                            if (StringUtils.isBlank((CharSequence)channelNum)) {
                                ChannelDto channelDto = this.scrmChannelService.getById(bizId, leads.getChannelId());
                                if (channelDto == null) continue;
                                channelNum = channelDto.getNum();
                                channelNumMap.put(leads.getChannelId(), channelNum);
                            }
                            customerDetail.setChannelId(channelNum);
                            customerDetail.setUpdateTime(new Date());
                            updateDetails.add(customerDetail);
                        }
                        boolean update = this.updateBatchById(updateDetails);
                        log.info("channelAssignment update: {}, size: {}", (Object)update, (Object)updateDetails.size());
                    }
                    log.info("channelAssignment end, bizId: {}, idType: {}", (Object)bizId, (Object)value);
                }
                catch (Exception e) {
                    log.error("\u5ba2\u6237\u7c7b\u578b\uff1a{} \u6570\u636e\u6e20\u9053\u5904\u7406\u62a5\u9519", (Object)value, (Object)e);
                }
            }
            BizTableContext.clear();
        });
    }

    private CustomerDetail buildCustomerDetail(CustomerDetailReq req, String corpId) {
        return CustomerDetail.builder().num(this.idGen.getNum()).bizId(req.getBizId()).corpId(corpId).customerNum(req.getCustomerNum()).name(req.getName()).area(req.getArea()).avatar(req.getAvatar()).corpName(req.getCorpName()).corpFullName(req.getCorpFullName()).type(req.getType()).gender(req.getGender()).remark(req.getRemark()).createBy(Long.valueOf(-1L)).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date()).source(req.getSource()).channelId(req.getChannelId()).build();
    }
}

