/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.entity.CustomerBinding;
import cn.kinyun.customer.center.dal.mapper.CustomerBindingMapper;
import cn.kinyun.customer.center.dto.req.BatchSetBindingReq;
import cn.kinyun.customer.center.dto.req.SetBindingReq;
import cn.kinyun.customer.center.dto.resp.CustomerBindingResp;
import cn.kinyun.customer.center.service.CcCustomerBindService;
import com.alibaba.dubbo.config.annotation.Service;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CcCustomerBindServiceImpl
extends ServiceImpl<CustomerBindingMapper, CustomerBinding>
implements CcCustomerBindService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerBindServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private ScrmBizService scrmBizService;

    public void setBinding(SetBindingReq params) {
        log.info("setBinding params:{}", (Object)params);
        params.validate();
        Long bizId = params.getBizId();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        String productLineId = params.getProductLineId();
        Long userId = params.getUserId();
        String customerNum = params.getCustomerNum();
        String source = params.getSource();
        String weworkUserNum = params.getWeworkUserNum();
        CustomerBinding customerBinding = (CustomerBinding)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"customer_num", (Object)customerNum)).eq((Object)"source", (Object)source)).eq(!ObjectUtils.isEmpty((Object)userId), (Object)"user_id", (Object)userId)).isNull(ObjectUtils.isEmpty((Object)userId), (Object)"user_id")).eq(StringUtils.isNotBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)weworkUserNum)).eq(StringUtils.isBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)"")).eq(StringUtils.isNotBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)productLineId)).eq(StringUtils.isBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)""));
        if (ObjectUtils.isEmpty((Object)customerBinding)) {
            this.save(this.buildCustomerBinding(params, bizSimpleDto.getCorpId()));
        } else {
            customerBinding.setIsDeleted(params.getIsDeleted());
            customerBinding.setDeleteTime(params.getDeleteTime());
            customerBinding.setUpdateTime(new Date());
            this.updateById(customerBinding);
        }
    }

    public void batchSetBinding(BatchSetBindingReq params) {
        log.info("batchSetBinding params:{}", (Object)params);
        params.validate();
        List customerBindReqs = params.getList();
        Long bizId = params.getBizId();
        String source = params.getSource();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        ArrayList customerBindings = Lists.newArrayList();
        customerBindReqs.forEach(customerBindReq -> {
            Long userId = customerBindReq.getUserId();
            String productLineId = customerBindReq.getProductLineId();
            String customerNum = customerBindReq.getCustomerNum();
            Integer isDeleted = customerBindReq.getIsDeleted();
            String weworkUserNum = customerBindReq.getWeworkUserNum();
            Date deleteTime = customerBindReq.getDeleteTime();
            CustomerBinding customerBinding = (CustomerBinding)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"source", (Object)source)).eq((Object)"customer_num", (Object)customerNum)).eq(!ObjectUtils.isEmpty((Object)userId), (Object)"user_id", (Object)userId)).isNull(ObjectUtils.isEmpty((Object)userId), (Object)"user_id")).eq(StringUtils.isNotBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)weworkUserNum)).eq(StringUtils.isBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)"")).eq(StringUtils.isNotBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)productLineId)).eq(StringUtils.isBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)""));
            if (ObjectUtils.isEmpty((Object)customerBinding)) {
                SetBindingReq setBindingReq = new SetBindingReq();
                BeanUtils.copyProperties((Object)customerBindReq, (Object)setBindingReq);
                setBindingReq.setBizId(bizId);
                setBindingReq.setSource(params.getSource());
                customerBindings.add(this.buildCustomerBinding(setBindingReq, bizSimpleDto.getCorpId()));
            } else {
                customerBinding.setDeleteTime(deleteTime);
                customerBinding.setIsDeleted(isDeleted);
                customerBindings.add(customerBinding);
            }
        });
        this.saveOrUpdateBatch(customerBindings);
    }

    public List<CustomerBindingResp> binding(SetBindingReq params) {
        log.info("binding params:{}", (Object)params);
        Long bizId = params.getBizId();
        String customerNum = params.getCustomerNum();
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum\u4e0d\u80fd\u4e3a\u7a7a");
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        String productLineId = params.getProductLineId();
        Long userId = params.getUserId();
        String source = params.getSource();
        String weworkUserNum = params.getWeworkUserNum();
        List customerBindings = this.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"customer_num", (Object)customerNum)).eq(!ObjectUtils.isEmpty((Object)userId), (Object)"user_id", (Object)userId)).eq(StringUtils.isNotBlank((CharSequence)source), (Object)"source", (Object)source)).eq(StringUtils.isNotBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)weworkUserNum)).eq(StringUtils.isNotBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)productLineId)).eq(StringUtils.isBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)""));
        if (CollectionUtils.isEmpty((Collection)customerBindings)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        customerBindings.forEach(customerBinding -> {
            CustomerBindingResp customerBindingResp = new CustomerBindingResp();
            BeanUtils.copyProperties((Object)customerBinding, (Object)customerBindingResp);
            result.add(customerBindingResp);
        });
        return result;
    }

    private CustomerBinding buildCustomerBinding(SetBindingReq params, String corpId) {
        return CustomerBinding.builder().num(this.idGen.getNum()).bizId(params.getBizId()).corpId(corpId).userId(params.getUserId()).weworkUserNum(params.getWeworkUserNum()).customerNum(params.getCustomerNum()).deleteTime(params.getDeleteTime()).userId(params.getUserId()).source(params.getSource()).productLineId(params.getProductLineId()).createBy(Long.valueOf(-1L)).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date()).isDeleted(Integer.valueOf(0)).build();
    }
}

