/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.dto.req.CollectionSaveReq;
import cn.kinyun.customer.center.dto.req.MerchantNewListReq;
import cn.kinyun.customer.center.dto.req.ProductIdempotentSaveReq;
import cn.kinyun.customer.center.dto.req.RevenueContractReq;
import cn.kinyun.customer.center.dto.req.YonbipNewInsertReq;
import cn.kinyun.customer.center.dto.resp.CollectionSaveResponse;
import cn.kinyun.customer.center.dto.resp.RevenueContractResp;
import cn.kinyun.customer.center.dto.resp.YonbipNewInsertResp;
import cn.kinyun.customer.center.service.YongYouService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.open.http.HttpClientUtil;
import com.yonyou.iuap.open.http.model.HttpRequest;
import com.yonyou.iuap.open.http.model.HttpResponse;
import com.yonyou.iuap.open.utils.SignUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class YongYouServiceImpl
implements YongYouService {
    private static final Logger log = LoggerFactory.getLogger(YongYouServiceImpl.class);
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisPrefix;

    public String getAccessToken() {
        String redisKey = this.redisPrefix + "yongyou:access_token";
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (accessToken != null) {
            log.info("\u4eceredis\u4e2d\u83b7\u53d6\u5230\u7528\u53cb\u8bbf\u95ee\u4ee4\u724caccessToken:{}", (Object)accessToken);
            return accessToken;
        }
        try {
            long curMills = System.currentTimeMillis();
            String signParams = SignUtil.sign((String)"e8c1fdf97f804dd88ff99af5ae1ea151", (Long)curMills, (String)"8c3bc71b5764dfe6277127cb2d0f800a7c014c73");
            String url = "https://c1.yonyoucloud.com/iuap-api-auth/open-auth/selfAppAuth/getAccessToken";
            url = url + "?appKey=e8c1fdf97f804dd88ff99af5ae1ea151";
            url = url + "&timestamp=" + curMills;
            url = url + "&signature=" + signParams;
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setUrl(url);
            HttpResponse httpResponse = HttpClientUtil.httpGet((HttpRequest)httpRequest);
            log.info("yongyou getAccessToken, result:{}", (Object)httpResponse.getResult());
            JSONObject jsonObject = JSONObject.parseObject((String)httpResponse.getResult());
            if (jsonObject != null && jsonObject.getJSONObject("data") != null) {
                accessToken = jsonObject.getJSONObject("data").getString("access_token");
                int expiresIn = jsonObject.getJSONObject("data").getIntValue("expire");
                this.redisTemplate.opsForValue().set((Object)redisKey, (Object)accessToken, (long)expiresIn, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u53cb\u8bbf\u95ee\u4ee4\u724c\u5f02\u5e38", (Throwable)e);
        }
        return accessToken;
    }

    public YonbipNewInsertResp idempotentNewInsert(String customerName, String customerMobile) {
        log.info("idempotentNewInsert,customerName:{}, customerMobile:{}", (Object)customerName, (Object)customerMobile);
        YonbipNewInsertReq req = new YonbipNewInsertReq();
        YonbipNewInsertReq.Data data = new YonbipNewInsertReq.Data();
        data.setCreateOrgCode("global00");
        data.setEnterpriseNature(NumberUtils.INTEGER_ONE);
        data.setPersonName(customerName);
        data.setInternalOrg(Boolean.valueOf(false));
        String code = customerName + "-" + customerMobile;
        data.setCode(code);
        YonbipNewInsertReq.Name name = new YonbipNewInsertReq.Name();
        name.setSimplifiedName(code);
        data.setName(name);
        req.setData(data);
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            log.error("idempotentNewInsert\u83b7\u53d6\u7528\u53cb\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25");
            return null;
        }
        String url = "https://c1.yonyoucloud.com/iuap-api-gateway/yonbip/digitalModel/merchant/idempotent/newinsert?access_token=" + accessToken;
        String params = JSON.toJSONString((Object)req);
        log.info("idempotentNewInsert, url:{},params:{}", (Object)url, (Object)params);
        try {
            HttpResponse httpResponse = HttpClientUtil.httpPostJson((String)url, (String)params, null, null);
            log.info("\u65b0\u589e\u5ba2\u6237\u6863\u6848, result:{}", (Object)httpResponse.getResult());
            String result = httpResponse.getResult();
            if (StringUtils.isNotBlank((CharSequence)result)) {
                return (YonbipNewInsertResp)JSON.parseObject((String)result, YonbipNewInsertResp.class);
            }
        }
        catch (Exception ex) {
            log.error("\u65b0\u589e\u5ba2\u6237\u6863\u6848\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
        }
        return null;
    }

    public String merchantNewList(String customerName, String customerMobile) {
        log.info("merchantNewList,customerName:{}, customerMobile:{}", (Object)customerName, (Object)customerMobile);
        MerchantNewListReq merchantNewListReq = new MerchantNewListReq();
        merchantNewListReq.setName(customerName + "-" + customerMobile);
        merchantNewListReq.setFilterPotential(Boolean.valueOf(true));
        merchantNewListReq.setPageIndex(Integer.valueOf(1));
        merchantNewListReq.setPageSize(Integer.valueOf(10));
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            log.error("merchantNewList\u83b7\u53d6\u7528\u53cb\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25");
            return "";
        }
        String url = "https://c1.yonyoucloud.com/iuap-api-gateway/yonbip/digitalModel/merchant/newlist?access_token=" + accessToken;
        String params = JSON.toJSONString((Object)merchantNewListReq);
        log.info("merchantNewList, url:{},params:{}", (Object)url, (Object)params);
        try {
            JSONArray jsonArray;
            HttpResponse httpResponse = HttpClientUtil.httpPostJson((String)url, (String)params, null, null);
            log.info("\u83b7\u53d6\u5ba2\u6237\u6863\u6848, result:{}", (Object)httpResponse.getResult());
            String result = httpResponse.getResult();
            if (StringUtils.isNotBlank((CharSequence)result) && (jsonArray = JSON.parseObject((String)result).getJSONArray("data")) != null && !jsonArray.isEmpty()) {
                return jsonArray.getJSONObject(0).getString("code");
            }
        }
        catch (Exception ex) {
            log.error("\u65b0\u589e\u5ba2\u6237\u6863\u6848\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
        }
        return "";
    }

    public Long productIdempotentSave(String productName, String productCode) {
        log.info("productIdempotentSave,productName:{}, productCode:{}", (Object)productName, (Object)productCode);
        ProductIdempotentSaveReq req = new ProductIdempotentSaveReq();
        ProductIdempotentSaveReq.ProductData data = new ProductIdempotentSaveReq.ProductData();
        req.setData(data);
        data.setOrgCode("global00");
        data.setCode(productCode);
        data.setAutoGenerateRangeData(Boolean.valueOf(true));
        data.setName(new ProductIdempotentSaveReq.ProductName(productName));
        data.setUseSku(NumberUtils.INTEGER_ONE);
        data.setManageClassCode("CLGK");
        data.setTransTypeCode("SYCSR002");
        data.setRealProductAttribute(NumberUtils.INTEGER_TWO);
        data.setVirtualProductAttribute(Integer.valueOf(7));
        data.setUnitUseType(NumberUtils.INTEGER_TWO);
        data.setUnitCode("HB");
        data.setDetail(new ProductIdempotentSaveReq.ProductDetail("HB", "HB", "HB", "HB", "HB", "HB", "HB", "HB", "HB", "HB", "HB"));
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            log.error("merchantNewList\u83b7\u53d6\u7528\u53cb\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25");
            return null;
        }
        String url = "https://c1.yonyoucloud.com/iuap-api-gateway/yonbip/digitalModel/product/idempotent/save?access_token=" + accessToken;
        String params = JSON.toJSONString((Object)req);
        log.info("productIdempotentSave, url:{},params:{}", (Object)url, (Object)params);
        try {
            JSONObject jsonObject;
            HttpResponse httpResponse = HttpClientUtil.httpPostJson((String)url, (String)params, null, null);
            log.info("\u4fdd\u5b58\u7269\u6599, result:{}", (Object)httpResponse.getResult());
            String result = httpResponse.getResult();
            if (StringUtils.isNotBlank((CharSequence)result) && (jsonObject = JSON.parseObject((String)result).getJSONObject("data")) != null) {
                return jsonObject.getLong("id");
            }
        }
        catch (Exception ex) {
            log.error("\u65b0\u589e\u5ba2\u6237\u6863\u6848\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
        }
        return null;
    }

    public CollectionSaveResponse collectionSave(CollectionSaveReq collectionSaveReq) {
        log.info("collectionSave,req:{}", (Object)collectionSaveReq);
        Date now = new Date();
        collectionSaveReq.getData().setBillDate(now);
        collectionSaveReq.getData().setSourceCode("rclRevenueContract");
        collectionSaveReq.getData().setObjectType(NumberUtils.INTEGER_ONE);
        collectionSaveReq.getData().setExchangeRate(BigDecimal.ONE);
        collectionSaveReq.getData().setExchangeRateDate(now);
        collectionSaveReq.getData().setStatus("Insert");
        collectionSaveReq.getData().setBustypeCode("ar_colsale");
        collectionSaveReq.getData().setExchangeRateTypeCode("01");
        collectionSaveReq.getData().setSrcApp("1590899514909655042");
        collectionSaveReq.getData().setBizFlowMakeBillCode("rclRevenueContractToCollectionBill");
        collectionSaveReq.getData().setSettleModeCode("system_0001");
        collectionSaveReq.getData().setSrcBillType("25");
        collectionSaveReq.getData().setOriCurrencyCode("CNY");
        collectionSaveReq.getData().getBodyItem().forEach(item -> {
            item.setStatus("Insert");
            item.setBizFlowMakeBillCode("rclRevenueContractToCollectionBill");
            item.setSrcBillType("25");
            item.setQuickTypeCode("2");
            item.setSrcOrderType("1570189715179044871");
        });
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            log.error("idempotentNewInsert\u83b7\u53d6\u7528\u53cb\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25");
            return null;
        }
        String url = "https://c1.yonyoucloud.com/iuap-api-gateway/yonbip/EFI/collection/save?access_token=" + accessToken;
        String params = JSON.toJSONString((Object)collectionSaveReq);
        log.info("collectionSave, url:{},params:{}", (Object)url, (Object)params);
        try {
            HttpResponse httpResponse = HttpClientUtil.httpPostJson((String)url, (String)params, null, null);
            log.info("\u6536\u6b3e\u5355\u4fdd\u5b58, result:{}", (Object)httpResponse.getResult());
            String result = httpResponse.getResult();
            if (StringUtils.isNotBlank((CharSequence)result)) {
                return (CollectionSaveResponse)JSON.parseObject((String)result, CollectionSaveResponse.class);
            }
        }
        catch (Exception ex) {
            log.error("\u6536\u6b3e\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
        }
        return null;
    }

    public RevenueContractResp revenueContractSave(RevenueContractReq revenueContractReq) {
        log.info("revenueContractSave,req:{}", (Object)revenueContractReq);
        Date now = new Date();
        String orderNo = revenueContractReq.getData().getCode();
        BigDecimal amount = revenueContractReq.getData().getOrimnyNotax();
        revenueContractReq.getData().setName(orderNo);
        revenueContractReq.getData().setContractTypeCode("rcl_generalct");
        revenueContractReq.getData().setVersion(Integer.valueOf(1));
        revenueContractReq.getData().setBillDate(now);
        revenueContractReq.getData().setSignDate(now);
        revenueContractReq.getData().setCurrTypeCode("CNY");
        revenueContractReq.getData().setExchangeRateTypeCode("01");
        revenueContractReq.getData().setExchangeRateDate(now);
        revenueContractReq.getData().setExchangeRate(BigDecimal.ONE);
        revenueContractReq.getData().setLocalmnyTax(BigDecimal.ZERO);
        revenueContractReq.getData().setBlnStartFlag(Boolean.valueOf(false));
        revenueContractReq.getData().setExtSrcSystem("SCRM");
        revenueContractReq.getData().setExtSrcBillCode(revenueContractReq.getData().getCode());
        revenueContractReq.getData().setStatus("Insert");
        revenueContractReq.getData().setOrimny(amount);
        revenueContractReq.getData().setLocalmnyNotax(amount);
        revenueContractReq.getData().setLocalmny(amount);
        revenueContractReq.getData().getRclContractBaseInfoList().forEach(item -> {
            item.setRowNo(NumberUtils.INTEGER_ONE);
            item.setFinanceCompFlag(Boolean.valueOf(false));
            item.setIncomeConfirmRule1Code("R006");
            item.setQuantity(BigDecimal.ONE);
            item.setUnitCode("HB");
            item.setCurrencyCode("CNY");
            item.setTaxRateEntityCode("NL");
            item.setExchangeRateTypeCode("01");
            item.setExchangeRateDate(now);
            item.setExchangeRate(BigDecimal.ONE);
            item.setLocalmnyTax(BigDecimal.ZERO);
            item.setStatus("Insert");
            item.setExtBeginBillId(orderNo);
            item.setExtSrcBillCode(orderNo);
            item.setExtSrcBodyId(orderNo);
            item.setExtBeginBillNo(orderNo);
            item.setExtSrcBillId(orderNo);
            item.setExtBeginBodyId(orderNo);
            item.setExtSrcTransTypeCode(orderNo);
            item.setExtBeginBillTypeCode(orderNo);
            item.setExtBeginTransTypeCode(orderNo);
            item.setExtSrcSystems(orderNo);
            item.setExtSrcBillTypeCode(orderNo);
            item.setOrimnyNotax(amount);
            item.setOrimny(amount);
            item.setLocalmnyNotax(amount);
            item.setLocalmny(amount);
        });
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            log.error("idempotentNewInsert\u83b7\u53d6\u7528\u53cb\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25");
            return null;
        }
        String url = "https://c1.yonyoucloud.com/iuap-api-gateway/yonbip/AMP/fiercl/revenuecontract/save?access_token=" + accessToken;
        String params = JSON.toJSONString((Object)revenueContractReq);
        log.info("\u5c65\u7ea6\u4e49\u52a1\u5355\u65b0\u589e, url:{},params:{}", (Object)url, (Object)params);
        try {
            HttpResponse httpResponse = HttpClientUtil.httpPostJson((String)url, (String)params, null, null);
            log.info("\u5c65\u7ea6\u4e49\u52a1\u5355\u65b0\u589e, result:{}", (Object)httpResponse.getResult());
            String result = httpResponse.getResult();
            if (StringUtils.isNotBlank((CharSequence)result)) {
                return (RevenueContractResp)JSON.parseObject((String)result, RevenueContractResp.class);
            }
        }
        catch (Exception ex) {
            log.error("\u5c65\u7ea6\u4e49\u52a1\u5355\u65b0\u589e\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
        }
        return null;
    }
}

