/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.dal.dto.OrderPayRecordDto;
import cn.kinyun.customer.center.dal.dto.OrderPayRecordStatisticDto;
import cn.kinyun.customer.center.dal.dto.OrderSkuDepPayRecordStatisticDto;
import cn.kinyun.customer.center.dal.dto.OrderSkuDepPayRecordStatisticParam;
import cn.kinyun.customer.center.dal.dto.QueryOrderPayRecordDto;
import cn.kinyun.customer.center.dal.entity.CustomerOrderPayRecord;
import cn.kinyun.customer.center.dal.entity.OrderDictionary;
import cn.kinyun.customer.center.dal.entity.OrderSkuList;
import cn.kinyun.customer.center.dal.mapper.CustomerDetailMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerOrderPayRecordMapper;
import cn.kinyun.customer.center.dal.mapper.OrderDictionaryMapper;
import cn.kinyun.customer.center.dal.mapper.OrderSkuListMapper;
import cn.kinyun.customer.center.dal.util.BizTableContext;
import cn.kinyun.customer.center.dto.req.QueryOrderSkuDepPayRecordReportReq;
import cn.kinyun.customer.center.dto.req.QueryPayRecordListReq;
import cn.kinyun.customer.center.dto.resp.DynamicFieldDto;
import cn.kinyun.customer.center.dto.resp.OrderPayRecordResp;
import cn.kinyun.customer.center.dto.resp.OrderSkuDepPayRecordReportList;
import cn.kinyun.customer.center.dto.resp.OrderSkuDepPayRecordReportResp;
import cn.kinyun.customer.center.dto.resp.PagePayRecordResp;
import cn.kinyun.customer.center.dto.resp.PayRecordListResp;
import cn.kinyun.customer.center.dto.resp.PayRecordStatisticsResp;
import cn.kinyun.customer.center.enums.OrderSource;
import cn.kinyun.customer.center.enums.PayChannelType;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.service.CcCustomerPayRecordService;
import cn.kinyun.trade.dto.RpcOrderInfoRespDto;
import cn.kinyun.trade.service.RpcOrderService;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmChannelService;
import com.kuaike.scrm.common.service.ScrmUserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service
public class CcCustomerPayRecordServiceImpl
implements CcCustomerPayRecordService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerPayRecordServiceImpl.class);
    @Autowired
    private CustomerOrderPayRecordMapper customerOrderPayRecordMapper;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private OrderSkuListMapper orderSkuListMapper;
    @Autowired
    private RpcOrderService rpcOrderService;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private CustomerDetailMapper customerDetailMapper;
    @Autowired
    private ScrmChannelService scrmChannelService;
    @Autowired
    private OrderDictionaryMapper orderDictionaryMapper;
    @Autowired
    private NodeService nodeService;

    public PayRecordStatisticsResp queryPayRecordStatistics(QueryPayRecordListReq params) {
        log.info("queryPayRecordStatistics req:{}", (Object)params);
        Long bizId = params.getBizId();
        BizTableContext.putBizId((Long)bizId);
        QueryOrderPayRecordDto queryOrderPayRecordDto = new QueryOrderPayRecordDto();
        BeanUtils.copyProperties((Object)params, (Object)queryOrderPayRecordDto);
        OrderPayRecordStatisticDto orderPayRecordPayAmountStatisticDto = this.customerOrderPayRecordMapper.queryOrderyPayRecordPayAmountStatistic(queryOrderPayRecordDto);
        OrderPayRecordStatisticDto orderPayRecordTotalAmountStatisticDto = this.customerOrderPayRecordMapper.queryOrderyPayRecordTotalAmountStatistic(queryOrderPayRecordDto);
        PayRecordStatisticsResp result = new PayRecordStatisticsResp();
        if (orderPayRecordPayAmountStatisticDto != null) {
            result.setTotalPayAmount(orderPayRecordPayAmountStatisticDto.getTotalPayAmount());
        }
        if (orderPayRecordTotalAmountStatisticDto != null) {
            result.setTotalOrderAmount(orderPayRecordTotalAmountStatisticDto.getTotalOrderAmount());
            result.setTotalRemainAmount(orderPayRecordTotalAmountStatisticDto.getTotalRemainAmount());
        }
        BizTableContext.clear();
        return result;
    }

    public PagePayRecordResp queryPayRecordList(QueryPayRecordListReq params) {
        log.info("queryPayRecordList req:{}", (Object)params);
        Long bizId = params.getBizId();
        String corpId = this.scrmBizService.getById(bizId).getCorpId();
        BizTableContext.putBizId((Long)bizId);
        ArrayList payRecordListRespList = Lists.newArrayList();
        QueryOrderPayRecordDto queryOrderPayRecordDto = new QueryOrderPayRecordDto();
        BeanUtils.copyProperties((Object)params, (Object)queryOrderPayRecordDto);
        int count = this.customerOrderPayRecordMapper.queryOrderyPayRecordCount(queryOrderPayRecordDto);
        PagePayRecordResp result = new PagePayRecordResp();
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        if (count == 0) {
            result.setList(Collections.EMPTY_LIST);
        } else {
            List fieldDtos;
            List customerOrderPayRecordList = this.customerOrderPayRecordMapper.queryOrderyPayRecordList(queryOrderPayRecordDto);
            Set userIds = customerOrderPayRecordList.stream().map(OrderPayRecordDto::getUserId).collect(Collectors.toSet());
            Map userMap = this.scrmUserService.getNameByIds(userIds);
            List orderNoList = customerOrderPayRecordList.stream().map(CustomerOrderPayRecord::getOrderNo).collect(Collectors.toList());
            QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"order_no", orderNoList);
            List skuList = this.orderSkuListMapper.selectList((Wrapper)queryWrapper);
            Map orderNoSkuNameMap = skuList.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo, Collectors.mapping(OrderSkuList::getSkuName, Collectors.toList())));
            Set customerNums = customerOrderPayRecordList.stream().map(OrderPayRecordDto::getCustomerNum).collect(Collectors.toSet());
            Map customerNumMobileMap = this.customerMapper.selectMobileByNums(bizId, customerNums);
            Map customerNameMap = this.customerDetailMapper.queryCustomerNameMap(bizId, customerNums);
            Map channalNum2NameMap = null;
            List channelNums = customerOrderPayRecordList.stream().map(OrderPayRecordDto::getChannelNum).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(channelNums)) {
                channalNum2NameMap = this.scrmChannelService.getNameByNums(bizId, channelNums);
            }
            Map<Object, Object> sourceMap = Maps.newHashMap();
            OrderDictionary orderDictionary = (OrderDictionary)this.orderDictionaryMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).orderByDesc((Object)"create_time"));
            Map<Object, Object> keyNames = Maps.newHashMap();
            if (orderDictionary != null && StringUtils.isNotBlank((CharSequence)orderDictionary.getExtendField())) {
                try {
                    fieldDtos = JacksonUtil.str2List((String)orderDictionary.getExtendField(), DynamicFieldDto.class);
                    keyNames = fieldDtos.stream().filter(it -> it.getIsDeleted() == 0).collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
                }
                catch (IOException e) {
                    log.error("error: ", (Throwable)e);
                }
            }
            if (orderDictionary != null && StringUtils.isNotBlank((CharSequence)orderDictionary.getSources())) {
                try {
                    fieldDtos = JacksonUtil.str2List((String)orderDictionary.getSources(), DynamicFieldDto.class);
                    sourceMap = fieldDtos.stream().collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
                }
                catch (IOException e) {
                    log.error("error: ", (Throwable)e);
                }
            }
            for (OrderSource orderSource : OrderSource.values()) {
                sourceMap.put(orderSource.getValue(), orderSource.getDesc());
            }
            List orderNos = customerOrderPayRecordList.stream().map(CustomerOrderPayRecord::getOrderNo).collect(Collectors.toList());
            List rpcOrderList = this.rpcOrderService.queryOrderInfoByOrderNos(corpId, orderNos);
            Map<String, RpcOrderInfoRespDto> orderNo2RpcOrder = rpcOrderList.stream().collect(Collectors.toMap(RpcOrderInfoRespDto::getOrderNo, it -> it));
            for (OrderPayRecordDto orderPayRecordDto : customerOrderPayRecordList) {
                PayRecordListResp resp = new PayRecordListResp();
                BeanUtils.copyProperties((Object)orderPayRecordDto, (Object)resp);
                if (userMap.get(resp.getUserId()) != null) {
                    resp.setUserName((String)userMap.get(resp.getUserId()));
                }
                if (CollectionUtils.isNotEmpty((Collection)orderNoSkuNameMap.get(orderPayRecordDto.getOrderNo()))) {
                    resp.setSkuName(orderNoSkuNameMap.get(orderPayRecordDto.getOrderNo()).stream().collect(Collectors.joining(",")));
                }
                if (StringUtils.isNotBlank((CharSequence)orderPayRecordDto.getSource())) {
                    resp.setSourceDesc((String)sourceMap.get(orderPayRecordDto.getSource()));
                }
                if (Objects.nonNull(orderPayRecordDto.getStudentType())) {
                    if (NumberUtils.INTEGER_ONE.equals(orderPayRecordDto.getStudentType())) {
                        resp.setStudentTypeName("\u5408\u4f5c\u5355\u4f4d");
                    } else if (NumberUtils.INTEGER_TWO.equals(orderPayRecordDto.getStudentType())) {
                        resp.setStudentTypeName("\u793e\u4f1a\u751f");
                    }
                }
                if (orderNo2RpcOrder.get(orderPayRecordDto.getOrderNo()) != null) {
                    RpcOrderInfoRespDto rpcOrderInfoRespDto = orderNo2RpcOrder.get(orderPayRecordDto.getOrderNo());
                    resp.setExamTypeName(rpcOrderInfoRespDto.getExamTypeName());
                    resp.setPerformanceNodeName(rpcOrderInfoRespDto.getPerformanceNodeName());
                    resp.setSalesNodeName(rpcOrderInfoRespDto.getSalesNodeName());
                }
                if (StringUtils.isNotBlank((CharSequence)orderPayRecordDto.getChannelNum()) && MapUtils.isNotEmpty((Map)channalNum2NameMap)) {
                    resp.setChannelName((String)channalNum2NameMap.get(orderPayRecordDto.getChannelNum()));
                }
                if (customerNumMobileMap.get(resp.getCustomerNum()) != null) {
                    resp.setCustomerPhone((String)customerNumMobileMap.get(resp.getCustomerNum()));
                }
                if (customerNameMap.get(resp.getCustomerNum()) != null) {
                    resp.setCustomerName((String)customerNameMap.get(resp.getCustomerNum()));
                }
                if (orderPayRecordDto.getStayFee() != null) {
                    resp.setTotalAmount(Long.valueOf(orderPayRecordDto.getStayFee() + orderPayRecordDto.getOrderAmount()));
                } else {
                    resp.setTotalAmount(orderPayRecordDto.getOrderAmount());
                }
                if (orderPayRecordDto.getPayStatus() != null && orderPayRecordDto.getPayStatus().equals(PayStatusEnum.PAID) || orderPayRecordDto.getRefundStatus() != null && !orderPayRecordDto.getRefundStatus().equals(RefundStatusEnum.NONE.getValue())) {
                    resp.setTotalRemainAmount(Long.valueOf(0L));
                } else {
                    resp.setTotalRemainAmount(Long.valueOf((orderPayRecordDto.getStayFee() == null ? 0L : orderPayRecordDto.getStayFee()) + (orderPayRecordDto.getOrderAmount() == null ? 0L : orderPayRecordDto.getOrderAmount()) - (orderPayRecordDto.getPaidAmount() == null ? 0L : orderPayRecordDto.getPaidAmount()) - (orderPayRecordDto.getDiscountAmount() == null ? 0L : orderPayRecordDto.getDiscountAmount())));
                }
                if (resp.getChannelType() != null && PayChannelType.get((Integer)resp.getChannelType()) != null) {
                    resp.setTypeDesc(PayChannelType.get((Integer)resp.getChannelType()).getDesc());
                } else {
                    resp.setChannelType(null);
                }
                payRecordListRespList.add(resp);
            }
            BeanUtils.copyProperties((Object)customerOrderPayRecordList, (Object)payRecordListRespList);
        }
        result.setPageDto(params.getPageDto());
        result.setList((List)payRecordListRespList);
        BizTableContext.clear();
        return result;
    }

    public OrderSkuDepPayRecordReportResp queryOrderSkuDepPayRecordReport(QueryOrderSkuDepPayRecordReportReq reqDto) {
        List list;
        Set departIds;
        log.info("queryOrderSkuDepPayRecordReport req:{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.validate();
        OrderSkuDepPayRecordReportResp result = new OrderSkuDepPayRecordReportResp();
        OrderSkuDepPayRecordStatisticParam params = new OrderSkuDepPayRecordStatisticParam();
        BeanUtils.copyProperties((Object)reqDto, (Object)params);
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getDepartIds()) && CollectionUtils.isNotEmpty((Collection)(departIds = this.nodeService.getPosterityIds((Collection)reqDto.getDepartIds(), reqDto.getBizId())))) {
            params.setDepartIds(departIds);
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.customerOrderPayRecordMapper.queryOrderSkuDepPayRecordStatistic(params)))) {
            result.setList((List)Lists.newArrayList());
            return result;
        }
        List departIds2 = list.stream().filter(dto -> dto.getDepartId() != null).map(OrderSkuDepPayRecordStatisticDto::getDepartId).distinct().collect(Collectors.toList());
        Map nodeId2NameMap = this.nodeService.getNameByIds(reqDto.getBizId(), departIds2);
        log.info("queryOrderSkuDepPayRecordReport nodeId2NameMap resp:{}", (Object)JSON.toJSONString((Object)nodeId2NameMap));
        ArrayList resultList = Lists.newArrayList();
        Map<String, List<OrderSkuDepPayRecordStatisticDto>> map = list.stream().collect(Collectors.groupingBy(OrderSkuDepPayRecordStatisticDto::getSkuNo));
        Long respTotalPayAmount = 0L;
        Long respTotalRemainAmount = 0L;
        Long respTotalOrderAmount = 0L;
        Integer respOrderCount = 0;
        for (Map.Entry<String, List<OrderSkuDepPayRecordStatisticDto>> entry : map.entrySet()) {
            String k = entry.getKey();
            List<OrderSkuDepPayRecordStatisticDto> v = entry.getValue();
            OrderSkuDepPayRecordReportList resp = new OrderSkuDepPayRecordReportList();
            resp.setSkuNo(k);
            resp.setSkuName(v.get(0).getSkuName());
            resp.setTotalPayAmount(Long.valueOf(v.stream().mapToLong(OrderSkuDepPayRecordStatisticDto::getTotalPayAmount).sum()));
            resp.setTotalOrderAmount(Long.valueOf(v.stream().mapToLong(OrderSkuDepPayRecordStatisticDto::getTotalOrderAmount).sum()));
            resp.setTotalRemainAmount(Long.valueOf(v.stream().mapToLong(OrderSkuDepPayRecordStatisticDto::getTotalRemainAmount).sum()));
            resp.setOrderCount(Integer.valueOf(v.stream().mapToInt(OrderSkuDepPayRecordStatisticDto::getOrderCount).sum()));
            resp.setDepList((List)Lists.newArrayList());
            respTotalPayAmount = respTotalPayAmount + resp.getTotalPayAmount();
            respTotalRemainAmount = respTotalRemainAmount + resp.getTotalRemainAmount();
            respTotalOrderAmount = respTotalOrderAmount + resp.getTotalOrderAmount();
            respOrderCount = respOrderCount + resp.getOrderCount();
            resultList.add(resp);
        }
        PayRecordStatisticsResp statisticsResp = new PayRecordStatisticsResp();
        statisticsResp.setTotalOrderAmount(respTotalOrderAmount);
        statisticsResp.setOrderCount(respOrderCount);
        statisticsResp.setTotalRemainAmount(respTotalRemainAmount);
        statisticsResp.setTotalPayAmount(respTotalPayAmount);
        result.setStatistics(statisticsResp);
        for (OrderSkuDepPayRecordReportList resp : resultList) {
            List<OrderSkuDepPayRecordStatisticDto> depList = map.get(resp.getSkuNo());
            for (OrderSkuDepPayRecordStatisticDto dto2 : depList) {
                if (dto2.getDepartId() != null) {
                    Set posterityIds = this.nodeService.getPosterityIds(dto2.getDepartId(), reqDto.getBizId());
                    List childDtos = depList.stream().filter(child -> posterityIds.contains(child.getDepartId())).collect(Collectors.toList());
                    long totalPayAmount = childDtos.stream().mapToLong(OrderSkuDepPayRecordStatisticDto::getTotalPayAmount).sum();
                    long totalOrderAmount = childDtos.stream().mapToLong(OrderSkuDepPayRecordStatisticDto::getTotalOrderAmount).sum();
                    long totalRemainAmount = childDtos.stream().mapToLong(OrderSkuDepPayRecordStatisticDto::getTotalRemainAmount).sum();
                    int totalOrderCount = childDtos.stream().mapToInt(OrderSkuDepPayRecordStatisticDto::getOrderCount).sum();
                    OrderSkuDepPayRecordReportList depResp = new OrderSkuDepPayRecordReportList();
                    if (nodeId2NameMap.get(dto2.getDepartId()) != null) {
                        depResp.setDepartName((String)nodeId2NameMap.get(dto2.getDepartId()));
                    }
                    depResp.setSkuNo(dto2.getSkuNo());
                    depResp.setSkuName(dto2.getSkuName());
                    depResp.setTotalPayAmount(Long.valueOf(totalPayAmount));
                    depResp.setTotalOrderAmount(Long.valueOf(totalOrderAmount));
                    depResp.setTotalRemainAmount(Long.valueOf(totalRemainAmount));
                    depResp.setOrderCount(Integer.valueOf(totalOrderCount));
                    resp.getDepList().add(depResp);
                    continue;
                }
                OrderSkuDepPayRecordReportList depResp = new OrderSkuDepPayRecordReportList();
                depResp.setSkuNo(dto2.getSkuNo());
                depResp.setSkuName(dto2.getSkuName());
                depResp.setTotalPayAmount(dto2.getTotalPayAmount());
                depResp.setTotalOrderAmount(dto2.getTotalOrderAmount());
                depResp.setTotalRemainAmount(dto2.getTotalRemainAmount());
                depResp.setOrderCount(dto2.getOrderCount());
                depResp.setDepartName("\u5176\u4ed6(\u7f51\u6821)");
                resp.getDepList().add(depResp);
            }
        }
        result.setList((List)resultList);
        return result;
    }

    public List<OrderPayRecordResp> queryPayRecordsByRequestIds(List<String> requestIds) {
        if (CollectionUtils.isEmpty(requestIds)) {
            log.info("requestIds is empty");
            return Collections.emptyList();
        }
        List payRecords = this.customerOrderPayRecordMapper.queryPayRecordsByRequestIds(requestIds);
        if (CollectionUtils.isEmpty((Collection)payRecords)) {
            return Collections.emptyList();
        }
        return payRecords.stream().map(payRecord -> {
            OrderPayRecordResp orderPayRecordResp = new OrderPayRecordResp();
            orderPayRecordResp.setNum(payRecord.getNum());
            orderPayRecordResp.setBizId(payRecord.getBizId());
            orderPayRecordResp.setCorpId(payRecord.getCorpId());
            orderPayRecordResp.setOrderNo(payRecord.getOrderNo());
            orderPayRecordResp.setChannelType(payRecord.getChannelType());
            orderPayRecordResp.setPayNo(payRecord.getPayNo());
            orderPayRecordResp.setPayAmount(payRecord.getPayAmount());
            orderPayRecordResp.setPayTime(payRecord.getPayTime());
            orderPayRecordResp.setPayStatus(payRecord.getPayStatus());
            orderPayRecordResp.setFkType(payRecord.getFkType());
            orderPayRecordResp.setFkId(payRecord.getFkId());
            orderPayRecordResp.setPostAmount(payRecord.getPostAmount());
            orderPayRecordResp.setTransaction(payRecord.getTransaction());
            orderPayRecordResp.setPlatformType(payRecord.getPlatformType());
            orderPayRecordResp.setPaymentVoucherUrl(payRecord.getPaymentVoucherUrl());
            orderPayRecordResp.setRequestId(payRecord.getRequestId());
            orderPayRecordResp.setWeworkProductId(payRecord.getWeworkProductId());
            return orderPayRecordResp;
        }).collect(Collectors.toList());
    }

    public void updateAmountByRequestId(String requestId, Long realPayAmount) {
        log.info("updateAmountByRequestId with requestId={}, realPayAmount={}", (Object)requestId, (Object)realPayAmount);
        if (StringUtils.isBlank((CharSequence)requestId) || Objects.isNull(realPayAmount)) {
            return;
        }
        this.customerOrderPayRecordMapper.updateAmountByRequestId(requestId, realPayAmount);
    }
}

