/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.crm.common.enums.OrderTradeType;
import cn.kinyun.crm.common.service.dto.req.SaleStateEvent;
import cn.kinyun.customer.center.common.service.RedisDistributedLock;
import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.common.utils.NetSchoolGoodsId;
import cn.kinyun.customer.center.dal.dto.OrderStatisticResp;
import cn.kinyun.customer.center.dal.dto.QueryOrderDto;
import cn.kinyun.customer.center.dal.dto.TuitionReportQuery;
import cn.kinyun.customer.center.dal.entity.Customer;
import cn.kinyun.customer.center.dal.entity.CustomerOrder;
import cn.kinyun.customer.center.dal.entity.CustomerOrderPayRecord;
import cn.kinyun.customer.center.dal.entity.CustomerRefundOrder;
import cn.kinyun.customer.center.dal.entity.OrderDictionary;
import cn.kinyun.customer.center.dal.entity.OrderLogistic;
import cn.kinyun.customer.center.dal.entity.OrderPeriods;
import cn.kinyun.customer.center.dal.entity.OrderSkuList;
import cn.kinyun.customer.center.dal.entity.RefundTransferRecord;
import cn.kinyun.customer.center.dal.entity.TuitionReport;
import cn.kinyun.customer.center.dal.mapper.CustomerDetailMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerOrderMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerOrderPayRecordMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerRefundOrderMapper;
import cn.kinyun.customer.center.dal.mapper.OrderDictionaryMapper;
import cn.kinyun.customer.center.dal.mapper.OrderLogisticMapper;
import cn.kinyun.customer.center.dal.mapper.OrderPeriodsMapper;
import cn.kinyun.customer.center.dal.mapper.OrderSkuListMapper;
import cn.kinyun.customer.center.dal.mapper.RefundTransferRecordMapper;
import cn.kinyun.customer.center.dal.mapper.TuitionReportMapper;
import cn.kinyun.customer.center.dal.util.BizTableContext;
import cn.kinyun.customer.center.dal.util.DateUtil;
import cn.kinyun.customer.center.dto.req.CollectionSaveReq;
import cn.kinyun.customer.center.dto.req.CustomerInfoPageReq;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.req.OrderStatisticsResp;
import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.req.RevenueContractReq;
import cn.kinyun.customer.center.dto.req.TuitionReportReq;
import cn.kinyun.customer.center.dto.req.order.OrderPeriodsReq;
import cn.kinyun.customer.center.dto.req.order.OrderQueryReq;
import cn.kinyun.customer.center.dto.req.order.OrderRecordReq;
import cn.kinyun.customer.center.dto.req.order.OrderReq;
import cn.kinyun.customer.center.dto.req.order.OrderSkuListReq;
import cn.kinyun.customer.center.dto.req.order.PayAmountReq;
import cn.kinyun.customer.center.dto.req.order.RefundReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderPayStatusReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderRefundInfoReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderReq;
import cn.kinyun.customer.center.dto.resp.CollectionSaveResponse;
import cn.kinyun.customer.center.dto.resp.CustomerAndOrderResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderAmountResq;
import cn.kinyun.customer.center.dto.resp.CustomerOrderInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderSimpleInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderSkuList;
import cn.kinyun.customer.center.dto.resp.CustomerOrderWeworkInfoResp;
import cn.kinyun.customer.center.dto.resp.DynamicFieldDto;
import cn.kinyun.customer.center.dto.resp.ExtendFieldResp;
import cn.kinyun.customer.center.dto.resp.LogisticsResp;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.dto.resp.OrderPayRecordResp;
import cn.kinyun.customer.center.dto.resp.OrderSkuResp;
import cn.kinyun.customer.center.dto.resp.OrderTotalResp;
import cn.kinyun.customer.center.dto.resp.PageCustomerOrderResp;
import cn.kinyun.customer.center.dto.resp.PageOrderListResp;
import cn.kinyun.customer.center.dto.resp.RefundOrderListResp;
import cn.kinyun.customer.center.dto.resp.RevenueContractResp;
import cn.kinyun.customer.center.dto.resp.TuitionReportDto;
import cn.kinyun.customer.center.dto.resp.TuitionReportRespDto;
import cn.kinyun.customer.center.dto.resp.YonbipNewInsertResp;
import cn.kinyun.customer.center.enums.OrderEntryMethodEnum;
import cn.kinyun.customer.center.enums.OrderSource;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.enums.RefundTypeEnum;
import cn.kinyun.customer.center.enums.TuitionReportTypeEnum;
import cn.kinyun.customer.center.enums.electricity.DouOrderStatusEnum;
import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import cn.kinyun.customer.center.enums.electricity.PayOrderStatusEnum;
import cn.kinyun.customer.center.enums.electricity.PlatformEnum;
import cn.kinyun.customer.center.enums.electricity.TaoBaoOrderStatusEnum;
import cn.kinyun.customer.center.enums.electricity.YzOrderStatusEnum;
import cn.kinyun.customer.center.sal.biz.service.impl.CcCustomerNumServiceImpl;
import cn.kinyun.customer.center.sal.biz.service.impl.CcCustomerService;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.center.service.CcCustomerTagService;
import cn.kinyun.customer.center.service.YongYouService;
import cn.kinyun.customer.common.OrderMsgDto;
import cn.kinyun.customer.utils.MobileUtils;
import cn.kinyun.pay.business.dto.request.PayConfigGroupQuery;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDto;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDtoResp;
import cn.kinyun.pay.business.enums.PayChannelType;
import cn.kinyun.pay.business.service.ScrmPayConfigService;
import cn.kinyun.trade.service.RpcOrderService;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.JsonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmChannelService;
import com.kuaike.scrm.common.service.ScrmSchoolService;
import com.kuaike.scrm.common.service.ScrmTagAutoService;
import com.kuaike.scrm.common.service.ScrmTagService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.service.dto.resp.ChannelDto;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import joptsimple.internal.Strings;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Service
public class CcCustomerOrderServiceImpl
implements CcCustomerOrderService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerOrderServiceImpl.class);
    @Value(value="${kafka.topic.trade_order}")
    private String topic;
    @Value(value="${sale.state.calculate.topic}")
    private String recalculateStateTopic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private IdGen idGen;
    @Autowired
    private CustomerOrderMapper customerOrderMapper;
    @Autowired
    private CustomerOrderPayRecordMapper customerOrderPayRecordMapper;
    @Autowired
    private CcCustomerDetailService customerDetailService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerNumServiceImpl customerNumService;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private OrderSkuListMapper orderSkuListMapper;
    @Autowired
    private CustomerDetailMapper customerDetailMapper;
    @Autowired
    private OrderDictionaryMapper orderDictionaryMapper;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private ScrmChannelService scrmChannelService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private CcCustomerService customerService;
    @Autowired
    private CustomerRefundOrderMapper customerRefundOrderMapper;
    @Autowired
    private OrderLogisticMapper orderLogisticMapper;
    @Autowired
    private RedisDistributedLock distributedLock;
    @Autowired
    private CcCustomerTagService ccCustomerTagService;
    @Autowired
    private ScrmTagService scrmTagService;
    @Autowired
    private ScrmTagAutoService scrmTagAutoService;
    @Autowired
    private RefundTransferRecordMapper refundTransferRecordMapper;
    @Resource
    private ScrmPayConfigService scrmPayConfigService;
    private static final Long ADMIN_ID = -1L;
    @Autowired
    private RpcOrderService rpcOrderService;
    @Autowired
    private OrderPeriodsMapper orderPeriodsMapper;
    @Autowired
    private TuitionReportMapper tuitionReportMapper;
    @Autowired
    private YongYouService yongYouService;
    @Autowired
    private ScrmSchoolService scrmSchoolService;
    private static final DateFormat YYYY_MM_DD_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public void addOrder(OrderReq params) {
        log.info("add order param:{}", (Object)JSON.toJSONString((Object)params));
        Preconditions.checkArgument((boolean)Objects.nonNull(params), (Object)"params is null");
        params.validate();
        String key = params.getBizId() + "_order_" + params.getOrderNo();
        try {
            this.distributedLock.reentrantLock(key);
            this.addOrderDymamic(params);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.distributedLock.unlock(key);
        }
    }

    private void addOrderDymamic(OrderReq params) {
        Map<String, String> mobileByCustomerNums;
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"is_deleted", (Object)0));
        if (Objects.nonNull(record) && Objects.nonNull(params.getUpdateTime()) && !this.isDecode(params.getEntryMethod()).booleanValue() && record.getUpdateTime().getTime() > params.getUpdateTime().getTime() + 2000L) {
            log.info("order add \u5f53\u524d\u8ba2\u5355\u6570\u636e\u5df2\u6267\u884c\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c\uff1a param:{}; recordUpdateTime:{}", (Object)JSON.toJSONString((Object)params), (Object)record.getUpdateTime().getTime());
            return;
        }
        String yongyouCustomerCode = this.yongYouService.merchantNewList(params.getCustomerName(), params.getCustomerMobile());
        if (StringUtils.isBlank((CharSequence)yongyouCustomerCode)) {
            log.info("addOrderDymamic customerName:{}, customerCode:{}\u8fd8\u672a\u540c\u6b65\u5230\u7528\u53cb", (Object)params.getCustomerName(), (Object)params.getCustomerMobile());
            YonbipNewInsertResp yonbipNewInsertResp = this.yongYouService.idempotentNewInsert(params.getCustomerName(), params.getCustomerMobile());
            if (Objects.nonNull(yonbipNewInsertResp) && Objects.nonNull(yonbipNewInsertResp.getData())) {
                yongyouCustomerCode = yonbipNewInsertResp.getData().getCode();
            }
        }
        boolean exist = true;
        if (record == null) {
            BizSimpleDto biz;
            record = new CustomerOrder();
            record.setNum(this.idGen.getNum());
            record.setStudentType(params.getStudentType());
            record.setChannelNum(params.getChannelNum());
            record.setPayGroupKey(params.getPayGroupKey());
            record.setBizId(params.getBizId());
            record.setSchoolId(params.getSchoolId());
            if ("scrm-open-api".equals(params.getOriginSys())) {
                record.setIsNetSchoolOrder(NumberUtils.INTEGER_ONE);
            }
            Preconditions.checkArgument(((biz = this.scrmBizService.getById(params.getBizId())) != null ? 1 : 0) != 0, (Object)"invalid bizId");
            record.setCorpId(biz.getCorpId());
            record.setPayGroupKey(params.getPayGroupKey());
            params.setCorpId(biz.getCorpId());
            record.setUserId(params.getUserId());
            params.setAfterOrderUser(params.getUserId());
            record.setWeworkUserNum(params.getWeworkUserNum());
            if (StringUtils.isNotBlank((CharSequence)params.getCustomerNum())) {
                record.setCustomerNum(params.getCustomerNum());
            }
            record.setProductLineId(params.getProductLineId());
            record.setSource(params.getSource());
            record.setOrderNo(params.getOrderNo());
            record.setCreateTime(new Date());
            if (params.getCreateTime() != null) {
                record.setOrderTime(params.getCreateTime());
            } else {
                record.setOrderTime(new Date());
            }
            record.setCreateBy(params.getCreateBy());
            if (Objects.nonNull(params.getStatus())) {
                record.setStatus(params.getStatus());
            }
            if (Objects.nonNull(params.getType())) {
                record.setType(params.getType());
            }
            if (Objects.nonNull(params.getPayType())) {
                record.setPayType(params.getPayType());
            }
            if (Objects.nonNull(params.getDeliveryAddress())) {
                record.setDeliveryAddress(params.getDeliveryAddress());
            }
            if (Objects.nonNull(params.getReceiveTel())) {
                record.setReceiveTel(params.getReceiveTel());
            }
            if (Objects.nonNull(params.getReceiveName())) {
                record.setReceiveName(params.getReceiveName());
            }
            if (Objects.nonNull(params.getPlatformType())) {
                record.setPlatformType(params.getPlatformType());
            }
            if (Objects.nonNull(params.getPromoterId())) {
                record.setPromoterId(params.getPromoterId());
            }
            record.setCustomerName(params.getCustomerName());
            record.setCustomerMobile(params.getCustomerMobile());
            exist = false;
        }
        if (Objects.nonNull(params.getStudentType())) {
            record.setStudentType(params.getStudentType());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getChannelNum())) {
            record.setChannelNum(params.getChannelNum());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerNum())) {
            record.setCustomerNum(params.getCustomerNum());
        }
        if (!exist && StringUtils.isEmpty((CharSequence)params.getCustomerNum())) {
            record.setCustomerNum("");
        }
        if (params.getCreateTime() != null) {
            record.setOrderTime(params.getCreateTime());
        }
        record.setCustomerName(params.getCustomerName());
        record.setCustomerMobile(params.getCustomerMobile());
        record.setOrderAmount(params.getOrderAmount());
        record.setYyCustomerCode(yongyouCustomerCode);
        Long i = this.orderSkuListMapper.selectCount((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        if (i > 0L) {
            this.orderSkuListMapper.delete((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        }
        String yongyouMaterialCode = "";
        ArrayList skuGoodsNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)params.getOrderSkuListReqs())) {
            for (OrderSkuListReq orderSkuListReq : params.getOrderSkuListReqs()) {
                OrderSkuList orderSkuList = new OrderSkuList();
                orderSkuList.setNum(this.idGen.getNum());
                orderSkuList.setCorpId(record.getCorpId());
                orderSkuList.setBizId(record.getBizId());
                orderSkuList.setOrderNo(params.getOrderNo());
                String scrmSkuNo = orderSkuListReq.getSkuNo();
                if ("scrm-open-api".equals(params.getOriginSys())) {
                    scrmSkuNo = NetSchoolGoodsId.getId((Long)params.getBizId(), (Integer)orderSkuListReq.getSkuType(), (String)orderSkuListReq.getSkuNo(), (Long)params.getSchoolId());
                }
                yongyouMaterialCode = scrmSkuNo;
                orderSkuList.setSkuNo(scrmSkuNo);
                orderSkuList.setSkuName(orderSkuListReq.getSkuName());
                orderSkuList.setSkuAmount(orderSkuListReq.getSkuAmount());
                orderSkuList.setSkuImgUrl(orderSkuListReq.getSkuImgUrl());
                orderSkuList.setRemark(orderSkuListReq.getRemark());
                orderSkuList.setGoodsNum(orderSkuListReq.getGoodsNum());
                orderSkuList.setOid(orderSkuListReq.getOid());
                orderSkuList.setTotalPrice(orderSkuListReq.getTotalPrice());
                orderSkuList.setAlias(orderSkuListReq.getAlias());
                orderSkuList.setGoodsUrl(orderSkuListReq.getGoodsUrl());
                orderSkuList.setSkuProperties(orderSkuListReq.getSkuProperties());
                orderSkuList.setPlatformType(orderSkuListReq.getPlatformType());
                orderSkuList.setCreateTime(new Date());
                orderSkuList.setUpdateTime(new Date());
                orderSkuList.setIsDeleted(Integer.valueOf(0));
                try {
                    this.orderSkuListMapper.insert((Object)orderSkuList);
                }
                catch (Exception e) {
                    log.error("\u63d2\u5165\u8ba2\u5355\u5546\u54c1\u5931\u8d25", (Throwable)e);
                }
                skuGoodsNames.add(orderSkuList.getSkuName());
            }
        } else {
            record.setSkuNo(params.getSkuNo());
            record.setSkuName(params.getSkuName());
            record.setSkuImgUrl(params.getSkuImgUrl());
            if (StringUtils.isNotBlank((CharSequence)params.getSkuNo())) {
                OrderSkuList orderSkuList = new OrderSkuList();
                orderSkuList.setNum(this.idGen.getNum());
                orderSkuList.setBizId(record.getBizId());
                orderSkuList.setCorpId(record.getCorpId());
                orderSkuList.setOrderNo(params.getOrderNo());
                orderSkuList.setSkuNo(params.getSkuNo());
                orderSkuList.setSkuName(params.getSkuName());
                orderSkuList.setSkuAmount(params.getSkuAmount());
                orderSkuList.setSkuImgUrl(params.getSkuImgUrl());
                Long skuCount = 1L;
                if (params.getSkuCount() != null) {
                    skuCount = params.getSkuCount().longValue();
                }
                orderSkuList.setGoodsNum(skuCount);
                orderSkuList.setCreateTime(new Date());
                orderSkuList.setUpdateTime(new Date());
                orderSkuList.setIsDeleted(Integer.valueOf(0));
                this.orderSkuListMapper.insert((Object)orderSkuList);
            }
            skuGoodsNames.add(params.getSkuName());
        }
        if (Objects.nonNull(params.getPayTime())) {
            record.setPayStatus(Integer.valueOf(Objects.nonNull(params.getPayTime()) ? PayStatusEnum.PAID.getValue() : PayStatusEnum.UNPAID.getValue()));
            record.setPayTime(params.getPayTime());
        }
        if (Objects.nonNull(params.getPayStatus())) {
            record.setPayStatus(params.getPayStatus());
        }
        if (Objects.nonNull(params.getShouldPayAmount())) {
            record.setShouldPayAmount(params.getShouldPayAmount());
        }
        if (Objects.nonNull(params.getDeliveryAddress())) {
            record.setDeliveryAddress(params.getDeliveryAddress());
        }
        if (Objects.nonNull(params.getReceiveTel())) {
            record.setReceiveTel(params.getReceiveTel());
        }
        if (Objects.nonNull(params.getReceiveTel())) {
            record.setReceiveName(params.getReceiveName());
        }
        if (Objects.nonNull(params.getShopName())) {
            record.setShopName(params.getShopName());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getShopId())) {
            record.setShopId(params.getShopId());
        }
        if (params.getCarriedAmount() != null) {
            record.setCarriedAmount(params.getCarriedAmount());
        }
        if (params.getStayFee() != null) {
            record.setStayFee(params.getStayFee());
        }
        if (Objects.nonNull(params.getEntryMethod()) && OrderEntryMethodEnum.MANUAL.getValue().equals(params.getEntryMethod())) {
            record.setEntryMethod(params.getEntryMethod());
            record.setPayStatus(Integer.valueOf(PayStatusEnum.PAID.getValue()));
            if (CollectionUtils.isNotEmpty((Collection)params.getDynamicColValue())) {
                record.setDynamicCol(JacksonUtil.obj2Str((Object)params.getDynamicColValue()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)params.getSource())) {
            record.setSource(params.getSource());
        }
        if (Objects.nonNull(params.getAchieveDepartId())) {
            record.setAchieveDepartId(params.getAchieveDepartId());
        }
        if (Objects.nonNull(params.getUpdateTime())) {
            record.setUpdateTime(params.getUpdateTime());
        } else {
            record.setUpdateTime(new Date());
        }
        if (Objects.nonNull(params.getPaidAmount())) {
            record.setPaidAmount(params.getPaidAmount());
        } else {
            record.setPaidAmount(Long.valueOf(0L));
        }
        record.setDiscountAmount(params.getDiscountAmount());
        record.setRefundNo(params.getRefundNo());
        record.setRefundAmount(params.getRefundAmount());
        record.setRefundStatus(params.getRefundStatus());
        record.setFkType(params.getFkType());
        record.setFkId(params.getFkId());
        record.setRemark(params.getRemark());
        if (Objects.isNull(record.getPayStatus())) {
            record.setPayStatus(Integer.valueOf(0));
        }
        record.setSchoolId(params.getSchoolId());
        record.setRealServicePeriod(params.getRealServicePeriod());
        record.setRealServicePeriodTime(params.getRealServicePeriodTime());
        record.setFreeServicePeriod(params.getFreeServicePeriod());
        record.setFreeServicePeriodTime(params.getFreeServicePeriodTime());
        record.setIsContainPhysical(Integer.valueOf(params.getIsContainPhysical() != false ? 1 : 0));
        record.setQqWechat(params.getQqWechat());
        record.setValidateDateBegin(params.getValidateDateBegin());
        record.setValidateDateEnd(params.getValidateDateEnd());
        record.setConsultantId(params.getConsultantId());
        if (exist) {
            params.setBeforeOrderUser(record.getUserId());
            params.setAfterOrderUser(params.getUserId());
            record.setUserId(params.getUserId());
            record.setStatus(params.getStatus());
            log.info("addOrderDymamic update customerOrder record:{}", (Object)record);
            this.customerOrderMapper.updateById((Object)record);
        } else {
            log.info("addOrderDymamic insert customerOrder record:{}", (Object)record);
            String financeCode = this.scrmSchoolService.getOrgCodeBySchoolId(params.getSchoolId());
            if (StringUtils.isBlank((CharSequence)financeCode)) {
                log.info("\u6839\u636eschoolId:{}\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u7f16\u7801", (Object)params.getSchoolId());
            } else {
                RevenueContractReq revenueContractReq = new RevenueContractReq();
                RevenueContractReq.PerformanceData performanceData = new RevenueContractReq.PerformanceData();
                revenueContractReq.setData(performanceData);
                RevenueContractReq.ContractBaseInfo contractBaseInfo = new RevenueContractReq.ContractBaseInfo();
                ArrayList<RevenueContractReq.ContractBaseInfo> rclContractBaseInfoList = new ArrayList<RevenueContractReq.ContractBaseInfo>();
                rclContractBaseInfoList.add(contractBaseInfo);
                performanceData.setRclContractBaseInfoList(rclContractBaseInfoList);
                performanceData.setAccentityCode(financeCode);
                performanceData.setCode(record.getOrderNo());
                performanceData.setCustomerCode(yongyouCustomerCode);
                long discountAmount = record.getDiscountAmount() != null ? record.getDiscountAmount() : 0L;
                BigDecimal shouldPayAmount = new BigDecimal((float)record.getOrderAmount().longValue() - (float)discountAmount / 10000.0f).setScale(2, 4);
                performanceData.setOrimnyNotax(shouldPayAmount);
                contractBaseInfo.setMaterialCode(yongyouMaterialCode);
                contractBaseInfo.setBeginDate(params.getValidateDateBegin());
                contractBaseInfo.setEndDate(params.getValidateDateEnd());
                String formattedDate = YYYY_MM_DD_FORMAT.format(params.getValidateDateBegin()).substring(0, 7);
                contractBaseInfo.setBeginApportionPeriodCode(formattedDate);
                Long apportionNum = DateUtil.getMonthsBetween((Date)params.getValidateDateBegin(), (Date)params.getValidateDateEnd());
                contractBaseInfo.setApportionNum(Integer.valueOf(apportionNum.intValue()));
                record.setYyRevenueContractReq(JsonUtil.toStr((Object)revenueContractReq));
                RevenueContractResp revenueContractResp = this.yongYouService.revenueContractSave(revenueContractReq);
                if (revenueContractResp != null && revenueContractResp.getCode().equals("200")) {
                    record.setYyRevenueContractResp(JsonUtil.toStr((Object)revenueContractResp));
                }
            }
            this.customerOrderMapper.insert((Object)record);
        }
        record = this.customerOrderMapper.getByOrderNo(record.getBizId(), record.getOrderNo());
        if (!record.getSource().equals(OrderSource.TRADE_ORDER) && StringUtils.isNotBlank((CharSequence)record.getCustomerNum()) && (mobileByCustomerNums = this.customerNumService.getMobileByCustomerNums(record.getBizId(), Lists.newArrayList((Object[])new String[]{record.getCustomerNum()}))).containsKey(record.getCustomerNum()) && StringUtils.isNotBlank((CharSequence)mobileByCustomerNums.get(record.getCustomerNum()))) {
            OrderMsgDto msgDto = this.buildOrderMsg(record, mobileByCustomerNums.get(record.getCustomerNum()), params.getChannelNum());
            msgDto.setName(params.getCustomerName());
            msgDto.setSkuNames((List)skuGoodsNames);
            msgDto.setNewLeads(params.getNewLeads());
            log.info("send order msg to kafka crm refresh leads msgDto: {}", (Object)msgDto);
            this.kafkaTemplate.send(this.topic, (Object)record.getOrderNo(), (Object)JacksonUtil.obj2Str((Object)msgDto));
        }
    }

    private OrderMsgDto buildOrderMsg(CustomerOrder customerOrder, String mobile, String channelNum) {
        ChannelDto channelDto = null;
        if (StringUtils.isBlank((CharSequence)channelNum)) {
            if (StringUtils.isNotBlank((CharSequence)customerOrder.getSource())) {
                channelDto = this.scrmChannelService.getByNum(Long.valueOf(0L), customerOrder.getSource());
            }
            if (channelDto == null) {
                channelDto = this.scrmChannelService.getByNum(Long.valueOf(0L), "orderCenter");
            }
        } else {
            channelDto = this.scrmChannelService.getByNum(customerOrder.getBizId(), channelNum);
        }
        OrderMsgDto orderMsgDto = new OrderMsgDto();
        orderMsgDto.setBizId(customerOrder.getBizId());
        orderMsgDto.setCorpId(customerOrder.getCorpId());
        orderMsgDto.setName(customerOrder.getCustomerName());
        orderMsgDto.setUserId(customerOrder.getUserId());
        orderMsgDto.setSource(customerOrder.getSource());
        orderMsgDto.setProductLineNo(customerOrder.getProductLineId());
        orderMsgDto.setMobile(mobile);
        orderMsgDto.setOrderNo(customerOrder.getOrderNo());
        orderMsgDto.setOrderPrice(customerOrder.getOrderAmount());
        orderMsgDto.setOrderTime(customerOrder.getOrderTime() == null ? null : Long.valueOf(customerOrder.getOrderTime().getTime()));
        orderMsgDto.setTradeAmount(customerOrder.getPaidAmount());
        orderMsgDto.setTradeType(Integer.valueOf(OrderTradeType.PAID.getValue()));
        orderMsgDto.setUserId(customerOrder.getUserId());
        if (channelDto != null) {
            orderMsgDto.setChannelId(channelDto.getId());
        }
        return orderMsgDto;
    }

    private OrderRecordReq buildOrdPayRecordReq(OrderReq orderReq) {
        OrderRecordReq orderRecordReq = new OrderRecordReq();
        BeanUtils.copyProperties((Object)orderReq, (Object)orderRecordReq);
        orderRecordReq.setChannelType(orderReq.getPaidChannelType());
        orderRecordReq.setPayTime(orderReq.getCreateTime());
        orderRecordReq.setPayAmount(orderReq.getPaidAmount());
        return orderRecordReq;
    }

    public void addOrderPayRecord(OrderRecordReq params) {
        log.info("add order pay record, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSource()), (Object)"source is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
        String key = params.getBizId() + "_orderRecord_" + params.getOrderNo();
        try {
            this.distributedLock.reentrantLock(key);
            this.adOrderRecordDynamic(params);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.distributedLock.unlock(key);
        }
    }

    private void adOrderRecordDynamic(OrderRecordReq params) {
        int payStatus;
        CustomerOrder customerOrder;
        if (StringUtils.isBlank((CharSequence)params.getPayNo())) {
            params.setPayNo("");
        }
        Preconditions.checkArgument(((customerOrder = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"is_deleted", (Object)0))) != null ? 1 : 0) != 0, (Object)("order not found:" + params.getOrderNo()));
        if (params.getIsDeleted() == 1 && StringUtils.isNotBlank((CharSequence)params.getNum())) {
            this.customerOrderPayRecordMapper.delete((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"num", (Object)params.getNum()));
            this.updatePaidAmount(customerOrder, params);
            this.tuitionReportMapper.deleteByNum(customerOrder.getBizId(), TuitionReportTypeEnum.PAYMENT.getDesc(), params.getNum());
            return;
        }
        CustomerOrderPayRecord record = null;
        if (params.getEntry() != null && params.getEntry() == 1) {
            if (StringUtils.isNotBlank((CharSequence)params.getNum())) {
                record = (CustomerOrderPayRecord)this.customerOrderPayRecordMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"num", (Object)params.getNum()));
            }
        } else {
            record = (CustomerOrderPayRecord)this.customerOrderPayRecordMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"pay_no", (Object)params.getPayNo()));
        }
        boolean exist = true;
        int n = payStatus = Objects.isNull(params.getPayStatus()) ? 3 : params.getPayStatus();
        if (record == null) {
            if (StringUtils.isNotBlank((CharSequence)params.getPayNo())) {
                CustomerOrderPayRecord existPayRecord = (CustomerOrderPayRecord)this.customerOrderPayRecordMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"pay_no", (Object)params.getPayNo()));
                Preconditions.checkArgument((existPayRecord == null ? 1 : 0) != 0, (Object)"\u652f\u4ed8\u5355\u5df2\u5b58\u5728");
            }
            record = new CustomerOrderPayRecord();
            record.setNum(this.idGen.getNum());
            record.setBizId(params.getBizId());
            BizSimpleDto biz = null;
            try {
                biz = this.scrmBizService.getById(params.getBizId());
            }
            catch (Exception e) {
                log.error("\u8c03\u7528scrmBizService.getById \u5f02\u5e38\uff1a:param{}", (Object)params.getBizId(), (Object)e);
            }
            Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)"invalid bizId");
            record.setCorpId(biz.getCorpId());
            exist = false;
            log.warn("not exist bizId={}, payNo={}", (Object)params.getBizId(), (Object)params.getPayNo());
            if (PayStatusEnum.PAID.getValue() == payStatus) {
                Date payTime = null;
                payTime = params.getPayTime() == null ? new Date() : params.getPayTime();
                this.addSavePaymentTuitionReport(customerOrder, payTime, record.getNum(), record.getPayAmount());
            }
        } else {
            log.warn("Exist bizId={}, payNo={}", (Object)params.getBizId(), (Object)params.getPayNo());
            if (record.getPayStatus().intValue() != PayStatusEnum.PAID.getValue() && payStatus == PayStatusEnum.PAID.getValue()) {
                this.addSavePaymentTuitionReport(customerOrder, record.getPayTime(), record.getNum(), record.getPayAmount());
            }
        }
        record.setPaymentVoucherUrl(params.getPaymentVoucherUrl());
        if (CollectionUtils.isNotEmpty((Collection)params.getPaymentVoucherUrlList())) {
            record.setPaymentVoucherUrl(StringUtils.join((Iterable)params.getPaymentVoucherUrlList(), (String)","));
        }
        record.setChannelType(Integer.valueOf(Objects.isNull(params.getChannelType()) ? -1 : params.getChannelType()));
        record.setPayNo(params.getPayNo());
        record.setPayStatus(Integer.valueOf(payStatus));
        record.setPayAmount(params.getPayAmount());
        if (params.getPayTime() == null) {
            record.setPayTime(new Date());
        } else {
            record.setPayTime(params.getPayTime());
        }
        record.setOrderNo(params.getOrderNo());
        record.setFkType(params.getFkType());
        record.setFkId(params.getFkId());
        record.setUpdateTime(new Date());
        record.setRequestId(params.getRequestId());
        record.setWeworkProductId(params.getWeworkProductId());
        if (exist) {
            this.customerOrderPayRecordMapper.updateById((Object)record);
        } else {
            record.setCreateTime(new Date());
            record.setPostAmount(params.getPostAmount());
            record.setTransaction(params.getTransaction());
            record.setPlatformType(params.getPlatformType());
            this.customerOrderPayRecordMapper.insert((Object)record);
        }
        if (PayStatusEnum.PAID.getValue() == record.getPayStatus().intValue() && Objects.isNull(customerOrder.getCustomerCode()) && StringUtils.isNotBlank((CharSequence)customerOrder.getCustomerMobile())) {
            Long customerCode = this.customerOrderMapper.queryCustomerCodeByBizSchoolIdAndMobile(customerOrder.getBizId(), customerOrder.getSchoolId(), customerOrder.getCustomerMobile());
            if (Objects.isNull(customerCode)) {
                customerCode = this.customerOrderMapper.queryMaxCustomerCodeByBizSchoolId(customerOrder.getBizId(), customerOrder.getSchoolId());
                customerCode = Objects.isNull(customerCode) ? NumberUtils.LONG_ONE : Long.valueOf(customerCode + 1L);
            }
            this.customerOrderMapper.updateCustomerCodeById(customerOrder.getId(), customerCode);
        }
        if (!params.getSource().equals(OrderSource.TRADE_ORDER.getValue())) {
            this.updatePaidAmount(customerOrder, params);
        }
    }

    private void addSavePaymentTuitionReport(CustomerOrder customerOrder, Date payTime, String payRecordNum, Long paidAmount) {
        String skuNo = this.orderSkuListMapper.querySkuNoByOrderNo(customerOrder.getBizId(), customerOrder.getOrderNo());
        TuitionReport tuitionReport = new TuitionReport();
        tuitionReport.setBizId(customerOrder.getBizId());
        Date orderTime = customerOrder.getOrderTime();
        LocalDate localDate = orderTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int year = localDate.getYear();
        int month = localDate.getMonthValue();
        tuitionReport.setYear(Integer.valueOf(year));
        tuitionReport.setMonth(Integer.valueOf(month));
        tuitionReport.setOrderNo(customerOrder.getOrderNo());
        tuitionReport.setPayOrRefundTime(payTime);
        tuitionReport.setBusinessDataType(TuitionReportTypeEnum.PAYMENT.getDesc());
        tuitionReport.setBusinessDataNum(payRecordNum);
        tuitionReport.setSchoolId(customerOrder.getSchoolId());
        tuitionReport.setSkuNo(skuNo);
        tuitionReport.setCreateTime(new Date());
        tuitionReport.setUpdateTime(new Date());
        tuitionReport.setIsDeleted(NumberUtils.INTEGER_ZERO);
        this.tuitionReportMapper.insert((Object)tuitionReport);
        if (StringUtils.isBlank((CharSequence)customerOrder.getYyRevenueContractResp())) {
            log.info("\u8ba2\u5355orderNo:{}\u672a\u540c\u6b65\u5230\u7528\u53cb", (Object)customerOrder.getOrderNo());
        } else {
            try {
                String financialCode = this.scrmSchoolService.getOrgCodeBySchoolId(customerOrder.getSchoolId());
                RevenueContractResp revenueContractResp = (RevenueContractResp)JacksonUtil.str2Obj((String)customerOrder.getYyRevenueContractResp(), RevenueContractResp.class);
                CollectionSaveReq collectionSaveReq = new CollectionSaveReq();
                CollectionSaveReq.DataDTO dataDTO = new CollectionSaveReq.DataDTO();
                CollectionSaveReq.BodyItemDTO bodyItemDTO = new CollectionSaveReq.BodyItemDTO();
                ArrayList<CollectionSaveReq.BodyItemDTO> bodyItemDTOS = new ArrayList<CollectionSaveReq.BodyItemDTO>();
                bodyItemDTOS.add(bodyItemDTO);
                dataDTO.setBodyItem(bodyItemDTOS);
                collectionSaveReq.setData(dataDTO);
                dataDTO.setOrgCode(financialCode);
                dataDTO.setFinanceOrgCode(financialCode);
                dataDTO.setSrcBillId(revenueContractResp.getData().getBillDO().getId());
                dataDTO.setSourceId(revenueContractResp.getData().getBillDO().getId());
                dataDTO.setCustomerCode(customerOrder.getYyCustomerCode());
                String materialCode = this.orderSkuListMapper.querySkuNoByOrderNo(customerOrder.getBizId(), customerOrder.getOrderNo());
                bodyItemDTO.setOriTaxIncludedAmount(new BigDecimal((float)paidAmount.longValue() / 10000.0f).setScale(2, 4));
                bodyItemDTO.setMaterialCode(materialCode);
                bodyItemDTO.setSrcBillId(revenueContractResp.getData().getBillDO().getId());
                bodyItemDTO.setSrcBillRowId(((RevenueContractResp.ResponseData.ReceiptPlan)revenueContractResp.getData().getBillDO().getRclReceiptPlanList().get(0)).getId());
                bodyItemDTO.setSourceId(revenueContractResp.getData().getBillDO().getId());
                bodyItemDTO.setSourceChildId(((RevenueContractResp.ResponseData.ReceiptPlan)revenueContractResp.getData().getBillDO().getRclReceiptPlanList().get(0)).getId());
                bodyItemDTO.setSrcBillNo(revenueContractResp.getData().getBillDO().getCode());
                bodyItemDTO.setSrcOrderRowId(((RevenueContractResp.ResponseData.ContractBaseInfo)revenueContractResp.getData().getBillDO().getRclContractBaseInfoList().get(0)).getId());
                String yyCollectionSaveReq = JsonUtil.toStr((Object)collectionSaveReq);
                String yyCollectionSaveResp = "";
                CollectionSaveResponse collectionSaveResponse = this.yongYouService.collectionSave(collectionSaveReq);
                if (Objects.nonNull(collectionSaveResponse) && collectionSaveResponse.getCode().equals("200")) {
                    yyCollectionSaveResp = JsonUtil.toStr((Object)collectionSaveResponse);
                }
                this.customerOrderPayRecordMapper.updateYyInfoByNum(yyCollectionSaveReq, yyCollectionSaveResp, payRecordNum);
            }
            catch (IOException e) {
                log.error("\u89e3\u6790\u7528\u53cb\u5c65\u7ea6\u4e49\u52a1\u54cd\u5e94\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void addSaveRefundTuitionReport(CustomerRefundOrder customerRefundOrder, CustomerOrder customerOrder) {
        String skuNo = this.orderSkuListMapper.querySkuNoByOrderNo(customerOrder.getBizId(), customerOrder.getOrderNo());
        TuitionReport tuitionReport = new TuitionReport();
        tuitionReport.setBizId(customerOrder.getBizId());
        LocalDate localDate = customerRefundOrder.getRefundTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int year = localDate.getYear();
        int month = localDate.getMonthValue();
        tuitionReport.setYear(Integer.valueOf(year));
        tuitionReport.setMonth(Integer.valueOf(month));
        tuitionReport.setOrderNo(customerOrder.getOrderNo());
        tuitionReport.setPayOrRefundTime(customerRefundOrder.getRefundTime());
        tuitionReport.setBusinessDataType(TuitionReportTypeEnum.REFUND.getDesc());
        tuitionReport.setBusinessDataNum(customerRefundOrder.getNum());
        tuitionReport.setSchoolId(customerOrder.getSchoolId());
        tuitionReport.setSkuNo(skuNo);
        tuitionReport.setCreateTime(new Date());
        tuitionReport.setUpdateTime(new Date());
        tuitionReport.setIsDeleted(NumberUtils.INTEGER_ZERO);
        this.tuitionReportMapper.insert((Object)tuitionReport);
    }

    public void tuitionReportSavePaymentOrder() {
        int year = LocalDate.now().getYear();
        int month = LocalDate.now().getMonthValue();
        try {
            List payRecords;
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().apply("YEAR(pay_time) = {0} AND MONTH(pay_time) = {1}", new Object[]{year, month})).eq(CustomerOrderPayRecord::getPayStatus, (Object)PayStatusEnum.PAID.getValue());
            int pageSize = 1000;
            int offset = 0;
            do {
                queryWrapper.last("LIMIT " + offset + "," + pageSize);
                payRecords = this.customerOrderPayRecordMapper.selectList((Wrapper)queryWrapper);
                for (CustomerOrderPayRecord payRecord : payRecords) {
                    try {
                        CustomerOrder customerOrder = this.customerOrderMapper.getByOrderNo(payRecord.getBizId(), payRecord.getOrderNo());
                        if (customerOrder != null) {
                            this.addSavePaymentTuitionReport(customerOrder, payRecord.getPayTime(), payRecord.getNum(), payRecord.getPayAmount());
                            log.info("\u6210\u529f\u751f\u6210\u652f\u4ed8\u5b66\u8d39\u62a5\u8868: payRecordNum={}", (Object)payRecord.getNum());
                            continue;
                        }
                        log.warn("\u672a\u627e\u5230\u5173\u8054\u7684\u5ba2\u6237\u8ba2\u5355: bizId={}, orderNo={}", (Object)payRecord.getBizId(), (Object)payRecord.getOrderNo());
                    }
                    catch (Exception e) {
                        log.error("\u5904\u7406\u652f\u4ed8\u8ba2\u5355\u751f\u6210\u5b66\u8d39\u62a5\u8868\u65f6\u51fa\u9519: payRecordNum={}", (Object)payRecord.getNum(), (Object)e);
                    }
                }
                offset += pageSize;
            } while (payRecords.size() == pageSize);
            log.info("\u652f\u4ed8\u5b66\u8d39\u62a5\u8868\u751f\u6210\u5b8c\u6210: year={}", (Object)year);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u652f\u4ed8\u5b66\u8d39\u62a5\u8868\u5931\u8d25: year={}", (Object)year, (Object)e);
            throw new RuntimeException("\u751f\u6210\u652f\u4ed8\u5b66\u8d39\u62a5\u8868\u5931\u8d25", e);
        }
    }

    public void tuitionReportSaveRefundOrder() {
        int year = LocalDate.now().getYear();
        int month = LocalDate.now().getMonthValue();
        try {
            List refundOrders;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().apply("YEAR(refund_time) = {0} AND MONTH(refund_time) = {1}", new Object[]{year, month});
            int pageSize = 1000;
            int offset = 0;
            do {
                queryWrapper.last("LIMIT " + offset + "," + pageSize);
                refundOrders = this.customerRefundOrderMapper.selectList((Wrapper)queryWrapper);
                for (CustomerRefundOrder refundOrder : refundOrders) {
                    try {
                        CustomerOrder customerOrder = this.customerOrderMapper.getByOrderNo(refundOrder.getBizId(), refundOrder.getOrderNo());
                        if (customerOrder != null) {
                            this.addSaveRefundTuitionReport(refundOrder, customerOrder);
                            log.info("\u6210\u529f\u751f\u6210\u9000\u6b3e\u5b66\u8d39\u62a5\u8868: refundOrderNum={}", (Object)refundOrder.getNum());
                            continue;
                        }
                        log.warn("\u672a\u627e\u5230\u5173\u8054\u7684\u5ba2\u6237\u8ba2\u5355: bizId={}, orderNo={}", (Object)refundOrder.getBizId(), (Object)refundOrder.getOrderNo());
                    }
                    catch (Exception e) {
                        log.error("\u5904\u7406\u9000\u6b3e\u8ba2\u5355\u751f\u6210\u5b66\u8d39\u62a5\u8868\u65f6\u51fa\u9519: refundOrderNum={}", (Object)refundOrder.getNum(), (Object)e);
                    }
                }
                offset += pageSize;
            } while (refundOrders.size() == pageSize);
            log.info("\u9000\u6b3e\u5b66\u8d39\u62a5\u8868\u751f\u6210\u5b8c\u6210: year={}, month={}", (Object)year, (Object)month);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u9000\u6b3e\u5b66\u8d39\u62a5\u8868\u5931\u8d25: year={}, month={}", new Object[]{year, month, e});
            throw new RuntimeException("\u751f\u6210\u9000\u6b3e\u5b66\u8d39\u62a5\u8868\u5931\u8d25", e);
        }
    }

    private void updatePaidAmount(CustomerOrder customerOrder, OrderRecordReq params) {
        List payRecordList = this.customerOrderPayRecordMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"pay_status", (Object)PayStatusEnum.PAID.getValue()));
        log.warn("payRecordList, bizId={}, payRecordList={}", (Object)params.getBizId(), (Object)payRecordList);
        Long payAmount = 0L;
        for (CustomerOrderPayRecord payRecord : payRecordList) {
            if (payRecord.getPayAmount() == null) continue;
            payAmount = payAmount + payRecord.getPayAmount();
        }
        CustomerOrder update = new CustomerOrder();
        update.setId(customerOrder.getId());
        update.setPaidAmount(payAmount);
        this.customerOrderMapper.updateById((Object)update);
        this.sendOrderMsg2Kafka(customerOrder, params.getOrderNo(), update, params.getNewLeads());
    }

    public void setOrderPayStatus(SetOrderPayStatusReq params) {
        log.info("set order pay status, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
        Preconditions.checkArgument((params.getPaidAmount() != null ? 1 : 0) != 0, (Object)"paidAmount is null");
        Preconditions.checkArgument((params.getPayStatus() != null ? 1 : 0) != 0, (Object)"payStatus is null");
        CustomerOrder customerOrder = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        log.warn("order not found, bizId={}, orderNo={}", (Object)params.getBizId(), (Object)params.getOrderNo());
        Preconditions.checkArgument((customerOrder != null ? 1 : 0) != 0, (Object)("order not found:" + params.getOrderNo()));
        CustomerOrder update = new CustomerOrder();
        update.setId(customerOrder.getId());
        update.setPaidAmount(params.getPaidAmount());
        update.setPayStatus(params.getPayStatus());
        update.setUpdateTime(new Date());
        if (params.getCarriedAmount() != null) {
            update.setCarriedAmount(params.getCarriedAmount());
        }
        if (params.getRefundStatus() != null) {
            update.setRefundStatus(params.getRefundStatus());
        }
        if (params.getOrderStatus() != null) {
            update.setStatus(params.getOrderStatus());
        }
        if (params.getSaleNodeId() != null) {
            update.setAchieveDepartId(params.getSaleNodeId());
        }
        this.customerOrderMapper.updateById((Object)update);
    }

    public void setOrderStatus(Long bizId, String orderNo, OrderStatusEnum orderStatusEnum) {
        log.info("setOrderStatus,bizId:{},orderNo:{},orderStatusEnum:{}", new Object[]{bizId, orderNo, orderStatusEnum});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (Object)"orderNo is null");
        Preconditions.checkArgument((orderStatusEnum != null ? 1 : 0) != 0, (Object)"orderStatusEnum is null");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(CustomerOrder::getBizId, (Object)bizId)).eq(CustomerOrder::getOrderNo, (Object)orderNo);
        CustomerOrder customerOrder = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)queryWrapper);
        Preconditions.checkArgument((customerOrder != null ? 1 : 0) != 0, (Object)("order not found:" + orderNo));
        CustomerOrder update = new CustomerOrder();
        update.setId(customerOrder.getId());
        update.setStatus(Integer.valueOf(orderStatusEnum.getValue()));
        this.customerOrderMapper.updateById((Object)update);
    }

    public void setOrder(SetOrderReq params) {
        log.info("setOrder req:{}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)("order not found:" + params.getOrderNo()));
        log.info("setOrder old order info:{}", (Object)record);
        boolean flag = false;
        if (params.getBelongUserId() != null) {
            flag = true;
            record.setUserId(params.getBelongUserId());
        }
        if (flag) {
            this.customerOrderMapper.updateById((Object)record);
        }
    }

    public void setOrderRefundInfo(SetOrderRefundInfoReq params) {
        log.info("set order refund info, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getRefundNo()), (Object)"refundNo is null");
        Preconditions.checkArgument((params.getRefundAmount() != null ? 1 : 0) != 0, (Object)"refundAmount is null");
        Preconditions.checkArgument((params.getRefundStatus() != null ? 1 : 0) != 0, (Object)"refundStatus is null");
        CustomerOrder customerOrder = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo()));
        log.warn("order not found, bizId={}, orderNo={}", (Object)params.getBizId(), (Object)params.getOrderNo());
        Preconditions.checkArgument((customerOrder != null ? 1 : 0) != 0, (Object)("order not found:" + params.getOrderNo()));
        CustomerOrder update = new CustomerOrder();
        update.setId(customerOrder.getId());
        update.setRefundNo(params.getRefundNo());
        update.setRefundStatus(params.getRefundStatus());
        update.setRefundAmount(params.getRefundAmount());
        update.setRefundTime(new Date());
        update.setUpdateTime(new Date());
        if (params.getCarriedAmount() != null) {
            update.setCarriedAmount(params.getCarriedAmount());
        }
        if (params.getPaidAmount() != null) {
            update.setPaidAmount(params.getPaidAmount());
        }
        this.customerOrderMapper.updateById((Object)update);
    }

    public void refundOrder(SetOrderRefundInfoReq params) {
        log.info("refund order, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOrderNo()), (Object)"orderNo is null");
        String key = params.getBizId() + "_refund_" + params.getOrderNo();
        try {
            this.distributedLock.reentrantLock(key);
            this.addRefundDymaic(params);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.distributedLock.unlock(key);
        }
    }

    private void addRefundDymaic(SetOrderRefundInfoReq params) {
        RefundTransferRecord transferRecord;
        CustomerOrder customerOrder = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"is_deleted", (Object)0));
        log.warn("order not found, bizId={}, orderNo={}", (Object)params.getBizId(), (Object)params.getOrderNo());
        Preconditions.checkArgument((customerOrder != null ? 1 : 0) != 0, (Object)("order not found:" + params.getOrderNo()));
        if (params.getIsDeleted() == 1 && StringUtils.isNotBlank((CharSequence)params.getNum())) {
            this.customerRefundOrderMapper.delete((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"num", (Object)params.getNum()));
            this.updateRefundAmount(customerOrder, params);
            return;
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{params.getRefundNo(), params.getRefundSerialNo(), params.getReason(), params.getRefundWay()}) && params.getRefundAmount() == null && params.getRefundTime() == null) {
            return;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getRefundNo()), (Object)"refundNo is null");
        Preconditions.checkArgument((params.getRefundAmount() != null ? 1 : 0) != 0, (Object)"refundAmount is null");
        Preconditions.checkArgument((params.getRefundStatus() != null ? 1 : 0) != 0, (Object)"refundStatus is null");
        CustomerRefundOrder customerRefundOrder = null;
        customerRefundOrder = StringUtils.isNotBlank((CharSequence)params.getNum()) && params.getEntry() != null && params.getEntry() == 1 ? (CustomerRefundOrder)this.customerRefundOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"num", (Object)params.getNum())) : (CustomerRefundOrder)this.customerRefundOrderMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"refund_no", (Object)params.getRefundNo()));
        if (customerRefundOrder == null) {
            CustomerRefundOrder exist = (CustomerRefundOrder)this.customerRefundOrderMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)params.getBizId())).eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"refund_no", (Object)params.getRefundNo()));
            Preconditions.checkArgument((exist == null ? 1 : 0) != 0, (Object)"\u9000\u6b3e\u5355\u5df2\u5b58\u5728");
            customerRefundOrder = new CustomerRefundOrder();
            customerRefundOrder.setNum(this.idGen.getNum());
            customerRefundOrder.setBizId(params.getBizId());
            customerRefundOrder.setCorpId(customerOrder.getCorpId());
            customerRefundOrder.setOrderNo(customerOrder.getOrderNo());
            customerRefundOrder.setRefundNo(params.getRefundNo());
            customerRefundOrder.setRefundSerialNo(params.getRefundSerialNo());
            customerRefundOrder.setStatus(params.getRefundStatus());
            customerRefundOrder.setRefundAmount(params.getRefundAmount());
            customerRefundOrder.setRefundType(params.getRefundType());
            customerRefundOrder.setApprovalStatus(params.getAuditStatus());
            customerRefundOrder.setReason(params.getReason());
            customerRefundOrder.setRemark(params.getRemark());
            customerRefundOrder.setPlatformType(params.getPlatformType());
            customerRefundOrder.setOid(params.getOid());
            customerRefundOrder.setRefundTime(params.getRefundTime());
            customerRefundOrder.setUpdateTime(new Date());
            customerRefundOrder.setCreateTime(new Date());
            customerRefundOrder.setCreateBy(Long.valueOf(params.getCreateBy() == null ? -1L : params.getCreateBy()));
            customerRefundOrder.setUpdateBy(Long.valueOf(-1L));
            customerRefundOrder.setRefundWay(params.getRefundWay());
            this.customerRefundOrderMapper.insert((Object)customerRefundOrder);
        } else {
            customerRefundOrder.setRefundSerialNo(params.getRefundSerialNo());
            customerRefundOrder.setStatus(params.getRefundStatus());
            customerRefundOrder.setRefundFailReason(params.getRefundFailReason());
            customerRefundOrder.setRefundAmount(params.getRefundAmount());
            customerRefundOrder.setRefundType(params.getRefundType());
            customerRefundOrder.setRefundTime(params.getRefundTime());
            customerRefundOrder.setUpdateTime(new Date());
            customerRefundOrder.setRefundWay(params.getRefundWay());
            this.customerRefundOrderMapper.updateById((Object)customerRefundOrder);
        }
        if (customerRefundOrder.getRefundType() != null && customerRefundOrder.getRefundType().intValue() == RefundTypeEnum.TRANSFER.getValue() && (transferRecord = this.refundTransferRecordMapper.queryTransferRecord(customerRefundOrder.getBizId(), customerRefundOrder.getNum())) != null) {
            transferRecord.setTransferNo(params.getRefundSerialNo());
        }
        if (params.getRefundStatus() != null && params.getRefundStatus().intValue() == RefundStatusEnum.REFUNDED.getValue()) {
            this.updateRefundAmount(customerOrder, params);
            this.addSaveRefundTuitionReport(customerRefundOrder, customerOrder);
            try {
                RevenueContractReq revenueContractReq = (RevenueContractReq)JacksonUtil.str2Obj((String)customerOrder.getYyRevenueContractReq(), RevenueContractReq.class);
                revenueContractReq.getData().setCode(customerOrder.getOrderNo() + "-T");
                BigDecimal orimnyNotax = new BigDecimal((float)(-customerRefundOrder.getRefundAmount().longValue()) / 10000.0f).setScale(2, RoundingMode.HALF_UP);
                revenueContractReq.getData().setOrimnyNotax(orimnyNotax);
                this.yongYouService.revenueContractSave(revenueContractReq);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Long refundAmount = customerRefundOrder.getRefundAmount();
            String yyCollectionSaveReq = this.customerOrderPayRecordMapper.selectCollectionSaveReqByOrderNo(customerOrder.getBizId(), customerOrder.getOrderNo());
            if (StringUtils.isNotBlank((CharSequence)yyCollectionSaveReq)) {
                try {
                    CollectionSaveReq collectionSaveReq = (CollectionSaveReq)JacksonUtil.str2Obj((String)yyCollectionSaveReq, CollectionSaveReq.class);
                    collectionSaveReq.getData().getBodyItem().forEach(item -> item.setOriTaxIncludedAmount(new BigDecimal((float)refundAmount.longValue() / 10000.0f).setScale(2, RoundingMode.HALF_UP)));
                    this.yongYouService.collectionSave(collectionSaveReq);
                }
                catch (Exception ex) {
                    log.error("\u9000\u6b3e\u65f6\u540c\u6b65\u6536\u6b3e\u4fe1\u606f\u5230\u7528\u53cb\u5931\u8d25", (Throwable)ex);
                }
            } else {
                log.info("\u9000\u6b3e\u65f6\u540c\u6b65\u6536\u6b3e\u4fe1\u606f yyCollectionSaveReq\u4e3a\u7a7a\uff0corderNo:{}", (Object)customerOrder.getOrderNo());
            }
        }
    }

    private void updateRefundAmount(CustomerOrder customerOrder, SetOrderRefundInfoReq params) {
        List refundOrderList = this.customerRefundOrderMapper.getByOrderNo(params.getBizId(), params.getOrderNo());
        Long refundAmount = 0L;
        for (CustomerRefundOrder refundOrder : refundOrderList) {
            if (refundOrder.getRefundAmount() == null) continue;
            refundAmount = refundAmount + refundOrder.getRefundAmount();
        }
        CustomerOrder update = new CustomerOrder();
        update.setId(customerOrder.getId());
        update.setRefundAmount(refundAmount);
        if (customerOrder.getPaidAmount() < refundAmount) {
            update.setStatus(Integer.valueOf(PayOrderStatusEnum.PARTIAL_REFUND.getValue()));
        } else {
            update.setStatus(Integer.valueOf(PayOrderStatusEnum.REFUNDED.getValue()));
        }
        this.customerOrderMapper.updateById((Object)update);
        this.sendOrderMsg2Kafka(customerOrder, params.getOrderNo(), update, 0);
    }

    private void sendOrderMsg2Kafka(CustomerOrder customerOrder, String orderNo, CustomerOrder update, Integer newLeads) {
        Map<String, String> mobileByCustomerNums;
        ArrayList skuGoods = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)customerOrder.getSkuName())) {
            skuGoods.add(customerOrder.getSkuName());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"biz_id", (Object)customerOrder.getBizId())).eq((Object)"order_no", (Object)orderNo)).eq((Object)"is_deleted", (Object)0);
        List orderSkuLists = this.orderSkuListMapper.selectList((Wrapper)queryWrapper);
        log.info("order sku list: {}, query params order_no: {}", (Object)orderSkuLists, (Object)orderNo);
        for (OrderSkuList orderSku : orderSkuLists) {
            if (!StringUtils.isNotBlank((CharSequence)orderSku.getSkuName())) continue;
            skuGoods.add(orderSku.getSkuName());
        }
        if (!customerOrder.getSource().equals(OrderSource.TRADE_ORDER) && StringUtils.isNotBlank((CharSequence)customerOrder.getCustomerNum()) && (mobileByCustomerNums = this.customerNumService.getMobileByCustomerNums(customerOrder.getBizId(), Lists.newArrayList((Object[])new String[]{customerOrder.getCustomerNum()}))).containsKey(customerOrder.getCustomerNum()) && StringUtils.isNotBlank((CharSequence)mobileByCustomerNums.get(customerOrder.getCustomerNum()))) {
            customerOrder.setPaidAmount(update.getPaidAmount());
            OrderMsgDto msgDto = this.buildOrderMsg(customerOrder, mobileByCustomerNums.get(customerOrder.getCustomerNum()), null);
            msgDto.setSkuNames((List)skuGoods);
            msgDto.setNewLeads(Integer.valueOf(Objects.isNull(newLeads) ? 0 : newLeads));
            log.info("send order msg to kafka crm refresh leads msgDto: {}", (Object)msgDto);
            this.kafkaTemplate.send(this.topic, (Object)customerOrder.getOrderNo(), (Object)JacksonUtil.obj2Str((Object)msgDto));
        }
    }

    public CustomerOrderResp queryCustomerOrderInfo(CustomerInfoPageReq pageReq) {
        Preconditions.checkArgument((pageReq.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pageReq.getCustomerNum()), (Object)"customerNum is null");
        log.info("queryCustomerOrderInfo,pageReq:{}", (Object)pageReq);
        List<String> customerNums = this.customerNumService.getCustomerNums(pageReq.getBizId(), pageReq.getCustomerNum());
        if (CollectionUtils.isEmpty(customerNums)) {
            log.info("queryCustomerOrderInfo customerNums is null");
            return null;
        }
        List orderList = this.customerOrderMapper.queryCustomerOrderList(pageReq.getBizId(), customerNums, Integer.valueOf(pageReq.getPageDto().getOffset()), pageReq.getPageDto().getPageSize(), pageReq.getIsSystemAdmin(), (Collection)pageReq.getExcludeBizIds());
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            log.info("queryCustomerOrderInfo, \u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f, bizId: {}, customerNum: {}", (Object)pageReq.getBizId(), (Object)pageReq.getCustomerNum());
            return null;
        }
        int count = this.customerOrderMapper.queryCustomerOrderSize(pageReq.getBizId(), customerNums, pageReq.getIsSystemAdmin(), (Collection)pageReq.getExcludeBizIds());
        pageReq.getPageDto().setCount(Integer.valueOf(count));
        pageReq.getPageDto().setCurPageCount(Integer.valueOf(orderList.size()));
        List orderNoList = orderList.stream().map(CustomerOrder::getOrderNo).collect(Collectors.toList());
        List payRecordList = this.customerOrderPayRecordMapper.queryOrderPayRecord(pageReq.getBizId(), orderNoList);
        List refundOrderList = this.customerRefundOrderMapper.queryCustomerRefundOrderList(orderNoList, null);
        Map orderNoRefundOrderMap = refundOrderList.stream().collect(Collectors.groupingBy(CustomerRefundOrder::getOrderNo, Collectors.mapping(Function.identity(), Collectors.toList())));
        List orderSkus = this.orderSkuListMapper.querySkuListByOrderNos(orderNoList);
        Map<String, List<OrderSkuList>> orderSkuMap = orderSkus.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo));
        ArrayList respList = Lists.newArrayList();
        for (CustomerOrder order : orderList) {
            CustomerOrderInfoResp infoResp = new CustomerOrderInfoResp();
            infoResp.setId(order.getNum());
            infoResp.setOrderNo(order.getOrderNo());
            infoResp.setOrderTime(order.getOrderTime());
            infoResp.setSkuNo(order.getSkuNo());
            infoResp.setSkuName(order.getSkuName());
            List<OrderSkuList> orderSkuList = orderSkuMap.getOrDefault(order.getOrderNo(), Lists.newArrayList());
            if (CollectionUtils.isNotEmpty(orderSkuList)) {
                List skuNames = orderSkuList.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getSkuName())).map(it -> it.getSkuName()).collect(Collectors.toList());
                infoResp.setSkuName(Joiner.on((String)",").join(skuNames));
                List skuNos = orderSkuList.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getSkuNo())).map(it -> it.getSkuNo()).collect(Collectors.toList());
                infoResp.setSkuNo(Joiner.on((String)",").join(skuNos));
            }
            infoResp.setOrderAmount(order.getOrderAmount());
            infoResp.setPaidAmount(order.getPaidAmount());
            infoResp.setRefundAmount(order.getRefundAmount());
            List customerRefundOrders = orderNoRefundOrderMap.get(order.getOrderNo());
            if (CollectionUtils.isNotEmpty(customerRefundOrders)) {
                infoResp.setRefundTime(((CustomerRefundOrder)customerRefundOrders.get(0)).getRefundTime());
            }
            infoResp.setRefundStatus(order.getRefundStatus());
            if (order.getRefundStatus() != null) {
                RefundStatusEnum refundStatusEnum = RefundStatusEnum.get((int)order.getRefundStatus());
                infoResp.setRefundStatusDesc(refundStatusEnum == null ? null : refundStatusEnum.getDesc());
            }
            infoResp.setCreateBy(order.getCreateBy());
            infoResp.setUserId(order.getUserId());
            List<CustomerOrderPayRecord> recordList = payRecordList.stream().filter(a -> a.getOrderNo().equals(order.getOrderNo())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(recordList)) {
                ArrayList payTypeList = Lists.newArrayList();
                recordList.forEach(a -> {
                    String payType = Optional.ofNullable(a.getChannelType()).map(item -> cn.kinyun.customer.center.enums.PayChannelType.get((Integer)item)).filter(Objects::nonNull).map(item -> item.getDesc()).orElse(null);
                    if (StringUtils.isNotBlank((CharSequence)payType)) {
                        payTypeList.add(payType);
                    }
                });
                infoResp.setPayTypeList((List)payTypeList);
            }
            respList.add(infoResp);
        }
        CustomerOrderResp orderResp = new CustomerOrderResp();
        orderResp.setOrderInfoResps((List)respList);
        orderResp.setPageDto(pageReq.getPageDto());
        return orderResp;
    }

    public List<CustomerOrderWeworkInfoResp> queryCustomerOrderList(Long bizId, String customerNum) {
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"Invalid customer num");
        List<String> customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
        log.info("queryCustomerOrderList customerNum: {},  customerNums: {}", (Object)customerNum, customerNums);
        if (CollectionUtils.isEmpty(customerNums)) {
            return null;
        }
        List userIdList = this.customerOrderMapper.queryCustomerOrderListByNum(bizId, customerNums);
        log.info("queryCustomerOrderList userIdList: {}", (Object)userIdList);
        ArrayList respList = Lists.newArrayList();
        userIdList.forEach(a -> {
            CustomerOrderWeworkInfoResp resp = new CustomerOrderWeworkInfoResp();
            resp.setUserId(a);
            respList.add(resp);
        });
        return respList;
    }

    public List<OrderTotalResp> orderCountList(QueryOrderListReq params) {
        OrderTotalResp resp = new OrderTotalResp();
        log.info("order list params: {}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = params.getBizId();
        BizTableContext.putBizId((Long)bizId);
        QueryOrderDto queryParams = (QueryOrderDto)BeanUtil.convert((Object)params, QueryOrderDto.class, (String[])new String[0]);
        List orderStatisticResps = this.customerOrderMapper.queryOrderCountList(queryParams);
        if (CollectionUtils.isEmpty((Collection)orderStatisticResps)) {
            return Lists.newArrayList();
        }
        List<OrderTotalResp> orderTotalResps = orderStatisticResps.stream().map(item -> {
            OrderTotalResp totalResp = new OrderTotalResp();
            BeanUtils.copyProperties((Object)item, (Object)totalResp);
            return totalResp;
        }).collect(Collectors.toList());
        BizTableContext.clear();
        return orderTotalResps;
    }

    private void queryByNameOrMobile(QueryOrderDto queryParams) {
        if (StringUtils.isBlank((CharSequence)queryParams.getNameOrMobile())) {
            queryParams.setNameOrMobile(null);
            return;
        }
        String query = queryParams.getNameOrMobile().trim();
        if (MobileUtils.isPhone((String)query)) {
            queryParams.setCustomerMobile(query);
        } else {
            queryParams.setCustomerName(query);
        }
    }

    public OrderTotalResp orderTotal(QueryOrderListReq params) {
        OrderTotalResp resp = new OrderTotalResp();
        log.info("order list params: {}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = params.getBizId();
        BizTableContext.putBizId((Long)bizId);
        QueryOrderDto queryParams = (QueryOrderDto)BeanUtil.convert((Object)params, QueryOrderDto.class, (String[])new String[0]);
        if (queryParams.getStatus() != null) {
            queryParams.setYzStatus(YzOrderStatusEnum.getYzOrderStatus((Integer)queryParams.getStatus()));
            queryParams.setTaoBaoStatus(TaoBaoOrderStatusEnum.getTaoBaoOrderStatus((Integer)queryParams.getStatus()));
            queryParams.setDouStatus(DouOrderStatusEnum.getDouOrderStatus((Integer)queryParams.getStatus()));
        }
        this.queryByNameOrMobile(queryParams);
        int total = this.customerOrderMapper.queryOrderCount(queryParams);
        int customerTotal = this.customerOrderMapper.queryCustomerCount(queryParams);
        Long paidTotal = this.customerOrderMapper.queryOrderPaidAmount(queryParams);
        resp.setOrderTotal(Integer.valueOf(total));
        resp.setCustomerTotal(Integer.valueOf(customerTotal));
        resp.setPaidTotal(paidTotal);
        BizTableContext.clear();
        return resp;
    }

    public List<OrderListResp> pureQueryOrderList(QueryOrderListReq params) {
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOrderNos() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        QueryOrderDto queryParams = (QueryOrderDto)BeanUtil.convert((Object)params, QueryOrderDto.class, (String[])new String[0]);
        this.queryByNameOrMobile(queryParams);
        List customerOrders = this.customerOrderMapper.queryOrderList(queryParams);
        ArrayList respList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)customerOrders)) {
            return respList;
        }
        for (CustomerOrder customerOrder : customerOrders) {
            OrderListResp resp = new OrderListResp();
            resp.setOrderNo(customerOrder.getOrderNo());
            resp.setPromoterId(customerOrder.getPromoterId());
            resp.setCustomerNum(customerOrder.getCustomerNum());
            resp.setUserId(customerOrder.getUserId());
            resp.setSource(customerOrder.getSource());
            resp.setOrderTime(customerOrder.getOrderTime());
            resp.setOrderAmount(customerOrder.getOrderAmount());
            resp.setPaidAmount(customerOrder.getPaidAmount());
            resp.setShouldPayAmount(customerOrder.getShouldPayAmount());
            resp.setDiscountAmount(customerOrder.getDiscountAmount());
            resp.setRefundAmount(customerOrder.getRefundAmount());
            resp.setRemark(customerOrder.getRemark());
            respList.add(resp);
        }
        return respList;
    }

    public OrderTotalResp orderCountGroupByUser(QueryOrderListReq params) {
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getUserIds()), (Object)"user id \u4e0d\u80fd\u4e3a\u7a7a");
        QueryOrderDto queryParams = (QueryOrderDto)BeanUtil.convert((Object)params, QueryOrderDto.class, (String[])new String[0]);
        Long bizId = params.getBizId();
        BizTableContext.putBizId((Long)bizId);
        Map userOrderCounts = this.customerOrderMapper.queryOrderCountGroupByUserId(queryParams);
        OrderTotalResp resp = new OrderTotalResp();
        resp.setUserOrderCount(userOrderCounts);
        BizTableContext.clear();
        return resp;
    }

    public PageOrderListResp orderList(QueryOrderListReq params) {
        log.info("order list params: {}", (Object)params);
        StopWatch timer = new StopWatch("orderList");
        QueryOrderDto queryParams = (QueryOrderDto)BeanUtil.convert((Object)params, QueryOrderDto.class, (String[])new String[0]);
        this.queryByNameOrMobile(queryParams);
        PageDto pageDto = params.getPageDto();
        if (queryParams.getStatus() != null) {
            queryParams.setScrmStatus(PayOrderStatusEnum.getScrmStatus((Integer)queryParams.getStatus()));
            queryParams.setYzStatus(YzOrderStatusEnum.getYzOrderStatus((Integer)queryParams.getStatus()));
            queryParams.setTaoBaoStatus(TaoBaoOrderStatusEnum.getTaoBaoOrderStatus((Integer)queryParams.getStatus()));
            queryParams.setDouStatus(DouOrderStatusEnum.getDouOrderStatus((Integer)queryParams.getStatus()));
        }
        if (pageDto != null) {
            timer.start("queryOrderCount");
            int total = this.customerOrderMapper.queryOrderCount(queryParams);
            timer.stop();
            pageDto.setCount(Integer.valueOf(total));
        }
        timer.start("queryOrderList");
        List customerOrders = this.customerOrderMapper.queryOrderList(queryParams);
        timer.stop();
        List orderNoList = customerOrders.stream().map(it -> it.getOrderNo()).collect(Collectors.toList());
        Map<Object, Object> orderNoSkuMap = Maps.newHashMap();
        Map<Object, Object> orderNoPayRecordMap = Maps.newHashMap();
        Map<Object, Object> orderNoRefundOrderMap = Maps.newHashMap();
        Map<Object, Object> orderNoLogisticMap = Maps.newHashMap();
        HashMap orderNoPayTypeMap = Maps.newHashMap();
        Map<Object, Object> orderNoSkuNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orderNoList)) {
            timer.start("orderSkuListMapperSelectList");
            QueryWrapper queryWrapper = (QueryWrapper)Wrappers.query().in((Object)"order_no", orderNoList);
            List skuList = this.orderSkuListMapper.selectList((Wrapper)queryWrapper);
            timer.stop();
            orderNoSkuNameMap = skuList.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo, Collectors.mapping(OrderSkuList::getSkuName, Collectors.toList())));
            orderNoSkuMap = skuList.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo, Collectors.mapping(Function.identity(), Collectors.toList())));
            timer.start("customerOrderPayRecordMapperSelectList");
            QueryWrapper orderPayRecordQueryWrapper = (QueryWrapper)Wrappers.query().in((Object)"order_no", orderNoList);
            List payRecords = this.customerOrderPayRecordMapper.selectList((Wrapper)orderPayRecordQueryWrapper);
            timer.stop();
            Iterator iterator = payRecords.iterator();
            while (iterator.hasNext()) {
                CustomerOrderPayRecord payRecord = (CustomerOrderPayRecord)iterator.next();
                if (orderNoPayTypeMap.containsKey(payRecord.getOrderNo())) continue;
                orderNoPayTypeMap.put(payRecord.getOrderNo(), payRecord);
            }
            orderNoPayRecordMap = payRecords.stream().collect(Collectors.groupingBy(CustomerOrderPayRecord::getOrderNo, Collectors.mapping(Function.identity(), Collectors.toList())));
            timer.start("queryCustomerRefundOrderList");
            List refundOrderList = this.customerRefundOrderMapper.queryCustomerRefundOrderList(orderNoList, null);
            timer.stop();
            orderNoRefundOrderMap = refundOrderList.stream().collect(Collectors.groupingBy(CustomerRefundOrder::getOrderNo, Collectors.mapping(Function.identity(), Collectors.toList())));
            timer.start("orderLogisticMapperSelectList");
            List logisticList = this.orderLogisticMapper.selectList((Wrapper)Wrappers.query().in((Object)"order_no", orderNoList));
            timer.stop();
            orderNoLogisticMap = logisticList.stream().collect(Collectors.groupingBy(OrderLogistic::getOrderNo, Collectors.mapping(Function.identity(), Collectors.toList())));
        }
        Map bizIdCustomerNumsMap = customerOrders.stream().collect(Collectors.groupingBy(CustomerOrder::getBizId, Collectors.mapping(CustomerOrder::getCustomerNum, Collectors.toSet())));
        Map bizId2OrgIds = customerOrders.stream().filter(it -> it.getAchieveDepartId() != null).collect(Collectors.groupingBy(CustomerOrder::getBizId, Collectors.mapping(CustomerOrder::getAchieveDepartId, Collectors.toSet())));
        HashMap orgNameMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty(bizId2OrgIds)) {
            timer.start("getNameByIds");
            for (Map.Entry entry : bizId2OrgIds.entrySet()) {
                Map bizOrgNameMap = this.nodeService.getNameByIds(entry.getKey(), (Collection)entry.getValue());
                if (!MapUtils.isNotEmpty((Map)bizOrgNameMap)) continue;
                orgNameMap.putAll(bizOrgNameMap);
            }
            timer.stop();
        }
        timer.start("orderDictionaryMapperSelectOne");
        List orderDictionarys = this.orderDictionaryMapper.selectList((Wrapper)Wrappers.query().orderByDesc((Object)"create_time"));
        Map bizId2OrderDictionaryMap = orderDictionarys.stream().collect(Collectors.toMap(OrderDictionary::getBizId, Function.identity()));
        timer.stop();
        HashMap bizId2KeyNames = Maps.newHashMap();
        HashMap bizId2SourceMap = Maps.newHashMap();
        for (Map.Entry entry : bizId2OrderDictionaryMap.entrySet()) {
            long bizId = entry.getKey();
            OrderDictionary orderDictionary = (OrderDictionary)entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)orderDictionary.getExtendField())) {
                try {
                    List fieldDtos = JacksonUtil.str2List((String)orderDictionary.getExtendField(), DynamicFieldDto.class);
                    Map<String, String> map = fieldDtos.stream().filter(it -> it.getIsDeleted() == 0).collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
                    bizId2KeyNames.put(bizId, map);
                }
                catch (IOException e) {
                    log.error("error: ", (Throwable)e);
                }
            }
            HashMap sourceMap = Maps.newHashMap();
            sourceMap.put("scrm", "scrm");
            for (OrderSource orderSource : OrderSource.values()) {
                sourceMap.put(orderSource.getValue(), orderSource.getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)orderDictionary.getSources())) {
                try {
                    List list = JacksonUtil.str2List((String)orderDictionary.getSources(), DynamicFieldDto.class);
                    sourceMap.putAll(list.stream().collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName)));
                }
                catch (IOException iOException) {
                    log.error("error: ", (Throwable)iOException);
                }
            }
            bizId2SourceMap.put(bizId, sourceMap);
        }
        HashSet userIdSet = Sets.newHashSet();
        HashSet channelNums = Sets.newHashSet();
        HashMap bizId2PayGroupKeys = Maps.newHashMap();
        for (CustomerOrder customerOrder : customerOrders) {
            if (customerOrder.getUserId() != null) {
                userIdSet.add(customerOrder.getUserId());
            }
            userIdSet.add(customerOrder.getCreateBy());
            if (StringUtils.isNotBlank((CharSequence)customerOrder.getChannelNum())) {
                channelNums.add(customerOrder.getChannelNum());
            }
            if (StringUtils.isNotBlank((CharSequence)customerOrder.getPayGroupKey())) {
                Set payGroupKeys = (Set)bizId2PayGroupKeys.get(customerOrder.getBizId());
                if (payGroupKeys == null) {
                    payGroupKeys = Sets.newHashSet();
                }
                payGroupKeys.add(customerOrder.getPayGroupKey());
                bizId2PayGroupKeys.put(customerOrder.getBizId(), payGroupKeys);
            }
            if (!Objects.nonNull(customerOrder.getConsultantId())) continue;
            userIdSet.add(customerOrder.getConsultantId());
        }
        Map userNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)userIdSet)) {
            timer.start("getNameByIds");
            userNameMap = this.scrmUserService.getNameByIds((Collection)userIdSet);
            timer.stop();
        }
        Map channalNum2NameMap = null;
        if (CollectionUtils.isNotEmpty((Collection)channelNums)) {
            timer.start("getNameByNums");
            channalNum2NameMap = this.scrmChannelService.queryChannelNamesByNums((Collection)channelNums);
            timer.stop();
        }
        HashMap payGroupKey2NameMap = null;
        if (MapUtils.isNotEmpty((Map)bizId2PayGroupKeys)) {
            payGroupKey2NameMap = Maps.newHashMap();
            timer.start("scrmBizService.getById");
            Map map = this.scrmBizService.getCorpIdsByIds(bizId2PayGroupKeys.keySet());
            timer.stop();
            timer.start("queryConfigGroup");
            for (Map.Entry entry : bizId2PayGroupKeys.entrySet()) {
                Long bizId = (Long)entry.getKey();
                Set payGroupKeys = (Set)entry.getValue();
                String corpId = (String)map.get(bizId);
                PayConfigGroupQuery payConfigGroupQuery = new PayConfigGroupQuery();
                payConfigGroupQuery.setCorpId(corpId);
                payConfigGroupQuery.setGroupKeys((Collection)payGroupKeys);
                PayConfigGroupDtoResp payConfigGroupDtoResp = this.scrmPayConfigService.queryConfigGroup(payConfigGroupQuery);
                if (payConfigGroupDtoResp == null || !CollectionUtils.isNotEmpty((Collection)payConfigGroupDtoResp.getList())) continue;
                payGroupKey2NameMap.putAll(payConfigGroupDtoResp.getList().stream().collect(Collectors.toMap(PayConfigGroupDto::getGroupKey, PayConfigGroupDto::getGroupName)));
            }
            timer.stop();
        }
        timer.start("loop");
        ArrayList arrayList = Lists.newArrayList();
        for (CustomerOrder customerOrder : customerOrders) {
            List orderLogisticList;
            PlatformEnum platformEnum;
            OrderStatusEnum orderStatusEnum;
            OrderListResp order = new OrderListResp();
            arrayList.add(order);
            long bizId = customerOrder.getBizId();
            order.setBizId(Long.valueOf(bizId));
            order.setCorpId(customerOrder.getCorpId());
            order.setRealServicePeriod(customerOrder.getRealServicePeriod());
            order.setFreeServicePeriod(customerOrder.getFreeServicePeriod());
            order.setRealServicePeriodTime(customerOrder.getRealServicePeriodTime());
            order.setFreeServicePeriodTime(customerOrder.getFreeServicePeriodTime());
            if (Objects.nonNull(customerOrder.getSchoolId()) && customerOrder.getSchoolId() > 0L) {
                order.setNetSchoolId(customerOrder.getSchoolId());
            }
            order.setIsNetSchoolOrder(customerOrder.getIsNetSchoolOrder());
            order.setId(customerOrder.getNum());
            order.setOrderNo(customerOrder.getOrderNo());
            order.setOrderTime(customerOrder.getOrderTime());
            order.setSource(customerOrder.getSource());
            order.setSourceDesc((String)((Map)bizId2SourceMap.get(bizId)).get(customerOrder.getSource()));
            List orderSkuLists = (List)orderNoSkuMap.get(customerOrder.getOrderNo());
            if (CollectionUtils.isNotEmpty((Collection)orderSkuLists)) {
                ArrayList skuRespList = Lists.newArrayList();
                orderSkuLists.stream().forEach(orderSkuList -> {
                    OrderSkuResp orderSkuResp = new OrderSkuResp();
                    BeanUtils.copyProperties((Object)orderSkuList, (Object)orderSkuResp);
                    skuRespList.add(orderSkuResp);
                });
                order.setSkuList((List)skuRespList);
            }
            if (CollectionUtils.isEmpty((Collection)order.getSkuList()) && StringUtils.isNotBlank((CharSequence)customerOrder.getSkuName())) {
                OrderSkuResp orderSkuResp = new OrderSkuResp();
                orderSkuResp.setSkuName(customerOrder.getSkuName());
                orderSkuResp.setSkuNo(customerOrder.getSkuNo());
                orderSkuResp.setSkuImgUrl(customerOrder.getSkuImgUrl());
                order.setSkuList((List)Lists.newArrayList((Object[])new OrderSkuResp[]{orderSkuResp}));
            }
            order.setOrderAmount(Long.valueOf(customerOrder.getOrderAmount() == null ? 0L : customerOrder.getOrderAmount()));
            order.setDiscountAmount(Long.valueOf(customerOrder.getDiscountAmount() == null ? 0L : customerOrder.getDiscountAmount()));
            order.setPaidAmount(Long.valueOf(customerOrder.getPaidAmount() == null ? 0L : customerOrder.getPaidAmount()));
            order.setShouldPayAmount(Long.valueOf(customerOrder.getShouldPayAmount() == null ? 0L : customerOrder.getShouldPayAmount()));
            List customerOrderPayRecords = (List)orderNoPayRecordMap.get(customerOrder.getOrderNo());
            if (CollectionUtils.isNotEmpty((Collection)customerOrderPayRecords)) {
                ArrayList orderPayRecordResps = Lists.newArrayList();
                customerOrderPayRecords.stream().forEach(customerOrderPayRecord -> {
                    String paymentVoucherUrl;
                    OrderPayRecordResp orderPayRecordResp = new OrderPayRecordResp();
                    BeanUtils.copyProperties((Object)customerOrderPayRecord, (Object)orderPayRecordResp);
                    if (orderPayRecordResp.getChannelType() != null && cn.kinyun.customer.center.enums.PayChannelType.get((Integer)orderPayRecordResp.getChannelType()) != null) {
                        orderPayRecordResp.setTypeDesc(cn.kinyun.customer.center.enums.PayChannelType.get((Integer)orderPayRecordResp.getChannelType()).getDesc());
                    }
                    if (orderPayRecordResp.getPayStatus() != null && PayStatusEnum.get((int)orderPayRecordResp.getPayStatus()) != null) {
                        orderPayRecordResp.setPayStatusDesc(PayStatusEnum.get((int)orderPayRecordResp.getPayStatus()).getDesc());
                    }
                    if (StringUtils.isNotBlank((CharSequence)(paymentVoucherUrl = customerOrderPayRecord.getPaymentVoucherUrl()))) {
                        List<String> vocherList = Arrays.asList(paymentVoucherUrl.split(","));
                        orderPayRecordResp.setPaymentVoucherUrlList(vocherList);
                    }
                    orderPayRecordResps.add(orderPayRecordResp);
                });
                order.setPayRecordList((List)orderPayRecordResps);
                CustomerOrderPayRecord payRecord = (CustomerOrderPayRecord)customerOrderPayRecords.get(0);
                if (payRecord != null) {
                    Integer payType = payRecord.getChannelType();
                    order.setPaidChannelType(payType);
                    if (payType != null && cn.kinyun.customer.center.enums.PayChannelType.get((Integer)payType) != null) {
                        order.setPaidTypeDesc(cn.kinyun.customer.center.enums.PayChannelType.get((Integer)payType).getDesc());
                    }
                    order.setPayNo(payRecord.getPayNo());
                }
            }
            order.setStatus(customerOrder.getStatus());
            if (order.getStatus() != null && Objects.nonNull(orderStatusEnum = this.deWrapperByPlatform(platformEnum = (PlatformEnum)Optional.ofNullable(customerOrder.getPlatformType()).map(item -> PlatformEnum.get((int)item)).orElse(null), order.getStatus()))) {
                order.setStatusDesc(orderStatusEnum.getDesc());
                order.setStatus(Integer.valueOf(orderStatusEnum.getValue()));
            }
            order.setSkuNames((List)orderNoSkuNameMap.get(customerOrder.getOrderNo()));
            if (CollectionUtils.isEmpty((Collection)order.getSkuNames()) && StringUtils.isNotBlank((CharSequence)customerOrder.getSkuName())) {
                order.setSkuNames((List)Lists.newArrayList((Object[])new String[]{customerOrder.getSkuName()}));
            }
            if (CollectionUtils.isNotEmpty((Collection)(orderLogisticList = (List)orderNoLogisticMap.get(customerOrder.getOrderNo())))) {
                ArrayList logisticsRespList = Lists.newArrayList();
                orderLogisticList.stream().forEach(orderLogistic -> {
                    LogisticsResp logisticsResp = new LogisticsResp();
                    BeanUtils.copyProperties((Object)orderLogistic, (Object)logisticsResp);
                    logisticsRespList.add(logisticsResp);
                });
                order.setLogisticsList((List)logisticsRespList);
            }
            order.setDeliveryAddress(customerOrder.getDeliveryAddress());
            order.setReceiveName(customerOrder.getReceiveName());
            order.setReceiveTel(customerOrder.getReceiveTel());
            order.setCustomerMobile(customerOrder.getCustomerMobile());
            order.setCustomerName(customerOrder.getCustomerName());
            order.setUserId(customerOrder.getUserId());
            order.setUserName((String)userNameMap.get(customerOrder.getUserId()));
            order.setAchieveDepartId(customerOrder.getAchieveDepartId());
            order.setAchieveDepartDesc((String)orgNameMap.get(customerOrder.getAchieveDepartId()));
            order.setEntryUser((String)userNameMap.get(customerOrder.getCreateBy()));
            order.setEntryTime(customerOrder.getCreateTime());
            order.setRemark(customerOrder.getRemark());
            order.setIsEntry(customerOrder.getEntryMethod());
            order.setPromoterId(customerOrder.getPromoterId());
            List refundOrderList = (List)orderNoRefundOrderMap.get(customerOrder.getOrderNo());
            if (CollectionUtils.isNotEmpty((Collection)refundOrderList)) {
                ArrayList refundOrderListResps = Lists.newArrayList();
                for (CustomerRefundOrder refundOrder : refundOrderList) {
                    RefundOrderListResp refundOrderListResp = new RefundOrderListResp();
                    BeanUtils.copyProperties((Object)refundOrder, (Object)refundOrderListResp);
                    Integer status = refundOrder.getStatus();
                    refundOrderListResp.setRefundStatus(status);
                    if (status != null && RefundStatusEnum.get((int)status) != null) {
                        refundOrderListResp.setRefundStatusDesc(RefundStatusEnum.get((int)status).getDesc());
                    }
                    if (refundOrderListResp.getRefundType() != null && RefundTypeEnum.get((int)refundOrderListResp.getRefundType()) != null) {
                        refundOrderListResp.setRefundTypeDesc(RefundTypeEnum.get((int)refundOrderListResp.getRefundType()).getDesc());
                    } else {
                        refundOrderListResp.setRefundTypeDesc(refundOrder.getRefundWay());
                    }
                    refundOrderListResps.add(refundOrderListResp);
                }
                order.setRefundOrderList((List)refundOrderListResps);
            }
            order.setRefundAmount(Long.valueOf(customerOrder.getRefundAmount() == null ? 0L : customerOrder.getRefundAmount()));
            try {
                if (StringUtils.isNotBlank((CharSequence)customerOrder.getDynamicCol())) {
                    List extendFieldRespList = JacksonUtil.str2List((String)customerOrder.getDynamicCol(), ExtendFieldResp.class);
                    for (ExtendFieldResp extendField : extendFieldRespList) {
                        extendField.setName((String)((Map)bizId2KeyNames.get(bizId)).get(extendField.getKey()));
                    }
                    extendFieldRespList = extendFieldRespList.stream().filter(it -> it.getName() != null).collect(Collectors.toList());
                    order.setExtendFiled(extendFieldRespList);
                }
            }
            catch (IOException e) {
                log.error("json parse error: ", (Throwable)e);
            }
            order.setCanBeDecode(this.canBeDecode(order.getSource(), customerOrder.getCustomerNum()));
            order.setCreateBy(customerOrder.getCreateBy());
            if (Objects.nonNull(customerOrder.getStudentType())) {
                if (NumberUtils.INTEGER_ONE.equals(customerOrder.getStudentType())) {
                    order.setStudentTypeName("\u5408\u4f5c\u5355\u4f4d");
                } else if (NumberUtils.INTEGER_TWO.equals(customerOrder.getStudentType())) {
                    order.setStudentTypeName("\u793e\u4f1a\u751f");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)customerOrder.getChannelNum()) && MapUtils.isNotEmpty((Map)channalNum2NameMap)) {
                order.setChannelName((String)channalNum2NameMap.get(customerOrder.getChannelNum()));
            }
            if (MapUtils.isNotEmpty((Map)payGroupKey2NameMap)) {
                order.setPayGroupName((String)payGroupKey2NameMap.get(customerOrder.getPayGroupKey()));
            }
            order.setQqWechat(customerOrder.getQqWechat());
            order.setConsultantId(customerOrder.getConsultantId());
            if (Objects.nonNull(customerOrder.getConsultantId())) {
                order.setConsultantName((String)userNameMap.get(customerOrder.getConsultantId()));
            }
            order.setValidateDateBegin(customerOrder.getValidateDateBegin());
            order.setValidateDateEnd(customerOrder.getValidateDateEnd());
        }
        timer.stop();
        log.info(timer.prettyPrint());
        PageOrderListResp resp = new PageOrderListResp();
        resp.setList((List)arrayList);
        resp.setPageDto(pageDto);
        return resp;
    }

    private CustomerOrderInfoResp build(CustomerOrder customerOrder) {
        CustomerOrderInfoResp resp = new CustomerOrderInfoResp();
        resp.setId(customerOrder.getNum());
        resp.setCustomerNum(customerOrder.getCustomerNum());
        resp.setOrderTime(customerOrder.getOrderTime());
        resp.setOrderNo(customerOrder.getOrderNo());
        resp.setSkuNo(customerOrder.getSkuNo());
        resp.setSkuName(customerOrder.getSkuName());
        resp.setOrderAmount(customerOrder.getOrderAmount());
        resp.setPaidAmount(customerOrder.getPaidAmount());
        resp.setRefundAmount(customerOrder.getRefundAmount());
        resp.setRefundTime(customerOrder.getRefundTime());
        resp.setRefundStatus(customerOrder.getRefundStatus());
        resp.setUserId(customerOrder.getUserId());
        resp.setCreateBy(customerOrder.getCreateBy());
        resp.setCustomerName(customerOrder.getCustomerName());
        resp.setProductLineId(customerOrder.getProductLineId());
        return resp;
    }

    public PageCustomerOrderResp queryByCustomerNum(Long bizId, List<String> customerNums, PageDto pageDto) {
        log.info("query by customerNum bizId: {}, customerNums: {}, pageDto: {}", new Object[]{bizId, customerNums, pageDto});
        if (CollectionUtils.isEmpty(customerNums)) {
            log.warn("queryByCustomerNum customerNums is empty");
            return null;
        }
        List customerOrders = this.customerOrderMapper.selectByCustomerNums(bizId, customerNums, pageDto);
        if (pageDto != null) {
            int total = this.customerOrderMapper.selectByCustomerNumsCount(bizId, customerNums);
            pageDto.setCount(Integer.valueOf(total));
            pageDto.setCurPageCount(Integer.valueOf(customerOrders.size()));
        }
        ArrayList list = Lists.newArrayList();
        for (CustomerOrder customerOrder : customerOrders) {
            CustomerOrderInfoResp orderInfoResp = this.build(customerOrder);
            list.add(orderInfoResp);
        }
        PageCustomerOrderResp resp = new PageCustomerOrderResp();
        resp.setList((List)list);
        resp.setPageDto(pageDto);
        return resp;
    }

    public PageCustomerOrderResp queryCustomerOrderList(Long bizId, Long userId, String skuName, List<String> customerNums, Long orderTimeBegin, Long orderTimeEnd, PageDto pageDto) {
        log.info("query customer order list bizId: {}, userId: {}, skuName: {}, customerNums: {}, orderTimeBegin:{}, orderTimeEnd: {}, pageDto: {}", new Object[]{bizId, userId, skuName, customerNums, orderTimeBegin, orderTimeEnd, pageDto});
        List customerOrders = this.customerOrderMapper.selectCustomerOrderList(bizId, userId, skuName, customerNums, orderTimeBegin, orderTimeEnd, pageDto);
        if (pageDto != null) {
            int total = this.customerOrderMapper.selectCustomerOrderCount(bizId, userId, skuName, customerNums, orderTimeBegin, orderTimeEnd);
            pageDto.setCount(Integer.valueOf(total));
            pageDto.setCurPageCount(Integer.valueOf(customerOrders.size()));
        }
        ArrayList list = Lists.newArrayList();
        for (CustomerOrder customerOrder : customerOrders) {
            CustomerOrderInfoResp infoResp = this.build(customerOrder);
            list.add(infoResp);
        }
        PageCustomerOrderResp resp = new PageCustomerOrderResp();
        resp.setPageDto(pageDto);
        resp.setList((List)list);
        return resp;
    }

    public CustomerAndOrderResp countCustomerAndOrder(Long bizId, Long userId, List<String> customerNums, Long orderTimeBegin, Long orderTimeEnd) {
        log.info("count customer order bizId: {}, userId: {}, customerNums: {}, orderTimeBegin: {}, orderTimeEnd: {}", new Object[]{bizId, userId, customerNums, orderTimeBegin, orderTimeEnd});
        int orderCount = this.customerOrderMapper.selectOrderCount(bizId, userId, customerNums, orderTimeBegin, orderTimeEnd);
        List list = this.customerOrderMapper.selectOrderCustomerNums(bizId, userId, customerNums, orderTimeBegin, orderTimeEnd);
        CustomerAndOrderResp req = new CustomerAndOrderResp();
        req.setCustomerNums(list);
        req.setOrderCount(orderCount);
        return req;
    }

    public Map<Long, List<String>> countCustomers(Long bizId, Date startTime, Date endTime, Set<Long> userIds, Long amount) {
        log.info("count customers bizId: {}, startTime: {}, endTime: {}, userIds: {}, amount: {}", new Object[]{bizId, startTime, endTime, userIds, amount});
        Integer containNullUserId = YnEnum.NO.getValue();
        if (CollectionUtils.isNotEmpty(userIds) && userIds.contains(ADMIN_ID)) {
            containNullUserId = YnEnum.YES.getValue();
        }
        return this.customerOrderMapper.countCustomers(bizId, userIds, startTime, endTime, amount, containNullUserId);
    }

    public List<CustomerOrderAmountResq> sumAmountByCustomerNum(Long bizId, Collection<String> customerNums) {
        log.info("sum amount by customerNum bizId: {}, customerNums: {}", (Object)bizId, customerNums);
        List list = this.customerOrderMapper.sumAmountByCustomerNum(bizId, null, customerNums);
        ArrayList result = Lists.newArrayList();
        for (Map map : list) {
            CustomerOrderAmountResq resq = new CustomerOrderAmountResq();
            resq.setCustomerNum(map.get("customerNum").toString());
            resq.setOrderCount(Integer.valueOf(NumberUtils.toInt((String)(map.get("orderCount") == null ? "0" : map.get("orderCount").toString()))));
            resq.setPaidAmount(Long.valueOf(NumberUtils.toLong((String)(map.get("paidAmount") == null ? "0" : map.get("paidAmount").toString()))));
            resq.setRefundAmount(Long.valueOf(NumberUtils.toLong((String)(map.get("refundAmount") == null ? "0" : map.get("refundAmount").toString()))));
            result.add(resq);
        }
        return result;
    }

    public List<CustomerOrderAmountResq> sumAmountByUserAndCustomerNum(Long bizId, Long userId, Collection<String> customerNums) {
        log.info("sum amount by customerNum bizId: {}, userId:{}, customerNums: {}", new Object[]{bizId, userId, customerNums});
        List list = this.customerOrderMapper.sumAmountByCustomerNum(bizId, userId, customerNums);
        ArrayList result = Lists.newArrayList();
        for (Map map : list) {
            CustomerOrderAmountResq resq = new CustomerOrderAmountResq();
            resq.setCustomerNum(map.get("customerNum").toString());
            resq.setOrderCount(Integer.valueOf(NumberUtils.toInt((String)(map.get("orderCount") == null ? "0" : map.get("orderCount").toString()))));
            resq.setPaidAmount(Long.valueOf(NumberUtils.toLong((String)(map.get("paidAmount") == null ? "0" : map.get("paidAmount").toString()))));
            resq.setRefundAmount(Long.valueOf(NumberUtils.toLong((String)(map.get("refundAmount") == null ? "0" : map.get("refundAmount").toString()))));
            result.add(resq);
        }
        return result;
    }

    public List<CustomerOrderInfoResp> queryOrderListByUserAndCustomerNums(Long bizId, Long userId, Collection<String> customerNums) {
        log.info("count customers bizId: {}, userId: {}, customerNums: {}", new Object[]{bizId, userId, customerNums});
        List customerOrders = this.customerOrderMapper.queryListByUserIdCustomerNums(bizId, userId, customerNums);
        ArrayList list = Lists.newArrayList();
        for (CustomerOrder customerOrder : customerOrders) {
            CustomerOrderInfoResp infoResp = this.build(customerOrder);
            list.add(infoResp);
        }
        return list;
    }

    public Map<Long, Long> countPayAmount(Long bizId, Date startTime, Date endTime, Set<Long> userIds, Long amount) {
        log.info("countPayAmount bizId: {}, startTime: {}, endTime: {}, userIds: {}, amount: {}", new Object[]{bizId, startTime, endTime, userIds, amount});
        return this.customerOrderPayRecordMapper.countPayAmount(bizId, startTime, endTime, userIds, amount);
    }

    public Map<Long, Long> countPayAmountByOrderTime(PayAmountReq req) {
        log.info("countPayAmountByOrderTime req: {},", (Object)JSON.toJSONString((Object)req));
        if (Objects.isNull(req)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53c2\u6570\u4e3a\u7a7a");
        }
        req.validate();
        Integer containNullUserId = YnEnum.NO.getValue();
        if (CollectionUtils.isNotEmpty((Collection)req.getUserIds()) && req.getUserIds().contains(-1L)) {
            containNullUserId = YnEnum.YES.getValue();
        }
        Map result = this.customerOrderMapper.countPayAmountByOrderTime(req.getBizId(), req.getStartTime(), req.getEndTime(), req.getUserIds(), containNullUserId);
        log.info("countPayAmountByOrderTime result: {}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public Map<Long, Long> countRefundAmount(RefundReq req) {
        log.info("countRefundAmount request:{}", (Object)JSON.toJSONString((Object)req));
        if (Objects.isNull(req) || Objects.isNull(req.getBizId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "bizId \u4e3a\u7a7a");
        }
        if (Objects.isNull(req.getStartTime()) || Objects.isNull(req.getEndTime())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65f6\u95f4\u8303\u56f4\u4e3a\u7a7a");
        }
        return this.customerOrderPayRecordMapper.countDiscountAmount(req.getBizId(), req.getStartTime(), req.getEndTime(), req.getUserIds());
    }

    public String addOrderManuel(OrderReq params) {
        log.info("\u624b\u52a8\u65b0\u589e\u8ba2\u5355\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)params));
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerMobile())) {
            String customerNum = this.customerNumService.getCustomerNumByMobile(params.getBizId(), params.getCustomerMobile());
            params.setCustomerNum(customerNum);
        }
        this.addOrder(params);
        if (StringUtils.isNotBlank((CharSequence)params.getCustomerName()) && StringUtils.isNotBlank((CharSequence)params.getCustomerNum())) {
            ModMobileReq modMobileReq = new ModMobileReq();
            modMobileReq.setCustomerNum(params.getCustomerNum());
            modMobileReq.setBizId(params.getBizId());
            modMobileReq.setName(params.getCustomerName());
            this.customerDetailService.updateCustomerDetail(modMobileReq, params.getCorpId());
        }
        HashSet updateSaleStateUser = Sets.newHashSet();
        if (Objects.nonNull(params.getBeforeOrderUser())) {
            updateSaleStateUser.add(params.getBeforeOrderUser());
        }
        if (Objects.nonNull(params.getAfterOrderUser())) {
            updateSaleStateUser.add(params.getAfterOrderUser());
        }
        if (CollectionUtils.isNotEmpty((Collection)updateSaleStateUser)) {
            this.sendSaleStateMessage(params.getBizId(), params.getCorpId(), updateSaleStateUser);
        }
        return params.getCustomerOrderNum();
    }

    public List<String> butchAdd(List<OrderReq> orderReq) {
        if (CollectionUtils.isEmpty(orderReq)) {
            return Lists.newArrayList();
        }
        orderReq.forEach(a -> {
            Preconditions.checkArgument((boolean)Objects.nonNull(a), (Object)"item is null");
            a.validate();
            a.validateCustomerNumAndMobile();
        });
        ArrayList result = Lists.newArrayList();
        for (OrderReq param : orderReq) {
            result.add(this.addOrderManuel(param));
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delOrder(OrderReq params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getOrderNo() != null ? 1 : 0) != 0, (Object)"orderNo is null");
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"order_no", (Object)params.getOrderNo())).eq((Object)"is_deleted", (Object)0));
        if (Objects.isNull(record)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u901a\u8fc7\u8ba2\u5355\u53f7\uff1a" + params.getOrderNo() + "\u6ca1\u6709\u627e\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        if (!Objects.equals(record.getEntryMethod(), OrderEntryMethodEnum.MANUAL.getValue())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5220\u9664\u7684\u8ba2\u5355\u4e0d\u662f\u624b\u52a8\u5f55\u5165\u4e0d\u80fd\u5220\u9664");
        }
        CustomerOrder customerOrder = new CustomerOrder();
        this.customerOrderMapper.logicDelById(record.getId());
        this.customerOrderPayRecordMapper.logicDelByOrderNo(record.getOrderNo());
        if (Objects.nonNull(record.getUserId())) {
            this.sendSaleStateMessage(record.getBizId(), record.getCorpId(), Sets.newHashSet((Object[])new Long[]{record.getUserId()}));
        }
        this.tuitionReportMapper.deleteByOrderNoAndBusinessDataType(record.getBizId(), record.getOrderNo(), TuitionReportTypeEnum.PAYMENT.getDesc());
        if (StringUtils.isBlank((CharSequence)record.getYyRevenueContractReq())) {
            log.info("record.getYyRevenueContractReq is blank");
            return;
        }
        try {
            RevenueContractReq revenueContractReq = (RevenueContractReq)JacksonUtil.str2Obj((String)record.getYyRevenueContractReq(), RevenueContractReq.class);
            revenueContractReq.getData().setCode(record.getOrderNo() + "-S");
            BigDecimal orimnyNotax = new BigDecimal((float)(-(customerOrder.getOrderAmount() - record.getDiscountAmount())) / 10000.0f).setScale(2, RoundingMode.HALF_UP);
            revenueContractReq.getData().setOrimnyNotax(orimnyNotax);
            this.yongYouService.revenueContractSave(revenueContractReq);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Boolean checkOrderExist(String orderNo) {
        log.info("add customer order, biId={};orderNo:{}", (Object)orderNo);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (Object)"orderNo is null");
        CustomerOrder record = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"order_no", (Object)orderNo)).eq((Object)"is_deleted", (Object)0));
        return Objects.nonNull(record) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void batchUpdate(Long bizId, List<String> orderNos, Long allocUserId, Long allocDeptId) {
        if (bizId == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(orderNos)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (allocUserId == null && allocDeptId == null) {
            log.info("allocUserId and allocDeptId is null");
            return;
        }
        this.customerOrderMapper.batchUpdateAllocUserDept(bizId, orderNos, allocUserId, allocDeptId);
    }

    public void updateOrderCustomerNum(Long bizId, String orderNo, String customerNum) {
        if (bizId == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8ba2\u5355id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5ba2\u6237num\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.customerOrderMapper.updateCustomerNumByOrderNo(bizId, orderNo, customerNum);
    }

    public List<String> queryCustomerNumsByOrder(OrderQueryReq req) {
        Long bizId = req.getBizId();
        Collection orderUserIds = req.getOrderUserIds() == null ? Lists.newArrayList() : req.getOrderUserIds();
        Collection skuNos = req.getSkuNos() == null ? Lists.newArrayList() : req.getSkuNos();
        Collection orderNos = req.getOrderNos() == null ? Lists.newArrayList() : req.getOrderNos();
        log.info("queryCustomerNumsByOrder: bizId:{}, userIds:{}, skuNos:{}, orderNos:{}", new Object[]{bizId, orderUserIds, skuNos, orderNos});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u5546\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)orderUserIds) && CollectionUtils.isEmpty((Collection)skuNos) && CollectionUtils.isEmpty((Collection)orderNos)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty((Collection)skuNos)) {
            List orderNosByProduct = this.orderSkuListMapper.queryOrderNoBySkuNo(bizId, skuNos);
            if (CollectionUtils.isEmpty((Collection)orderNosByProduct)) {
                return Lists.newArrayList();
            }
            if (CollectionUtils.isNotEmpty((Collection)orderNos)) {
                if (CollectionUtils.isEmpty(orderNos = CollectionUtils.intersection((Iterable)orderNos, (Iterable)orderNosByProduct))) {
                    return Lists.newArrayList();
                }
            } else {
                orderNos.addAll(orderNosByProduct);
            }
        }
        log.info("queryCustomerNumsByOrder: bizId:{}, userIds:{}, orderNos:{}", new Object[]{bizId, orderUserIds, orderNos});
        if (CollectionUtils.isEmpty(orderNos) && CollectionUtils.isEmpty((Collection)orderUserIds)) {
            return Lists.newArrayList();
        }
        QueryOrderDto queryOrderDto = new QueryOrderDto();
        queryOrderDto.setBizId(bizId);
        queryOrderDto.setOrderNos(orderNos);
        if (CollectionUtils.isNotEmpty((Collection)orderUserIds)) {
            queryOrderDto.setUserIds((List)Lists.newArrayList((Iterable)orderUserIds));
        }
        ArrayList statusList = Lists.newArrayList();
        statusList.add(OrderStatusEnum.HAD_PAY.getValue());
        statusList.add(OrderStatusEnum.WAIT_DELIVERY.getValue());
        statusList.add(OrderStatusEnum.SUCCESSED.getValue());
        queryOrderDto.setStatusList((Collection)statusList);
        List yzList = YzOrderStatusEnum.getPaidStatus();
        queryOrderDto.setYzStatus(yzList);
        List taobaoList = TaoBaoOrderStatusEnum.getPaidStatus();
        queryOrderDto.setTaoBaoStatus(taobaoList);
        List doudianList = DouOrderStatusEnum.getPaidStatus();
        queryOrderDto.setDouStatus(doudianList);
        List customerNums = this.customerOrderMapper.queryCustomerNumsByOrder(queryOrderDto);
        log.info("queryCustomerNumsByOrder: bizId:{}, userIds:{}, orderNos:{}, customerNums:{}", new Object[]{bizId, orderUserIds, orderNos, customerNums});
        return customerNums;
    }

    public OrderListResp customerOrdDetail(String num) {
        PlatformEnum platformEnum;
        OrderStatusEnum orderStatusEnum;
        List logisticList;
        List refundOrderList;
        List fieldDtos;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u5ba2\u6237\u4e2d\u5fc3\u8ba2\u5355num \u4e0d\u80fd\u4e3a\u7a7a");
        CustomerOrder customerOrder = (CustomerOrder)this.customerOrderMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"num", (Object)num)).eq((Object)"is_deleted", (Object)0));
        if (Objects.isNull(customerOrder)) {
            log.warn("\u672a\u67e5\u5230\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606fnum:{}", (Object)num);
            return null;
        }
        List payRecords = this.customerOrderPayRecordMapper.selectList((Wrapper)Wrappers.query().eq((Object)"order_no", (Object)customerOrder.getOrderNo()));
        HashSet customerNums = Sets.newHashSet((Object[])new String[]{customerOrder.getCustomerNum()});
        BizTableContext.putBizId((Long)customerOrder.getBizId());
        List<String> userMobileByNum = this.customerService.getUserMobileByNum(customerOrder.getBizId(), customerOrder.getCustomerNum());
        String multiMobile = String.join((CharSequence)",", userMobileByNum);
        Map customerNumMobileMap = this.customerMapper.selectMobileByNums(customerOrder.getBizId(), (Collection)customerNums);
        List customerList = this.customerMapper.selectMobileByMainNums(customerOrder.getBizId(), (Collection)customerNums);
        for (Customer customer : customerList) {
            customerNumMobileMap.put(customer.getMainNum(), customer.getId1());
        }
        Map customerNameMap = this.customerDetailMapper.queryCustomerNameMap(customerOrder.getBizId(), (Collection)customerNums);
        Long achieveDepartId = customerOrder.getAchieveDepartId();
        HashMap orgNameMap = Maps.newHashMap();
        if (Objects.nonNull(achieveDepartId)) {
            orgNameMap.putAll(this.nodeService.getNameByIds(customerOrder.getBizId(), (Collection)Sets.newHashSet((Object[])new Long[]{achieveDepartId})));
        }
        OrderDictionary orderDictionary = (OrderDictionary)this.orderDictionaryMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)customerOrder.getBizId())).orderByDesc((Object)"create_time"));
        Map<Object, Object> keyNames = Maps.newHashMap();
        Map<Object, Object> sourceMap = Maps.newHashMap();
        if (orderDictionary != null && StringUtils.isNotBlank((CharSequence)orderDictionary.getExtendField())) {
            try {
                fieldDtos = JacksonUtil.str2List((String)orderDictionary.getExtendField(), DynamicFieldDto.class);
                keyNames = fieldDtos.stream().collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
            }
            catch (IOException e) {
                log.error("error: ", (Throwable)e);
            }
        }
        if (orderDictionary != null && StringUtils.isNotBlank((CharSequence)orderDictionary.getSources())) {
            try {
                fieldDtos = JacksonUtil.str2List((String)orderDictionary.getSources(), DynamicFieldDto.class);
                sourceMap = fieldDtos.stream().collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
            }
            catch (IOException e) {
                log.error("error: ", (Throwable)e);
            }
        }
        Map userNameMap = Maps.newHashMap();
        HashSet userIds = Sets.newHashSet();
        if (Objects.nonNull(customerOrder.getUserId())) {
            userIds.add(customerOrder.getUserId());
        }
        if (Objects.nonNull(customerOrder.getConsultantId())) {
            userIds.add(customerOrder.getConsultantId());
        }
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            userNameMap = this.scrmUserService.getNameByIds((Collection)Sets.newHashSet((Object[])new Long[]{customerOrder.getUserId()}));
        }
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)customerOrder.getBizId())).in((Object)"order_no", (Collection)Sets.newHashSet((Object[])new String[]{customerOrder.getOrderNo()}));
        List skuList = this.orderSkuListMapper.selectList((Wrapper)queryWrapper);
        OrderListResp order = new OrderListResp();
        order.setBizId(customerOrder.getBizId());
        order.setCorpId(customerOrder.getCorpId());
        if (CollectionUtils.isNotEmpty((Collection)skuList)) {
            ArrayList skuRespList = Lists.newArrayList();
            skuList.stream().forEach(orderSkuList -> {
                OrderSkuResp orderSkuResp = new OrderSkuResp();
                BeanUtils.copyProperties((Object)orderSkuList, (Object)orderSkuResp);
                skuRespList.add(orderSkuResp);
            });
            order.setSkuList((List)skuRespList);
        }
        if (CollectionUtils.isNotEmpty((Collection)payRecords)) {
            ArrayList orderPayRecordResps = Lists.newArrayList();
            payRecords.stream().forEach(customerOrderPayRecord -> {
                String paymentVoucherUrl;
                OrderPayRecordResp orderPayRecordResp = new OrderPayRecordResp();
                BeanUtils.copyProperties((Object)customerOrderPayRecord, (Object)orderPayRecordResp);
                if (orderPayRecordResp.getChannelType() != null && cn.kinyun.customer.center.enums.PayChannelType.get((Integer)orderPayRecordResp.getChannelType()) != null) {
                    orderPayRecordResp.setTypeDesc(cn.kinyun.customer.center.enums.PayChannelType.get((Integer)orderPayRecordResp.getChannelType()).getDesc());
                } else {
                    orderPayRecordResp.setChannelType(null);
                }
                if (orderPayRecordResp.getPayStatus() != null && PayStatusEnum.get((int)orderPayRecordResp.getPayStatus()) != null) {
                    orderPayRecordResp.setPayStatusDesc(PayStatusEnum.get((int)orderPayRecordResp.getPayStatus()).getDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)(paymentVoucherUrl = customerOrderPayRecord.getPaymentVoucherUrl()))) {
                    List<String> vocherList = Arrays.asList(paymentVoucherUrl.split(","));
                    orderPayRecordResp.setPaymentVoucherUrlList(vocherList);
                }
                orderPayRecordResps.add(orderPayRecordResp);
            });
            order.setPayRecordList((List)orderPayRecordResps);
        }
        if (CollectionUtils.isNotEmpty((Collection)(refundOrderList = this.customerRefundOrderMapper.getByOrderNo(customerOrder.getBizId(), customerOrder.getOrderNo())))) {
            ArrayList refundOrderListResps = Lists.newArrayList();
            for (CustomerRefundOrder refundOrder : refundOrderList) {
                RefundOrderListResp refundOrderListResp = new RefundOrderListResp();
                BeanUtils.copyProperties((Object)refundOrder, (Object)refundOrderListResp);
                Integer status = refundOrder.getStatus();
                refundOrderListResp.setRefundStatus(status);
                if (status != null && RefundStatusEnum.get((int)status) != null) {
                    refundOrderListResp.setRefundStatusDesc(RefundStatusEnum.get((int)status).getDesc());
                }
                if (refundOrderListResp.getRefundType() != null && RefundTypeEnum.get((int)refundOrderListResp.getRefundType()) != null) {
                    refundOrderListResp.setRefundTypeDesc(RefundTypeEnum.get((int)refundOrderListResp.getRefundType()).getDesc());
                }
                refundOrderListResps.add(refundOrderListResp);
            }
            order.setRefundOrderList((List)refundOrderListResps);
        }
        if (CollectionUtils.isNotEmpty((Collection)(logisticList = this.orderLogisticMapper.selectList((Wrapper)Wrappers.query().eq((Object)"order_no", (Object)customerOrder.getOrderNo()))))) {
            ArrayList logisticsRespList = Lists.newArrayList();
            logisticList.stream().forEach(orderLogistic -> {
                LogisticsResp logisticsResp = new LogisticsResp();
                BeanUtils.copyProperties((Object)orderLogistic, (Object)logisticsResp);
                logisticsRespList.add(logisticsResp);
            });
            order.setLogisticsList((List)logisticsRespList);
        }
        order.setId(customerOrder.getNum());
        order.setOrderNo(customerOrder.getOrderNo());
        order.setOrderTime(customerOrder.getOrderTime());
        order.setSource(customerOrder.getSource());
        order.setSourceDesc((String)sourceMap.get(customerOrder.getSource()));
        if (CollectionUtils.isEmpty((Collection)order.getSkuNames())) {
            order.setSkuNames((List)Lists.newArrayList((Object[])new String[]{customerOrder.getSkuName()}));
        }
        order.setOrderAmount(Long.valueOf(customerOrder.getOrderAmount() == null ? 0L : customerOrder.getOrderAmount()));
        order.setDiscountAmount(Long.valueOf(customerOrder.getDiscountAmount() == null ? 0L : customerOrder.getDiscountAmount()));
        order.setPaidAmount(Long.valueOf(customerOrder.getPaidAmount() == null ? 0L : customerOrder.getPaidAmount()));
        order.setDeliveryAddress(customerOrder.getDeliveryAddress());
        order.setReceiveName(customerOrder.getReceiveName());
        order.setReceiveTel(customerOrder.getReceiveTel());
        order.setPromoterId(customerOrder.getPromoterId());
        order.setStatus(customerOrder.getStatus());
        order.setOrderStatus(order.getStatus());
        if (order.getStatus() != null && Objects.nonNull(orderStatusEnum = this.deWrapperByPlatform(platformEnum = (PlatformEnum)Optional.ofNullable(customerOrder.getPlatformType()).map(item -> PlatformEnum.get((int)item)).orElse(null), order.getStatus()))) {
            order.setStatusDesc(orderStatusEnum.getDesc());
        }
        order.setCustomerMobile(multiMobile);
        order.setCustomerName((String)customerNameMap.get(customerOrder.getCustomerNum()));
        order.setUserName((String)userNameMap.get(customerOrder.getUserId()));
        if (StringUtils.isNotBlank((CharSequence)order.getUserName())) {
            order.setUserId(customerOrder.getUserId());
        }
        order.setAchieveDepartId(customerOrder.getAchieveDepartId());
        order.setAchieveDepartDesc((String)orgNameMap.get(customerOrder.getAchieveDepartId()));
        order.setEntryUser((String)userNameMap.get(customerOrder.getCreateBy()));
        order.setEntryTime(customerOrder.getCreateTime());
        order.setRemark(customerOrder.getRemark());
        order.setIsEntry(customerOrder.getEntryMethod());
        order.setShouldPayAmount(customerOrder.getShouldPayAmount());
        order.setRealServicePeriod(customerOrder.getRealServicePeriod());
        order.setRealServicePeriodTime(customerOrder.getRealServicePeriodTime());
        order.setFreeServicePeriod(customerOrder.getFreeServicePeriod());
        order.setFreeServicePeriodTime(customerOrder.getFreeServicePeriodTime());
        order.setQqWechat(customerOrder.getQqWechat());
        order.setValidateDateBegin(customerOrder.getValidateDateBegin());
        order.setValidateDateEnd(customerOrder.getValidateDateEnd());
        order.setConsultantId(customerOrder.getConsultantId());
        if (Objects.nonNull(customerOrder.getConsultantId())) {
            order.setConsultantName((String)userNameMap.get(customerOrder.getConsultantId()));
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)customerOrder.getDynamicCol())) {
                List extendFieldRespList = JacksonUtil.str2List((String)customerOrder.getDynamicCol(), ExtendFieldResp.class);
                for (ExtendFieldResp extendField : extendFieldRespList) {
                    extendField.setName((String)keyNames.get(extendField.getKey()));
                }
                order.setExtendFiled(extendFieldRespList);
            }
        }
        catch (IOException e) {
            log.error("json parse error: ", (Throwable)e);
        }
        BizTableContext.clear();
        return order;
    }

    public List<OrderStatisticsResp> queryByCustomerNums(Long bizId, Collection<String> customerNums) {
        if (CollectionUtils.isEmpty(customerNums) || Objects.isNull(bizId)) {
            log.error("\u67e5\u8be2customer_num \u5bf9\u5e94\u7684\u8ba2\u5355\u6570\u636e \u53c2\u6570\u5f02\u5e38:biz{}; mobiles:{}", (Object)bizId, customerNums);
            return null;
        }
        List statisticResps = this.customerOrderMapper.queryOrderInfoByCustomerNum(bizId, customerNums);
        List customerLatestOrderInfo = this.customerOrderMapper.queryLatestOrderInfo(bizId, customerNums);
        return this.buildOrderStatisticsResp(statisticResps, customerLatestOrderInfo, customerNums);
    }

    private List<OrderStatisticsResp> buildOrderStatisticsResp(List<OrderStatisticResp> statisticResps, List<OrderStatisticResp> customerLatestOrderInfo, Collection<String> customerNums) {
        Map<String, List<OrderStatisticResp>> orderStatistics = statisticResps.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCustomerNum())).collect(Collectors.groupingBy(OrderStatisticResp::getCustomerNum));
        Map<String, List<OrderStatisticResp>> customerLatestOrderStatistics = customerLatestOrderInfo.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCustomerNum())).collect(Collectors.groupingBy(OrderStatisticResp::getCustomerNum));
        ArrayList<OrderStatisticsResp> responses = new ArrayList<OrderStatisticsResp>();
        HashMap customerNumsOrderTotal = Maps.newHashMap();
        HashMap customerNumsPaidAmount = Maps.newHashMap();
        HashMap customerNumsRefundAmount = Maps.newHashMap();
        HashMap customerNumsLatestOrderTime = Maps.newHashMap();
        HashMap customerNumsLatestOrderNo = Maps.newHashMap();
        for (String customerNum : customerNums) {
            List<OrderStatisticResp> orderStatisticResps = orderStatistics.get(customerNum);
            if (CollectionUtils.isEmpty(orderStatisticResps)) continue;
            Integer countOrDefault = customerNumsOrderTotal.getOrDefault(customerNum, 0);
            int orderTotal = orderStatisticResps.stream().filter(item -> Objects.nonNull(item.getOrderTotal())).mapToInt(item -> item.getOrderTotal()).sum();
            customerNumsOrderTotal.put(customerNum, countOrDefault + orderTotal);
            Long paidAmountOrDefault = customerNumsPaidAmount.getOrDefault(customerNum, 0L);
            long paidAmount = orderStatisticResps.stream().filter(item -> Objects.nonNull(item.getTotalPaidAmount())).mapToLong(item -> item.getTotalPaidAmount()).sum();
            customerNumsPaidAmount.put(customerNum, paidAmount + paidAmountOrDefault);
            Long refundAmountOrDefault = customerNumsRefundAmount.getOrDefault(customerNum, 0L);
            long refundAmount = orderStatisticResps.stream().filter(item -> Objects.nonNull(item.getTotalRefundAmount())).mapToLong(item -> item.getTotalRefundAmount()).sum();
            customerNumsRefundAmount.put(customerNum, refundAmount + refundAmountOrDefault);
            List<OrderStatisticResp> latestOrderInfo = customerLatestOrderStatistics.get(customerNum);
            if (CollectionUtils.isEmpty(latestOrderInfo)) continue;
            Date latestOrderTime = customerNumsLatestOrderTime.getOrDefault(customerNum, null);
            OrderStatisticResp latestRespInfo = latestOrderInfo.stream().max(Comparator.comparing(OrderStatisticResp::getLastOrderTime)).orElse(null);
            if (Objects.nonNull(latestRespInfo)) {
                if (Objects.nonNull(latestOrderTime) && latestRespInfo.getLastOrderTime().before(latestOrderTime)) continue;
                customerNumsLatestOrderTime.put(customerNum, latestRespInfo.getLastOrderTime());
                customerNumsLatestOrderNo.put(customerNum, latestRespInfo.getLastOrderNo());
            }
            OrderStatisticsResp resp = new OrderStatisticsResp();
            resp.setCustomerNum(customerNum);
            resp.setOrderCount(customerNumsOrderTotal.getOrDefault(customerNum, 0));
            resp.setTotalRefundAmount(customerNumsRefundAmount.getOrDefault(customerNum, 0L));
            resp.setTotalPaidAmount(customerNumsPaidAmount.getOrDefault(customerNum, 0L));
            resp.setLastOrderNo((String)customerNumsLatestOrderNo.get(customerNum));
            resp.setLastOrderTime((Date)customerNumsLatestOrderTime.get(customerNum));
            responses.add(resp);
        }
        log.info("\u83b7\u53d6\u624b\u673a\u53f7\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString(responses));
        return responses;
    }

    public List<OrderStatisticsResp> queryByMobile(Long bizId, Collection<String> mobiles) {
        if (CollectionUtils.isEmpty(mobiles) || Objects.isNull(bizId)) {
            log.error("\u67e5\u8be2\u624b\u673a\u53f7\u5bf9\u5e94\u7684\u8ba2\u5355\u6570\u636e \u53c2\u6570\u5f02\u5e38:biz{}; mobiles:{}", (Object)bizId, mobiles);
            return null;
        }
        Map mobileByCustomerNums = this.customerMapper.batchGetCustomerNumByMobile(bizId, mobiles);
        Set allCustomerNums = mobileByCustomerNums.values().stream().flatMap(item -> item.stream()).collect(Collectors.toSet());
        List statisticResps = this.customerOrderMapper.queryOrderInfoByCustomerNum(bizId, allCustomerNums);
        List customerLatestOrderInfo = this.customerOrderMapper.queryLatestOrderInfo(bizId, allCustomerNums);
        Map<String, List<OrderStatisticResp>> orderStatistics = statisticResps.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCustomerNum())).collect(Collectors.groupingBy(OrderStatisticResp::getCustomerNum));
        Map<String, List<OrderStatisticResp>> customerLatestOrderStatistics = customerLatestOrderInfo.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCustomerNum())).collect(Collectors.groupingBy(OrderStatisticResp::getCustomerNum));
        Set hasCustomerMobiles = mobileByCustomerNums.keySet();
        ArrayList<OrderStatisticsResp> responses = new ArrayList<OrderStatisticsResp>();
        HashMap mobileOrderTotal = Maps.newHashMap();
        HashMap mobilePaidAmount = Maps.newHashMap();
        HashMap mobileRefundAmount = Maps.newHashMap();
        HashMap mobileLatestOrderTime = Maps.newHashMap();
        HashMap mobileLatestOrderNo = Maps.newHashMap();
        for (String hasCustomerMobile : hasCustomerMobiles) {
            List customerNums = (List)mobileByCustomerNums.get(hasCustomerMobile);
            for (String customerNum : customerNums) {
                List<OrderStatisticResp> orderStatisticResps = orderStatistics.get(customerNum);
                if (CollectionUtils.isEmpty(orderStatisticResps)) continue;
                Integer countOrDefault = mobileOrderTotal.getOrDefault(hasCustomerMobile, 0);
                int orderTotal = orderStatisticResps.stream().filter(item -> Objects.nonNull(item.getOrderTotal())).mapToInt(item -> item.getOrderTotal()).sum();
                mobileOrderTotal.put(hasCustomerMobile, countOrDefault + orderTotal);
                Long paidAmountOrDefault = mobilePaidAmount.getOrDefault(hasCustomerMobile, 0L);
                long paidAmount = orderStatisticResps.stream().filter(item -> Objects.nonNull(item.getTotalPaidAmount())).mapToLong(item -> item.getTotalPaidAmount()).sum();
                mobilePaidAmount.put(hasCustomerMobile, paidAmount + paidAmountOrDefault);
                Long refundAmountOrDefault = mobileRefundAmount.getOrDefault(hasCustomerMobile, 0L);
                long refundAmount = orderStatisticResps.stream().filter(item -> Objects.nonNull(item.getTotalRefundAmount())).mapToLong(item -> item.getTotalRefundAmount()).sum();
                mobileRefundAmount.put(hasCustomerMobile, refundAmount + refundAmountOrDefault);
                List<OrderStatisticResp> latestOrderInfo = customerLatestOrderStatistics.get(customerNum);
                if (CollectionUtils.isEmpty(latestOrderInfo)) continue;
                Date latestOrderTime = mobileLatestOrderTime.getOrDefault(hasCustomerMobile, null);
                OrderStatisticResp latestRespInfo = latestOrderInfo.stream().max(Comparator.comparing(OrderStatisticResp::getLastOrderTime)).orElse(null);
                if (!Objects.nonNull(latestRespInfo) || Objects.nonNull(latestOrderTime) && latestRespInfo.getLastOrderTime().before(latestOrderTime)) continue;
                mobileLatestOrderTime.put(hasCustomerMobile, latestRespInfo.getLastOrderTime());
                mobileLatestOrderNo.put(hasCustomerMobile, latestRespInfo.getLastOrderNo());
            }
            OrderStatisticsResp resp = new OrderStatisticsResp();
            resp.setMobile(hasCustomerMobile);
            resp.setOrderCount(mobileOrderTotal.getOrDefault(hasCustomerMobile, 0));
            resp.setTotalRefundAmount(mobileRefundAmount.getOrDefault(hasCustomerMobile, 0L));
            resp.setTotalPaidAmount(mobilePaidAmount.getOrDefault(hasCustomerMobile, 0L));
            resp.setLastOrderNo((String)mobileLatestOrderNo.get(hasCustomerMobile));
            resp.setLastOrderTime((Date)mobileLatestOrderTime.get(hasCustomerMobile));
            responses.add(resp);
        }
        log.info("\u83b7\u53d6\u624b\u673a\u53f7\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString(responses));
        return responses;
    }

    public List<String> queryAllOrderCustomers(OrderReq orderReq) {
        if (Objects.isNull(orderReq) || Objects.isNull(orderReq.getBizId())) {
            log.error("\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38:{}", (Object)JSON.toJSONString((Object)orderReq));
            return Lists.newArrayList();
        }
        if (Objects.isNull(orderReq.getOrderTimeStart()) && Objects.isNull(orderReq.getOrderTimeEnd()) && Objects.isNull(orderReq.getOrderSource())) {
            log.error("\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38 \u5fc5\u4f20\u53c2\u6570\u672a\u6307\u5b9a:{}", (Object)JSON.toJSONString((Object)orderReq));
            return Lists.newArrayList();
        }
        QueryOrderDto queryOrderDto = new QueryOrderDto();
        queryOrderDto.setBizId(orderReq.getBizId());
        queryOrderDto.setOrderTimeStart(orderReq.getOrderTimeStart());
        queryOrderDto.setOrderTimeEnd(orderReq.getOrderTimeEnd());
        queryOrderDto.setSource(orderReq.getOrderSource());
        queryOrderDto.setCustomerNums((Collection)orderReq.getCustomerNums());
        List customersNums = null;
        try {
            customersNums = this.customerOrderMapper.queryAllOrderCustomers(queryOrderDto);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38:{}", (Object)JSON.toJSONString((Object)orderReq));
            customersNums = Lists.newArrayList();
        }
        return customersNums;
    }

    public CustomerOrderSimpleInfoResp queryCustomerFirstOrderSimpleInfoByCustomerNums(Long bizId, String customerNum) {
        log.info("queryCustomerFirstOrderSimpleInfoByCustomerNums,bizId:{},customerNum:{}", (Object)bizId, (Object)customerNum);
        if (bizId == null || bizId <= 0L) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "bizId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "customerNum\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
        if (CollectionUtils.isEmpty(customerNums)) {
            log.info("queryCustomerFirstOrderSimpleInfoByCustomerNums\u6839\u636ebizId:{},customerNum:{}\u672a\u67e5\u8be2\u5230customerNums", (Object)bizId, (Object)customerNum);
            return null;
        }
        CustomerOrder customerOrder = this.customerOrderMapper.queryFirstOrderByCustomerNums(bizId, customerNums);
        if (customerOrder == null) {
            log.info("\u6839\u636ebizId:{},customerNums:{}\u672a\u67e5\u8be2\u5230\u8ba2\u5355", (Object)bizId, customerNums);
            return null;
        }
        List orderSkuLists = this.orderSkuListMapper.selectByBizIdAndOrderNo(bizId, customerOrder.getOrderNo());
        CustomerOrderSimpleInfoResp resp = new CustomerOrderSimpleInfoResp();
        resp.setOrderNo(customerOrder.getOrderNo());
        resp.setOrderAmount(customerOrder.getPaidAmount());
        resp.setOrderTime(customerOrder.getOrderTime());
        ArrayList skuNos = Lists.newArrayList();
        ArrayList skuNames = Lists.newArrayList();
        for (OrderSkuList orderSkuList : orderSkuLists) {
            skuNos.add(orderSkuList.getSkuNo());
            skuNames.add(orderSkuList.getSkuName());
        }
        resp.setSkuNos((List)skuNos);
        resp.setSkuName(String.join((CharSequence)",", skuNames));
        return resp;
    }

    public List<CustomerOrderInfoResp> queryOrderByTime(Long bizId, Collection<String> customerNums, Collection<PayStatusEnum> payStatusEnums, Date orderTimeBegin, Date orderTimeEnd) {
        log.info("queryOrderByTime,bizId:{},customerNums:{},payStatusEnums:{},orderTimeBegin:{},orderTimeEnd:{}", new Object[]{bizId, customerNums, payStatusEnums, orderTimeBegin, orderTimeEnd});
        if (bizId == null || CollectionUtils.isEmpty(customerNums) || orderTimeBegin == null && orderTimeEnd == null) {
            return Collections.emptyList();
        }
        QueryOrderDto params = new QueryOrderDto();
        params.setBizId(bizId);
        params.setCustomerNums(customerNums);
        if (CollectionUtils.isNotEmpty(payStatusEnums)) {
            params.setPayStatus((Collection)payStatusEnums.stream().map(PayStatusEnum::getValue).collect(Collectors.toSet()));
        }
        params.setOrderTimeStart(orderTimeBegin);
        params.setOrderTimeEnd(orderTimeEnd);
        List customerOrders = this.customerOrderMapper.selectOrderByTime(params);
        if (CollectionUtils.isEmpty((Collection)customerOrders)) {
            return Collections.emptyList();
        }
        ArrayList<CustomerOrderInfoResp> list = new ArrayList<CustomerOrderInfoResp>();
        for (CustomerOrder customerOrder : customerOrders) {
            Long paidAmount = customerOrder.getPaidAmount();
            String customerNum = customerOrder.getCustomerNum();
            Long userId = customerOrder.getUserId();
            CustomerOrderInfoResp dto = new CustomerOrderInfoResp();
            dto.setPaidAmount(paidAmount);
            dto.setCustomerNum(customerNum);
            dto.setUserId(userId);
            list.add(dto);
        }
        return list;
    }

    public CustomerOrderSimpleInfoResp queryOrderSimpleInfoByOrderNo(Long bizId, String orderNo) {
        log.info("queryOrderSimpleInfoByOrderNo,bizId:{},orderNo:{}", (Object)bizId, (Object)orderNo);
        if (bizId == null || StringUtils.isBlank((CharSequence)orderNo)) {
            return null;
        }
        CustomerOrder customerOrder = this.customerOrderMapper.selectByBizIdAndOrderNo(bizId, orderNo);
        if (customerOrder == null) {
            log.info("\u6839\u636ebizId:{},orderNo:{}\u672a\u67e5\u8be2\u5230\u8ba2\u5355", (Object)bizId, (Object)orderNo);
            return null;
        }
        List orderSkuLists = this.orderSkuListMapper.selectByBizIdAndOrderNo(bizId, customerOrder.getOrderNo());
        String skuName = orderSkuLists.stream().map(OrderSkuList::getSkuName).collect(Collectors.joining(","));
        HashSet customerNums = Sets.newHashSet((Object[])new String[]{customerOrder.getCustomerNum()});
        List<String> userMobileByNum = this.customerService.getUserMobileByNum(bizId, customerOrder.getCustomerNum());
        String multiMobile = String.join((CharSequence)",", userMobileByNum);
        Map customerNameMap = this.customerDetailMapper.queryCustomerNameMap(bizId, (Collection)customerNums);
        CustomerOrderSimpleInfoResp simpleInfoResp = new CustomerOrderSimpleInfoResp();
        simpleInfoResp.setCustomerOrderId(customerOrder.getId());
        simpleInfoResp.setOrderNo(customerOrder.getOrderNo());
        simpleInfoResp.setOrderAmount(customerOrder.getOrderAmount());
        simpleInfoResp.setPaidAmount(customerOrder.getPaidAmount());
        simpleInfoResp.setDiscountAmount(customerOrder.getDiscountAmount());
        simpleInfoResp.setSkuName(skuName);
        simpleInfoResp.setCustomerNum(customerOrder.getCustomerNum());
        simpleInfoResp.setCustomerName((String)customerNameMap.get(customerOrder.getCustomerNum()));
        simpleInfoResp.setCustomerPhone(multiMobile);
        simpleInfoResp.setOrderStatus(customerOrder.getStatus());
        return simpleInfoResp;
    }

    public void updateOrderContractSignStatus(String orderNo, Integer signStatus) {
        log.info("updateOrderContractSignStatus,orderNo:{},signStatus:{}", (Object)orderNo, (Object)signStatus);
        if (StringUtils.isBlank((CharSequence)orderNo) || signStatus == null) {
            log.info("\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
            return;
        }
        this.customerOrderMapper.updateOrderContractSignStatus(orderNo, signStatus);
    }

    public List<CustomerOrderSkuList> searchOrderSkuList(Long bizId, String skuName) {
        if (bizId == null || bizId <= 0L) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "bizId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderSkuListList = this.orderSkuListMapper.querySkuListBySkuName(bizId, skuName);
        if (CollectionUtils.isEmpty((Collection)orderSkuListList)) {
            return Lists.newArrayList();
        }
        ArrayList resps = Lists.newArrayList();
        orderSkuListList.forEach(item -> {
            CustomerOrderSkuList resp = new CustomerOrderSkuList();
            resp.setSkuNo(item.getSkuNo());
            resp.setSkuName(item.getSkuName());
            resps.add(resp);
        });
        return resps;
    }

    public Long getOrderRemainPayAmount(Long bizId, String orderNo) {
        CustomerOrder customerOrder = this.customerOrderMapper.selectByBizIdAndOrderNo(bizId, orderNo);
        if (Objects.isNull(customerOrder) || customerOrder.getIsDeleted() == 1) {
            return NumberUtils.LONG_ZERO;
        }
        Long orderAmount = customerOrder.getOrderAmount() != null ? customerOrder.getOrderAmount() : NumberUtils.LONG_ZERO;
        Long paidAmount = customerOrder.getPaidAmount() != null ? customerOrder.getPaidAmount() : NumberUtils.LONG_ZERO;
        return Math.max(orderAmount - paidAmount, NumberUtils.LONG_ZERO);
    }

    public Long getOrderBizIdByOrderNo(String orderNo) {
        return this.customerOrderMapper.queryBizIdByOrderNo(orderNo);
    }

    public void addSaveOrderPeriods(OrderPeriodsReq req) {
        log.info("addSaveOrderPeriods req:{}", (Object)req);
        BizTableContext.putBizId((Long)req.getBizId());
        OrderPeriods orderPeriods = this.convert2OrderPeriods(req);
        this.orderPeriodsMapper.insert((Object)orderPeriods);
    }

    public TuitionReportRespDto tuitionReportList(TuitionReportReq req) {
        log.info("tuitionReportList,req:{}", (Object)req);
        int pageNum = req.getPageDto() != null ? req.getPageDto().getPageNum() : 1;
        req.validate();
        req.getPageDto().setPageNum(Integer.valueOf(pageNum));
        TuitionReportQuery query = this.convert2TuitionReportQuery(req);
        List tuitionReports = this.tuitionReportMapper.selectListByQuery(query);
        if (CollectionUtils.isEmpty((Collection)tuitionReports)) {
            return null;
        }
        int count = this.tuitionReportMapper.selectCountByQuery(query);
        req.getPageDto().setCount(Integer.valueOf(count));
        HashSet orderNos = Sets.newHashSet();
        HashSet payRecordNums = Sets.newHashSet();
        HashSet refundRecordNums = Sets.newHashSet();
        for (TuitionReport tuitionReport : tuitionReports) {
            orderNos.add(tuitionReport.getOrderNo());
            if (TuitionReportTypeEnum.PAYMENT.getDesc().equals(tuitionReport.getBusinessDataType())) {
                payRecordNums.add(tuitionReport.getBusinessDataNum());
                continue;
            }
            refundRecordNums.add(tuitionReport.getBusinessDataNum());
        }
        List customerOrders = this.customerOrderMapper.selectByOrderNos((Collection)orderNos);
        List payRecords = CollectionUtils.isEmpty((Collection)payRecordNums) ? Collections.emptyList() : this.customerOrderPayRecordMapper.selectByNums((Collection)payRecordNums);
        List refundRecords = CollectionUtils.isEmpty((Collection)refundRecordNums) ? Collections.emptyList() : this.customerRefundOrderMapper.selectByNums((Collection)refundRecordNums);
        List orderLogistics = this.orderLogisticMapper.queryOrderNo2TrackingNosMap((Collection)orderNos);
        Map<String, List<String>> orderNo2TrackingNosMap = orderLogistics.stream().collect(Collectors.groupingBy(OrderLogistic::getOrderNo, Collectors.mapping(OrderLogistic::getTrackingNo, Collectors.toList())));
        Map<String, List<String>> orderNo2LogisticsCompanyMap = orderLogistics.stream().collect(Collectors.groupingBy(OrderLogistic::getOrderNo, Collectors.mapping(OrderLogistic::getCompanyName, Collectors.toList())));
        List orderPeriods = this.orderPeriodsMapper.selectByOrderNos((Collection)orderNos);
        TuitionReportRespDto resp = this.buildTuitionReportRespDto(tuitionReports, customerOrders, payRecords, refundRecords, orderNo2TrackingNosMap, orderNo2LogisticsCompanyMap, orderPeriods);
        resp.setPageDto(req.getPageDto());
        return resp;
    }

    private TuitionReportRespDto buildTuitionReportRespDto(List<TuitionReport> tuitionReports, List<CustomerOrder> customerOrders, List<CustomerOrderPayRecord> payRecords, List<CustomerRefundOrder> refundRecords, Map<String, List<String>> orderNo2TrackingNosMap, Map<String, List<String>> orderNo2LogisticsCompanyMap, List<OrderPeriods> orderPeriodsList) {
        Map<String, CustomerOrder> orderNo2OrderMap = customerOrders.stream().collect(Collectors.toMap(CustomerOrder::getOrderNo, item -> item));
        Map<String, CustomerOrderPayRecord> payRecordNums2PayRecordMap = payRecords.stream().filter(Objects::nonNull).filter(record -> record.getNum() != null).collect(Collectors.toMap(CustomerOrderPayRecord::getNum, item -> item));
        Map<String, CustomerRefundOrder> refundRecordNums2RefundRecordMap = refundRecords.stream().filter(Objects::nonNull).filter(item -> item.getNum() != null).collect(Collectors.toMap(CustomerRefundOrder::getNum, item -> item, (existing, replacement) -> existing));
        Map<String, OrderPeriods> orderNo2OrderPeriodsMap = orderPeriodsList.stream().filter(Objects::nonNull).filter(item -> item.getOrderNo() != null).collect(Collectors.toMap(OrderPeriods::getOrderNo, item -> item));
        HashSet userIds = Sets.newHashSet();
        HashSet deptIds = Sets.newHashSet();
        for (CustomerOrder customerOrder : customerOrders) {
            if (Objects.nonNull(customerOrder.getUserId()) && customerOrder.getUserId() > 0L) {
                userIds.add(customerOrder.getUserId());
            }
            if (Objects.nonNull(customerOrder.getConsultantId()) && customerOrder.getConsultantId() > 0L) {
                userIds.add(customerOrder.getConsultantId());
            }
            if (!Objects.nonNull(customerOrder.getAchieveDepartId())) continue;
            deptIds.add(customerOrder.getAchieveDepartId());
        }
        Map userId2NameMap = this.scrmUserService.getNameByIds((Collection)userIds);
        TuitionReportRespDto resp = new TuitionReportRespDto();
        ArrayList tuitionReportDtos = Lists.newArrayList();
        for (TuitionReport tuitionReport : tuitionReports) {
            List trackingNos;
            List companyNames;
            TuitionReportDto tuitionReportDto = new TuitionReportDto();
            tuitionReportDtos.add(tuitionReportDto);
            tuitionReportDto.setOrderNo(tuitionReport.getOrderNo());
            tuitionReportDto.setId(tuitionReport.getId());
            tuitionReportDto.setYear(tuitionReport.getYear());
            tuitionReportDto.setMonth(tuitionReport.getMonth());
            tuitionReportDto.setPayOrRefundTime(tuitionReport.getPayOrRefundTime());
            tuitionReportDto.setBusinessDataType(tuitionReport.getBusinessDataType());
            tuitionReportDto.setSchoolId(tuitionReport.getSchoolId());
            tuitionReportDto.setSkuNo(tuitionReport.getSkuNo());
            CustomerOrder customerOrder = orderNo2OrderMap.get(tuitionReport.getOrderNo());
            if (Objects.nonNull(customerOrder.getCustomerCode())) {
                tuitionReportDto.setCustomerCode(String.valueOf(customerOrder.getCustomerCode()));
            }
            if (Objects.isNull(tuitionReport.getSchoolId())) {
                tuitionReportDto.setSchoolId(customerOrder.getSchoolId());
            }
            tuitionReportDto.setCustomerName(customerOrder.getCustomerName());
            tuitionReportDto.setCustomerMobile(customerOrder.getCustomerMobile());
            tuitionReportDto.setQqWechat(customerOrder.getQqWechat());
            tuitionReportDto.setServiceBeginTime(customerOrder.getOrderTime());
            int totalPeriods = 0;
            if (Objects.nonNull(customerOrder.getRealServicePeriod())) {
                totalPeriods += customerOrder.getRealServicePeriod().intValue();
                tuitionReportDto.setServiceEndTime(DateUtils.addMonths((Date)customerOrder.getOrderTime(), (int)customerOrder.getRealServicePeriod()));
            }
            if (Objects.nonNull(customerOrder.getFreeServicePeriod())) {
                totalPeriods += customerOrder.getFreeServicePeriod().intValue();
            }
            tuitionReportDto.setGiftServiceEndTime(DateUtils.addMonths((Date)customerOrder.getOrderTime(), (int)totalPeriods));
            tuitionReportDto.setValidateDateBegin(customerOrder.getValidateDateBegin());
            tuitionReportDto.setValidateDateEnd(customerOrder.getValidateDateEnd());
            if (Objects.nonNull(customerOrder.getValidateDateBegin()) && Objects.nonNull(customerOrder.getValidateDateEnd())) {
                String validateDateStr = YYYY_MM_DD_FORMAT.format(customerOrder.getValidateDateBegin()) + "\u81f3" + YYYY_MM_DD_FORMAT.format(customerOrder.getValidateDateEnd());
                tuitionReportDto.setValidateDateStr(validateDateStr);
            }
            tuitionReportDto.setSignContractStatus("\u672a\u7b7e");
            OrderPeriods orderPeriods = orderNo2OrderPeriodsMap.get(tuitionReport.getOrderNo());
            if (Objects.nonNull(orderPeriods)) {
                tuitionReportDto.setConfirmPeriodsCount(orderPeriods.getConfirmPeriodsCount());
                tuitionReportDto.setDispatchPeriodsCount(orderPeriods.getDispatchPeriodsCount());
                tuitionReportDto.setRefundPeriodsCount(orderPeriods.getRefundPeriodsCount());
                tuitionReportDto.setSurplusPeriodsCount(orderPeriods.getSurplusPeriodsCount());
            }
            if (NumberUtils.INTEGER_ONE.equals(customerOrder.getIsContainPhysical())) {
                tuitionReportDto.setIsContainPhysical(NumberUtils.INTEGER_ONE);
                tuitionReportDto.setIsContainPhysicalDesc("\u662f");
            } else {
                tuitionReportDto.setIsContainPhysical(NumberUtils.INTEGER_ZERO);
                tuitionReportDto.setIsContainPhysicalDesc("\u5426");
            }
            if (MapUtils.isNotEmpty(orderNo2LogisticsCompanyMap) && orderNo2LogisticsCompanyMap.containsKey(tuitionReport.getOrderNo()) && CollectionUtils.isNotEmpty(companyNames = orderNo2LogisticsCompanyMap.get(tuitionReport.getOrderNo()).stream().filter(company -> StringUtils.isNotBlank((CharSequence)company)).collect(Collectors.toList()))) {
                tuitionReportDto.setLogisticsCompany(Strings.join(companyNames, (String)","));
            }
            if (MapUtils.isNotEmpty(orderNo2TrackingNosMap) && orderNo2TrackingNosMap.containsKey(tuitionReport.getOrderNo()) && CollectionUtils.isNotEmpty(trackingNos = orderNo2TrackingNosMap.get(tuitionReport.getOrderNo()).stream().filter(trackingNo -> StringUtils.isNotBlank((CharSequence)trackingNo)).collect(Collectors.toList()))) {
                tuitionReportDto.setTrackingNo(Strings.join(trackingNos, (String)","));
            }
            if (TuitionReportTypeEnum.PAYMENT.getDesc().equals(tuitionReport.getBusinessDataType())) {
                CustomerOrderPayRecord payRecord = payRecordNums2PayRecordMap.get(tuitionReport.getBusinessDataNum());
                if (Objects.nonNull(PayChannelType.get((Integer)payRecord.getChannelType()))) {
                    tuitionReportDto.setChannelTypeName(PayChannelType.get((Integer)payRecord.getChannelType()).getDesc());
                } else {
                    tuitionReportDto.setChannelTypeName("");
                }
                tuitionReportDto.setTradeNo(payRecord.getPayNo());
                tuitionReportDto.setRealAmount(new BigDecimal(payRecord.getPayAmount()).divide(new BigDecimal(10000), 2, 4).toString());
                tuitionReportDto.setChannelType(payRecord.getChannelType());
                PlatformEnum platformEnum = Optional.ofNullable(customerOrder.getPlatformType()).map(item -> PlatformEnum.get((int)item)).orElse(null);
                OrderStatusEnum orderStatusEnum = this.deWrapperByPlatform(platformEnum, customerOrder.getStatus());
                if (Objects.nonNull(orderStatusEnum)) {
                    tuitionReportDto.setStatusDesc(orderStatusEnum.getDesc());
                }
            } else {
                CustomerRefundOrder refundRecord = refundRecordNums2RefundRecordMap.get(tuitionReport.getBusinessDataNum());
                if (Objects.nonNull(refundRecord.getRefundType())) {
                    tuitionReportDto.setChannelTypeName(RefundTypeEnum.get((int)refundRecord.getRefundType()).getDesc());
                }
                tuitionReportDto.setTradeNo(refundRecord.getRefundSerialNo());
                tuitionReportDto.setRealAmount(new BigDecimal(refundRecord.getRefundAmount()).divide(new BigDecimal(10000), 2, 4).toString());
                tuitionReportDto.setRefundReason(refundRecord.getReason());
                tuitionReportDto.setRefundWay(refundRecord.getRefundWay());
                tuitionReportDto.setStatusDesc("\u5df2\u6210\u529f");
                tuitionReportDto.setRefundSerialNo(refundRecord.getRefundSerialNo());
            }
            tuitionReportDto.setOrderAmount(new BigDecimal(customerOrder.getOrderAmount()).divide(new BigDecimal(10000), 2, 4).toString());
            tuitionReportDto.setDiscountAmount(new BigDecimal(customerOrder.getDiscountAmount() == null ? 0L : customerOrder.getDiscountAmount()).divide(new BigDecimal(10000), 2, 4).toString());
            if (MapUtils.isNotEmpty((Map)userId2NameMap)) {
                if (Objects.nonNull(customerOrder.getUserId())) {
                    tuitionReportDto.setUserName((String)userId2NameMap.get(customerOrder.getUserId()));
                }
                if (Objects.nonNull(customerOrder.getConsultantId())) {
                    tuitionReportDto.setConsultantName((String)userId2NameMap.get(customerOrder.getConsultantId()));
                }
            }
            tuitionReportDto.setOrderRemark(customerOrder.getRemark());
            tuitionReportDto.setAchieveDepartId(customerOrder.getAchieveDepartId());
            tuitionReportDto.setIsDeleted(tuitionReport.getIsDeleted());
            if (NumberUtils.INTEGER_ONE.equals(tuitionReport.getIsDeleted())) {
                tuitionReportDto.setIsDeletedDesc("\u662f");
            } else {
                tuitionReportDto.setIsDeletedDesc("\u5426");
            }
            tuitionReportDto.setPayGroupKey(customerOrder.getPayGroupKey());
        }
        resp.setTuitionReportDtos((List)tuitionReportDtos);
        return resp;
    }

    private TuitionReportQuery convert2TuitionReportQuery(TuitionReportReq req) {
        TuitionReportQuery query = new TuitionReportQuery();
        query.setBizId(req.getBizId());
        query.setIsMainBizId(req.getIsMainBizId());
        query.setExcludeBizIds(req.getExcludeBizIds());
        query.setBeginTime(req.getBeginTime());
        query.setEndTime(req.getEndTime());
        query.setSchoolId(req.getSchoolId());
        query.setSkuNos(req.getSkuNos());
        query.setPageDto(req.getPageDto());
        return query;
    }

    private OrderPeriods convert2OrderPeriods(OrderPeriodsReq req) {
        OrderPeriods orderPeriods = new OrderPeriods();
        orderPeriods.setOrderNo(req.getOrderNo());
        orderPeriods.setPeriodsCount(req.getPeriodsCount());
        orderPeriods.setConfirmPeriodsCount(req.getConfirmPeriodsCount());
        orderPeriods.setDispatchPeriodsCount(req.getDispatchPeriodsCount());
        orderPeriods.setRefundPeriodsCount(req.getRefundPeriodsCount());
        orderPeriods.setSurplusPeriodsCount(req.getSurplusPeriodsCount());
        orderPeriods.setCreateTime(req.getCreateTime());
        return orderPeriods;
    }

    public void sendSaleStateMessage(Long bizId, String corpId, Set<Long> userId) {
        SaleStateEvent saleStateEvent = new SaleStateEvent();
        saleStateEvent.setEventUpStream("scrm-backend");
        saleStateEvent.setBiId(bizId);
        saleStateEvent.setCorpId(corpId);
        saleStateEvent.setNeedReCountUserId(userId);
        String saleStateEventStr = JSON.toJSONString((Object)saleStateEvent);
        log.info("kafka topic:{} produce msg:{}", (Object)this.recalculateStateTopic, (Object)saleStateEventStr);
        CompletableFuture.runAsync(() -> this.kafkaTemplate.send(this.recalculateStateTopic, (Object)saleStateEventStr));
    }

    private OrderStatusEnum deWrapperByPlatform(PlatformEnum platformEnum, Integer orderStatus) {
        if (Objects.isNull(orderStatus)) {
            return null;
        }
        if (Objects.isNull(platformEnum)) {
            return OrderStatusEnum.get((int)orderStatus);
        }
        if (PlatformEnum.YOU_ZAN.equals((Object)platformEnum)) {
            YzOrderStatusEnum yzOrderStatusEnum = YzOrderStatusEnum.get((int)orderStatus);
            if (Objects.isNull(yzOrderStatusEnum)) {
                log.info("\u8ba2\u5355\u72b6\u6001\u672a\u627e\u5230\u9002\u914d\u7684\u901a\u7528\u72b6\u6001\uff1aplatform\uff1a{}; orderStatus:{}", (Object)orderStatus);
                return null;
            }
            Integer commponOrderStatus = yzOrderStatusEnum.getOrderStatus();
            if (Objects.isNull(commponOrderStatus)) {
                return null;
            }
            return OrderStatusEnum.get((int)commponOrderStatus);
        }
        if (PlatformEnum.TAO_BAO.equals((Object)platformEnum)) {
            TaoBaoOrderStatusEnum yzOrderStatusEnum = TaoBaoOrderStatusEnum.get((int)orderStatus);
            if (Objects.isNull(yzOrderStatusEnum)) {
                log.info("\u8ba2\u5355\u72b6\u6001\u672a\u627e\u5230\u9002\u914d\u7684\u901a\u7528\u72b6\u6001\uff1aplatform\uff1a{}; orderStatus:{}", (Object)orderStatus);
                return null;
            }
            Integer commponOrderStatus = yzOrderStatusEnum.getOrderStatus();
            if (Objects.isNull(commponOrderStatus)) {
                return null;
            }
            return OrderStatusEnum.get((int)commponOrderStatus);
        }
        if (PlatformEnum.DOU_DIAN.equals((Object)platformEnum)) {
            DouOrderStatusEnum yzOrderStatusEnum = DouOrderStatusEnum.get((int)orderStatus);
            if (Objects.isNull(yzOrderStatusEnum)) {
                log.info("\u8ba2\u5355\u72b6\u6001\u672a\u627e\u5230\u9002\u914d\u7684\u901a\u7528\u72b6\u6001\uff1aplatform\uff1a{}; orderStatus:{}", (Object)orderStatus);
                return null;
            }
            Integer commponOrderStatus = yzOrderStatusEnum.getOrderStatus();
            if (Objects.isNull(commponOrderStatus)) {
                return null;
            }
            return OrderStatusEnum.get((int)commponOrderStatus);
        }
        if (PlatformEnum.SCRM.equals((Object)platformEnum)) {
            PayOrderStatusEnum statusEnum = PayOrderStatusEnum.get((int)orderStatus);
            if (Objects.isNull(statusEnum)) {
                log.info("\u8ba2\u5355\u72b6\u6001\u672a\u627e\u5230\u9002\u914d\u7684\u901a\u7528\u72b6\u6001\uff1aplatform\uff1a{}; orderStatus:{}", (Object)orderStatus);
                return null;
            }
            Integer commponOrderStatus = statusEnum.getOrderStatus();
            if (Objects.isNull(commponOrderStatus)) {
                return null;
            }
            return OrderStatusEnum.get((int)commponOrderStatus);
        }
        OrderStatusEnum result = OrderStatusEnum.get((int)orderStatus);
        if (result == null) {
            log.info("\u672a\u627e\u5230 \u8ba2\u5355\u72b6\u6001\u9002\u914d");
        }
        return result;
    }

    private Boolean canBeDecode(String source, String customerNum) {
        if (StringUtils.isNotBlank((CharSequence)customerNum) || StringUtils.isBlank((CharSequence)source)) {
            return Boolean.FALSE;
        }
        OrderSource sourceType = OrderSource.getType((String)source);
        if (Objects.isNull(sourceType)) {
            return Boolean.FALSE;
        }
        return sourceType.getCanBeDecode();
    }

    private Boolean isDecode(Integer entryMethod) {
        if (Objects.isNull(entryMethod)) {
            return false;
        }
        if (OrderEntryMethodEnum.DECODE.getValue() == entryMethod) {
            return true;
        }
        return false;
    }

    @Transactional
    public void setOrderPayTimeoutStatus(List<String> orderNos, List<String> payNos) {
        log.info("set order paystatus orderNos: {}, payNos: {}", orderNos, payNos);
        if (CollectionUtils.isNotEmpty(payNos)) {
            CustomerOrderPayRecord payRecord = new CustomerOrderPayRecord();
            payRecord.setPayStatus(Integer.valueOf(PayStatusEnum.TIMEOUT.getValue()));
            QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().in((Object)"pay_no", payNos);
            this.customerOrderPayRecordMapper.update((Object)payRecord, (Wrapper)queryWrapper);
        }
    }
}

