/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.dal.entity.OrderLogistic;
import cn.kinyun.customer.center.dal.mapper.OrderLogisticMapper;
import cn.kinyun.customer.center.dto.req.order.LogisticsReq;
import cn.kinyun.customer.center.service.CcLogisticService;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CcLogisticServiceImpl
implements CcLogisticService {
    private static final Logger log = LoggerFactory.getLogger(CcLogisticServiceImpl.class);
    @Resource
    OrderLogisticMapper orderLogisticMapper;

    public void addLogistic(List<LogisticsReq> req) {
        log.info("add logistic param:{}", (Object)JSON.toJSONString(req));
        if (CollectionUtils.isEmpty(req)) {
            return;
        }
        List orderLogistics = req.stream().filter(item -> {
            try {
                item.checkParam();
            }
            catch (Exception e) {
                log.error("\u7269\u6d41\u4fe1\u606f \u53c2\u6570\u6821\u9a8c\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)item), (Object)e);
                return false;
            }
            return true;
        }).map(this::buildOrderLogistic).collect(Collectors.toList());
        List orderNos = orderLogistics.stream().map(item -> item.getOrderNo()).collect(Collectors.toList());
        List logisticList = this.orderLogisticMapper.selectList((Wrapper)Wrappers.query().in((Object)"order_no", orderNos));
        if (!CollectionUtils.isEmpty((Collection)logisticList)) {
            List collect = logisticList.stream().map(item -> item.getId()).collect(Collectors.toList());
            this.orderLogisticMapper.deleteBatchIds(collect);
        }
        log.info("\u521b\u5efa\u7269\u6d41\u4fe1\u606f\uff1a:{}", (Object)JSON.toJSONString(orderLogistics));
        for (OrderLogistic logistic : orderLogistics) {
            this.orderLogisticMapper.insertOrUpdate(logistic);
        }
    }

    public OrderLogistic buildOrderLogistic(LogisticsReq req) {
        return OrderLogistic.builder().orderNo(req.getOrderNo()).company(req.getCompany()).createBy(Long.valueOf(-1L)).updateBy(Long.valueOf(-1L)).companyName(req.getCompanyName()).createTime(new Date()).updateTime(new Date()).deliveryId(req.getDeliveryId()).skipTime(req.getSkipTime()).trackingNo(req.getTrackingNo()).build();
    }
}

