/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.crm.common.enums.LeadsViewStatus;
import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.common.service.RedisDistributedLock;
import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.entity.Customer;
import cn.kinyun.customer.center.dal.entity.CustomerDetail;
import cn.kinyun.customer.center.dal.mapper.CustomerDetailMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dal.util.BizTableContext;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.CustomerIdType;
import cn.kinyun.customer.center.enums.electricity.PlatformEnum;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.utils.AESUtil;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmChannelService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.service.dto.resp.ChannelDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;

@Service
public class CcCustomerDetailServiceImpl
extends ServiceImpl<CustomerDetailMapper, CustomerDetail>
implements CcCustomerDetailService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerDetailServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerNumService customerNumService;
    @Autowired
    private CustomerDetailMapper customerDetailMapper;
    @Autowired
    private ScrmChannelService scrmChannelService;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private RedisDistributedLock distributedLock;
    @Value(value="${scrm.electricity.yz.aesKey}")
    private String aesKey;

    public void add(CustomerDetailReq req) {
        log.info("customerDetail req:{}, bizId: {}, customerNum: {}", new Object[]{req, req.getBizId(), req.getCustomerNum()});
        req.validate();
        Long bizId = req.getBizId();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        String customerNum = req.getCustomerNum();
        CustomerDetail detail = (CustomerDetail)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)req.getBizId())).eq((Object)"customer_num", (Object)customerNum));
        log.info("customerDetail detail: {}", (Object)detail);
        if (ObjectUtils.isEmpty((Object)detail)) {
            log.info("customerDetail save detail: {}", (Object)detail);
            this.save(this.buildCustomerDetail(req, bizSimpleDto.getCorpId()));
        } else {
            if (StringUtils.isNotBlank((CharSequence)req.getAvatar())) {
                detail.setAvatar(req.getAvatar());
            }
            if (req.getCoverValue() != null && req.getCoverValue() == 1) {
                if (StringUtils.isNotBlank((CharSequence)req.getName())) {
                    detail.setName(req.getName());
                }
                if (!ObjectUtils.isEmpty((Object)req.getGender())) {
                    detail.setGender(req.getGender());
                }
            } else {
                if (StringUtils.isEmpty((CharSequence)detail.getName()) || "-".equals(detail.getName())) {
                    detail.setName(req.getName());
                }
                if (ObjectUtils.isEmpty((Object)detail.getGender()) || !ObjectUtils.isEmpty((Object)detail.getGender()) && detail.getGender() == 0) {
                    detail.setGender(req.getGender());
                }
            }
            if (StringUtils.isEmpty((CharSequence)detail.getArea())) {
                detail.setArea(req.getArea());
            }
            if (ObjectUtils.isEmpty((Object)detail.getChannelId())) {
                detail.setChannelId(req.getChannelId());
            }
            if (ObjectUtils.isEmpty((Object)detail.getPromoterId())) {
                detail.setPromoterId(req.getPromoterId());
            }
            detail.setUpdateTime(new Date());
            log.info("customerDetail update detail: {}", (Object)detail);
            this.updateById(detail);
        }
    }

    public void addBatch(Long bizId, List<CustomerDetailReq> list) {
        log.info("batchCustomerDetail bizId:{}, list: {}", (Object)bizId, list);
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        ArrayList addList = Lists.newArrayList();
        ArrayList modList = Lists.newArrayList();
        Map<Object, Object> existMap = Collections.emptyMap();
        List customerNums = list.stream().map(it -> it.getCustomerNum()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerNums)) {
            List existList = this.customerDetailMapper.queryByCustomerNums(bizId, customerNums);
            existMap = existList.stream().collect(Collectors.toMap(it -> it.getCustomerNum(), it -> it));
        }
        for (CustomerDetailReq it2 : list) {
            String customerNum = it2.getCustomerNum();
            CustomerDetail detail = (CustomerDetail)existMap.get(customerNum);
            if (Objects.nonNull(detail)) {
                detail.setName(it2.getName());
                detail.setArea(it2.getArea());
                detail.setAvatar(it2.getAvatar());
                detail.setCorpName(it2.getCorpName());
                detail.setCorpFullName(it2.getCorpFullName());
                detail.setType(it2.getType());
                detail.setGender(it2.getGender());
                detail.setRemark(it2.getRemark());
                if (detail.getPromoterId() == null) {
                    detail.setPromoterId(it2.getPromoterId());
                }
                modList.add(detail);
                continue;
            }
            CustomerDetail customerDetail = this.buildCustomerDetail(it2, bizSimpleDto.getCorpId());
            addList.add(customerDetail);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("\u6279\u91cf\u4fdd\u5b58\u5ba2\u6237\u8be6\u60c5:{}", (Object)addList.size());
            this.customerDetailMapper.batchInsert((Collection)addList);
        }
        if (CollectionUtils.isNotEmpty((Collection)modList)) {
            log.info("\u6279\u91cf\u66f4\u65b0\u5ba2\u6237\u8be6\u60c5:{}", (Object)modList.size());
            this.customerDetailMapper.batchInsert((Collection)modList);
        }
    }

    public CustomerDetailResp queryCustomerDetail(Long bizId, String customerNum) {
        log.info("queryCustomerDetail bizId:{}, num: {}", (Object)bizId, (Object)customerNum);
        String mainNum = this.customerNumService.getMainNum(bizId, customerNum);
        customerNum = StringUtils.isBlank((CharSequence)mainNum) ? customerNum : mainNum;
        CustomerDetail detail = (CustomerDetail)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"customer_num", (Object)customerNum));
        CustomerDetailResp resp = new CustomerDetailResp();
        if (detail != null) {
            BeanUtils.copyProperties((Object)detail, (Object)resp);
        }
        return resp;
    }

    public List<CustomerDetailResp> queryCustomerDetails(Long bizId, Collection<String> customerNums) {
        Set nums;
        log.info("queryCustomerDetails bizId:{}, num: {}", (Object)bizId, customerNums);
        if (CollectionUtils.isEmpty(customerNums)) {
            return Collections.emptyList();
        }
        Map mainNumMap = this.customerMapper.selectMainNums(bizId, customerNums);
        if (MapUtils.isEmpty((Map)mainNumMap)) {
            return Collections.emptyList();
        }
        HashMap<String, Set> mainNumCustomerNumMap = new HashMap<String, Set>();
        for (Map.Entry entry : mainNumMap.entrySet()) {
            String customerNum = (String)entry.getKey();
            String mainNum = (String)entry.getValue();
            nums = mainNumCustomerNumMap.getOrDefault(mainNum, new HashSet());
            nums.add(customerNum);
            mainNumCustomerNumMap.put(mainNum, nums);
        }
        List details = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).in((Object)"customer_num", mainNumMap.values()));
        if (CollectionUtils.isEmpty((Collection)details)) {
            return Collections.emptyList();
        }
        ArrayList respList = Lists.newArrayList();
        for (CustomerDetail detail : details) {
            nums = (Set)mainNumCustomerNumMap.get(detail.getCustomerNum());
            for (String num : nums) {
                detail.setCustomerNum(num);
                CustomerDetailResp resp = new CustomerDetailResp();
                BeanUtils.copyProperties((Object)detail, (Object)resp);
                respList.add(resp);
            }
        }
        return respList;
    }

    public void updateCustomerDetail(ModMobileReq req, String corpId) {
        log.info("updateCustomerDetail:{}", (Object)JSON.toJSONString((Object)req));
        String customerNum = req.getCustomerNum();
        ArrayList customerNums = Lists.newArrayList();
        String mainNum = this.customerNumService.getMainNum(req.getBizId(), req.getCustomerNum());
        customerNums.add(customerNum);
        if (StringUtils.isNotBlank((CharSequence)mainNum)) {
            customerNums.add(mainNum);
        }
        log.info("updateCustomerDetail customerNum: {}, mainNum: {}", (Object)req.getCustomerNum(), (Object)mainNum);
        List details = this.customerDetailMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)req.getBizId())).in((Object)"customer_num", (Collection)customerNums));
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            for (CustomerDetail customerDetail : details) {
                if (Objects.nonNull(req.getGender())) {
                    customerDetail.setGender(req.getGender());
                }
                if (StringUtils.isNotBlank((CharSequence)req.getName())) {
                    customerDetail.setName(req.getName());
                }
                if (StringUtils.isNotBlank((CharSequence)req.getChannelId())) {
                    customerDetail.setChannelId(req.getChannelId());
                }
                if (StringUtils.isNotBlank((CharSequence)req.getArea())) {
                    customerDetail.setArea(req.getArea());
                }
                if (StringUtils.isNotBlank((CharSequence)req.getDescription())) {
                    customerDetail.setRemark(req.getDescription());
                }
                if (customerDetail.getPromoterId() == null) {
                    customerDetail.setPromoterId(req.getPromoterId());
                }
                if (customerDetail.getPromoterId() == null) {
                    customerDetail.setPromoterId(req.getPromoterId());
                }
                this.updateById(customerDetail);
            }
        } else {
            CustomerDetailReq customerDetailReq = new CustomerDetailReq();
            customerDetailReq.setCustomerNum(req.getCustomerNum());
            customerDetailReq.setName(req.getName());
            customerDetailReq.setGender(req.getGender());
            customerDetailReq.setArea(req.getArea());
            customerDetailReq.setBizId(req.getBizId());
            customerDetailReq.setChannelId(req.getChannelId());
            this.save(this.buildCustomerDetail(customerDetailReq, corpId));
        }
    }

    public List<CustomerDetailResp> queryCustomerDetailInfo(CustomerDetailReq req) {
        req.validateUnionIds();
        log.info("queryCustomerDetailInfo param:{}", (Object)JSON.toJSONString((Object)req));
        List customers = this.customerMapper.batchSelectByUnionId(req.getBizId(), (Collection)req.getUnionIds(), null);
        Set customerNums = customers.stream().map(item -> item.getNum()).collect(Collectors.toSet());
        List customerDetails = this.customerDetailMapper.queryByCustomerNums(req.getBizId(), customerNums);
        Map<String, List<CustomerDetail>> customerDetailsMaps = customerDetails.stream().collect(Collectors.groupingBy(item -> item.getCustomerNum()));
        return customers.stream().map(item -> {
            List details;
            CustomerDetailResp detailResp = new CustomerDetailResp();
            detailResp.setCustomerNum(item.getNum());
            if (MapUtils.isNotEmpty((Map)customerDetailsMaps) && CollectionUtils.isNotEmpty((Collection)(details = (List)customerDetailsMaps.get(item.getNum())))) {
                CustomerDetail customerDetail = (CustomerDetail)details.get(0);
                detailResp.setAvatar(customerDetail.getAvatar());
                detailResp.setArea(customerDetail.getArea());
                detailResp.setChannelId(customerDetail.getChannelId());
                detailResp.setRemark(customerDetail.getRemark());
                detailResp.setType(customerDetail.getType());
                detailResp.setGender(customerDetail.getGender());
            }
            detailResp.setUnionId(item.getUnionId());
            return detailResp;
        }).collect(Collectors.toList());
    }

    public void channelAssignment(Long bizId) {
        log.info("channelAssignment bizId: {}", (Object)bizId);
        CompletableFuture.runAsync(() -> {
            BizTableContext.putBizId((Long)bizId);
            ArrayList channelNums = Lists.newArrayList((Object[])new String[]{SourceType.SCRM_SYNC.getCode(), SourceType.TRADE_SYNC.getCode(), SourceType.AD_SYNC.getCode(), SourceType.DYNAMIC_FORM_SYNC.getCode(), SourceType.LIVE_COMMERCE.getCode()});
            Map channelIdMap = this.scrmChannelService.getIdByNums(bizId, (Collection)channelNums);
            Map channelNumMap = this.scrmChannelService.getNumByIds(bizId, channelIdMap.values());
            for (CustomerIdType idType : CustomerIdType.values()) {
                int value = idType.getValue();
                try {
                    if (value != CustomerIdType.WEWORK_CONTACT_ID.getValue() && value != CustomerIdType.MOBILE.getValue()) continue;
                    List customerDetails = this.customerDetailMapper.queryEmptyChannelCustomerDetail(bizId, Integer.valueOf(value));
                    if (CollectionUtils.isEmpty((Collection)customerDetails)) {
                        log.info("no customerDetails to update channel, bizId: {}, idType: {}", (Object)bizId, (Object)value);
                        continue;
                    }
                    if (value == CustomerIdType.WEWORK_CONTACT_ID.getValue()) {
                        for (CustomerDetail customerDetail : customerDetails) {
                            customerDetail.setChannelId(SourceType.SCRM_SYNC.getCode());
                            customerDetail.setUpdateTime(new Date());
                        }
                        boolean update = this.updateBatchById(customerDetails);
                        log.info("channelAssignment update: {}, size: {}", (Object)update, (Object)customerDetails.size());
                    } else {
                        if (value != CustomerIdType.MOBILE.getValue()) continue;
                        ArrayList updateDetails = Lists.newArrayList();
                        for (CustomerDetail customerDetail : customerDetails) {
                            CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
                            crmLeadsInfoReq.setMobile(customerDetail.getId1());
                            crmLeadsInfoReq.setCorpId(customerDetail.getCorpId());
                            CrmLeadsInfoResp leads = this.crmLeadsService.getLeads(crmLeadsInfoReq);
                            if (leads == null || leads.getChannelId() == -1L) continue;
                            String channelNum = (String)channelNumMap.get(leads.getChannelId());
                            if (StringUtils.isBlank((CharSequence)channelNum)) {
                                ChannelDto channelDto = this.scrmChannelService.getById(bizId, leads.getChannelId());
                                if (channelDto == null) continue;
                                channelNum = channelDto.getNum();
                                channelNumMap.put(leads.getChannelId(), channelNum);
                            }
                            customerDetail.setChannelId(channelNum);
                            customerDetail.setUpdateTime(new Date());
                            updateDetails.add(customerDetail);
                        }
                        boolean update = this.updateBatchById(updateDetails);
                        log.info("channelAssignment update: {}, size: {}", (Object)update, (Object)updateDetails.size());
                    }
                    log.info("channelAssignment end, bizId: {}, idType: {}", (Object)bizId, (Object)value);
                }
                catch (Exception e) {
                    log.error("\u5ba2\u6237\u7c7b\u578b\uff1a{} \u6570\u636e\u6e20\u9053\u5904\u7406\u62a5\u9519", (Object)value, (Object)e);
                }
            }
            BizTableContext.clear();
        });
    }

    public String syncElectricPlatformCustomer(CustomerDetailReq req) {
        log.info("syncElectricPlatformCustomer param:{}", (Object)JSON.toJSONString((Object)req));
        try {
            if (Objects.isNull(req)) {
                return null;
            }
            this.checkSyncParam(req);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u7528\u6237\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
        if (PlatformEnum.YOU_ZAN.getValue() == req.getPlatformCode().intValue()) {
            this.decodeYZCustomer(req);
        }
        if (StringUtils.isBlank((CharSequence)req.getMobile())) {
            log.info("\u7528\u6237\u5173\u952e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\u6570\u636e\uff1amobile:{};", (Object)req.getMobile());
            return null;
        }
        String customerNum = this.customerNumService.getCustomerNumByType(req.getBizId(), CustomerIdType.MOBILE.getValue(), req.getMobile(), "", null);
        req.setCustomerNum(customerNum);
        BizSimpleDto bizServiceById = this.scrmBizService.getById(req.getBizId());
        if (Objects.isNull(bizServiceById)) {
            log.error("\u5f53\u524d\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1abizId:{}", (Object)req.getBizId());
            return customerNum;
        }
        if (StringUtils.isNotBlank((CharSequence)req.getName())) {
            ModMobileReq modMobileReq = new ModMobileReq();
            modMobileReq.setBizId(req.getBizId());
            modMobileReq.setCustomerNum(req.getCustomerNum());
            modMobileReq.setName(req.getName());
            modMobileReq.setBizId(req.getBizId());
            this.updateCustomerDetail(modMobileReq, bizServiceById.getCorpId());
        }
        return customerNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrderLeads(CustomerDetailReq req) {
        log.info("addOrderLeads param:{}", (Object)JSON.toJSONString((Object)req));
        if (Objects.isNull(req)) {
            return;
        }
        if (Objects.isNull(req.getBizId())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)req.getMobile())) {
            log.info("addOrderLeads mobile is null, return");
            return;
        }
        String key = req.getBizId() + "_leads_" + req.getMobile();
        try {
            this.distributedLock.reentrantLock(key);
            this.addLeadsDynamic(req);
        }
        catch (Exception e) {
            log.error("add order leads failed", (Throwable)e);
        }
        finally {
            this.distributedLock.unlock(key);
        }
    }

    private void addLeadsDynamic(CustomerDetailReq req) {
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(req.getBizId());
        CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
        crmLeadsInfoReq.setCorpId(bizSimpleDto.getCorpId());
        crmLeadsInfoReq.setMobile(req.getMobile());
        crmLeadsInfoReq.setName(req.getName());
        if (this.crmLeadsService.exists(crmLeadsInfoReq)) {
            log.info("addOrderLeads leads exist, corpId:{}, mobile:{}", (Object)bizSimpleDto.getCorpId(), (Object)req.getMobile());
            this.crmLeadsService.updateLeadsLatestRefreshTime(req.getBizId(), req.getMobile(), new Date(), LeadsViewStatus.HOT);
            return;
        }
        CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
        crmLeadsReq.setCorpId(bizSimpleDto.getCorpId());
        crmLeadsReq.setMobile(req.getMobile());
        crmLeadsReq.setName(req.getName());
        crmLeadsReq.setAllocUserId(req.getUserId());
        crmLeadsReq.setTradeAmount(req.getTradeAmount());
        ChannelDto channelDto = this.scrmChannelService.getByNum(req.getBizId(), SourceType.TRADE_SYNC.getCode());
        if (channelDto != null) {
            crmLeadsReq.setChannelId(channelDto.getId());
        }
        crmLeadsReq.setSourceType(Integer.valueOf(SourceType.TRADE_SYNC.getValue()));
        try {
            this.crmLeadsService.addLeads(crmLeadsReq);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u65b0\u589e\u7ebf\u7d22\u5f02\u5e38", (Throwable)e);
        }
        try {
            this.crmLeadsService.updateLeadsLatestRefreshTime(req.getBizId(), req.getMobile(), new Date(), LeadsViewStatus.NEW);
        }
        catch (Exception e) {
            log.error("addLeadsDynamic,updateLeadsLatestRefreshTime error", (Throwable)e);
        }
    }

    private void checkSyncParam(CustomerDetailReq req) {
        Preconditions.checkArgument((req != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getPlatformCode() != null ? 1 : 0) != 0, (Object)"platformCode\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private CustomerDetail buildCustomerDetail(CustomerDetailReq req, String corpId) {
        return CustomerDetail.builder().num(this.idGen.getNum()).bizId(req.getBizId()).corpId(corpId).customerNum(req.getCustomerNum()).name(req.getName()).area(req.getArea()).avatar(req.getAvatar()).corpName(req.getCorpName()).corpFullName(req.getCorpFullName()).type(req.getType()).gender(req.getGender()).remark(req.getRemark()).createBy(Long.valueOf(-1L)).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date()).source(req.getSource()).channelId(req.getChannelId()).promoterId(req.getPromoterId()).build();
    }

    private void decodeYZCustomer(CustomerDetailReq req) {
        if (StringUtils.isNotBlank((CharSequence)req.getEncodeMobile())) {
            String mobile = AESUtil.AESDecrypt((String)req.getEncodeMobile(), (String)this.aesKey);
            req.setMobile(mobile);
        }
        if (StringUtils.isNotBlank((CharSequence)req.getEncodeName())) {
            String name = AESUtil.AESDecrypt((String)req.getEncodeName(), (String)this.aesKey);
            req.setName(name);
        }
        if (StringUtils.isNotBlank((CharSequence)req.getEncodeAddress())) {
            String address = AESUtil.AESDecrypt((String)req.getEncodeAddress(), (String)this.aesKey);
            req.setAddress(address);
        }
    }

    public Long getPromoterIdByCustomerNum(Long bizId, String customerNum) {
        log.info("getPromoterIdByCustomerNum,bizId:{},customerNum:{}", (Object)bizId, (Object)customerNum);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum is null");
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"customer is null");
        customerNum = StringUtils.isNotBlank((CharSequence)customer.getMainNum()) ? customer.getMainNum() : customer.getNum();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(CustomerDetail::getBizId, (Object)bizId)).eq(CustomerDetail::getCustomerNum, (Object)customerNum);
        List customerDetails = this.customerDetailMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)customerDetails)) {
            return null;
        }
        return ((CustomerDetail)customerDetails.get(0)).getPromoterId();
    }

    public void setPromoterIdByCustomerNum(Long bizId, Long promoterId, String customerNum) {
        log.info("setPromoterIdByCustomerNum,bizId:{},promoterId:{},customerNum:{}", new Object[]{bizId, promoterId, customerNum});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum is null");
        Preconditions.checkArgument((promoterId != null ? 1 : 0) != 0, (Object)"promoterId is null");
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"customer is null");
        customerNum = StringUtils.isNotBlank((CharSequence)customer.getMainNum()) ? customer.getMainNum() : customer.getNum();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(CustomerDetail::getBizId, (Object)bizId)).eq(CustomerDetail::getCustomerNum, (Object)customerNum);
        List customerDetails = this.customerDetailMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)customerDetails)) {
            log.info("setPromoterIdByCustomerNum,bizId:{},promoterId:{},customerNum:{},customerDetails isEmpty", new Object[]{bizId, promoterId, customerNum});
            return;
        }
        Long oldPromoterId = ((CustomerDetail)customerDetails.get(0)).getPromoterId();
        Preconditions.checkArgument((oldPromoterId == null ? 1 : 0) != 0, (Object)("oldPromoterId is not null,oldPromoterId is " + oldPromoterId));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(CustomerDetail::getCustomerNum, (Object)customerNum)).set(CustomerDetail::getPromoterId, (Object)promoterId)).set(CustomerDetail::getUpdateTime, (Object)new Date());
        int update = this.customerDetailMapper.update(null, (Wrapper)updateWrapper);
        log.info("setPromoterIdByCustomerNum,bizId:{},promoterId:{},customerNum:{},update:{}", new Object[]{bizId, promoterId, customerNum, update});
    }
}

