/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.entity.CustomerBinding;
import cn.kinyun.customer.center.dal.mapper.CustomerBindingMapper;
import cn.kinyun.customer.center.dto.req.BatchSetBindingReq;
import cn.kinyun.customer.center.dto.req.CustomerBindReq;
import cn.kinyun.customer.center.dto.req.SetBindingReq;
import cn.kinyun.customer.center.dto.resp.CustomerBindingResp;
import cn.kinyun.customer.center.service.CcCustomerBindService;
import com.alibaba.dubbo.config.annotation.Service;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

@Service
public class CcCustomerBindServiceImpl
extends ServiceImpl<CustomerBindingMapper, CustomerBinding>
implements CcCustomerBindService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerBindServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CustomerBindingMapper customerBindingMapper;

    public void setBinding(SetBindingReq params) {
        String weworkUserNum;
        log.info("setBinding params:{}", (Object)params);
        params.validate();
        Long bizId = params.getBizId();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        String productLineId = params.getProductLineId();
        Long userId = params.getUserId();
        String customerNum = params.getCustomerNum();
        String source = params.getSource();
        CustomerBinding customerBinding = this.customerBindingMapper.queryByUserIdOrWeworkUserNumAndCustomerNum(bizId, source, userId, weworkUserNum = params.getWeworkUserNum(), customerNum, productLineId);
        if (ObjectUtils.isEmpty((Object)customerBinding)) {
            this.save(this.buildCustomerBinding(params, bizSimpleDto.getCorpId()));
        } else {
            this.buildUpdateFields(params.getIsDeleted(), params.getDeleteTime(), productLineId, userId, weworkUserNum, customerBinding);
            this.customerBindingMapper.updateById(customerBinding);
        }
    }

    private void buildUpdateFields(Integer isDeleted, Date deleteTime, String productLineId, Long userId, String weworkUserNum, CustomerBinding customerBinding) {
        if (!Objects.equals(userId, customerBinding.getUserId()) && userId > 0L) {
            customerBinding.setUserId(userId);
        }
        if (!StringUtils.equals((CharSequence)weworkUserNum, (CharSequence)customerBinding.getWeworkUserNum()) && StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            customerBinding.setWeworkUserNum(weworkUserNum);
        }
        if (!StringUtils.equals((CharSequence)productLineId, (CharSequence)customerBinding.getProductLineId())) {
            customerBinding.setProductLineId(productLineId);
        }
        customerBinding.setIsDeleted(isDeleted);
        if (Objects.equals(NumberUtils.INTEGER_ONE, customerBinding.getIsDeleted())) {
            customerBinding.setDeleteTime(deleteTime);
        } else {
            customerBinding.setDeleteTime(null);
        }
        customerBinding.setUpdateTime(new Date());
    }

    private boolean diffCustomerBinding(CustomerBindReq req, CustomerBinding customerBinding) {
        if (!Objects.equals(req.getUserId(), customerBinding.getUserId())) {
            return true;
        }
        if (!Objects.equals(req.getWeworkUserNum(), customerBinding.getWeworkUserNum())) {
            return true;
        }
        if (!Objects.equals(req.getProductLineId(), customerBinding.getProductLineId())) {
            return true;
        }
        if (!Objects.equals(req.getIsDeleted(), customerBinding.getIsDeleted())) {
            return true;
        }
        return !Objects.equals(req.getDeleteTime(), customerBinding.getDeleteTime());
    }

    public void batchSetBinding(BatchSetBindingReq params) {
        log.info("batchSetBinding params:{}", (Object)params);
        params.validate();
        Long bizId = params.getBizId();
        String source = params.getSource();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        List partition = Lists.partition((List)params.getList(), (int)100);
        int updateCount = 0;
        int insertCount = 0;
        for (List list : partition) {
            List customerBindingList = list.stream().map(a -> {
                CustomerBinding item = new CustomerBinding();
                BeanUtils.copyProperties((Object)a, (Object)item);
                item.setBizId(bizId);
                item.setSource(source);
                return item;
            }).collect(Collectors.toList());
            ArrayList userList = Lists.newArrayList();
            ArrayList weworkUserNumList = Lists.newArrayList();
            for (CustomerBinding customerBinding : customerBindingList) {
                if (Objects.nonNull(customerBinding.getUserId()) && customerBinding.getUserId() > 0L) {
                    userList.add(customerBinding);
                }
                if (!StringUtils.isNotBlank((CharSequence)customerBinding.getWeworkUserNum())) continue;
                weworkUserNumList.add(customerBinding);
            }
            HashSet existsCustomerBindings = Sets.newHashSet();
            List existsCustomerBindingsByUserId = this.customerBindingMapper.queryListByCustomerBindingListUserId(customerBindingList);
            List existsCustomerBindingsByWeworkUserNum = this.customerBindingMapper.queryListByCustomerBindingListWeworkUserNum(customerBindingList);
            if (CollectionUtils.isNotEmpty((Collection)existsCustomerBindingsByUserId)) {
                existsCustomerBindings.addAll(existsCustomerBindingsByUserId);
            }
            if (CollectionUtils.isNotEmpty((Collection)existsCustomerBindingsByWeworkUserNum)) {
                existsCustomerBindings.addAll(existsCustomerBindingsByWeworkUserNum);
            }
            ArrayList updateList = Lists.newArrayList();
            ArrayList insertList = Lists.newArrayList();
            HashMap userIdCustomerNumMap = Maps.newHashMap();
            HashMap weworkUserNumCustomerNumMap = Maps.newHashMap();
            for (CustomerBinding existsCustomerBinding : existsCustomerBindings) {
                String key;
                if (StringUtils.isNotBlank((CharSequence)existsCustomerBinding.getWeworkUserNum())) {
                    key = this.getUserIdCustomerNumKey(existsCustomerBinding);
                    userIdCustomerNumMap.put(key, existsCustomerBinding);
                    continue;
                }
                key = this.getWeworkUserNumCustomerNumKey(existsCustomerBinding);
                weworkUserNumCustomerNumMap.put(key, existsCustomerBinding);
            }
            for (CustomerBindReq customerBindReq : list) {
                String key1 = this.getUserIdCustomerNumKey(bizId, source, customerBindReq);
                CustomerBinding entity = (CustomerBinding)userIdCustomerNumMap.get(key1);
                if (Objects.isNull(entity)) {
                    String key2 = this.getWeworkUserNumCustomerNumKey(bizId, source, customerBindReq);
                    entity = (CustomerBinding)weworkUserNumCustomerNumMap.get(key2);
                }
                if (Objects.isNull(entity)) {
                    SetBindingReq setBindingReq = new SetBindingReq();
                    BeanUtils.copyProperties((Object)customerBindReq, (Object)setBindingReq);
                    setBindingReq.setBizId(bizId);
                    setBindingReq.setSource(params.getSource());
                    insertList.add(this.buildCustomerBinding(setBindingReq, bizSimpleDto.getCorpId()));
                    continue;
                }
                if (!this.diffCustomerBinding(customerBindReq, entity)) continue;
                this.buildUpdateFields(customerBindReq.getIsDeleted(), customerBindReq.getDeleteTime(), customerBindReq.getProductLineId(), customerBindReq.getUserId(), customerBindReq.getWeworkUserNum(), entity);
                updateList.add(entity);
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateCount += this.customerBindingMapper.batchUpdate((List)updateList);
            }
            if (!CollectionUtils.isNotEmpty((Collection)insertList)) continue;
            insertCount += this.customerBindingMapper.batchInsert((Collection)insertList);
        }
        log.info("batchSetBinding insertCount={}, updateCount={}", (Object)insertCount, (Object)updateCount);
    }

    private String getWeworkUserNumCustomerNumKey(CustomerBinding item) {
        return String.format("%d#%s#%d#%s#%s", item.getBizId(), item.getCustomerNum(), item.getUserId(), item.getProductLineId(), item.getSource());
    }

    private String getUserIdCustomerNumKey(CustomerBinding item) {
        return String.format("%d#%s#%s#%s#%s", item.getBizId(), item.getCustomerNum(), item.getWeworkUserNum(), item.getProductLineId(), item.getSource());
    }

    private String getWeworkUserNumCustomerNumKey(Long bizId, String source, CustomerBindReq item) {
        return String.format("%d#%s#%d#%s#%s", bizId, item.getCustomerNum(), item.getUserId(), item.getProductLineId(), source);
    }

    private String getUserIdCustomerNumKey(Long bizId, String source, CustomerBindReq item) {
        return String.format("%d#%s#%s#%s#%s", bizId, item.getCustomerNum(), item.getWeworkUserNum(), item.getProductLineId(), source);
    }

    public List<CustomerBindingResp> binding(SetBindingReq params) {
        log.info("binding params:{}", (Object)params);
        Long bizId = params.getBizId();
        String customerNum = params.getCustomerNum();
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum\u4e0d\u80fd\u4e3a\u7a7a");
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (ObjectUtils.isEmpty((Object)bizSimpleDto)) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        String productLineId = params.getProductLineId();
        Long userId = params.getUserId();
        String source = params.getSource();
        String weworkUserNum = params.getWeworkUserNum();
        List customerBindings = this.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"customer_num", (Object)customerNum)).eq(!ObjectUtils.isEmpty((Object)userId), (Object)"user_id", (Object)userId)).eq(StringUtils.isNotBlank((CharSequence)source), (Object)"source", (Object)source)).eq(StringUtils.isNotBlank((CharSequence)weworkUserNum), (Object)"wework_user_num", (Object)weworkUserNum)).eq(StringUtils.isNotBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)productLineId)).eq(StringUtils.isBlank((CharSequence)productLineId), (Object)"product_line_id", (Object)""));
        if (CollectionUtils.isEmpty((Collection)customerBindings)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        customerBindings.forEach(customerBinding -> {
            CustomerBindingResp customerBindingResp = new CustomerBindingResp();
            BeanUtils.copyProperties((Object)customerBinding, (Object)customerBindingResp);
            result.add(customerBindingResp);
        });
        return result;
    }

    private CustomerBinding buildCustomerBinding(SetBindingReq params, String corpId) {
        return CustomerBinding.builder().num(this.idGen.getNum()).bizId(params.getBizId()).corpId(corpId).userId(params.getUserId()).weworkUserNum(params.getWeworkUserNum()).customerNum(params.getCustomerNum()).deleteTime(Objects.nonNull(params.getIsDeleted()) && Objects.equals(NumberUtils.INTEGER_ONE, params.getIsDeleted()) ? params.getDeleteTime() : null).userId(params.getUserId()).source(params.getSource()).productLineId(params.getProductLineId()).createBy(Long.valueOf(-1L)).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date()).isDeleted(Integer.valueOf(Objects.nonNull(params.getIsDeleted()) ? params.getIsDeleted() : 0)).build();
    }

    public void cancelBind(Long bizId) {
        log.info("cancel bind bizId:{}", (Object)bizId);
        this.customerBindingMapper.cancelBind(bizId);
    }
}

